/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.stack;

import com.ibm.vis.engine.internal.grammar.coordinate.functions.LinearFunctionalPath;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.DataStack;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PolyPathMaker;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import java.util.LinkedHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
final class StackState {
    private DataStack negativeStack = new DataStack();
    private DataStack positiveStack = new DataStack();
    private final LinkedHashMap<ShapePoly, Shape> transformedPolyMap = new LinkedHashMap();

    StackState() {
    }

    public void clear() {
        this.negativeStack = new DataStack();
        this.positiveStack = new DataStack();
    }

    public double getStackingOffset(double d, double d2, double d3) {
        double d4 = d3 - d2;
        if (d4 < 0.0) {
            return this.negativeStack.getStackingOffset(d, d4);
        }
        return this.positiveStack.getStackingOffset(d, d4);
    }

    public ShapePoly stack(LinearFunctionalPath linearFunctionalPath, double d, boolean bl, PolyPathMaker polyPathMaker) {
        if (linearFunctionalPath.isNonNegative()) {
            return this.positiveStack.stackPath(linearFunctionalPath, d, bl, polyPathMaker);
        }
        return this.negativeStack.stackPath(linearFunctionalPath, d, bl, polyPathMaker);
    }

    public Shape getTransformedPoly(ShapePoly shapePoly) {
        return this.transformedPolyMap.get(shapePoly);
    }

    public void setTransformedShapeForPoly(ShapePoly shapePoly, Shape shape) {
        this.transformedPolyMap.put(shapePoly, shape);
    }
}

