/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.stack;

import com.ibm.vis.engine.internal.grammar.ShapeIterator;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.DefaultStacker;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.GlyphStacker;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.PolyStacker;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.StackState;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.Stacker;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.geom.Dim;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class StackTransform
extends CoordinateTransform {
    private final Map<String, StackState> panelStackState = new HashMap<String, StackState>();

    @Override
    protected Shape transformShape(Shape shape, Dim dim, Scale[] scaleArray) {
        double d;
        double d2;
        if (!shape.isElement()) {
            return shape;
        }
        String string = shape.getFacetKey();
        StackState stackState = this.getStackStateForFacet(string);
        Stacker stacker = !shape.canScaleY() ? new GlyphStacker(stackState) : (shape instanceof ShapePoly ? new PolyStacker(stackState) : new DefaultStacker(stackState));
        Shape shape2 = stacker.stack(shape, d2 = dim.getHeight() * (1.0 - scaleArray[0].getBase()), d = Math.max(0.0, d2));
        if (shape2 != null) {
            shape2.addMeta(shape);
        }
        return shape2;
    }

    private StackState getStackStateForFacet(String string) {
        StackState stackState = this.panelStackState.get(string);
        if (stackState == null) {
            stackState = new StackState();
            this.panelStackState.put(string, stackState);
        }
        return stackState;
    }

    @Override
    public void transformShapes(ShapeList shapeList, Dim dim, Scale[] scaleArray) {
        this.clearStackState();
        shapeList.sortByAestheticGroup();
        ShapeIterator<Shape> shapeIterator = shapeList.elementIterator();
        while (shapeIterator.hasNext()) {
            shapeIterator.replace(this.transformShape((Shape)shapeIterator.next(), dim, scaleArray));
        }
        this.clearStackState();
    }

    private void clearStackState() {
        for (StackState stackState : this.panelStackState.values()) {
            stackState.clear();
        }
    }

    @Override
    public boolean isStacking() {
        return true;
    }

    @Override
    public double[] inverseTransform(double[] dArray, Dim dim, Scale[] scaleArray) {
        return dArray;
    }

    @Override
    protected double calculateGapSize(double d, int n) {
        return 0.0;
    }
}

