/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.element;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.element.SchemaBuilder;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.scene.SymbolBuilder;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class BoxPlotBuilder
extends SchemaBuilder {
    protected static final int REQUIRED_NUM_COMPONENTS = 4;
    public static final String BOX = "box";
    public static final String WHISKERS = "whiskers";
    public static final String MEDIAN = "median";

    BoxPlotBuilder(VisContext visContext, Coordinates coordinates, Dim dim, String string, Dim dim2, ValueProvider[] valueProviderArray, Row[] rowArray, StyleSpec styleSpec) {
        super(visContext, coordinates, dim, string, dim2, valueProviderArray, rowArray, styleSpec);
    }

    @Override
    protected Shape makeSchemaShape(double d, double d2, double d3, double d4, Row row) {
        Schema schema;
        if (this.getComponentValueProviders().length != 4) {
            throw new SpecException("Expected number of components: '4", ErrorCode.ENGINE_ELEMENT_COMPONENTS_INVALID, null);
        }
        if (row == null) {
            schema = this.makeBoxplotSwatch(d, d3);
        } else {
            double[] dArray = new double[5];
            this.getValuesFromProviders(row, dArray);
            dArray[dArray.length - 1] = d2;
            BasicFactory.sortArray(dArray);
            double d5 = dArray[4];
            double d6 = dArray[3];
            double d7 = dArray[2];
            double d8 = dArray[1];
            double d9 = dArray[0];
            Shape[] shapeArray = new Shape[3];
            shapeArray[0] = BoxPlotBuilder.createWhiskers(d, d2, d3, d6, d5, d8, d9, this.visContext);
            Shape shape = ShapeFactory2.CreateRect(d - d3 / 2.0, d8, d3, d6 - d8);
            shape.setDefaultStyle(this.getStyle());
            shape.setMeta("part", BOX);
            shapeArray[1] = shape;
            shapeArray[2] = new ShapeLine(new double[]{d - d3 / 2.0, d + d3 / 2.0}, new double[]{d7, d7}, false);
            shapeArray[2].setMeta("part", MEDIAN);
            shapeArray[2].setColorAestheticOnlyChangesOutline(true);
            schema = new Schema(d - d3 / 2.0, d9, d3, d5 - d9, shapeArray, true);
        }
        return schema;
    }

    private static Shape createWhiskers(double d, double d2, double d3, double d4, double d5, double d6, double d7, VisContext visContext) {
        int n;
        Path path = (Path)SymbolBuilder.makeSymbol("t-beam", d, (d4 + d5) / 2.0, 2.0 * d3 / 3.0, d4 - d5, null, visContext);
        Path path2 = (Path)SymbolBuilder.makeSymbol("t-beam", d, (d6 + d7) / 2.0, 2.0 * d3 / 3.0, d6 - d7, null, visContext);
        int n2 = path2.getXArray().length;
        int n3 = path.getXArray().length;
        int n4 = n2 + n3;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        char[] cArray = new char[n4];
        for (n = 0; n < n2; ++n) {
            dArray[n] = path2.getXArray()[n];
            dArray2[n] = path2.getYArray()[n];
            cArray[n] = path2.getTypes()[n];
        }
        for (n = 0; n < n3; ++n) {
            dArray[n + n2] = path.getXArray()[n];
            dArray2[n + n2] = path.getYArray()[n];
            cArray[n + n2] = path.getTypes()[n];
        }
        Path path3 = new Path(dArray, dArray2, false, cArray);
        path3.setMeta("part", WHISKERS);
        path3.setScaleDimensions(1);
        path3.setUseBoundsForLabel(true);
        return path3;
    }

    private void getValuesFromProviders(Row row, double[] dArray) {
        ValueProvider[] valueProviderArray = this.getComponentValueProviders();
        int n = 0;
        for (ValueProvider valueProvider : valueProviderArray) {
            Double d = null;
            if (valueProvider.getBaseField() == null) {
                throw new SpecException("Boxplots require a field property in components. 'value' is not supported.", ErrorCode.DATA_INVALID, null);
            }
            d = this.toScreenY(valueProvider.getBaseField(), row, valueProvider.getSpan());
            if (d == null) {
                throw new SpecException("Null values not allowed in boxplot.", ErrorCode.DATA_INVALID, null);
            }
            dArray[n++] = d;
        }
    }

    private Schema makeBoxplotSwatch(double d, double d2) {
        Shape[] shapeArray = new Shape[]{ItemBuilder.makeRectangle(d - d2 / 2.0, 0.0, d2, this.extent.getHeight(), this.getStyle())};
        Shape shape = shapeArray[0];
        Schema schema = new Schema(shape.getX(), shape.getY(), shape.getWidth(), shape.getHeight(), shapeArray, true);
        schema.setSnap(StyleBuilder.getSnap(this.getStyle()));
        return schema;
    }
}

