/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.element;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.geo.GeoData;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.layout.ShapeMaker;
import com.ibm.vis.engine.internal.grammar.values.DerivedValueProducer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class Builder
implements ShapeMaker,
DerivedValueProducer {
    public final Coordinates coords;
    public Dim extent;
    public final VisContext visContext;
    private boolean snap;
    protected Dim size;
    public static final String ALIGN_START = "start";
    public static final String ALIGN_MID = "middle";
    public static final String ALIGN_END = "end";

    protected Builder(VisContext visContext, Coordinates coordinates, Dim dim) {
        this.coords = coordinates;
        this.extent = dim;
        this.visContext = visContext;
    }

    protected abstract Shape makeShape(Position var1, Integer var2);

    public abstract Shape makeShapeInside(Rect var1, int var2);

    protected abstract Shape makeAugmentedShape(GeoData var1, int var2);

    protected final Double toScreenY(Field field, Row row, Integer n) {
        assert (field != null);
        assert (row != null);
        double d = row.data[field.getIndex()];
        Double d2 = this.coords.scales[0].toZeroOne(d, field.unit, n);
        if (d2 == null) {
            return null;
        }
        return this.extent.getHeight() * (1.0 - d2);
    }

    @Override
    public final Shape make(Position position, int n, boolean bl) {
        Shape shape = this.makeShape(position, n);
        if (shape != null && bl) {
            shape.setRow(n);
        }
        return shape;
    }

    public Double getBase(Position position) {
        return null;
    }

    @Override
    public final Shape makeInside(Rect rect, int n, boolean bl) {
        assert (rect != null);
        if (bl) assert (n > -1);
        Shape shape = this.makeShapeInside(rect, n);
        if (shape != null && bl) {
            shape.setRow(n);
        }
        return shape;
    }

    public Shape makeFromAugmentation(int n, GeoData geoData, double[] dArray) {
        Shape shape = this.makeAugmentedShape(geoData, n);
        if (shape == null) {
            return null;
        }
        double d = this.extent.getWidth() / (dArray[1] - dArray[0]);
        double d2 = this.extent.getHeight() / (dArray[2] - dArray[3]);
        double d3 = -dArray[0] * d;
        double d4 = -dArray[3] * d2;
        if (this.augmentedShapesNeedScaling()) {
            shape.affine(d, d3, d2, d4, false);
        } else {
            Point point = geoData.featureCenter(n);
            double d5 = point.getX() * d + d3 - point.getX();
            double d6 = point.getY() * d2 + d4 - point.getY();
            shape.affine(1.0, d5, 1.0, d6, false);
        }
        if (shape != null) {
            shape.setRow(n);
        }
        return shape;
    }

    public ArrayList<Shape> makeContinuousShapes(Position[] positionArray, int[] nArray, Row[] rowArray) {
        assert (false) : "Should never be called";
        return null;
    }

    public boolean makesContinuousShapes() {
        return false;
    }

    protected final boolean getSnap() {
        return this.snap;
    }

    protected final void setSnap(boolean bl) {
        this.snap = bl;
    }

    @Override
    public Number getDerivedValue(String string, Number number, Integer n) {
        return null;
    }

    public void updateDefaultSize(Double[] doubleArray) {
        if (doubleArray[0] != null && this.size != null) {
            this.size.setHeight(doubleArray[0]);
        }
        if (doubleArray[1] != null && this.size != null) {
            this.size.setWidth(doubleArray[1]);
        }
    }

    public Rect modifyShapeSpanClipBounds(Shape shape, Rect rect) {
        return rect;
    }

    public boolean augmentedShapesNeedScaling() {
        return true;
    }
}

