/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.element;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.geo.GeoData;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.element.Builder;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.ElementsSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class CustomBuilder
extends Builder {
    CustomBuilder(VisContext visContext, Coordinates coordinates, Dim dim, Vis vis, Data data, Dim dim2, ElementsSpec elementsSpec) {
        super(visContext, coordinates, dim);
        if (!visContext.isUpdateDataOnly()) {
            if (vis.customConfig != null) {
                throw new SpecException("Multiple custom elments found: Specification can contain only one Custom element", ErrorCode.SPEC_INVALID_PARAMETERS, null);
            }
            if (coordinates != null) {
                if (coordinates.containsTranspose()) {
                    throw new SpecException("Custom elements do not support transpose transform", ErrorCode.SPEC_INVALID_PARAMETERS, null);
                }
                for (int i = 0; i < coordinates.scales.length; ++i) {
                    if (coordinates.scales[i] == null || coordinates.scales[i].getSpans().size() <= 1) continue;
                    throw new SpecException("Custom elements do not support multiple spans", ErrorCode.SPEC_INVALID_PARAMETERS, null);
                }
            }
            if (elementsSpec.customOptions == null) {
                throw new SpecException("No custom options specified for element maplayer", ErrorCode.SPEC_IS_NULL, null);
            }
            if (elementsSpec.customOptions.uri == null) {
                throw new SpecException("uri in custom options not specified for element maplayer", ErrorCode.SPEC_IS_NULL, null);
            }
            vis.customConfig = elementsSpec.customOptions;
        }
    }

    @Override
    protected Shape makeShape(Position position, Integer n) {
        return null;
    }

    @Override
    public Shape makeShapeInside(Rect rect, int n) {
        return null;
    }

    @Override
    protected Shape makeAugmentedShape(GeoData geoData, int n) {
        return null;
    }
}

