/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.element;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.geo.GeoData;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.element.Builder;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class EdgeBuilder
extends Builder {
    private String symbol;
    private String startArrow;
    private String endArrow;
    private Object paddingSpec;
    private final Boolean prefHorizontal;
    private static final String SEMICIRCLE = "semiCircle";

    EdgeBuilder(VisContext visContext, Coordinates coordinates, Dim dim, StyleSpec styleSpec) {
        super(visContext, coordinates, dim);
        this.setSnap(StyleBuilder.getSnap(styleSpec));
        if (styleSpec != null) {
            this.symbol = (String)styleSpec.symbol;
            this.startArrow = styleSpec.startArrow;
            this.endArrow = styleSpec.endArrow;
            this.paddingSpec = styleSpec.padding;
        }
        this.prefHorizontal = dim.getWidth() > dim.getHeight();
    }

    @Override
    public Shape makeShapeInside(Rect rect, int n) {
        return null;
    }

    @Override
    public Shape makeAugmentedShape(GeoData geoData, int n) {
        PolyShape[] polyShapeArray = geoData.featurePolygons(n);
        if (polyShapeArray == null) {
            return null;
        }
        double d = polyShapeArray[0].getXArray()[0];
        double d2 = polyShapeArray[0].getYArray()[0];
        PolyShape polyShape = polyShapeArray[polyShapeArray.length - 1];
        double d3 = polyShape.getXArray()[polyShape.getXArray().length - 1];
        double d4 = polyShape.getYArray()[polyShape.getYArray().length - 1];
        return ItemBuilder.makeLine(d, d2, d3, d4, null);
    }

    @Override
    protected Shape makeShape(Position position, Integer n) {
        PolyShape polyShape;
        double[] dArray;
        double[] dArray2;
        if (position.XYUndefined()) {
            return null;
        }
        if (this.coords.scales.length == 1 && position.hasY2()) {
            dArray2 = new double[2];
            dArray = new double[2];
            dArray2[0] = this.extent.getWidth() / 2.0;
            dArray[0] = this.extent.getHeight() - position.Y() * this.extent.getHeight();
            dArray2[1] = dArray2[0];
            dArray[1] = this.extent.getHeight() - position.Y2() * this.extent.getHeight();
            this.insetLineCoords(dArray2, dArray);
            polyShape = ItemBuilder.makeLineForPoints(dArray2, dArray, null);
        } else if (this.coords.scales.length == 2 && position.hasX2() && position.hasY2()) {
            dArray2 = new double[2];
            dArray = new double[2];
            dArray2[0] = position.X() * this.extent.getWidth();
            dArray[0] = this.extent.getHeight() - position.Y() * this.extent.getHeight();
            dArray2[1] = position.X2() * this.extent.getWidth();
            dArray[1] = this.extent.getHeight() - position.Y2() * this.extent.getHeight();
            this.insetLineCoords(dArray2, dArray);
            polyShape = ItemBuilder.makeLineForPoints(dArray2, dArray, null);
        } else {
            return null;
        }
        polyShape.setEdgeProperties(this.prefHorizontal, this.symbol, this.startArrow, this.endArrow);
        if (this.symbol != null && this.symbol.equals(SEMICIRCLE)) {
            double d = Math.sqrt((polyShape.getXArray()[0] - polyShape.getXArray()[1]) * (polyShape.getXArray()[0] - polyShape.getXArray()[1]) + (polyShape.getYArray()[0] - polyShape.getYArray()[1]) * (polyShape.getYArray()[0] - polyShape.getYArray()[1])) / 2.0;
            Path path = new Path(new double[]{0.0, 0.0, 0.5522875, 1.0, 1.5522875, 2.0, 2.0}, new double[]{0.0, 0.5522875, 1.0, 1.0, 1.0, 0.5522875, 0.0}, false, new char[]{'M', 'C', ',', ',', 'C', ',', ','});
            double d2 = d == 0.0 ? 0.0 : Math.abs(polyShape.getXArray()[1] - polyShape.getXArray()[0]) / (2.0 * d);
            double d3 = d == 0.0 ? 0.0 : Math.abs(polyShape.getYArray()[1] - polyShape.getYArray()[0]) / (2.0 * d);
            for (int i = 0; i < path.getXArray().length; ++i) {
                double d4 = polyShape.getXArray()[0] < polyShape.getXArray()[1] ? polyShape.getXArray()[0] + d * path.getXArray()[i] * d2 - d * d3 * path.getYArray()[i] : polyShape.getXArray()[0] - d * path.getXArray()[i] * d2 + d * d3 * path.getYArray()[i];
                double d5 = polyShape.getYArray()[0] >= polyShape.getYArray()[1] ? polyShape.getYArray()[0] - d * path.getXArray()[i] * d3 - d * d2 * path.getYArray()[i] : polyShape.getYArray()[0] + d * path.getXArray()[i] * d3 + d * d2 * path.getYArray()[i];
                path.getXArray()[i] = d4;
                path.getYArray()[i] = d5;
            }
            path.setEdgeProperties(this.prefHorizontal, this.symbol, this.startArrow, this.endArrow);
            path.setSymbol(this.symbol);
            return path;
        }
        return polyShape;
    }

    void insetLineCoords(double[] dArray, double[] dArray2) {
        int n = dArray[0] > dArray[1] ? 1 : 0;
        int n2 = dArray2[0] > dArray2[1] ? 1 : 0;
        int n3 = 1 - n;
        int n4 = 1 - n2;
        Insets insets = Insets.makeForStylePadding(this.paddingSpec, new Dim(dArray[n3] - dArray[n], dArray2[n4] - dArray2[n2]), this.extent);
        int n5 = n;
        dArray[n5] = dArray[n5] + insets.left;
        int n6 = n2;
        dArray2[n6] = dArray2[n6] + insets.top;
        int n7 = n3;
        dArray[n7] = dArray[n7] - insets.right;
        int n8 = n4;
        dArray2[n8] = dArray2[n8] - insets.bottom;
    }
}

