/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.element;

import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.grammar.LabelLineProducer;
import com.ibm.vis.engine.internal.grammar.ShapeIterator;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.element.Builder;
import com.ibm.vis.engine.internal.grammar.element.CustomBuilder;
import com.ibm.vis.engine.internal.grammar.element.EdgeBuilder;
import com.ibm.vis.engine.internal.grammar.element.IntervalBuilder;
import com.ibm.vis.engine.internal.grammar.element.PathBuilder;
import com.ibm.vis.engine.internal.grammar.element.PointBuilder;
import com.ibm.vis.engine.internal.grammar.element.PositionModifierFactory;
import com.ibm.vis.engine.internal.grammar.element.SchemaBuilder;
import com.ibm.vis.engine.internal.grammar.element.SchemaBuilderFactory;
import com.ibm.vis.engine.internal.grammar.element.TextBuilder;
import com.ibm.vis.engine.internal.grammar.element.positionmodifier.PositionModifier;
import com.ibm.vis.engine.internal.grammar.label.LabelCallout;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.label.ShapeLabelLinesHolder;
import com.ibm.vis.engine.internal.grammar.label.Tooltip;
import com.ibm.vis.engine.internal.grammar.label.TooltipProducer;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutFactory;
import com.ibm.vis.engine.internal.grammar.scale.ContinuousScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.RangeProvider;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleFitInfo;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.grammar.values.DerivedValueProducer;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.grammar.values.ValueProviderFactory;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.MappedJSONObject;
import com.ibm.vis.engine.internal.nativeImpl.SpecUtil;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.engine.internal.struct.SmoothAreaPathMaker;
import com.ibm.vis.engine.internal.struct.SmoothPolyPathMaker;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.geom.Wedge;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.ComponentSpec;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.PositionSpec;
import com.ibm.vis.spec.internal.PreferredSizeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.TooltipSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class Element
extends IdentifiableItem
implements DerivedValueProducer,
RangeProvider {
    public static final String OUTSIDE = "outside";
    public static final String LABEL_KEY_SUFFIX = "|L";
    private static final String BACKGROUND_KEY_SUFFIX = "|BL";
    public static final String ELEMENT_TEXT = "text";
    public static final String ELEMENT_POINT = "point";
    public static final String ELEMENT_INTERVAL = "interval";
    public static final String ELEMENT_SCHEMA = "schema";
    public static final String ELEMENT_EDGE = "edge";
    public static final String ELEMENT_PATH = "path";
    public static final String ELEMENT_LINE = "line";
    public static final String ELEMENT_POLYGON = "polygon";
    public static final String ELEMENT_AREA = "area";
    public static final String ELEMENT_SCHEMA_BOXPLOT = "schema:boxplot";
    public static final String ELEMENT_CUSTOM = "custom";
    public static final String AT_BOUND = "atBounds";
    public static final String NONE = "none";
    public static final String OVERLAP = "overlap";
    public static final String SYMBOL_PART = "symbol";
    public static final String SMOOTH_INTERPOLATION = "smooth";
    public static final String LABEL_ID_PREFIX = "L";
    public static final String LABEL_LINE_ID_PREFIX = "LN";
    public static final String META_PART = "part";
    public static final String DODGE_POSITION_MODIFIER = "dodge";
    public static final String SIZE_MODIFIER_TYPE_HEIGHT = "height";
    public static final String SIZE_MODIFIER_TYPE_WIDTH = "width";
    public static final int NO_CLIP = 4;
    public static final int AT_BOUND_CLIP = 2;
    public static final int OVERLAP_CLIP = 1;
    public static final ValueProvider[] EMPTY_VALUE_PROVIDERS = new ValueProvider[0];
    private static final String CHORDLAYOUT_ARC_STYLE = "arc";
    public final Grammar grammar;
    public final String type;
    public final String interactionType;
    private final double zOrder;
    public final boolean isLineWithPoints;
    public final ValueProvider[] positions;
    public final ValueProvider[] components;
    public final Aesthetic[] aesthetics;
    public final List<LabelProducer> labelProducers;
    public final ElementsSpec spec;
    public Data data;
    public final Layout layout;
    public final String[][] coordinateFieldsIDs;
    public final String[] aestheticFieldIDs;
    public List<Shape> cachedShapes;
    public Dim extent;
    public Dim size;
    public Shape baseline;
    private Builder cachedBuilder;
    private final String positionModifier;
    private final Vis vis;
    private final int elementIndex;
    private double maxShapeSize = -1.0;
    private final ArrayList<TooltipProducer> tooltipProducers = new ArrayList();
    private final Object[] description;
    private static List<String> continuousElementTypes = new ArrayList<String>();

    public Element(String string, VisInterface visInterface, Grammar grammar, ElementsSpec elementsSpec, int n) {
        super(string, visInterface);
        this.vis = (Vis)visInterface;
        this.grammar = grammar;
        this.spec = elementsSpec;
        this.elementIndex = n;
        this.description = this.spec.description;
        this.type = elementsSpec.type;
        this.zOrder = elementsSpec.zOrder == null ? 0.0 : elementsSpec.zOrder.doubleValue();
        this.interactionType = elementsSpec.interactionType;
        this.positionModifier = elementsSpec.positionModifier;
        this.positions = Element.initPositions(this.vis, elementsSpec);
        this.coordinateFieldsIDs = Element.initCoordinateFieldIds(this.positions);
        this.data = this.prepData(this.vis, this.positions);
        this.components = Element.initComponents(this.vis, elementsSpec);
        this.layout = elementsSpec.positioning == null ? null : LayoutFactory.makeLayout(elementsSpec.positioning, this.data, grammar, this.vis, elementsSpec.style, elementsSpec.styles);
        this.aesthetics = Aesthetic.getElementAesthetics(this, elementsSpec);
        this.aestheticFieldIDs = Element.initAestheticFieldIDs(this.aesthetics);
        this.isLineWithPoints = this.type.equals(ELEMENT_LINE) && this.spec.symbolStyle != null;
        this.labelProducers = this.prepLabelProducers(this.vis, elementsSpec, grammar);
    }

    private void initTooltips() {
        if (this.tooltipProducers != null && this.spec.tooltip != null) {
            TooltipSpec[] tooltipSpecArray;
            for (TooltipSpec tooltipSpec : tooltipSpecArray = this.spec.tooltip) {
                String string = tooltipSpec.modifies == null ? null : tooltipSpec.modifies.part;
                this.tooltipProducers.add(new TooltipProducer(this.data, this.vis, string, tooltipSpec));
            }
        }
    }

    private List<LabelProducer> prepLabelProducers(Vis vis, ElementsSpec elementsSpec, Grammar grammar) {
        ArrayList<LabelProducer> arrayList = new ArrayList<LabelProducer>();
        if (elementsSpec.label != null) {
            ElementLabelSpec[] elementLabelSpecArray;
            boolean bl = Element.isInside(this.type);
            for (ElementLabelSpec elementLabelSpec : elementLabelSpecArray = elementsSpec.label) {
                LabelProducer labelProducer = LabelProducer.makeForData(this.data, vis, bl, elementLabelSpec, null, !this.grammar.isLabelCollisionMethodNone());
                StyleSpec styleSpec = elementsSpec.style;
                if (styleSpec != null && styleSpec.stroke != null && styleSpec.outline != null && !grammar.coordinates.containsPolar()) {
                    labelProducer.addPaddingForOutline(elementsSpec.style);
                }
                labelProducer.addAesthetics(Aesthetic.getLabelAesthetics(this, labelProducer, elementLabelSpec));
                arrayList.add(labelProducer);
            }
        }
        return arrayList;
    }

    private List<LabelLineProducer> prepLabelLineProducers(Vis vis, ElementsSpec elementsSpec, Grammar grammar) {
        ArrayList<LabelLineProducer> arrayList = new ArrayList<LabelLineProducer>();
        if (elementsSpec.label != null) {
            for (ElementLabelSpec elementLabelSpec : elementsSpec.label) {
                String string = this.getLabelPosition(elementLabelSpec);
                Object object = elementLabelSpec.lineMinSize;
                if (object != null && OUTSIDE.equals(string)) {
                    Dim dim;
                    Double d;
                    Double d2 = Math.min(grammar.graphSize.getHeight(), grammar.graphSize.getWidth());
                    Double d3 = UnitConverter.convertLength(object, d2, d = Double.valueOf(Math.min((dim = vis.getSize()).getHeight(), dim.getWidth())));
                    if (d3 == null) continue;
                    arrayList.add(new LabelLineProducer(elementLabelSpec.lineStyle, d3));
                    continue;
                }
                arrayList.add(null);
            }
        }
        return arrayList;
    }

    private String getLabelPosition(ElementLabelSpec elementLabelSpec) {
        if (elementLabelSpec == null || elementLabelSpec.style == null || elementLabelSpec.style.location == null) {
            if (Element.isInside(this.type)) {
                return "inside";
            }
            return OUTSIDE;
        }
        return elementLabelSpec.style.location;
    }

    private static String[] initAestheticFieldIDs(Aesthetic[] aestheticArray) {
        String[] stringArray = new String[aestheticArray.length];
        for (int i = 0; i < aestheticArray.length; ++i) {
            stringArray[i] = aestheticArray[i].valueProvider.getBaseField() == null ? null : aestheticArray[i].valueProvider.getBaseField().id;
        }
        return stringArray;
    }

    private static ValueProvider[] initComponents(Vis vis, ElementsSpec elementsSpec) {
        ValueProvider[] valueProviderArray;
        if (elementsSpec.components != null) {
            ComponentSpec[] componentSpecArray = elementsSpec.components;
            valueProviderArray = new ValueProvider[componentSpecArray.length];
            for (int i = 0; i < valueProviderArray.length; ++i) {
                valueProviderArray[i] = ValueProviderFactory.makeComponentProvider(componentSpecArray[i], vis);
            }
        } else {
            valueProviderArray = new ValueProvider[]{ValueProviderFactory.DEFAULT, ValueProviderFactory.DEFAULT};
        }
        return valueProviderArray;
    }

    private static String[][] initCoordinateFieldIds(ValueProvider[] valueProviderArray) {
        String[][] stringArray = new String[valueProviderArray.length][];
        for (int i = 0; i < valueProviderArray.length; ++i) {
            stringArray[i] = valueProviderArray[i].getBaseField() == null ? null : new String[]{valueProviderArray[i].getBaseField().id};
        }
        return stringArray;
    }

    private static ValueProvider[] initPositions(Vis vis, ElementsSpec elementsSpec) {
        ValueProvider[] valueProviderArray;
        if (elementsSpec.positioning == null) {
            PositionSpec[] positionSpecArray = elementsSpec.position;
            if (positionSpecArray == null) {
                valueProviderArray = EMPTY_VALUE_PROVIDERS;
            } else {
                valueProviderArray = new ValueProvider[positionSpecArray.length];
                for (int i = 0; i < valueProviderArray.length; ++i) {
                    valueProviderArray[i] = ValueProviderFactory.makePositionProvider(positionSpecArray[i], vis);
                }
            }
        } else {
            valueProviderArray = new ValueProvider[]{ValueProviderFactory.DEFAULT, ValueProviderFactory.DEFAULT};
        }
        return valueProviderArray;
    }

    public Dim getPreferredSize() {
        if (this.layout == null) {
            return new Dim(400.0, 400.0);
        }
        Dim dim = this.extent;
        this.extent = new Dim(5000.0, 5000.0);
        Dim dim2 = this.calculateDefaultShapeSize(this.spec.style);
        Builder builder = this.makeBuilder(this.grammar.coordinates, this.type, this.extent, dim2, this.spec.style);
        this.layout.getAdapter().connect(this.data.rows, builder, this.elementIndex);
        Dim dim3 = this.layout.getPreferredSize(this.data.rows.length);
        this.extent = dim;
        return dim3;
    }

    public ShapeList makeShapes(String string, Coordinates coordinates, Dim dim, int n, Rect rect, Rect rect2) {
        Object object;
        Builder builder;
        Dim dim2;
        String string2 = string + "E" + n;
        if (!this.usesStacking()) {
            coordinates = coordinates.removeStackTransform();
        }
        this.extent = dim;
        this.size = dim2 = this.calculateDefaultShapeSize(this.spec.style);
        this.cachedBuilder = builder = this.makeBuilder(coordinates, this.type, dim, dim2, this.spec.style);
        Builder builder2 = null;
        if (this.isLineWithPoints) {
            object = this.calculateDefaultShapeSize(this.spec.symbolStyle);
            builder2 = this.makeBuilder(coordinates, ELEMENT_POINT, dim, (Dim)object, this.spec.symbolStyle);
        }
        this.setBaseline(coordinates, builder);
        object = this.makeBaseShapes(coordinates, dim, n, builder, builder2, rect2);
        ((ShapeList)object).applyShapeIDs(string2);
        this.applyElementProperties((ShapeList)object, dim);
        this.applyFaceting((ShapeList)object);
        this.applyCoordinateTransforms((ShapeList)object, coordinates, dim);
        this.applyStylesAndAesthetics((ShapeList)object);
        this.applyPositionModifiers((ShapeList)object, coordinates);
        this.cachedShapes = new ArrayList<Shape>(((ShapeList)object).getAllShapes());
        this.cacheDefenderScrollUnit((ShapeList)object);
        this.applyLabels(string2, (ShapeList)object, rect);
        return object;
    }

    private void applyStylesAndAesthetics(ShapeList shapeList) {
        boolean bl;
        boolean bl2 = bl = this.layout == null || !this.layout.needsAestheticsPreApplied();
        if (bl) {
            this.styleShapes(shapeList);
            this.applyAesthetics(shapeList);
        } else {
            for (Shape shape : shapeList.getElementShapes()) {
                if (shape.getRows() == null) continue;
                Row row = this.data.rows[shape.getRows()[0]];
                for (Aesthetic aesthetic : this.aesthetics) {
                    if (!aesthetic.type.equals("color")) continue;
                    aesthetic.apply(shape, row);
                }
            }
        }
    }

    private void applyCoordinateTransforms(ShapeList shapeList, Coordinates coordinates, Dim dim) {
        if (this.layout == null || this.layout.respectsTransforms()) {
            coordinates.modifyShapes(shapeList, dim);
        }
        if (coordinates.containsPolar()) {
            this.updateWedgeShapes(shapeList);
        }
    }

    private void applyFaceting(ShapeList shapeList) {
        this.grammar.faceting.addFacetInfoToShapes(shapeList, this);
    }

    private void applyElementProperties(ShapeList shapeList, Dim dim) {
        Rect rect = new Rect(0.0, 0.0, dim.getWidth(), dim.getHeight());
        for (Shape shape : shapeList.getElementShapes()) {
            Element.setOriginalRowFromData(shape, this.data);
            shape.setGlobalGradient(rect);
            shape.setIsElement(true);
        }
    }

    private static void setOriginalRowFromData(Shape shape, Data data) {
        int[] nArray = shape.getRows();
        if (nArray == null) {
            return;
        }
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        for (int n : shape.getRows()) {
            Row[] rowArray = data.rows;
            if (rowArray == null || rowArray.length <= n) continue;
            Row row = rowArray[n];
            row.addOriginalRows(intPrimitiveArrayList, false);
        }
        if (intPrimitiveArrayList.size() > 0) {
            shape.setOriginalRows(intPrimitiveArrayList.toArray());
        }
    }

    private ShapeList makeBaseShapes(Coordinates coordinates, Dim dim, int n, Builder builder, Builder builder2, Rect rect) {
        ShapeList shapeList;
        if (this.vis.getVisContext().isUpdateDataOnly() && this.layout != null) {
            this.layout.prepareForNewRows(this.data.rows.length);
        }
        if (this.layout != null) {
            Rect rect2 = coordinates.getLayoutBounds(dim);
            this.layout.getAdapter().setLayoutBoundsStartPoint(new Point(rect2.getX(), rect2.getY()));
            builder.extent = dim = new Dim(rect2.getWidth(), rect2.getHeight());
            shapeList = this.makeByLayout(dim, n, builder, rect2);
        } else {
            shapeList = this.usesAugmentation() ? this.makeByPositions(coordinates, builder, rect) : (builder.makesContinuousShapes() ? this.makePerSplitShape(coordinates, builder, builder2) : this.makeByPositions(coordinates, builder, rect));
        }
        return shapeList;
    }

    public double getAreaUnderCurve() {
        Field field;
        boolean bl;
        boolean bl2 = bl = !this.type.equals(ELEMENT_EDGE) && !this.type.equals(ELEMENT_TEXT) && this.data != null && !this.data.isPdf();
        if (bl && this.positions != null && this.positions.length >= 2 && (field = this.positions[1].getBaseField()) != null) {
            Range range = field.getDataRange();
            double d = field.granularity == null ? range.getRange() / (double)(this.data.rows.length - 1) : field.granularity;
            double d2 = 0.0;
            for (Row row : this.data.rows) {
                Double d3 = this.positions[0].getNumber(row);
                if (d3 == null) continue;
                d2 += d3 * d;
            }
            return d2;
        }
        return Double.NaN;
    }

    public void addSpaceRequirements(ScaleFitInfo scaleFitInfo, boolean bl) {
        StyleSpec styleSpec = this.spec.style;
        if (this.isLineWithPoints) {
            styleSpec = this.spec.symbolStyle;
        }
        double d = StyleBuilder.getStrokeWidth(styleSpec);
        double d2 = 0.03;
        double d3 = 0.005;
        if (styleSpec != null && (this.isLineWithPoints || ELEMENT_POINT.equals(this.type) || ELEMENT_INTERVAL.equals(this.type) && !bl || this.type.contains(ELEMENT_SCHEMA) || ELEMENT_TEXT.equals(this.type))) {
            PreferredSizeSpec[] preferredSizeSpecArray = Element.buildPreferredDimension(styleSpec, new Dim(0.0, 0.0));
            Double d4 = UnitConverter.convertLength(preferredSizeSpecArray[0], 15.0, 300.0);
            Double d5 = UnitConverter.convertLength(preferredSizeSpecArray[1], 15.0, 300.0);
            assert (d4 != null && d5 != null);
            double d6 = bl ? d5.doubleValue() : d4.doubleValue();
            if (this.needsSpaceAdjustment(styleSpec)) {
                d6 = Math.min(d4, d5);
            }
            if (d6 > 0.0) {
                d += d6;
                d2 = d3;
            }
        }
        scaleFitInfo.requirePadding(this, d / 2.0, d2 / 2.0);
    }

    private boolean needsSpaceAdjustment(StyleSpec styleSpec) {
        if (this.isLineWithPoints || ELEMENT_POINT.equals(this.type)) {
            Object object = styleSpec.symbol;
            if (object == null) {
                String string = "circle";
            } else if (BasicFactory.isString(object)) {
                String string = (String)object;
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private Data prepData(Vis vis, ValueProvider[] valueProviderArray) {
        Data data = this.chooseData(vis, valueProviderArray);
        if (data != null && data.fields != null && data.fields.length > 0 && !data.isDerived()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Field object : data.fields) {
                arrayList.add(object.id);
            }
            Element.verifyThatFieldExists(vis, data, arrayList);
            for (ValueProvider valueProvider : this.positions) {
                if (valueProvider.getBaseField() == null || arrayList.contains(valueProvider.getBaseField().id)) continue;
                String string = "Field id '" + valueProvider.getBaseField().id + "' does not exist in data source '" + data.id + "'.";
                throw new SpecException(string, ErrorCode.SPEC_INVALID_DATA_FIELD_REFERENCE, null);
            }
        }
        return data;
    }

    private static void verifyThatFieldExists(Vis vis, Data data, List<String> list) {
        GrammarSpec[] grammarSpecArray;
        VisJSONSpec visJSONSpec = vis.getCurrentSpec();
        if (visJSONSpec == null || visJSONSpec.grammar == null || visJSONSpec.grammar.length == 0) {
            return;
        }
        for (GrammarSpec grammarSpec : grammarSpecArray = visJSONSpec.grammar) {
            ElementsSpec[] elementsSpecArray = grammarSpec.elements;
            if (elementsSpecArray == null || elementsSpecArray.length <= 0) continue;
            Element.verifyElements(data, list, elementsSpecArray);
        }
    }

    private static void verifyElements(Data data, List<String> list, ElementsSpec[] elementsSpecArray) {
        for (ElementsSpec elementsSpec : elementsSpecArray) {
            PositionSpec[] positionSpecArray = elementsSpec.position;
            if (positionSpecArray == null || positionSpecArray.length <= 0 || !Element.refMatchesData(data, elementsSpec)) continue;
            Element.verifyElementPositions(data, list, positionSpecArray);
        }
    }

    private static void verifyElementPositions(Data data, List<String> list, PositionSpec[] positionSpecArray) {
        for (PositionSpec positionSpec : positionSpecArray) {
            FieldValueRefSpec fieldValueRefSpec = positionSpec.field;
            if (fieldValueRefSpec == null || fieldValueRefSpec.$ref == null || list.contains(fieldValueRefSpec.$ref)) continue;
            String string = "Field id '" + fieldValueRefSpec.$ref + "' does not exist in data source '" + data.id + "'.";
            throw new SpecException(string, ErrorCode.SPEC_INVALID_DATA_FIELD_REFERENCE, null);
        }
    }

    private static boolean refMatchesData(Data data, ElementsSpec elementsSpec) {
        return elementsSpec.data != null && elementsSpec.data.$ref != null && elementsSpec.data.$ref.equals(data.id);
    }

    private Data chooseData(Vis vis, ValueProvider[] valueProviderArray) {
        if (vis.getData() == null || vis.getData().length == 0) {
            return null;
        }
        if (vis.getData().length == 1) {
            return vis.getData()[0];
        }
        if (this.spec.data != null && this.spec.data.$ref != null) {
            return (Data)vis.getByID(this.spec.data.$ref);
        }
        Object object = valueProviderArray;
        int n = ((ValueProvider[])object).length;
        for (int i = 0; i < n; ++i) {
            ValueProvider valueProvider = object[i];
            if (valueProvider.getBaseField() == null) continue;
            return valueProvider.getBaseField().data;
        }
        if ((this.type.equals(ELEMENT_EDGE) || this.type.equals(ELEMENT_PATH) || this.type.equals(ELEMENT_LINE)) && this.spec.positioning != null) {
            if (this.spec.positioning.from != null) {
                object = this.spec.positioning.from.$ref;
            } else if (this.spec.positioning.to != null) {
                object = this.spec.positioning.to.$ref;
            } else {
                throw new SpecException("Element " + this.elementIndex + ": The LayoutSpec for a '" + this.type + "' element must contain 'from' and 'to' fields", ErrorCode.SPEC_MISSING_PARAMETER, null);
            }
            Field field = (Field)vis.getByID((String)object);
            return field.data;
        }
        if (this.spec.positioning != null) {
            if (this.spec.positioning.id != null) {
                object = (Field)vis.getByID(this.spec.positioning.id.$ref);
                return object.data;
            }
            if (this.spec.positioning.layer != null) {
                object = (Field)vis.getByID(this.spec.positioning.layer.$ref);
                return object.data;
            }
            if (this.spec.positioning.order != null) {
                object = (Field)vis.getByID(this.spec.positioning.order.$ref);
                return object.data;
            }
        }
        if ((object = this.chooseDataFromAesthetics()) != null) {
            return object;
        }
        object = this.chooseDataFromTextContents();
        if (object != null) {
            return object;
        }
        object = this.chooseDataFromComponents();
        if (object != null) {
            return object;
        }
        if (valueProviderArray.length > 0) {
            if (ELEMENT_POINT.equals(this.type) || ELEMENT_EDGE.equals(this.type) || ELEMENT_INTERVAL.equals(this.type) || ELEMENT_TEXT.equals(this.type)) {
                return null;
            }
            throw new SpecException("Element " + this.elementIndex + ": A '" + this.type + "' element cannot be used as a guide element (with all positions constant) unless the 'data' property is set", ErrorCode.SPEC_BAD_GUIDE_ELEMENT, null);
        }
        throw new SpecException("Element " + this.elementIndex + ": The data for element of type '" + this.type + "' cannot be located, try setting the 'data' property", ErrorCode.SPEC_UNABLE_TO_LOCATE_DATA, null);
    }

    private Data chooseDataFromAesthetics() {
        AestheticSpec[][] aestheticSpecArrayArray;
        for (AestheticSpec[] aestheticSpecArray : aestheticSpecArrayArray = new AestheticSpec[][]{this.spec.accessibility, this.spec.color, this.spec.dashing, this.spec.font, this.spec.meta, this.spec.offset, this.spec.size, this.spec.split, this.spec.styleBy, this.spec.symbol, this.spec.visibility}) {
            if (aestheticSpecArray == null) continue;
            for (AestheticSpec aestheticSpec : aestheticSpecArray) {
                if (aestheticSpec.field == null || aestheticSpec.field.$ref == null) continue;
                Field field = (Field)this.vis.getByID(aestheticSpec.field.$ref);
                return field.data;
            }
        }
        return null;
    }

    private Data chooseDataFromTextContents() {
        Data data;
        MappedJSONObject[] mappedJSONObjectArray;
        if (this.spec.content != null && (mappedJSONObjectArray = this.chooseDataFromContent(this.spec.content)) != null) {
            return mappedJSONObjectArray;
        }
        if (this.spec.label != null) {
            for (MappedJSONObject mappedJSONObject : this.spec.label) {
                data = this.chooseDataFromContent(((ElementLabelSpec)mappedJSONObject).content);
                if (data == null) continue;
                return data;
            }
        }
        if (this.spec.tooltip != null) {
            for (MappedJSONObject mappedJSONObject : this.spec.tooltip) {
                data = this.chooseDataFromContent(((TooltipSpec)mappedJSONObject).content);
                if (data == null) continue;
                return data;
            }
        }
        return null;
    }

    private Data chooseDataFromContent(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        for (Object object : objectArray) {
            IdentifiableItem identifiableItem;
            String string = SpecUtil.get$RefFromReference(object);
            if (string == null || !((identifiableItem = this.vis.getByID(string)) instanceof Field)) continue;
            return ((Field)identifiableItem).data;
        }
        return null;
    }

    private Data chooseDataFromComponents() {
        if (this.spec.components != null) {
            for (ComponentSpec componentSpec : this.spec.components) {
                if (componentSpec.field == null || componentSpec.field.$ref == null) continue;
                Field field = (Field)this.vis.getByID(componentSpec.field.$ref);
                return field.data;
            }
        }
        return null;
    }

    private void addLabels(ShapeList shapeList, String string) {
        int n;
        int n2 = this.labelProducers.size();
        ArrayList<List<ShapeLabelLinesHolder>> arrayList = new ArrayList<List<ShapeLabelLinesHolder>>(n2);
        ArrayList<List<Shape>> arrayList2 = new ArrayList<List<Shape>>(n2);
        ArrayList<List<Text>> arrayList3 = new ArrayList<List<Text>>(n2);
        ArrayList<StyleSpec> arrayList4 = new ArrayList<StyleSpec>(n2);
        for (n = 0; n < n2; ++n) {
            arrayList.add(new ArrayList());
            arrayList2.add(new ArrayList());
            arrayList3.add(new ArrayList());
            arrayList4.add(this.spec.label[n].lineStyle);
        }
        n = this.getClip();
        ShapeIterator<Shape> shapeIterator = shapeList.elementIterator();
        while (shapeIterator.hasNext()) {
            Rect rect;
            Shape shape = (Shape)shapeIterator.next();
            Rect rect2 = shape.getSpanClipBounds();
            Rect rect3 = rect = rect2 != null ? Shape.toRect(shape.getBounds().makeIntersection(rect2)) : null;
            if (n != 4 && rect2 != null && (rect == null || !rect.hasExtent())) continue;
            this.applyLabelsToShape(shapeList, string, arrayList, arrayList2, shape, arrayList3);
        }
        this.applyCallouts(shapeList, string, n2, arrayList, arrayList2, arrayList3, arrayList4);
    }

    private void applyCallouts(ShapeList shapeList, String string, int n, List<List<ShapeLabelLinesHolder>> list, List<List<Shape>> list2, List<List<Text>> list3, List<StyleSpec> list4) {
        Object object;
        Object object2;
        int n2;
        LabelCallout labelCallout = new LabelCallout(this.grammar, this, this.extent);
        for (n2 = 0; n2 < n; ++n2) {
            object2 = list.get(n2);
            object = this.labelProducers.get(n2);
            if (!"callout".equals(((LabelProducer)object).getLocation())) continue;
            labelCallout.modifyShapes((List<ShapeLabelLinesHolder>)object2, (LabelProducer)object, list4.get(n2));
        }
        for (n2 = 0; n2 < n; ++n2) {
            object2 = list.get(n2);
            object = list3.get(n2);
            assert (object2 != null);
            assert (object != null);
            Element.addCalloutLinesAndArrangeLabels(shapeList, (List<ShapeLabelLinesHolder>)object2, string, object);
        }
        for (n2 = 0; n2 < n; ++n2) {
            object2 = this.labelProducers.get(n2);
            object = list2.get(n2);
            Element.adjustLabelPlaques(shapeList, object, (LabelProducer)object2);
        }
    }

    private static void addCalloutLinesAndArrangeLabels(ShapeList shapeList, List<ShapeLabelLinesHolder> list, String string, List<Text> list2) {
        Object object;
        Object object2;
        ShapeIterator<Text> shapeIterator = shapeList.elementLabelIterator(0);
        for (Text object3 : list2) {
            boolean bl = shapeIterator.seekTo(object3);
            assert (bl);
            object2 = object3.getID();
            assert (object2 != null);
            object = Element.getShapeLabelLineHolderForLabelId(list, (String)object2);
            if (object == null) {
                shapeIterator.remove();
                continue;
            }
            shapeIterator.replace(((ShapeLabelLinesHolder)object).getShapeLabel());
        }
        Element.setLabelLineIds(list, string);
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            Text text = shapeLabelLinesHolder.getShapeLabel();
            object2 = shapeLabelLinesHolder.getLabelLine();
            object = shapeLabelLinesHolder.getElementShape();
            if (object2 == null || text == null || text.getText() == null || text.getText().trim().length() <= 0) continue;
            shapeList.addLabelLine((Shape)object2, (Shape)object, text, false);
        }
    }

    private static void adjustLabelPlaques(ShapeList shapeList, List<Shape> list, LabelProducer labelProducer) {
        ShapeIterator<Shape> shapeIterator = shapeList.plaqueIterator();
        for (Shape shape : list) {
            if (1004 != shape.getType() && 1002 != shape.getType()) continue;
            Text text = shapeList.getLabelForPlaque(shape);
            ShapeIterator<Text> shapeIterator2 = shapeList.elementLabelIterator(0);
            boolean bl = shapeIterator2.seekTo(text);
            if (!bl) {
                shape.setWidth(0.0);
                shape.setHeight(0.0);
                continue;
            }
            if (text.getText() != null && text.getText().trim().length() == 0) {
                bl = shapeIterator.seekTo(shape);
                assert (bl);
                shapeIterator.remove();
                continue;
            }
            labelProducer.adjustPlaqueBounds(text, shape);
        }
    }

    private void applyLabelsToShape(ShapeList shapeList, String string, List<List<ShapeLabelLinesHolder>> list, List<List<Shape>> list2, Shape shape, List<List<Text>> list3) {
        Object object;
        int n = this.labelProducers.size();
        String string2 = string + LABEL_ID_PREFIX;
        if (this.layout != null) {
            object = null;
            if (this.labelProducers != null && this.labelProducers.size() > 0) {
                object = this.labelProducers.get(0);
            }
            if (this.layout.applyLabels(shape, shapeList, this.shouldRemoveLabelTooltips((LabelProducer)object))) {
                return;
            }
            shape = this.layout.getLabelShape(shape);
        }
        object = this.prepLabelLineProducers(this.vis, this.spec, this.grammar);
        int n2 = shape.getID().indexOf("S");
        String string3 = shape.getID().substring(n2 + 1);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            LabelProducer labelProducer = this.labelProducers.get(i);
            LabelLineProducer labelLineProducer = (LabelLineProducer)object.get(i);
            ElementLabelSpec elementLabelSpec = this.spec.label[i];
            boolean bl2 = this.putLabelWithShape(labelProducer);
            Text text = labelProducer.makeLabel(elementLabelSpec.content, shape);
            if (text == null) {
                list.get(i).add(new ShapeLabelLinesHolder(shape, null, null));
                continue;
            }
            this.preventLineWithPointsOverlap(shape, text);
            Shape shape2 = labelProducer.makeLabelBackground(text, shape);
            if (labelProducer.style.location == null || labelProducer.style.location.isEmpty()) {
                labelProducer.style.location = OUTSIDE;
            }
            boolean bl3 = bl = shape.isVisible() && text.isVisible();
            if (shape2 != null) {
                shape2.addMeta(shape);
                shape2.setVisible(bl);
                if ("callout".equals(labelProducer.style.location)) {
                    list2.get(i).add(shape2);
                }
                if (shape.getKey() != null) {
                    shape2.setKey(shape.getKey() + BACKGROUND_KEY_SUFFIX);
                }
                shape2.setID(string2 + "B" + string3);
            }
            shapeList.addPlaqueAndLabelForShape(shape, text, shape2, bl2, labelLineProducer);
            text.addMeta(shape);
            text.setVisible(bl);
            if ("callout".equals(labelProducer.style.location)) {
                list.get(i).add(new ShapeLabelLinesHolder(shape, text, null));
                list3.get(i).add(text);
            }
            if (this.shouldRemoveLabelTooltips(labelProducer)) {
                text.disableTooltip();
            }
            if (shape.getKey() == null) continue;
            text.setKey(shape.getKey() + LABEL_KEY_SUFFIX);
        }
    }

    protected boolean shouldRemoveLabelTooltips(LabelProducer labelProducer) {
        return labelProducer != null && this.spec.tooltip != null && this.spec.tooltip.length > 0 && !ELEMENT_TEXT.equals(this.type) && "inside".equals(labelProducer.getLocation());
    }

    private static ShapeLabelLinesHolder getShapeLabelLineHolderForLabelId(List<ShapeLabelLinesHolder> list, String string) {
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            String string2;
            if (shapeLabelLinesHolder.getShapeLabel() == null || (string2 = shapeLabelLinesHolder.getShapeLabel().getID()) == null || !string2.equals(string)) continue;
            return shapeLabelLinesHolder;
        }
        return null;
    }

    private static void setLabelLineIds(List<ShapeLabelLinesHolder> list, String string) {
        String string2 = string + LABEL_LINE_ID_PREFIX;
        int n = 0;
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            ShapePoly shapePoly = shapeLabelLinesHolder.getLabelLine();
            if (shapePoly == null) continue;
            shapePoly.setID(string2 + n++);
        }
    }

    private boolean putLabelWithShape(LabelProducer labelProducer) {
        return ELEMENT_TEXT.equals(this.type) || ELEMENT_POINT.equals(this.type) || SYMBOL_PART.equals(labelProducer.part) || this.isLineWithPoints;
    }

    private void preventLineWithPointsOverlap(Shape shape, Shape shape2) {
        if (this.isLineWithPoints && this.spec.symbolStyle != null && ELEMENT_LINE.equals(shape.getElementPart())) {
            Text text = (Text)shape2;
            if (!"middle".equals(text.valign)) {
                double d = this.calculateDefaultShapeSize(this.spec.symbolStyle).getHeight();
                int n = "start".equals(text.valign) ? -1 : 1;
                text.getPoint().setY(text.getPoint().getY() + (double)n * d / 2.0);
            }
        }
    }

    public Builder makeBuilder(Coordinates coordinates, String string, Dim dim, Dim dim2, StyleSpec styleSpec) {
        VisContext visContext = this.vis.getVisContext();
        if (string.startsWith(ELEMENT_SCHEMA)) {
            return SchemaBuilderFactory.createBuilder(visContext, coordinates, dim, string, dim2, this.components, this.data.rows, styleSpec);
        }
        if (string.equals(ELEMENT_INTERVAL)) {
            return new IntervalBuilder(visContext, coordinates, dim, dim2, styleSpec, this.getClip() == 2);
        }
        if (string.equals(ELEMENT_POINT)) {
            return new PointBuilder(visContext, coordinates, dim, dim2, styleSpec);
        }
        if (string.equals(ELEMENT_EDGE)) {
            return new EdgeBuilder(visContext, coordinates, dim, styleSpec);
        }
        if (string.equals(ELEMENT_PATH)) {
            return new PathBuilder(visContext, coordinates, dim, false, false, false, null, styleSpec);
        }
        if (string.equals(ELEMENT_LINE)) {
            return this.getBuilder(coordinates, dim, true, false, false, string, styleSpec);
        }
        if (string.equals(ELEMENT_POLYGON)) {
            return new PathBuilder(visContext, coordinates, dim, false, true, false, null, styleSpec);
        }
        if (string.equals(ELEMENT_AREA)) {
            return this.getBuilder(coordinates, dim, true, true, true, string, styleSpec);
        }
        if (string.equals(ELEMENT_TEXT)) {
            return new TextBuilder(visContext, coordinates, dim, this.vis, this.data, dim2, this.spec);
        }
        if (string.equals(ELEMENT_CUSTOM)) {
            return new CustomBuilder(visContext, coordinates, dim, this.vis, this.data, dim2, this.spec);
        }
        throw new UnsupportedOperationException("Type '" + string + "' not supported yet");
    }

    private Builder getBuilder(Coordinates coordinates, Dim dim, boolean bl, boolean bl2, boolean bl3, String string, StyleSpec styleSpec) {
        if (SMOOTH_INTERPOLATION.equals(this.spec.interpolation)) {
            SmoothPolyPathMaker smoothPolyPathMaker = ELEMENT_AREA.equals(string) ? new SmoothAreaPathMaker() : new SmoothPolyPathMaker();
            return new PathBuilder(this.vis.getVisContext(), coordinates, dim, bl, bl2, bl3, smoothPolyPathMaker, styleSpec);
        }
        return new PathBuilder(this.vis.getVisContext(), coordinates, dim, bl, bl2, bl3, null, styleSpec);
    }

    public Dim calculateDefaultShapeSize(StyleSpec styleSpec) {
        Double d;
        Double d2;
        PreferredSizeSpec[] preferredSizeSpecArray;
        Dim dim;
        Dim dim2;
        Dim dim3 = dim2 = this.extent == null ? new Dim(1000.0, 1000.0) : this.extent;
        if (this.layout != null) {
            dim = this.layout.getDefaultShapeSize(dim2, this.data.rows.length);
        } else if (ELEMENT_TEXT.equals(this.type) && styleSpec != null && styleSpec.font != null && styleSpec.font.size != null) {
            preferredSizeSpecArray = Element.buildPreferredDimension(styleSpec, dim2);
            d2 = UnitConverter.convertLength(preferredSizeSpecArray[0].preferred, dim2.getWidth(), dim2.getWidth());
            d = UnitConverter.convertLength(preferredSizeSpecArray[1].preferred, dim2.getHeight(), dim2.getHeight());
            dim = new Dim(d2 == null ? dim2.getWidth() : d2.doubleValue(), d == null ? dim2.getHeight() : d.doubleValue());
        } else {
            dim = this.grammar.coordinates.getDefaultSize(dim2, this.positions, this.type);
        }
        if (styleSpec != null) {
            preferredSizeSpecArray = Element.buildPreferredDimension(styleSpec, dim);
            d2 = UnitConverter.convertLength(preferredSizeSpecArray[0], dim.getWidth(), dim2.getWidth());
            d = UnitConverter.convertLength(preferredSizeSpecArray[1], dim.getHeight(), dim2.getHeight());
            assert (d2 != null);
            assert (d != null);
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            if (d < 0.0) {
                d = 0.0;
            }
            dim.setWidth(d2);
            dim.setHeight(d);
        }
        return dim;
    }

    private static PreferredSizeSpec[] buildPreferredDimension(StyleSpec styleSpec, Dim dim) {
        PreferredSizeSpec preferredSizeSpec = Element.getPreferredSizeSpecForSize(styleSpec);
        PreferredSizeSpec preferredSizeSpec2 = Element.buildPreferredSizeSpec(preferredSizeSpec, styleSpec.width, dim.getWidth());
        PreferredSizeSpec preferredSizeSpec3 = Element.buildPreferredSizeSpec(preferredSizeSpec, styleSpec.height, dim.getHeight());
        return new PreferredSizeSpec[]{preferredSizeSpec2, preferredSizeSpec3};
    }

    private static PreferredSizeSpec getPreferredSizeSpecForSize(StyleSpec styleSpec) {
        PreferredSizeSpec preferredSizeSpec = new PreferredSizeSpec();
        if (styleSpec.size != null) {
            if (BasicFactory.isNumber(styleSpec.size) || BasicFactory.isString(styleSpec.size)) {
                preferredSizeSpec.preferred = styleSpec.size;
            } else if (styleSpec.size instanceof PreferredSizeSpec) {
                preferredSizeSpec = (PreferredSizeSpec)styleSpec.size;
            }
        }
        return preferredSizeSpec;
    }

    private static PreferredSizeSpec buildPreferredSizeSpec(PreferredSizeSpec preferredSizeSpec, Object object, double d) {
        PreferredSizeSpec preferredSizeSpec2 = new PreferredSizeSpec();
        if (object != null) {
            if (BasicFactory.isNumber(object) || BasicFactory.isString(object)) {
                preferredSizeSpec2.preferred = object;
            } else {
                preferredSizeSpec2 = (PreferredSizeSpec)object;
            }
        }
        if (preferredSizeSpec2.preferred == null) {
            Object object2 = preferredSizeSpec2.preferred = preferredSizeSpec.preferred == null ? Double.valueOf(d) : preferredSizeSpec.preferred;
        }
        if (preferredSizeSpec2.max == null) {
            preferredSizeSpec2.max = preferredSizeSpec.max;
        }
        if (preferredSizeSpec2.min == null) {
            preferredSizeSpec2.min = preferredSizeSpec.min;
        }
        return preferredSizeSpec2;
    }

    private ShapeList makeByLayout(Dim dim, int n, Builder builder, Rect rect) {
        double d;
        this.layout.getAdapter().connect(this.data.rows, builder, n);
        ShapeList shapeList = this.layout.buildLayout(this.data.rows.length, dim, rect);
        if (this.data.keyField != null) {
            for (Shape shape : shapeList.getElementShapes()) {
                int[] nArray;
                if (shape.getKey() != null || (nArray = shape.getRows()) == null) continue;
                shape.setKey(this.data.getKey(this.data.rows[nArray[0]]));
            }
        }
        double d2 = d = FontHelper.getDefaultFontSize(this.vis.getVisContext().getMinimumFontSize());
        for (Shape shape : shapeList.getElementShapes()) {
            Object object;
            double d3;
            if (!(shape instanceof Text) || !((d3 = ((Text)(object = (Text)shape)).getFont().getSize()) > d2)) continue;
            d2 = d3;
        }
        double d4 = 0.0;
        for (Aesthetic aesthetic : this.aesthetics) {
            for (int i = 0; aesthetic.getMapping() != null && i < aesthetic.getMapping().size(); ++i) {
                double d5;
                Object object = aesthetic.getMapping().getValue(i);
                if (!(object instanceof String) || !((String)object).endsWith("%") || !((d5 = UnitConverter.convertLength(object, 100.0, 100.0) / 100.0) > d4)) continue;
                d4 = d5;
            }
        }
        if (d4 == 0.0) {
            d4 = 1.0;
        }
        this.maxShapeSize = d2 / d4 / 0.85;
        return shapeList;
    }

    public boolean usesStacking() {
        return this.positionModifier == null || !this.positionModifier.equals(NONE);
    }

    private void cacheDefenderScrollUnit(ShapeList shapeList) {
        ShapeIterator<Shape> shapeIterator = shapeList.elementIterator();
        if ("scrollUnit".equals(this.interactionType) && shapeIterator.hasNext()) {
            this.vis.cacheDefenderScrollUnit((Shape)shapeIterator.next());
        }
    }

    private void applyLabels(String string, ShapeList shapeList, Rect rect) {
        if (this.labelProducers.size() > 0 || this.layout != null) {
            Rect rect2 = this.getClipBounds(rect);
            for (LabelProducer labelProducer : this.labelProducers) {
                labelProducer.setBounds(rect2, rect);
            }
            this.addLabels(shapeList, string);
        }
    }

    private Rect getClipBounds(Rect rect) {
        int n = this.getClip();
        if (n == 4) {
            return null;
        }
        if (n == 2) {
            Rect rect2 = new Rect(0.0, 0.0, this.grammar.graphSize.getWidth(), this.grammar.graphSize.getHeight());
            return rect2;
        }
        Rect rect3 = new Rect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        return rect3;
    }

    private void setBaseline(Coordinates coordinates, Builder builder) {
        if (this.layout != null || this.data == null || this.data.rows == null || this.data.rows.length == 0 || this.data.rows[0].data.length == 0) {
            return;
        }
        Row row = this.data.rows[0];
        Position position = coordinates.getPosition(row, this.positions);
        Double d = builder.getBase(position);
        if (d == null) {
            this.baseline = null;
            return;
        }
        this.baseline = ShapeLine.make(0.0, d, this.extent.getWidth(), d);
        this.baseline = coordinates.modifyShape(this.baseline, this.extent);
        if (coordinates.containsPolar()) {
            double d2;
            double d3;
            int n = this.baseline.getType();
            if (1001 == n) {
                d3 = ((ShapeLine)this.baseline).getXArray()[0];
                d2 = ((ShapeLine)this.baseline).getYArray()[0];
            } else {
                Point point = ((Wedge)this.baseline.getGeom()).getOrigin();
                d3 = point.getX();
                d2 = point.getY();
            }
            this.baseline = ShapeLine.make(d3, d2, d3, d2);
        }
        this.baseline.setSnap(StyleBuilder.getSnap(this.spec.style));
    }

    private void applyAesthetics(ShapeList shapeList) {
        ShapeIterator<Shape> shapeIterator = shapeList.elementIterator();
        while (shapeIterator.hasNext()) {
            shapeIterator.replace(this.applyAesthetic((Shape)shapeIterator.next()));
        }
    }

    public Shape applyAesthetic(Shape shape) {
        Row row;
        if (shape.getRows() != null && shape.getRows().length > 0 && this.data != null && this.data.rows.length > 0) {
            row = this.data.rows[shape.getRows()[0]];
            this.grammar.faceting.applyFacetingToShape(shape, row, this);
        } else {
            row = Row.createEmptyRow(0, -1);
        }
        for (Aesthetic aesthetic : this.aesthetics) {
            shape = aesthetic.apply(shape, row);
        }
        return shape;
    }

    private void styleShapes(ShapeList shapeList) {
        StyleBuilder.modifyThresholdStyleSpec(this.spec.style, this.grammar.coordinates.scales);
        for (Shape shape : shapeList.getElementShapes()) {
            if (this.layout != null && this.layout.applyStyles(shape)) continue;
            this.styleShape(shape);
        }
    }

    public void styleShape(Shape shape) {
        int n = shape.getType();
        String string = shape.getMeta(META_PART);
        StyleSpec styleSpec = null;
        if (this.layout != null) {
            styleSpec = this.layout.getAdapter().getTargetedStyle(CHORDLAYOUT_ARC_STYLE);
        }
        if (styleSpec == null) {
            StyleSpec styleSpec2 = styleSpec = this.isLineWithPoints && SYMBOL_PART.equals(string) ? this.spec.symbolStyle : this.spec.style;
        }
        if (styleSpec == null) {
            if (1009 == n || 1007 == n) {
                StyleBuilder.setDefaultTextStyle((Text)shape);
            } else if (shape.isFilled()) {
                StyleBuilder.setDefaultFillStyle(shape);
            } else {
                StyleBuilder.setDefaultStrokeStyle(shape);
            }
        } else if (1009 == n || 1007 == n) {
            StyleBuilder.setUnfilled(shape, styleSpec, null);
        } else if (shape.isFilled() && (shape.getFill() == null || shape.canScaleBoth())) {
            StyleBuilder.setFilled(shape, styleSpec);
        } else if (!shape.isFilled()) {
            Double d = null;
            if (Element.isStrokeShape(this.type) && styleSpec.size != null) {
                d = this.getStrokeWidthForStyleSize(styleSpec);
            }
            StyleBuilder.setUnfilled(shape, styleSpec, d);
        }
        this.styleParts(shape);
    }

    protected static boolean isStrokeShape(String string) {
        return ELEMENT_PATH.equals(string) || ELEMENT_LINE.equals(string) || ELEMENT_EDGE.equals(string);
    }

    private void styleParts(Shape shape) {
        Shape[] shapeArray = shape.getParts();
        if (shapeArray != null) {
            for (Shape shape2 : shapeArray) {
                if (shape2.getFill() == null && shape2.getOutline() == null && shape2.getStroke() == null) {
                    this.styleShape(shape2);
                    if (!shape2.isFilled() && shape.isFilled()) {
                        shape2.setFill(Fill.makeSolid(shape2.getOutline()));
                        shape2.setOutline(null);
                    }
                }
                this.styleParts(shape2);
            }
        }
    }

    private Double getStrokeWidthForStyleSize(StyleSpec styleSpec) {
        double d = StyleBuilder.getDefaultStrokeWidth();
        Dim dim = new Dim(d, d);
        PreferredSizeSpec[] preferredSizeSpecArray = Element.buildPreferredDimension(styleSpec, dim);
        return UnitConverter.convertLength(preferredSizeSpecArray[0], dim.getWidth(), this.extent.getWidth());
    }

    private void updateWedgeShapes(ShapeList shapeList) {
        if (this.labelProducers != null) {
            for (LabelProducer labelProducer : this.labelProducers) {
                if (!this.isWedgeModificationRequired(labelProducer)) continue;
                for (Shape shape : shapeList.getAllShapes()) {
                    if (!(shape.getGeom() instanceof Wedge)) continue;
                    shape.scale(0.5, 0.5);
                }
            }
        }
    }

    private boolean isWedgeModificationRequired(LabelProducer labelProducer) {
        return labelProducer.style.location != null && "callout".equals(labelProducer.style.location) && this.getDiameterFromSpec() == null;
    }

    private static boolean isInside(String string) {
        return string.equals(ELEMENT_INTERVAL) || string.equals(ELEMENT_POLYGON) || string.equals(ELEMENT_AREA);
    }

    private List<IntPrimitiveArrayList> groupsByAesthetics(List<IntPrimitiveArrayList> list) {
        if (!this.needsGroupingByAesthetics()) {
            throw new EngineException("Data grouping by aesthetic is required only for elements of type path,line,area and polygon OR if stack transform is being used", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
        }
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!aesthetic.isSplitting() || this.isLineWithPoints && aesthetic.modifiesSymbol()) continue;
            ArrayList<IntPrimitiveArrayList> arrayList = new ArrayList<IntPrimitiveArrayList>();
            for (IntPrimitiveArrayList intPrimitiveArrayList : list) {
                this.splitByAesthetic(intPrimitiveArrayList, aesthetic, arrayList);
            }
            list = arrayList;
        }
        return list;
    }

    private boolean needsGroupingByAesthetics() {
        if (this.grammar.coordinates.containsStacking()) {
            return true;
        }
        return continuousElementTypes.contains(this.type);
    }

    public boolean usesAugmentation() {
        return this.data != null && this.data.augmentation != null && this.positions.length == 0 && this.layout == null;
    }

    private ShapeList makeByPositions(Coordinates coordinates, Builder builder, Rect rect) {
        int n;
        Row[] rowArray;
        ShapeList shapeList = new ShapeList();
        Field[] fieldArray = this.getDefaultKeyFields();
        if (this.hasVariableRef() || this.data != null && this.data.augmentation != null) {
            rowArray = this.data.rows;
            List<IntPrimitiveArrayList> list = this.makeDataGroups();
            for (n = list.size() - 1; n >= 0; --n) {
                IntPrimitiveArrayList object3 = list.get(n);
                for (int i = 0; i < object3.size(); ++i) {
                    Object object;
                    int n2 = object3.get(i);
                    Shape shape = null;
                    Position position = coordinates.getPosition(rowArray[n2], this.positions);
                    if (position != null) {
                        builder.updateDefaultSize(position.getSuggestedSize());
                    }
                    if (this.usesAugmentation()) {
                        object = coordinates.get2DScaleRanges();
                        if (object[0] == object[1]) {
                            object[0] = object[0] - 0.001;
                            object[1] = object[1] + 0.001;
                        }
                        if (object[2] == object[3]) {
                            object[2] = object[2] - 0.001;
                            object[3] = object[3] + 0.001;
                        }
                        shape = builder.makeFromAugmentation(n2, this.data.augmentation, (double[])object);
                    } else {
                        if (position != null) {
                            shape = builder.make(position, n2, true);
                        }
                        if (shape == null) {
                            shape = ShapeFactory2.CreateRect(0.0, 0.0, 0.0, 0.0);
                            shape.setRow(n2);
                            shape.setVisible(false);
                        }
                    }
                    if (shape == null) continue;
                    this.addKeyInfo(shape, rowArray[n2], fieldArray);
                    shape.setPosition(position);
                    double[] dArray = object = this.isClipBySpan() ? this.calculateShapeSpanClipRect(shape.getRows(), shape, coordinates, builder) : null;
                    if (this.data.augmentation != null && rect != null) {
                        object = object == null ? (Object)rect : (Object)object.makeIntersection(rect);
                    }
                    if (!coordinates.containsProjection()) {
                        shape.setSpanClipBounds((Rect)object);
                    }
                    shape.setAestheticGroup(n);
                    shapeList.addElementShape(shape);
                }
            }
        } else {
            boolean bl = true;
            if (this.data == null || this.data.rows == null || this.data.rows.length == 0) {
                rowArray = new Row[]{Row.createEmptyRow(coordinates.scales.length, 0)};
                bl = false;
            } else {
                Row[] rowArray2;
                if (this.hasReferencedFields()) {
                    rowArray2 = this.data.rows;
                } else {
                    Row[] rowArray3 = new Row[1];
                    rowArray2 = rowArray3;
                    rowArray3[0] = this.data.rows[0];
                }
                rowArray = rowArray2;
            }
            for (n = 0; n < rowArray.length; ++n) {
                Shape shape;
                Position position = coordinates.getPosition(rowArray[n], this.positions);
                if (position == null || (shape = builder.make(position, n, bl)) == null) continue;
                if (bl) {
                    this.addKeyInfo(shape, rowArray[n], fieldArray);
                }
                shapeList.addElementShape(shape);
            }
        }
        double d = 0.0;
        for (Shape shape : shapeList.getElementShapes()) {
            double d2 = shape.getBounds().getHeight();
            if (!(d2 > d)) continue;
            d = d2;
        }
        this.maxShapeSize = d;
        return shapeList;
    }

    private void addKeyInfo(Shape shape, Row row, Field[] fieldArray) {
        shape.setKey(this.data.getKeyWithDefaultFields(row, fieldArray));
        Element.addKeyToShapeParts(shape);
    }

    private static void addKeyToShapeParts(Shape shape) {
        Shape[] shapeArray = shape.getParts();
        if (shapeArray != null) {
            for (Shape shape2 : shapeArray) {
                shape2.setKey(shape.getKey());
            }
        }
    }

    private boolean hasReferencedFields() {
        return this.aestheticFieldIDs.length > 0 || this.isLabelReferenced();
    }

    private boolean isLabelReferenced() {
        if (this.spec.label == null || this.spec.label.length == 0) {
            return false;
        }
        for (ElementLabelSpec elementLabelSpec : this.spec.label) {
            for (Object object : elementLabelSpec.content) {
                if (!(object instanceof FieldValueRefSpec)) continue;
                return true;
            }
        }
        return false;
    }

    private Field[] getDefaultKeyFields() {
        Field field;
        int n;
        if (this.positions.length == 0) {
            return null;
        }
        if (this.grammar.coordinates.containsCluster()) {
            Field[] fieldArray;
            int n2;
            int n3 = Math.min(this.grammar.coordinates.axes.length, this.positions.length - 1);
            ArrayList<Field[]> arrayList = new ArrayList<Field[]>();
            for (n2 = 0; n2 < n3; ++n2) {
                fieldArray = this.positions[n2 + 1].getBaseField();
                if (fieldArray == null) continue;
                arrayList.add(fieldArray);
            }
            n2 = arrayList.size();
            if (n2 == 0) {
                return null;
            }
            fieldArray = new Field[n2];
            for (int i = 0; i < n2; ++i) {
                fieldArray[i] = (Field)arrayList.get(i);
            }
            return fieldArray;
        }
        if (this.positions.length < 2 && this.aestheticFieldIDs.length > 0) {
            for (n = 0; n < this.aesthetics.length; ++n) {
                if (!this.aesthetics[n].isSplitting() || this.aesthetics[n].valueProvider.getBaseField() == null) continue;
                return new Field[]{this.aesthetics[n].valueProvider.getBaseField()};
            }
        }
        if ((field = this.positions[n = this.positions.length - 1].getBaseField()) == null) {
            while (field == null && n > -1) {
                field = this.positions[n].getBaseField();
                --n;
            }
            if (field == null) {
                return null;
            }
        }
        return new Field[]{field};
    }

    private void handleMissingCategoryValuesAsZeroForStack(Coordinates coordinates, IntPrimitiveArrayList intPrimitiveArrayList, Row[] rowArray, ArrayList<Position> arrayList, IntPrimitiveArrayList intPrimitiveArrayList2) {
        boolean bl;
        boolean bl2 = bl = coordinates.scales.length > 1 && coordinates.containsStacking() && coordinates.scales[1].getCategoryCount() > 0;
        if (bl) {
            Position position;
            int n = coordinates.scales[1].getCategoryCount();
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (int i = 0; i < n; ++i) {
                hashMap.put(i, i);
            }
            Field field = this.positions[1].getBaseField();
            Unit unit = this.positions[1].getUnit();
            int n2 = 0;
            for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
                int n3 = intPrimitiveArrayList.get(i);
                position = coordinates.getPosition(rowArray[n3], this.positions);
                if (!position.XPositionCoordinateUndefined()) {
                    int n4 = coordinates.scales[1].getCategoryIndexFromZeroOne(position.X(), unit);
                    hashMap.remove(n4);
                }
                arrayList.add(position);
                intPrimitiveArrayList2.add(n3);
                n2 = n3;
            }
            for (Integer n5 : hashMap.keySet()) {
                double d;
                double[] dArray = new double[rowArray[0].data.length];
                for (ValueProvider valueProvider : this.positions) {
                    dArray[valueProvider.getBaseField().getIndex()] = 0.0;
                }
                dArray[field.getIndex()] = d = (double)coordinates.scales[1].getFieldCategoryIndex(n5, unit).intValue();
                Row row = Row.createRow(dArray, n2);
                position = coordinates.getPosition(row, this.positions);
                arrayList.add(position);
                intPrimitiveArrayList2.add(n2);
            }
        } else {
            for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
                int n = intPrimitiveArrayList.get(i);
                Position position = coordinates.getPosition(rowArray[n], this.positions);
                arrayList.add(position);
                intPrimitiveArrayList2.add(n);
            }
        }
    }

    private Rect calculateShapeSpanClipRect(int[] nArray, Shape shape, Coordinates coordinates, Builder builder) {
        Dim dim = builder.extent;
        if (coordinates.containsPolar() || coordinates.scales.length == 0 || this.positions.length == 0) {
            return null;
        }
        Rect rect = this.computeBoundsForSpansUnion(nArray, coordinates, dim);
        if (rect == null || rect.similar(Rect.makeRectFromDim(dim))) {
            return null;
        }
        return builder.modifyShapeSpanClipBounds(shape, rect);
    }

    private Rect computeBoundsForSpansUnion(int[] nArray, Coordinates coordinates, Dim dim) {
        Rect rect = null;
        double[] dArray = new double[4];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Row row = this.data.rows[n];
            ScaleSpan scaleSpan = this.getSpanForPosition(row, coordinates.scales[0], this.positions[0]);
            ScaleSpan scaleSpan2 = null;
            if (coordinates.scales.length > 1) {
                scaleSpan2 = this.getSpanForPosition(row, coordinates.scales[1], this.positions[1]);
            }
            if (scaleSpan == null) continue;
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = dim.getWidth();
            dArray[3] = dim.getHeight();
            Range range = scaleSpan.getExtendedOutRange();
            Range range2 = scaleSpan2 != null ? scaleSpan2.getExtendedOutRange() : null;
            Range range3 = null;
            Range range4 = null;
            if (coordinates.containsTranspose()) {
                range3 = range;
                range4 = range2;
            } else {
                range3 = range2;
                range4 = range;
            }
            if (range3 != null) {
                dArray[0] = range3.getMin() * dim.getWidth();
                dArray[2] = range3.getRange() * dim.getWidth();
            }
            if (range4 != null) {
                dArray[1] = dim.getHeight() - range4.getMax() * dim.getHeight();
                dArray[3] = range4.getRange() * dim.getHeight();
            }
            if (rect == null) {
                rect = new Rect(dArray[0], dArray[1], dArray[2], dArray[3]);
                continue;
            }
            rect.extendTo(dArray[0], dArray[1], dArray[0] + dArray[2], dArray[1] + dArray[3]);
        }
        return rect;
    }

    private ScaleSpan getSpanForPosition(Row row, Scale scale, ValueProvider valueProvider) {
        Double d;
        Integer n = valueProvider.getSpan();
        ScaleSpan scaleSpan = n != null ? scale.getSpans().get(n) : ((d = Double.valueOf(valueProvider.getNumber(row))) != null ? valueProvider.getMatchingSpan(d, scale) : null);
        return scaleSpan;
    }

    private ShapeList makePerSplitShape(Coordinates coordinates, Builder builder, Builder builder2) {
        Row[] rowArray = this.data.rows;
        ShapeList shapeList = new ShapeList();
        List<IntPrimitiveArrayList> list = this.makeDataGroups();
        int n = list.size();
        Field[] fieldArray = this.getDefaultKeyFields();
        for (int i = list.size() - 1; i >= 0; --i) {
            IntPrimitiveArrayList intPrimitiveArrayList = list.get(i);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            IntPrimitiveArrayList intPrimitiveArrayList2 = new IntPrimitiveArrayList();
            this.handleMissingCategoryValuesAsZeroForStack(coordinates, intPrimitiveArrayList, rowArray, arrayList, intPrimitiveArrayList2);
            int[] nArray = new int[intPrimitiveArrayList2.size()];
            int n2 = 0;
            for (int j = 0; j < intPrimitiveArrayList2.size(); ++j) {
                int n3;
                nArray[n2] = n3 = intPrimitiveArrayList2.get(j);
                ++n2;
            }
            Position[] positionArray = arrayList.toArray(new Position[arrayList.size()]);
            ArrayList<Shape> arrayList2 = builder.makeContinuousShapes(positionArray, nArray, rowArray);
            if (arrayList2 != null) {
                for (int j = arrayList2.size() - 1; j >= 0; --j) {
                    Rect rect;
                    Shape shape = arrayList2.get(j);
                    shape.setAestheticGroup(n);
                    shape.setKey(this.data.getKeyWithDefaultFields(rowArray[nArray[0]], fieldArray));
                    if (this.isLineWithPoints) {
                        shape.setMeta(META_PART, ELEMENT_LINE);
                    }
                    shape.setSpanClipBounds((rect = this.calculateShapeSpanClipRect(shape.getRows(), shape, coordinates, builder)) == null ? null : rect.getBounds());
                    shapeList.addElementShape(shape);
                    Position[] positionArray2 = null;
                    if (builder2 == null || (positionArray2 = shape.getPositions()) == null) continue;
                    int[] nArray2 = shape.getRows();
                    for (int k = nArray2.length - 1; k >= 0; --k) {
                        Position position = positionArray2[k];
                        builder2.updateDefaultSize(position.getSuggestedSize());
                        int n4 = nArray2[k];
                        Shape shape2 = builder2.make(position, n4, true);
                        if (shape2 == null) continue;
                        shape2.setKey(this.data.getKey(rowArray[n4]));
                        shape2.setContainingShape(shape);
                        shape2.setMeta(META_PART, SYMBOL_PART);
                        shape2.setAestheticGroup(n);
                        shape2.setGlyphLike();
                        shape2.setPosition(position);
                        Rect rect2 = this.calculateShapeSpanClipRect(shape2.getRows(), shape2, coordinates, builder2);
                        shape2.setSpanClipBounds(rect2 == null ? null : rect2.getBounds());
                        shapeList.addElementShape(shape2);
                    }
                }
            }
            --n;
        }
        return shapeList;
    }

    private void splitByAesthetic(IntPrimitiveArrayList intPrimitiveArrayList, Aesthetic aesthetic, ArrayList<IntPrimitiveArrayList> arrayList) {
        int n;
        assert (this.needsGroupingByAesthetics());
        HashMap<Double, IntPrimitiveArrayList> hashMap = new HashMap<Double, IntPrimitiveArrayList>();
        IntPrimitiveArrayList intPrimitiveArrayList2 = new IntPrimitiveArrayList();
        aesthetic.valueProvider.enableOrdering(this.grammar.coordinates.containsStacking());
        for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
            n = intPrimitiveArrayList.get(i);
            if (aesthetic.valueProvider.getBaseField() != null && this.data.rows[n].data.length <= aesthetic.valueProvider.getBaseField().getIndex()) continue;
            Double d = aesthetic.valueProvider.getNumber(this.data.rows[n]);
            if (d == null) {
                intPrimitiveArrayList2.add(n);
                continue;
            }
            double d2 = d;
            if (Double.isNaN(d2)) {
                intPrimitiveArrayList2.add(n);
                continue;
            }
            IntPrimitiveArrayList intPrimitiveArrayList3 = (IntPrimitiveArrayList)hashMap.get(d2);
            if (intPrimitiveArrayList3 == null) {
                intPrimitiveArrayList3 = new IntPrimitiveArrayList();
                hashMap.put(d2, intPrimitiveArrayList3);
            }
            intPrimitiveArrayList3.add(n);
        }
        Object[] objectArray = BasicFactory.getHashMapKeysAsDoubleArray(hashMap);
        if (!intPrimitiveArrayList2.isEmpty()) {
            arrayList.add(intPrimitiveArrayList2);
        }
        BasicFactory.sortArray(objectArray);
        for (n = objectArray.length - 1; n >= 0; --n) {
            arrayList.add((IntPrimitiveArrayList)hashMap.get(objectArray[n]));
        }
    }

    public boolean hasVariableRef() {
        for (ValueProvider valueProvider : this.positions) {
            if (valueProvider.getBaseField() == null) continue;
            return true;
        }
        return false;
    }

    private void applyPositionModifiers(ShapeList shapeList, Coordinates coordinates) {
        PositionModifier positionModifier;
        if (this.positionModifier != null && (positionModifier = PositionModifierFactory.createPositionModifier(this.positionModifier)) != null) {
            HashMap<String, ArrayList<Shape>> hashMap = new HashMap<String, ArrayList<Shape>>();
            for (Shape shape : shapeList.getElementShapes()) {
                double[] dArray = this.getCoordinates(shape.getRows());
                String string = Element.arrayToString(dArray);
                ArrayList<Shape> arrayList = hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(shape);
            }
            positionModifier.modifyPositions(hashMap, coordinates.transposesAxes());
        }
    }

    private static String arrayToString(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append(dArray[i]);
            if (i >= dArray.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void produceTooltip(List<Shape> list, TooltipProducer tooltipProducer) {
        for (Shape shape : list) {
            this.produceShapeTooltip(shape, tooltipProducer);
        }
    }

    public String getShapeTooltip(Shape shape) {
        if (shape == null) {
            return null;
        }
        String string = shape.getDisplayTooltip();
        if (string != null) {
            return string;
        }
        this.initTooltips();
        if (this.tooltipProducers.isEmpty()) {
            return null;
        }
        for (TooltipProducer tooltipProducer : this.tooltipProducers) {
            if (tooltipProducer.part == null) continue;
            this.produceShapeTooltip(shape, tooltipProducer);
        }
        for (TooltipProducer tooltipProducer : this.tooltipProducers) {
            if (tooltipProducer.part != null) continue;
            this.produceShapeTooltip(shape, tooltipProducer);
        }
        return shape.getDisplayTooltip();
    }

    private void produceShapeTooltip(Shape shape, TooltipProducer tooltipProducer) {
        Tooltip tooltip = tooltipProducer.makeTooltip(shape);
        shape.setTooltip(tooltip.getRegularTooltip());
        shape.setFormattedTooltip(tooltip.getFormattedTooltip());
        Shape[] shapeArray = shape.getParts();
        if (shapeArray != null && shapeArray.length > 0) {
            ArrayList<Shape> arrayList = new ArrayList<Shape>();
            for (Shape shape2 : shapeArray) {
                if (shape2.getElementPart() != null && shape2.getTooltip() != null) continue;
                arrayList.add(shape2);
            }
            this.produceTooltip(arrayList, tooltipProducer);
        }
    }

    public boolean desiresZero(Coordinates coordinates) {
        boolean bl = coordinates.scales.length < this.positions.length;
        return !bl && (this.type.equals(ELEMENT_AREA) || this.type.equals(ELEMENT_INTERVAL));
    }

    public String getDefaultSizeModifierType(boolean bl) {
        if (this.type.equals(ELEMENT_INTERVAL) || this.type.equals(ELEMENT_SCHEMA_BOXPLOT)) {
            return bl ? SIZE_MODIFIER_TYPE_HEIGHT : SIZE_MODIFIER_TYPE_WIDTH;
        }
        return null;
    }

    public double[] getCoordinates(int[] nArray) {
        if (this.layout != null) {
            return null;
        }
        if (nArray == null || nArray.length < 1 || this.data == null || this.data.rows == null || nArray[0] < 0 || this.data.rows.length <= nArray[0]) {
            return null;
        }
        double[] dArray = new double[this.positions.length];
        Row row = this.data.rows[nArray[0]];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.positions[i].getNumber(row);
        }
        return dArray;
    }

    public double[] getAestheticValues(int[] nArray) {
        if (nArray == null || nArray.length < 1 || this.data == null || this.data.rows == null || nArray[0] < 0 || this.data.rows.length <= nArray[0]) {
            return null;
        }
        double[] dArray = new double[this.aesthetics.length];
        Row row = this.data.rows[nArray[0]];
        for (int i = 0; i < dArray.length; ++i) {
            Double d = this.aesthetics[i].valueProvider.getNumber(row);
            dArray[i] = d == null ? Double.NaN : d;
        }
        return dArray;
    }

    public int getClip() {
        String string = this.spec.clip;
        if (AT_BOUND.equals(string)) {
            return 2;
        }
        if (NONE.equals(string)) {
            return 4;
        }
        if (OVERLAP.equals(string)) {
            return 1;
        }
        return this.layout == null ? 2 : 4;
    }

    public boolean isClipBySpan() {
        return this.spec.clipBySpan != null ? this.spec.clipBySpan : true;
    }

    public Aesthetic[] getAesthetics() {
        return this.aesthetics;
    }

    @Override
    public Number getDerivedValue(String string, Number number, Integer n) {
        if (this.cachedBuilder == null) {
            return null;
        }
        return this.cachedBuilder.getDerivedValue(string, number, n);
    }

    private PreferredSizeSpec getDiameterFromSpec() {
        assert (this.grammar.coordinates != null);
        CoordinateTransform[] coordinateTransformArray = this.grammar.coordinates.getTransforms();
        if (coordinateTransformArray != null) {
            for (CoordinateTransform coordinateTransform : coordinateTransformArray) {
                if (coordinateTransform == null || !coordinateTransform.isPolar()) continue;
                return coordinateTransform.getDiameterSpec();
            }
        }
        return null;
    }

    public Object[] getDescription() {
        return this.description;
    }

    public double getZOrder() {
        return this.zOrder;
    }

    public List<IntPrimitiveArrayList> makeDataGroups() {
        List<IntPrimitiveArrayList> list = null;
        if (this.grammar.faceting != null) {
            list = this.grammar.faceting.makeDataGroups(this);
        }
        if (list == null) {
            list = this.getDefaultDataGroups();
        }
        if (this.needsGroupingByAesthetics()) {
            list = this.groupsByAesthetics(list);
        }
        return list;
    }

    private List<IntPrimitiveArrayList> getDefaultDataGroups() {
        ArrayList<IntPrimitiveArrayList> arrayList = new ArrayList<IntPrimitiveArrayList>();
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        if (this.data != null && this.data.rows != null) {
            for (int i = 0; i < this.data.rows.length; ++i) {
                intPrimitiveArrayList.add(i);
            }
        }
        arrayList.add(intPrimitiveArrayList);
        return arrayList;
    }

    public int getDimensionIndex(int n) {
        int n2 = this.positions.length;
        int n3 = this.grammar.coordinates.scales.length;
        if (n2 == n3) {
            return n;
        }
        if (n2 == 2 * n3) {
            return (int)Math.floor(n / 2);
        }
        if (n2 == n3 + 1) {
            return n < 2 ? 0 : n - 1;
        }
        throw new IllegalStateException("Mismatch between scales and fields lengths");
    }

    public List<Field> getFieldsForDimension(int n) {
        int n2;
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (n2 = 0; n2 < this.positions.length; ++n2) {
            int n3 = this.getDimensionIndex(n2);
            Field field = this.positions[n2].getBaseField();
            if (n3 != n || field == null || arrayList.contains(field)) continue;
            arrayList.add(field);
        }
        if (SchemaBuilder.componentsAffectScale(this.type, n)) {
            for (n2 = 0; n2 < this.components.length; ++n2) {
                Field field = this.components[n2].getBaseField();
                if (field == null || arrayList.contains(field)) continue;
                arrayList.add(field);
            }
        }
        return arrayList;
    }

    public Collection<? extends Number> getFixedValues(int n) {
        ArrayList<Number> arrayList = new ArrayList<Number>();
        ValueProvider[] valueProviderArray = this.positions;
        for (int i = 0; i < valueProviderArray.length; ++i) {
            ValueProvider valueProvider = valueProviderArray[i];
            int n2 = this.getDimensionIndex(i);
            if (n2 != n || !valueProvider.getIncludeInRange()) continue;
            arrayList.add(valueProvider.getNumber(null));
        }
        if (this.usesAugmentation()) {
            this.getFixedValuesFromAugmentedData(n, arrayList);
        }
        return arrayList;
    }

    protected void getFixedValuesFromAugmentedData(int n, List<Number> list) {
        Rect rect = this.data.augmentation.getGlobalBounds();
        ContinuousScaleSpan continuousScaleSpan = null;
        if (this.grammar.coordinates.scales.length > n && this.grammar.coordinates.scales[n].spans.size() > 0 && this.grammar.coordinates.scales[n].spans.get(0) instanceof ContinuousScaleSpan) {
            continuousScaleSpan = (ContinuousScaleSpan)this.grammar.coordinates.scales[n].spans.get(0);
        }
        if (n == 0) {
            if (continuousScaleSpan == null || !continuousScaleSpan.isNumDomainDefinedInSpec() || this.data.augmentation.getIncludeInRange()) {
                list.add(rect.getY());
                list.add(rect.getY() + rect.getHeight());
            }
        } else if (n == 1 && (continuousScaleSpan == null || !continuousScaleSpan.isNumDomainDefinedInSpec() || this.data.augmentation.getIncludeInRange())) {
            list.add(rect.getX());
            list.add(rect.getX() + rect.getWidth());
        }
    }

    public void makeStackRange(HashMap<String, Range> hashMap) {
        Row[] rowArray;
        Range range = Range.ZERO;
        if (this.positions.length < 1 || !this.usesStacking()) {
            return;
        }
        HashMap<String, Range> hashMap2 = new HashMap<String, Range>();
        ValueProvider valueProvider = this.positions[0];
        String string = null;
        if (valueProvider.getBaseField() != null) {
            string = valueProvider.getBaseField().label;
        }
        for (Row row : rowArray = this.getRows()) {
            double d;
            Double d2 = valueProvider.getNumber(row);
            if (d2 == null || Double.isNaN(d = ((Number)d2).doubleValue())) continue;
            String string2 = this.grammar.faceting.updateKey(Element.makePositionKey(row, this.positions), row);
            Range range2 = (Range)hashMap2.get(string2);
            if (range2 == null) {
                range2 = Range.ZERO;
            }
            if (d < 0.0) {
                range2 = new Range(range2.getMin() + d, range2.getMax());
                range = range.unionValue(range2.getMin());
            } else {
                range2 = new Range(range2.getMin(), range2.getMax() + d);
                range = range.unionValue(range2.getMax());
            }
            hashMap2.put(string2, range2);
        }
        if (string != null) {
            Range range3 = hashMap.get(string);
            if (range3 != null) {
                range = range.createUnion(range3);
            }
            hashMap.put(string, range);
        }
    }

    private Row[] getRows() {
        if (this.positions == null || this.positions.length < 2 || this.positions[1].getBaseField() == null) {
            return this.data.rows;
        }
        if (!this.positions[1].getBaseField().isCategorical() && (this.type.equals(ELEMENT_LINE) || this.type.equals(ELEMENT_AREA))) {
            List<IntPrimitiveArrayList> list = this.makeDataGroups();
            ArrayList<Range> arrayList = new ArrayList<Range>();
            for (IntPrimitiveArrayList intPrimitiveArrayList : list) {
                arrayList.add(this.getGroupRange(intPrimitiveArrayList));
            }
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(this.getInterpolatePositions((Range)arrayList.get(i), list.get(i)));
            }
            ArrayList<Row> arrayList3 = new ArrayList<Row>();
            arrayList3.addAll(BasicFactory.asList(this.data.rows));
            for (int i = 0; i < arrayList2.size(); ++i) {
                Row[] rowArray = this.interpolateRows((DoublePrimitiveArrayList)arrayList2.get(i), list.get(i));
                if (rowArray == null) continue;
                arrayList3.addAll(BasicFactory.asList(rowArray));
            }
            return arrayList3.toArray(new Row[arrayList3.size()]);
        }
        return this.data.rows;
    }

    private Row[] interpolateRows(DoublePrimitiveArrayList doublePrimitiveArrayList, IntPrimitiveArrayList intPrimitiveArrayList) {
        if (doublePrimitiveArrayList.size() == 0 || intPrimitiveArrayList.size() == 0) {
            return null;
        }
        Row[] rowArray = new Row[doublePrimitiveArrayList.size()];
        double[] dArray = this.data.rows[intPrimitiveArrayList.get((int)0)].data;
        for (int i = 0; i < doublePrimitiveArrayList.size(); ++i) {
            double[] dArray2 = new double[dArray.length];
            for (int j = 0; j < dArray2.length; ++j) {
                dArray2[j] = dArray[j];
            }
            dArray2[this.positions[1].getBaseField().getIndex()] = doublePrimitiveArrayList.get(i);
            dArray2[this.positions[0].getBaseField().getIndex()] = this.interpolateY(doublePrimitiveArrayList.get(i), intPrimitiveArrayList).doubleValue();
            rowArray[i] = Row.createRow(dArray2, -1);
        }
        return rowArray;
    }

    private Number interpolateY(double d, IntPrimitiveArrayList intPrimitiveArrayList) {
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        Number number = null;
        Number number2 = null;
        for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
            Row row = this.data.rows[intPrimitiveArrayList.get(i)];
            Double d4 = this.positions[1].getNumber(row);
            if (d4 == null) continue;
            if (d4 < d && d4 > d2) {
                d2 = d4;
                number = this.positions[0].getNumber(row);
                continue;
            }
            if (!(d4 > d) || !(d4 < d3)) continue;
            d3 = d4;
            number2 = this.positions[0].getNumber(row);
        }
        if (number == null && number2 == null) {
            return null;
        }
        if (number == null) {
            return number2.doubleValue() / 2.0;
        }
        if (number2 == null) {
            return number.doubleValue() / 2.0;
        }
        return (number.doubleValue() + number2.doubleValue()) / 2.0;
    }

    private DoublePrimitiveArrayList getInterpolatePositions(Range range, IntPrimitiveArrayList intPrimitiveArrayList) {
        ValueProvider valueProvider = this.positions[1];
        DoublePrimitiveArrayList doublePrimitiveArrayList = new DoublePrimitiveArrayList();
        for (int i = 0; i < this.data.rows.length; ++i) {
            Row row;
            Double d;
            if (intPrimitiveArrayList.contains(i) || (d = Double.valueOf(valueProvider.getNumber(row = this.data.rows[i]))) == null) continue;
            double d2 = d;
            if (!doublePrimitiveArrayList.contains(d2) && range.contains(d2) && !this.isContained(d2, intPrimitiveArrayList)) {
                doublePrimitiveArrayList.add(d2);
            }
            if (doublePrimitiveArrayList.contains(d2) || !range.contains(d2) || this.isContained(d2, intPrimitiveArrayList)) continue;
            doublePrimitiveArrayList.add(d2);
        }
        return doublePrimitiveArrayList;
    }

    private boolean isContained(double d, IntPrimitiveArrayList intPrimitiveArrayList) {
        ValueProvider valueProvider = this.positions[1];
        for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
            Row row = this.data.rows[intPrimitiveArrayList.get(i)];
            Double d2 = valueProvider.getNumber(row);
            if (d2 == null || d != d2) continue;
            return true;
        }
        return false;
    }

    private Range getGroupRange(IntPrimitiveArrayList intPrimitiveArrayList) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        ValueProvider valueProvider = this.positions[1];
        for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
            Row row = this.data.rows[intPrimitiveArrayList.get(i)];
            Double d3 = valueProvider.getNumber(row);
            if (d3 == null) continue;
            double d4 = d3;
            d = Math.min(d4, d);
            d2 = Math.max(d4, d2);
        }
        return new Range(d, d2);
    }

    private static String makePositionKey(Row row, ValueProvider[] valueProviderArray) {
        if (valueProviderArray.length < 2) {
            return "";
        }
        Double d = valueProviderArray[1].getNumber(row);
        if (d == null) {
            return "";
        }
        String string = "" + d;
        for (int i = 2; i < valueProviderArray.length; ++i) {
            string = string + "|";
            Double d2 = valueProviderArray[i].getNumber(row);
            if (d2 == null) continue;
            string = string + d2;
        }
        return string;
    }

    public void setInputDomainRange(Scale scale) {
        if (this.positions != null) {
            for (int i = 0; i < this.positions.length; ++i) {
                ValueProvider valueProvider = this.positions[i];
                Range range = valueProvider.getRange();
                Integer n = valueProvider.getSpan();
                if (range != null && n != null && n >= 0 && n < scale.spans.size()) {
                    range = UnitConverter.convertRange(range, valueProvider.getUnit(), scale.spans.get(n).getInputUnit());
                }
                scale.setRangeForSpan(range, n);
            }
        }
    }

    @Override
    public Range getDataRange(int n, Unit unit) {
        Range range = Range.EMPTY;
        List<Field> list = this.getFieldsForDimension(n);
        for (Field field : list) {
            if (!field.unit.equals(unit) || !field.range.isComplete()) continue;
            range = range.createUnion(UnitConverter.convertRange(field.range, field.unit, unit));
        }
        return range;
    }

    public Dim getLegendSymbolSize() {
        Dim dim = this.extent;
        if (this.extent == null) {
            this.extent = this.getPreferredSize();
        }
        Dim dim2 = this.calculateDefaultShapeSize(this.spec.style);
        this.extent = dim;
        return dim2;
    }

    public String getLinkTarget() {
        HashMap<Double, Shape> hashMap;
        if (!ELEMENT_EDGE.equals(this.spec.type) && !ELEMENT_PATH.equals(this.spec.type) || this.layout == null || this.spec.positioning.method == null) {
            return null;
        }
        String string = this.spec.positioning.method;
        if (string.equals("chord")) {
            return "*";
        }
        if ((string.equals("link") || string.equals("sankey") || string.equals("route")) && (hashMap = this.layout.getAdapter().getElementItems(this.spec.positioning.id.$ref)) != null && !hashMap.isEmpty()) {
            for (Double d : hashMap.keySet()) {
                Shape shape = hashMap.get(d);
                String string2 = shape.getID();
                if (string2 == null) continue;
                return SceneIdUtil.baseId(string2);
            }
        }
        return null;
    }

    public double getMaxShapeSize() {
        return this.maxShapeSize;
    }

    static {
        continuousElementTypes.add(ELEMENT_AREA);
        continuousElementTypes.add(ELEMENT_LINE);
        continuousElementTypes.add(ELEMENT_POLYGON);
        continuousElementTypes.add(ELEMENT_PATH);
    }
}

