/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.element;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.geo.GeoData;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.element.Builder;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.CustomGlyphBuilder;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.scene.SymbolBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.SymbolSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class IntervalBuilder
extends Builder {
    private final boolean fixedWidth;
    private String symbolName;
    private CustomGlyphBuilder symbolDef;
    private final StyleSpec style;
    private final boolean clipping;

    IntervalBuilder(VisContext visContext, Coordinates coordinates, Dim dim, Dim dim2, StyleSpec styleSpec, boolean bl) {
        super(visContext, coordinates, dim);
        this.setSnap(StyleBuilder.getSnap(styleSpec));
        this.size = dim2;
        this.fixedWidth = this.isWidthAbsoluteSize(styleSpec);
        this.style = styleSpec;
        this.clipping = bl;
        if (styleSpec == null || styleSpec.symbol == null) {
            this.symbolName = "rect";
        } else if (BasicFactory.isString(styleSpec.symbol)) {
            this.symbolName = (String)styleSpec.symbol;
        } else {
            this.symbolName = null;
            this.symbolDef = new CustomGlyphBuilder((SymbolSpec)styleSpec.symbol, dim, visContext);
        }
    }

    private boolean isWidthAbsoluteSize(StyleSpec styleSpec) {
        return styleSpec != null && (UnitConverter.convertLength(styleSpec.width, null, null) != null || UnitConverter.convertLength(styleSpec.size, null, null) != null);
    }

    @Override
    public Shape makeShapeInside(Rect rect, int n) {
        return ItemBuilder.makeRectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), this.style);
    }

    @Override
    protected Shape makeAugmentedShape(GeoData geoData, int n) {
        Rect rect = geoData.featureBounds(n, true);
        return ShapeFactory2.CreateRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public Double getBase(Position position) {
        Double d = null;
        if (position.length() == 0) {
            d = this.extent.getHeight() / 2.0 - this.size.getHeight() / 2.0;
        } else {
            double d2 = this.coords.scales[0].getBase();
            d2 = Math.max(0.0, Math.min(1.0, d2));
            d = this.extent.getHeight() - d2 * this.extent.getHeight();
        }
        return d;
    }

    @Override
    protected Shape makeShape(Position position, Integer n) {
        double d;
        double d2;
        double d3;
        if (position.XYUndefined()) {
            return null;
        }
        double d4 = 0.0;
        String string = null;
        if (position.length() == 0) {
            if (this.style == null || this.style.valign == null || "middle".equals(this.style.valign)) {
                d4 = this.extent.getHeight() / 2.0 - this.size.getHeight() / 2.0;
            } else if ("start".equals(this.style.valign)) {
                d4 = 0.0;
            } else if ("end".equals(this.style.valign)) {
                d4 = this.extent.getHeight() - this.size.getHeight();
            }
            d3 = this.size.getHeight();
        } else if (position.hasY2()) {
            d4 = this.extent.getHeight() - position.Y2() * this.extent.getHeight();
            d3 = this.extent.getHeight() - position.Y() * this.extent.getHeight() - d4;
        } else {
            d2 = 0.0;
            if (!this.coords.needsToExtendChartToIntersectTheAxisZeroPoint()) {
                d2 = this.getOriginOfSpan(position, this.clipping);
            }
            d4 = this.extent.getHeight() - position.Y() * this.extent.getHeight();
            d3 = this.extent.getHeight() - d2 * this.extent.getHeight() - d4;
        }
        if (d3 < 0.0 && !"t-beam".equals(this.symbolName)) {
            d4 += d3;
            d3 = -d3;
            string = "y";
        }
        d2 = 0.0;
        if (position.length() < 2) {
            if (this.style == null || this.style.align == null || "middle".equals(this.style.align)) {
                d2 = this.extent.getWidth() / 2.0 - this.size.getWidth() / 2.0;
            } else if ("start".equals(this.style.align)) {
                d2 = 0.0;
            } else if ("end".equals(this.style.align)) {
                d2 = this.extent.getWidth() - this.size.getWidth();
            }
            d = this.size.getWidth();
        } else if (position.hasX2()) {
            d2 = position.X() * this.extent.getWidth();
            d = position.X2() * this.extent.getWidth() - d2;
        } else {
            if (this.style == null || this.style.align == null || "middle".equals(this.style.align)) {
                d2 = position.X() * this.extent.getWidth() - this.size.getWidth() / 2.0;
            } else if ("start".equals(this.style.align)) {
                d2 = position.X() * this.extent.getWidth() - this.size.getWidth();
            } else if ("end".equals(this.style.align)) {
                d2 = position.X() * this.extent.getWidth();
            }
            d = this.size.getWidth();
        }
        if (d < 0.0) {
            d2 += d;
            d = -d;
            string = "y".equals(string) ? "both" : "x";
        }
        return this.buildShape(d2, d4, d, d3, string);
    }

    private Shape buildShape(double d, double d2, double d3, double d4, String string) {
        Shape shape;
        double d5 = d + d3 / 2.0;
        double d6 = d2 + d4 / 2.0;
        if (this.symbolDef != null) {
            shape = this.symbolDef.makeCustomShape(d5, d6, d3, d4, this.style);
        } else if (this.symbolName.startsWith("rect")) {
            if (d3 < 0.1 && d4 < 0.1) {
                shape = ShapeFactory2.CreateRect(d, d2, d3, d4);
            } else {
                shape = ItemBuilder.makeRectangle(d, d2, d3, d4, this.style);
                shape.setFill(null);
            }
        } else {
            shape = SymbolBuilder.makeSymbol(this.symbolName, d5, d6, d3, d4, this.style, this.visContext);
            SymbolBuilder.scaleSymbol(shape, this.symbolName, d3, d4);
        }
        shape.setScaleDimensions(this.fixedWidth ? 2 : 3);
        shape.setSnap(StyleBuilder.getSnap(this.style));
        shape.setReversed(string);
        return shape;
    }

    double getOriginOfSpan(Position position, boolean bl) {
        Scale scale = this.coords.scales[0];
        double d = position.getYOrigin(scale);
        if (bl) {
            d = scale.getOutRange().clamp(d);
        }
        return d;
    }

    @Override
    public Rect modifyShapeSpanClipBounds(Shape shape, Rect rect) {
        ScaleSpan scaleSpan;
        Unit unit;
        Position position = shape.getPosition();
        if (position.hasY2()) {
            return rect;
        }
        double d = this.getOriginOfSpan(position, this.clipping);
        if (this.clipping) {
            d = Range.ZERO_ONE.clamp(d);
        }
        Scale scale = this.coords.scales[0];
        Double d2 = scale.zeroOneToDataValue(d);
        Unit unit2 = unit = position.fields[0] != null ? position.fields[0].unit : null;
        if (unit != null && d2 != null && (scaleSpan = scale.getMatchingSpan(d2, unit)) != null) {
            Range range = scaleSpan.getOutRange();
            Rect rect2 = rect.copy();
            if (this.coords.containsTranspose()) {
                rect2.setX(range.getMin() * this.extent.getWidth());
                rect2.setWidth(range.getRange() * this.extent.getWidth());
            } else {
                rect2.setY(this.extent.getHeight() - range.getMax() * this.extent.getHeight());
                rect2.setHeight(range.getRange() * this.extent.getHeight());
            }
            rect.extendToRect(rect2);
        }
        return rect;
    }

    @Override
    public void updateDefaultSize(Double[] doubleArray) {
        if (doubleArray[0] != null && this.size != null) {
            this.size.setHeight(doubleArray[0]);
        }
        if (doubleArray[1] != null && this.size != null) {
            if (this.style != null && this.style.width != null) {
                this.size.setWidth(UnitConverter.convertLength(this.style.width, doubleArray[1], this.extent.getWidth()));
            } else if (this.style != null && this.style.size != null) {
                this.size.setWidth(UnitConverter.convertLength(this.style.size, doubleArray[1], this.extent.getWidth()));
            } else {
                this.size.setWidth(doubleArray[1]);
            }
        }
    }
}

