/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.element;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.geo.GeoData;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.coordinate.PositionComparator;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.LinearFunctionalPath;
import com.ibm.vis.engine.internal.grammar.element.Builder;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.PolyPathMaker;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class PathBuilder
extends Builder {
    private final boolean sort;
    private final boolean close;
    private final boolean drop;
    private String startArrow;
    private String endArrow;
    private final Position[] swatchPositions;
    private final PolyPathMaker pathMaker;
    private final List<ShapePoly> cachedPolys;
    private LinearFunctionalPath curveTopFunctionalPath;

    PathBuilder(VisContext visContext, Coordinates coordinates, Dim dim, boolean bl, boolean bl2, boolean bl3, PolyPathMaker polyPathMaker, StyleSpec styleSpec) {
        super(visContext, coordinates, dim);
        this.setSnap(StyleBuilder.getSnap(styleSpec));
        if (styleSpec != null) {
            this.startArrow = styleSpec.startArrow;
            this.endArrow = styleSpec.endArrow;
        }
        this.sort = bl;
        this.close = bl2;
        this.drop = bl3;
        this.pathMaker = polyPathMaker;
        this.swatchPositions = bl3 ? new Position[]{Position.makeSimple(new double[]{0.0, 0.0}), Position.makeSimple(new double[]{0.25, 0.6}), Position.makeSimple(new double[]{0.75, 0.4}), Position.makeSimple(new double[]{1.0, 1.0})} : new Position[]{Position.makeSimple(new double[]{0.5, 0.0}), Position.makeSimple(new double[]{0.5, 1.0})};
        this.cachedPolys = new ArrayList<ShapePoly>();
        this.curveTopFunctionalPath = null;
    }

    @Override
    public Double getBase(Position position) {
        double d = this.coords == null ? 0.0 : this.coords.scales[0].getBase();
        d = Math.max(0.0, Math.min(1.0, d));
        double d2 = this.extent.getHeight() - d * this.extent.getHeight();
        return d2;
    }

    @Override
    public ArrayList<Shape> makeContinuousShapes(Position[] positionArray, int[] nArray, Row[] rowArray) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        int n = positionArray.length;
        if (positionArray == null) {
            return arrayList;
        }
        if (n > 0 && positionArray[0].length() == 1) {
            this.make1dShape(arrayList, positionArray, nArray);
            return arrayList;
        }
        positionArray = this.filterPositions(positionArray);
        n = positionArray.length;
        int[] nArray2 = null;
        if (this.sort) {
            int n2 = n != 0 ? positionArray[0].base.length : 0;
            nArray2 = PositionComparator.makeSortOrder(positionArray, n2);
        }
        DoublePrimitiveArrayList doublePrimitiveArrayList = new DoublePrimitiveArrayList();
        DoublePrimitiveArrayList doublePrimitiveArrayList2 = new DoublePrimitiveArrayList();
        DoublePrimitiveArrayList doublePrimitiveArrayList3 = new DoublePrimitiveArrayList();
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        ArrayList<Position> arrayList2 = new ArrayList<Position>();
        for (int i = 0; i < n; ++i) {
            int n3 = nArray2 != null ? nArray2[i] : i;
            Position position = positionArray[n3];
            if (position.X() == null) {
                return arrayList;
            }
            if (position.Y() == null || position.hasY2() && position.Y2() == null) {
                this.addShape(arrayList, intPrimitiveArrayList, arrayList2, doublePrimitiveArrayList, doublePrimitiveArrayList2, doublePrimitiveArrayList3);
                doublePrimitiveArrayList = new DoublePrimitiveArrayList();
                doublePrimitiveArrayList2 = new DoublePrimitiveArrayList();
                doublePrimitiveArrayList3 = new DoublePrimitiveArrayList();
                intPrimitiveArrayList = new IntPrimitiveArrayList();
                arrayList2 = new ArrayList();
                continue;
            }
            if (nArray != null) {
                intPrimitiveArrayList.add(nArray[n3]);
                arrayList2.add(position);
            }
            doublePrimitiveArrayList.add(position.X() * this.extent.getWidth());
            double d = this.extent.getHeight() - position.Y() * this.extent.getHeight();
            doublePrimitiveArrayList2.add(d);
            if (!position.hasY2()) continue;
            d = this.extent.getHeight() - position.Y2() * this.extent.getHeight();
            doublePrimitiveArrayList3.add(d);
        }
        this.addShape(arrayList, intPrimitiveArrayList, arrayList2, doublePrimitiveArrayList, doublePrimitiveArrayList2, doublePrimitiveArrayList3);
        return arrayList;
    }

    private void make1dShape(ArrayList<Shape> arrayList, Position[] positionArray, int[] nArray) {
        ArrayList<Position> arrayList2 = new ArrayList<Position>();
        double[] dArray = new double[positionArray.length];
        DoublePrimitiveArrayList doublePrimitiveArrayList = new DoublePrimitiveArrayList(positionArray.length);
        double d = this.extent.getWidth() / 2.0;
        for (int i = 0; i < positionArray.length; ++i) {
            arrayList2.add(positionArray[i]);
            dArray[i] = this.extent.getHeight() - positionArray[i].Y() * this.extent.getHeight();
            doublePrimitiveArrayList.add(d);
        }
        if (this.sort) {
            BasicFactory.sortArray(dArray);
        }
        DoublePrimitiveArrayList doublePrimitiveArrayList2 = new DoublePrimitiveArrayList(positionArray.length);
        for (int i = 0; i < positionArray.length; ++i) {
            doublePrimitiveArrayList2.add(dArray[i]);
        }
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                intPrimitiveArrayList.add(nArray[i]);
            }
        }
        Shape shape = this.createShape(doublePrimitiveArrayList, doublePrimitiveArrayList2, intPrimitiveArrayList);
        shape.setPositions(positionArray);
        arrayList.add(shape);
        this.cacheShape(shape);
    }

    private void addShape(ArrayList<Shape> arrayList, IntPrimitiveArrayList intPrimitiveArrayList, ArrayList<Position> arrayList2, DoublePrimitiveArrayList doublePrimitiveArrayList, DoublePrimitiveArrayList doublePrimitiveArrayList2, DoublePrimitiveArrayList doublePrimitiveArrayList3) {
        if (doublePrimitiveArrayList.size() == 0) {
            return;
        }
        Shape shape = doublePrimitiveArrayList3.isEmpty() ? this.createShape(doublePrimitiveArrayList, doublePrimitiveArrayList2, intPrimitiveArrayList) : this.createTwoSidedShape(doublePrimitiveArrayList, doublePrimitiveArrayList2, doublePrimitiveArrayList3, intPrimitiveArrayList);
        shape.setPositions(arrayList2.toArray(new Position[arrayList2.size()]));
        arrayList.add(shape);
        this.cacheShape(shape);
    }

    private Position[] filterPositions(Position[] positionArray) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (Position position : positionArray) {
            if (position.containsUndefinedXValues()) continue;
            arrayList.add(position);
        }
        return arrayList.toArray(new Position[arrayList.size()]);
    }

    private Shape createShape(DoublePrimitiveArrayList doublePrimitiveArrayList, DoublePrimitiveArrayList doublePrimitiveArrayList2, IntPrimitiveArrayList intPrimitiveArrayList) {
        Object object;
        Object object2 = doublePrimitiveArrayList.toArray();
        double[] dArray = doublePrimitiveArrayList2.toArray();
        if (this.drop) {
            object = new double[((double[])object2).length + 2];
            double[] dArray2 = new double[((double[])object2).length + 2];
            for (int i = 0; i < ((double[])object2).length; ++i) {
                object[i + 1] = object2[i];
                dArray2[i + 1] = dArray[i];
            }
            dArray = dArray2;
            object2 = object;
            object2[0] = object2[1];
            object2[((double[])object2).length - 1] = object2[((double[])object2).length - 2];
            double d = this.coords == null ? 0.0 : this.coords.scales[0].getBase();
            dArray[0] = this.extent.getHeight() - d * this.extent.getHeight();
            dArray[((double[])object2).length - 1] = dArray[0];
        }
        object = this.getShape((double[])object2, dArray);
        if (this.drop && 1003 == ((Shape)object).getType()) {
            ((ShapePoly)object).setNonTopPointsCount(-1);
        }
        return this.addRowsInfo(intPrimitiveArrayList, (Shape)object);
    }

    private Shape addRowsInfo(IntPrimitiveArrayList intPrimitiveArrayList, Shape shape) {
        if (intPrimitiveArrayList.size() > 0) {
            shape.setRows(intPrimitiveArrayList.toArray());
        }
        return shape;
    }

    private Shape createTwoSidedShape(DoublePrimitiveArrayList doublePrimitiveArrayList, DoublePrimitiveArrayList doublePrimitiveArrayList2, DoublePrimitiveArrayList doublePrimitiveArrayList3, IntPrimitiveArrayList intPrimitiveArrayList) {
        int n = doublePrimitiveArrayList.size();
        double[] dArray = new double[n * 2];
        double[] dArray2 = new double[n * 2];
        for (int i = 0; i < n; ++i) {
            dArray[i] = doublePrimitiveArrayList.get(i);
            dArray2[i] = doublePrimitiveArrayList2.get(i);
            int n2 = n - 1 - i;
            dArray[i + n] = doublePrimitiveArrayList.get(n2);
            dArray2[i + n] = doublePrimitiveArrayList3.get(n2);
        }
        Shape shape = this.getShape(dArray, dArray2);
        return this.addRowsInfo(intPrimitiveArrayList, shape);
    }

    protected Shape getShape(double[] object, double[] dArray) {
        Object object2;
        if (this.close && ((double[])object).length == 3 && object[0] == object[1] && object[1] == object[2]) {
            object2 = new double[5];
            double[] dArray2 = new double[5];
            object2[0] = Math.max(object[0] - 1.0, 0.0);
            dArray2[0] = dArray[0];
            object2[1] = Math.max(object[0] - 1.0, 0.0);
            dArray2[1] = dArray[1];
            object2[2] = object[1];
            dArray2[2] = dArray[1];
            object2[3] = object[2] + 1.0;
            dArray2[3] = dArray[1];
            object2[4] = object[2] + 1.0;
            dArray2[4] = dArray[2];
            object = object2;
            dArray = dArray2;
        }
        object2 = new ShapePoly((double[])object, dArray, this.close, this.pathMaker);
        ((Shape)object2).setSnap(this.getSnap());
        if (!((PolyShape)object2).isFilled()) {
            ((Shape)object2).setStartArrowByName(this.startArrow);
            ((Shape)object2).setEndArrowByName(this.endArrow);
        }
        return object2;
    }

    @Override
    public boolean makesContinuousShapes() {
        return true;
    }

    @Override
    public Shape makeShapeInside(Rect rect, int n) {
        double[] dArray = new double[]{rect.getX(), rect.getX() + rect.getWidth(), rect.getX() + rect.getWidth(), rect.getX()};
        double[] dArray2 = new double[]{rect.getY(), rect.getY(), rect.getY() + rect.getHeight(), rect.getY() + rect.getHeight()};
        return new ShapePoly(dArray, dArray2, false, null);
    }

    @Override
    protected Shape makeAugmentedShape(GeoData geoData, int n) {
        Shape[] shapeArray = geoData.featurePolygons(n);
        if (shapeArray == null) {
            return null;
        }
        if (shapeArray.length == 1) {
            return shapeArray[0];
        }
        Rect rect = geoData.featureBounds(n, false);
        return new Schema(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), shapeArray, this.close);
    }

    @Override
    protected Shape makeShape(Position position, Integer n) {
        assert (false) : "Should never be called";
        return null;
    }

    @Override
    public Number getDerivedValue(String string, Number number, Integer n) {
        if (number == null) {
            return null;
        }
        if ("curveTop".equals(string)) {
            this.makeCurveTopFunction();
            if (this.curveTopFunctionalPath == null) {
                return null;
            }
            Double d = this.coords.scales[1].toZeroOne(number.doubleValue(), null, n);
            if (d == null || Double.isNaN(d)) {
                return null;
            }
            double d2 = d * this.extent.getWidth();
            double d3 = this.curveTopFunctionalPath.getY(d2);
            if (Double.isNaN(d3)) {
                return null;
            }
            Double d4 = this.coords.scales[0].dimensionValueToDataValue(this.extent.getHeight() - d3, this.extent.getHeight());
            if (d4 == null || Double.isNaN(d4)) {
                return null;
            }
            return d4;
        }
        return null;
    }

    private void makeCurveTopFunction() {
        if (this.curveTopFunctionalPath != null) {
            return;
        }
        if (this.cachedPolys.size() != 1) {
            return;
        }
        ShapePoly shapePoly = this.cachedPolys.get(0);
        this.curveTopFunctionalPath = new LinearFunctionalPath(Double.NaN);
        int n = shapePoly.getXArray().length;
        if (n > 0) {
            this.curveTopFunctionalPath.moveTo(shapePoly.getXArray()[0], shapePoly.getYArray()[0]);
            for (int i = 0; i < n - 1; ++i) {
                this.curveTopFunctionalPath.lineTo(shapePoly.getXArray()[i], shapePoly.getYArray()[i]);
            }
            if (shapePoly.getXArray()[n - 2] < shapePoly.getXArray()[n - 1]) {
                this.curveTopFunctionalPath.lineTo(shapePoly.getXArray()[n - 1], shapePoly.getYArray()[n - 1]);
            }
        }
    }

    private void cacheShape(Shape shape) {
        if (1003 == shape.getType()) {
            ShapePoly shapePoly = (ShapePoly)shape;
            int n = shapePoly.getXArray().length;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            System.arraycopy(shapePoly.getXArray(), 0, dArray, 0, n);
            System.arraycopy(shapePoly.getYArray(), 0, dArray2, 0, n);
            this.cachedPolys.add(new ShapePoly(dArray, dArray2, shapePoly.isFilled(), shapePoly.getPathMaker()));
        }
    }
}

