/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.element;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.geo.GeoData;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.element.Builder;
import com.ibm.vis.engine.internal.interaction.defender.ScrollUnitControllerAction;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.CustomGlyphBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.scene.SymbolBuilder;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.SymbolSpec;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PointBuilder
extends Builder {
    private final String symbolName;
    private CustomGlyphBuilder symbolDef;
    private final int scaleDimensions;
    private final StyleSpec style;

    public PointBuilder(VisContext visContext, Coordinates coordinates, Dim dim, Dim dim2, StyleSpec styleSpec) {
        super(visContext, coordinates, dim);
        Object object;
        this.setSnap(StyleBuilder.getSnap(styleSpec));
        this.style = styleSpec;
        this.size = dim2;
        Object object2 = object = styleSpec == null ? null : styleSpec.symbol;
        if (object == null) {
            this.symbolName = "circle";
        } else if (BasicFactory.isString(object)) {
            this.symbolName = (String)object;
        } else {
            this.symbolName = null;
            if (styleSpec != null) {
                SymbolSpec symbolSpec = (SymbolSpec)styleSpec.symbol;
                SymbolSpec symbolSpec2 = ScrollUnitControllerAction.modify(symbolSpec, dim);
                this.symbolDef = new CustomGlyphBuilder(symbolSpec2, dim, visContext);
            }
        }
        this.scaleDimensions = this.getScaleDimensions(styleSpec);
    }

    private int getScaleDimensions(StyleSpec styleSpec) {
        if (styleSpec == null) {
            return 0;
        }
        boolean bl = styleSpec.width != null ? this.isPercent(styleSpec.width) : this.isPercent(styleSpec.size);
        boolean bl2 = styleSpec.height != null ? this.isPercent(styleSpec.height) : this.isPercent(styleSpec.size);
        return (bl ? 1 : 0) + (bl2 ? 2 : 0);
    }

    private boolean isPercent(Object object) {
        if (object == null) {
            return false;
        }
        if (!BasicFactory.isString(object)) {
            return false;
        }
        return ((String)object).endsWith("%") && !((String)object).endsWith("%%");
    }

    @Override
    public Shape makeShapeInside(Rect rect, int n) {
        Dim dim = this.size;
        double d = dim.getWidth() <= rect.getWidth() && n == -1 ? dim.getWidth() : rect.getWidth();
        double d2 = dim.getHeight() <= rect.getHeight() && n == -1 ? dim.getHeight() : rect.getHeight();
        return this.build(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0, d, d2);
    }

    @Override
    public boolean augmentedShapesNeedScaling() {
        return false;
    }

    private StyleSpec getStyle() {
        return this.style;
    }

    @Override
    protected Shape makeShape(Position position, Integer n) {
        double d = 0.0;
        double d2 = 0.0;
        if (position.length() == 0) {
            if (this.style == null || this.style.align == null || "middle".equals(this.style.align)) {
                d = this.extent.getWidth() / 2.0;
            } else if ("start".equals(this.style.align)) {
                d = 0.0;
            } else if ("end".equals(this.style.align)) {
                d = this.extent.getWidth() - this.size.getWidth();
            }
            if (this.style == null || this.style.valign == null || "middle".equals(this.style.valign)) {
                d2 = this.extent.getHeight() / 2.0;
            } else if ("start".equals(this.style.valign)) {
                d2 = 0.0;
            } else if ("end".equals(this.style.valign)) {
                d2 = this.extent.getHeight() - this.size.getHeight();
            }
        } else {
            if (position.XYUndefined()) {
                return null;
            }
            if (position.length() == 1) {
                if (this.style == null || this.style.align == null || "middle".equals(this.style.align)) {
                    d = this.extent.getWidth() / 2.0;
                } else if ("start".equals(this.style.align)) {
                    d = this.size.getWidth();
                } else if ("end".equals(this.style.align)) {
                    d = this.extent.getWidth() - this.size.getWidth();
                }
                d2 = this.extent.getHeight() - position.Y() * this.extent.getHeight();
            } else {
                d = position.X() * this.extent.getWidth();
                d2 = this.extent.getHeight() - position.Y() * this.extent.getHeight();
            }
        }
        Shape shape = this.build(d, d2, this.size.getWidth(), this.size.getHeight());
        return shape;
    }

    private Shape build(double d, double d2, double d3, double d4) {
        Shape shape = this.symbolDef != null ? this.symbolDef.makeCustomShape(d, d2, d3, d4, this.style) : SymbolBuilder.makeSymbol(this.symbolName, d, d2, d3, d4, this.style, this.visContext);
        if (this.style != null) {
            shape.setDefaultStyle(this.style);
        }
        if (this.isAdaptableShape(shape)) {
            shape.setScaleDimensions(this.scaleDimensions);
        }
        return shape;
    }

    protected boolean isAdaptableShape(Shape shape) {
        return 1004 == shape.getType() || "i-beam".equals(this.symbolName) || "t-beam".equals(this.symbolName);
    }

    @Override
    public Shape makeFromAugmentation(int n, GeoData geoData, double[] dArray) {
        Object object;
        ArrayList<Point> arrayList = geoData.featurePoints(n);
        if (arrayList == null || arrayList.isEmpty()) {
            if (this.visContext != null && this.visContext.getLogger() != null) {
                this.visContext.getLogger().warning(LogComponent.CommonGrammar, "No augmented data was found for data row " + n + ", that data is not shown");
            }
            return null;
        }
        double d = this.extent.getWidth() / (dArray[1] - dArray[0]);
        double d2 = this.extent.getHeight() / (dArray[2] - dArray[3]);
        double d3 = -dArray[0] * d;
        double d4 = -dArray[3] * d2;
        if (arrayList.size() == 1) {
            Point point = arrayList.get(0);
            Shape shape = this.build(point.getX(), point.getY(), this.size.getWidth(), this.size.getHeight());
            Point point2 = geoData.featureCenter(n);
            double d5 = point2.getX() * d + d3 - point2.getX();
            double d6 = point2.getY() * d2 + d4 - point2.getY();
            shape.affine(1.0, d5, 1.0, d6, false);
            shape.setRow(n);
            return shape;
        }
        Shape[] shapeArray = new Shape[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object = arrayList.get(i);
            Shape shape = this.build(((Point)object).getX(), ((Point)object).getY(), this.size.getWidth(), this.size.getHeight());
            Point point = shape.getCenter();
            double d7 = point.getX() * d + d3 - point.getX();
            double d8 = point.getY() * d2 + d4 - point.getY();
            shape.affine(1.0, d7, 1.0, d8, false);
            shape.setRow(n);
            shapeArray[i] = shape;
        }
        Rect rect = geoData.featureBounds(n, false);
        object = new Schema(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), shapeArray, false);
        ((Shape)object).setSnap(StyleBuilder.getSnap(this.getStyle()));
        ((Shape)object).setRow(n);
        return object;
    }

    @Override
    protected Shape makeAugmentedShape(GeoData geoData, int n) {
        return null;
    }
}

