/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.element;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.geo.GeoData;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.element.Builder;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.scene.SymbolBuilder;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SchemaBuilder
extends Builder {
    private final String type;
    private final ValueProvider[] componentValueProviders;
    private final Row[] rows;
    private final StyleSpec style;

    @Override
    public Shape makeFromAugmentation(int n, GeoData geoData, double[] dArray) {
        if (this.type.equals("schema")) {
            return super.makeFromAugmentation(n, geoData, dArray);
        }
        Point point = geoData.featureCenter(n);
        double d = this.extent.getWidth() * (point.getX() - dArray[0]) / (dArray[1] - dArray[0]);
        double d2 = this.extent.getHeight() * (1.0 - (point.getY() - dArray[2]) / (dArray[3] - dArray[2]));
        Rect rect = new Rect(d - this.size.getWidth() / 2.0, d2 - this.size.getHeight() / 2.0, this.size.getWidth(), this.size.getHeight());
        return this.makeInside(rect, n, true);
    }

    @Override
    protected Shape makeAugmentedShape(GeoData geoData, int n) {
        Shape[] shapeArray = geoData.featurePolygons(n);
        if (shapeArray == null) {
            Point point = geoData.featureCenter(n);
            if (point == null) {
                return null;
            }
            return SymbolBuilder.makeSymbol("circle", point.getX(), point.getY(), this.size.getWidth(), this.size.getHeight(), null, this.visContext);
        }
        if (shapeArray == null || shapeArray.length == 1) {
            return shapeArray[0];
        }
        Rect rect = geoData.featureBounds(n, false);
        Schema schema = new Schema(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), shapeArray, shapeArray[0].isFilled());
        schema.setSnap(StyleBuilder.getSnap(this.getStyle()));
        return schema;
    }

    private static Shape[] makePieParts(double[] dArray, double d, double d2, double d3, double d4) {
        double d52;
        double d6 = 0.0;
        for (double d52 : dArray) {
            d6 += d52;
        }
        if (d6 <= 0.0) {
            return null;
        }
        Shape[] shapeArray = new Shape[dArray.length];
        double d7 = Math.max(d3, d4);
        d52 = 0.0;
        for (int i = 0; i < shapeArray.length; ++i) {
            shapeArray[i] = ShapeFactory2.createWedge(d, d2, 0.0, d7, Math.PI * 2 * (d52 + dArray[i]) / d6, Math.PI * 2 * d52 / d6);
            shapeArray[i].setFill(SchemaBuilder.makeFill(i));
            d52 += dArray[i];
        }
        return shapeArray;
    }

    private static Shape makeProfileShape(double[] dArray, double d, double d2, double d3, double d4, VisContext visContext) {
        int n = dArray.length;
        double[] dArray2 = new double[n + 2];
        double[] dArray3 = new double[n + 2];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = d - d3 + d3 * 2.0 * (double)i / (double)(n - 1);
            dArray3[i] = d2 + d4 - d4 * 2.0 * dArray[i];
        }
        dArray2[n] = d + d3;
        dArray3[n] = d2 + d4;
        dArray2[n + 1] = d - d3;
        dArray3[n + 1] = d2 + d4;
        return new ShapePoly(dArray2, dArray3, true, null);
    }

    private static Shape makeStarShape(double[] dArray, double d, double d2, double d3, double d4, VisContext visContext) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double d5 = Math.max(d3, d4) / 2.0;
        for (int i = 0; i < n; ++i) {
            double d6 = Math.PI * 2 * (double)i / (double)n;
            dArray2[i] = d + d5 * dArray[i] * Math.cos(d6);
            dArray3[i] = d2 + d5 * dArray[i] * Math.sin(d6);
        }
        return new ShapePoly(dArray2, dArray3, true, null);
    }

    private static Shape[] makeRose(double[] dArray, double d, double d2, double d3, double d4) {
        int n = dArray.length;
        double d5 = Math.max(d3, d4);
        double d6 = Math.min(10.0, d5 / 4.0);
        Shape[] shapeArray = new Shape[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d7 = d6 + (d5 - d6) * dArray[i];
            shapeArray[n2] = ShapeFactory2.createWedge(d, d2, 10.0, d7, Math.PI * 2 * (double)n2 / (double)n, Math.PI * 2 * (double)(n2 + 1) / (double)n);
            ++n2;
        }
        return shapeArray;
    }

    private static Fill makeFill(int n) {
        ColorNew[] colorNewArray = ColorUtil.getDefaultColors();
        ColorNew colorNew = colorNewArray[n % colorNewArray.length];
        return Fill.makeSolid(colorNew);
    }

    SchemaBuilder(VisContext visContext, Coordinates coordinates, Dim dim, String string, Dim dim2, ValueProvider[] valueProviderArray, Row[] rowArray, StyleSpec styleSpec) {
        super(visContext, coordinates, dim);
        this.setSnap(StyleBuilder.getSnap(styleSpec));
        this.type = string;
        this.size = dim2;
        this.componentValueProviders = valueProviderArray;
        this.rows = rowArray;
        this.style = styleSpec;
    }

    @Override
    public Shape makeShapeInside(Rect rect, int n) {
        return this.makeSchemaShape(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0, rect.getWidth(), rect.getHeight(), this.getRows()[n]);
    }

    @Override
    protected Shape makeShape(Position position, Integer n) {
        double d;
        double d2;
        if (position.XYUndefined()) {
            return null;
        }
        if (position.length() == 0) {
            d2 = this.extent.getWidth() / 2.0;
            d = this.extent.getHeight() / 2.0;
        } else if (position.length() == 1) {
            d2 = this.extent.getWidth() / 2.0;
            d = this.extent.getHeight() - position.Y() * this.extent.getHeight();
        } else {
            d2 = position.X() * this.extent.getWidth();
            d = this.extent.getHeight() - position.Y() * this.extent.getHeight();
        }
        Shape shape = null;
        Row row = null;
        if (n != null) {
            row = this.rows[n];
        }
        if ((shape = this.makeSchemaShape(d2, d, this.size.getWidth(), this.size.getHeight(), row)) != null) {
            shape.setSnap(StyleBuilder.getSnap(this.getStyle()));
        }
        return shape;
    }

    protected Shape makeSchemaShape(double d, double d2, double d3, double d4, Row row) {
        Object object;
        int n = 0;
        double[] dArray = new double[this.componentValueProviders.length];
        for (int i = 0; i < this.componentValueProviders.length; ++i) {
            Field field = this.componentValueProviders[i].getBaseField();
            Double d5 = this.componentValueProviders[i].getNumber(row);
            dArray[i] = d5 == null ? Double.NaN : (field == null ? ((Number)d5).doubleValue() : field.range.toZeroOne(d5));
        }
        for (double d6 : dArray) {
            if (!(d6 >= 0.0)) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        if (n != dArray.length) {
            object = new double[n];
            int n2 = 0;
            for (double d7 : dArray) {
                if (!(d7 >= 0.0)) continue;
                object[n2++] = d7;
            }
            dArray = object;
        }
        if (this.type.endsWith("pie")) {
            Shape[] shapeArray = SchemaBuilder.makePieParts(dArray, d, d2, d3 / 2.0, d4 / 2.0);
            object = new Schema(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4, shapeArray, true);
        } else if (this.type.endsWith("profile")) {
            object = SchemaBuilder.makeProfileShape(dArray, d, d2, d3 / 2.0, d4 / 2.0, this.visContext);
        } else if (this.type.endsWith("star")) {
            object = SchemaBuilder.makeStarShape(dArray, d, d2, d3, d4, this.visContext);
        } else if (this.type.endsWith("rose")) {
            Shape[] shapeArray = SchemaBuilder.makeRose(dArray, d, d2, d3 / 2.0, d4 / 2.0);
            object = new Schema(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4, shapeArray, true);
        } else {
            throw new IllegalArgumentException("Unknown schema: " + this.type);
        }
        ((Shape)object).setSnap(StyleBuilder.getSnap(this.getStyle()));
        return object;
    }

    protected final StyleSpec getStyle() {
        return this.style;
    }

    protected final ValueProvider[] getComponentValueProviders() {
        return this.componentValueProviders;
    }

    protected Row[] getRows() {
        return this.rows;
    }

    public static boolean componentsAffectScale(String string, int n) {
        return string.endsWith("boxplot") && n == 0;
    }
}

