/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.element;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.geo.GeoData;
import com.ibm.vis.engine.internal.globalization.NumericShapingInfo;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.element.Builder;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.label.TextContentPart;
import com.ibm.vis.engine.internal.grammar.label.TextProducer;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class TextBuilder
extends Builder {
    private final Object[] content;
    private final StyleSpec style;
    private final StyleSpec backgroundStyle;
    private final Vis vis;
    private final Data data;
    private String align;
    private String valign;
    private boolean stretch;
    private boolean fit;
    private boolean inside;
    private static final String TEXT_ELEMENT_LEGEND_SWATCH = "A";
    public String clipSymbol;
    private boolean isLegendEntry;
    public final NumericShapingInfo shapingInfo;
    private double fontSizeFromSpec;

    TextBuilder(VisContext visContext, Coordinates coordinates, Dim dim, Vis vis, Data data, Dim dim2, ElementsSpec elementsSpec) {
        super(visContext, coordinates, dim);
        this.setSnap(StyleBuilder.getSnap(elementsSpec.style));
        if (elementsSpec.content == null) {
            throw new SpecException("No content provided for element text", ErrorCode.SPEC_IS_NULL, null);
        }
        this.content = elementsSpec.content;
        this.style = elementsSpec.style;
        this.backgroundStyle = elementsSpec.textBackgroundStyle;
        this.size = dim2;
        this.vis = vis;
        this.data = data;
        this.shapingInfo = visContext.getNumericShapingInfo();
        this.align = this.style != null && this.style.align != null ? this.style.align : "middle";
        this.valign = this.style != null && this.style.valign != null ? this.style.valign : "middle";
        this.inside = false;
        if (this.style != null && this.style.location != null && BasicFactory.isString(this.style.location)) {
            if ("inside".equals(this.style.location)) {
                this.inside = true;
            } else if ("stretch".equals(this.style.location)) {
                this.stretch = true;
            } else if ("fit".equals(this.style.location)) {
                this.fit = true;
            }
        }
        double d = FontHelper.getDefaultFontSize(visContext.getMinimumFontSize());
        this.fontSizeFromSpec = elementsSpec.style != null && elementsSpec.style.font != null && elementsSpec.style.font.size != null ? UnitConverter.convertLength(elementsSpec.style.font.size, d, d) : d;
        this.clipSymbol = TextProducer.isContentCategorical(this.vis, this.content) ? "\u2026" : "#";
        this.isLegendEntry = false;
    }

    @Override
    protected Shape makeShape(Position position, Integer n) {
        double d;
        double d2;
        TextContent textContent = null;
        if (this.isLegendEntry) {
            textContent = TextContent.makeForString(TEXT_ELEMENT_LEGEND_SWATCH, this.vis.getVisContext().getMinimumFontSize());
            this.align = "middle";
            this.valign = "middle";
        } else {
            if (n == null) {
                n = -1;
            }
            textContent = TextProducer.makeTextContent(this.vis, this.data, this.content, n);
        }
        if (textContent == null) {
            return null;
        }
        if (position.XYUndefined()) {
            return null;
        }
        Font font = this.getFont(this.size, textContent);
        if (position.length() == 0) {
            d2 = this.extent.getWidth() / 2.0;
            d = this.extent.getHeight() / 2.0;
        } else if (position.length() == 1) {
            d2 = this.extent.getWidth() / 2.0;
            d = this.extent.getHeight() - position.Y() * this.extent.getHeight();
        } else {
            d2 = position.X() * this.extent.getWidth();
            d = this.extent.getHeight() - position.Y() * this.extent.getHeight();
        }
        return this.buildShape(d2, d, font, textContent);
    }

    private Font getFont(Dim dim, TextContent textContent) {
        Font font = null;
        double d = dim.getHeight();
        if (this.style != null) {
            FontSpec fontSpec = this.style.font;
            if (fontSpec != null) {
                fontSpec = (FontSpec)fontSpec.copy();
                if (fontSpec.size == null) {
                    fontSpec.size = d;
                    fontSpec.setCachedObject(null);
                }
                font = FontHelper.makeFromSpec(fontSpec, this.visContext.getMinimumFontSize(), this.visContext.usesFractionalMetrics());
            } else {
                font = FontHelper.makeForSize(d, this.visContext.getMinimumFontSize(), this.visContext.usesFractionalMetrics());
            }
        } else {
            font = FontHelper.makeForSize(d, this.visContext.getMinimumFontSize(), this.visContext.usesFractionalMetrics());
        }
        double d2 = font.getSize() / this.fontSizeFromSpec;
        for (TextContentPart textContentPart : textContent.getContent()) {
            Object object = textContentPart.getValue();
            if (object == null || !BasicFactory.isString(textContentPart.getValue())) continue;
            Font font2 = textContentPart.getFont();
            if (font2 != null) {
                textContentPart.setFont(font2.modifySize(font2.getSize() * d2));
                continue;
            }
            textContentPart.setFont(font);
        }
        return font;
    }

    @Override
    public Shape makeShapeInside(Rect rect, int n) {
        Text text = this.build(rect, n);
        return text;
    }

    private Text build(Rect rect, int n) {
        TextContent textContent = TextProducer.makeTextContent(this.vis, this.data, this.content, n);
        Text text = textContent != null ? this.assembleText(rect, textContent) : null;
        return text;
    }

    private Text assembleText(Rect rect, TextContent textContent) {
        double d = rect.getX();
        double d2 = rect.getY();
        Dim dim = new Dim(rect.getWidth(), rect.getHeight());
        String string = this.align;
        String string2 = this.valign;
        Point point = new Point(d, d2);
        Insets insets = this.style != null && this.style.padding != null ? Insets.makeForStylePadding(this.style.padding, dim, dim) : Insets.NONE;
        double d3 = "start".equals(string) ? point.getX() + insets.left : ("end".equals(string) ? point.getX() + rect.getWidth() - insets.right : point.getX() + rect.getWidth() / 2.0);
        double d4 = "start".equals(this.valign) ? point.getY() + insets.top : ("end".equals(this.valign) ? point.getY() + rect.getHeight() - insets.bottom : point.getY() + rect.getHeight() / 2.0);
        if ("middleOfFirstLine".equals(string2)) {
            string2 = "middle";
        }
        Text text = ItemBuilder.makeText(textContent, d3, d4, string, string2, this.getFont(dim, textContent), this.style, this.backgroundStyle, dim, false, this.clipSymbol, this.shapingInfo, this.vis.getVisContext().getTooltipsForTruncatedText());
        if (this.fit) {
            text = text.sizeToFit(dim, false);
        } else if (this.stretch) {
            text = text.stretchToFit(dim);
        } else if (this.inside) {
            text.clipToFit(dim.getWidth());
        }
        if (text == null) {
            return null;
        }
        text.applyTextAngle();
        return text;
    }

    private Shape buildShape(double d, double d2, Font font, TextContent textContent) {
        Text text = ItemBuilder.makeText(textContent, d, d2, this.align, this.valign, font, this.style, this.backgroundStyle, this.size, false, "\u2026", this.shapingInfo, this.vis.getVisContext().getTooltipsForTruncatedText());
        if (text == null) {
            return null;
        }
        text.setUsesBackgroundPlaque(true);
        if (this.fit) {
            text = text.sizeToFit(this.size, false);
        } else if (this.stretch) {
            text = text.stretchToFit(this.size);
        } else if (this.inside) {
            text.clipToFit(this.size.getWidth());
        }
        text.applyTextAngle();
        return text;
    }

    @Override
    protected Shape makeAugmentedShape(GeoData geoData, int n) {
        return null;
    }
}

