/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.element.positionmodifier;

import com.ibm.vis.engine.internal.grammar.element.positionmodifier.PileShapeComparator;
import com.ibm.vis.engine.internal.grammar.element.positionmodifier.PositionModifier;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Pile
extends PositionModifier {
    private boolean pileInXDirection = true;

    @Override
    public void modifyPositions(HashMap<String, ArrayList<Shape>> hashMap, boolean bl) {
        this.pileInXDirection = !bl;
        for (ArrayList<Shape> arrayList : hashMap.values()) {
            if (arrayList.size() < 2) continue;
            this.sort(arrayList);
            this.pile(arrayList);
        }
    }

    private void sort(ArrayList<Shape> arrayList) {
        BasicFactory.sortList(arrayList, new PileShapeComparator(this.pileInXDirection));
    }

    private void pile(ArrayList<Shape> arrayList) {
        double d = 0.0;
        for (int i = 1; i < arrayList.size(); ++i) {
            Shape shape = arrayList.get(i - 1);
            Shape shape2 = arrayList.get(i);
            Rect rect = shape.getBounds();
            Rect rect2 = shape2.getBounds();
            if (this.pileInXDirection) {
                shape2.affine(1.0, d += rect.getWidth() / 2.0 + rect2.getWidth() / 2.0, 1.0, 0.0, false);
                continue;
            }
            shape2.affine(1.0, 0.0, 1.0, d -= rect.getHeight() / 2.0 + rect2.getHeight() / 2.0, false);
        }
    }
}

