/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.label.TextProducer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class AbstractLabelProducer {
    protected final Data data;
    protected final Vis vis;
    public final String part;
    public boolean isCategorical;

    protected AbstractLabelProducer(Data data, Vis vis, String string) {
        this.data = data;
        this.vis = vis;
        this.part = string;
        this.isCategorical = true;
    }

    public TextContent makeContentFor(Object[] objectArray, Shape shape) {
        if (this.part != null && shape.getElementPart() != null && !this.part.equals(shape.getElementPart())) {
            return null;
        }
        if (shape.getRows() != null && shape.getRows().length > 0) {
            TextContent textContent = this.makeTextContent(objectArray, shape.getRows()[0]);
            this.checkLabelConsistency(objectArray, shape, textContent);
            return textContent;
        }
        return this.makeTextContent(objectArray, -1);
    }

    private void checkLabelConsistency(Object[] objectArray, Shape shape, TextContent textContent) {
        if (!shape.getNeedsConsistentLabels()) {
            return;
        }
        for (int i = 1; i < shape.getRows().length; ++i) {
            TextContent textContent2 = this.makeTextContent(objectArray, shape.getRows()[i]);
            if (textContent.getText().equals(textContent2.getText())) continue;
            String string = "Label consistency error - a label or tooltip cannot be created for this element and data (see \"Label\" in the VizJSON Reference Guide)";
            throw new EngineException(string, ErrorCode.ENGINE_ROWS_CREATE_CONFLICTING_LABEL, null);
        }
    }

    public TextContent makeTextContent(Object[] objectArray, int n) {
        if (!TextProducer.isContentCategorical(this.vis, objectArray)) {
            this.isCategorical = false;
        }
        return TextProducer.makeTextContent(this.vis, this.data, objectArray, n);
    }
}

