/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.geom.qt.QTItem;
import com.ibm.vis.engine.internal.geom.qt.QuadTree;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.label.CollisionComparator;
import com.ibm.vis.engine.internal.grammar.label.CollisionItem;
import com.ibm.vis.engine.internal.grammar.label.Stress;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CollisionHandler {
    private static final double COORDS_MULTIPLIER = 1000.0;
    private static final double ELEM_LABEL_COLL_MULTIPLIER = 8.0;
    private static final double LABEL_COLL_MULTIPLIER = 2.0;
    private static final double LABEL_COLL_PENALTY = 3.0;
    private static final double CALLOUT_LABEL_COLL_MULTIPLIER = 2.0;
    private static final double CALLOUTS_COLL_MULTIPLIER = 1.0;
    private static final double DISTANCE_MULTIPLIER = 0.01;
    private static final double BEST_DIR_MULTIPLIER = 5.0;
    private static final double CALLOUT_ELEM_COLL_MULTIPLIER = 1.0;
    double penalty;
    private int[] xdirs;
    private int[] ydirs;
    private static final int CONGESTION_LIMIT = 4;
    private final String method;
    double maxMoveDistance;
    private double maxLoops;
    QuadTree<CollisionItem> itemsQT;
    HashMap<CollisionItem, Shape> itemsAndCallouts;
    QuadTree<Geom> fixedQT;
    private Map<Geom, Integer> whichElement;
    Geom back;

    public CollisionHandler(String string) {
        this.method = string == null ? "limited" : string;
    }

    public void moveLabels(ShapeList[] shapeListArray, Rect rect, Coordinates coordinates, VisContext visContext) {
        if (this.method.equals("none")) {
            return;
        }
        Dim dim = rect.getExtent();
        CollisionItem[] collisionItemArray = this.buildStructures(shapeListArray, dim);
        if (collisionItemArray.length == 0) {
            return;
        }
        Dim dim2 = CollisionHandler.getLabelMeanSize(collisionItemArray);
        this.setAlgorithmLoopParameters(dim, collisionItemArray.length, dim2);
        Shape shape = ShapeFactory2.CreateRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        if (coordinates != null) {
            shape = coordinates.modifyShape(shape, dim);
        }
        this.back = shape.getGeom();
        int n = 0;
        while ((double)n < this.maxLoops && !this.singlePass(collisionItemArray)) {
            ++n;
        }
        for (CollisionItem collisionItem : collisionItemArray) {
            collisionItem.commitMove();
        }
    }

    CollisionItem[] buildStructures(ShapeList[] shapeListArray, Dim dim) {
        CollisionItem[] collisionItemArray = CollisionHandler.getMovableItems(shapeListArray);
        if (collisionItemArray.length == 0) {
            return collisionItemArray;
        }
        double d = dim.getWidth();
        double d2 = dim.getHeight();
        this.fixedQT = new QuadTree(20, -d2 / 4.0, -d / 4.0, d2 * 5.0 / 4.0, d * 5.0 / 4.0);
        this.itemsQT = new QuadTree(20, -d2 / 4.0, -d / 4.0, d2 * 5.0 / 4.0, d * 5.0 / 4.0);
        this.itemsAndCallouts = new HashMap();
        Rect rect = null;
        for (int i = 0; i < collisionItemArray.length; ++i) {
            rect = collisionItemArray[i].getOverallBounds();
            this.itemsQT.add(new QTItem<CollisionItem>(collisionItemArray[i], rect.getY(), rect.getX(), rect.getY2(), rect.getX2()));
            this.updateCallout(collisionItemArray[i]);
        }
        this.addFixedGeoms(shapeListArray);
        return collisionItemArray;
    }

    public void setAlgorithmLoopParameters(Dim dim, int n, Dim dim2) {
        int n2 = Math.max(2, (int)Math.ceil(dim2.getWidth() / 12.0));
        int n3 = Math.max(2, (int)Math.ceil(dim2.getHeight() / 4.0));
        this.xdirs = new int[]{0, 0, n2, -n2, n2, -n2, n2, -n2};
        this.ydirs = new int[]{n3, -n3, 0, 0, -n3, n3, n3, -n3};
        double d = (double)(n * 8) * Math.log(n);
        if (this.method.equals("full")) {
            this.maxLoops = Math.min(100.0, 1000000.0 / d);
            this.maxMoveDistance = dim.getMin();
            this.penalty = 0.0;
        } else {
            this.maxLoops = Math.min(20.0, 50000.0 / d);
            this.maxMoveDistance = Math.max(3.0 * dim2.getHeight(), 0.1 * dim.getMin());
            this.penalty = 1.0;
        }
    }

    private boolean singlePass(CollisionItem[] collisionItemArray) {
        boolean bl = true;
        for (CollisionItem collisionItem : collisionItemArray) {
            if (!collisionItem.needsCheck()) continue;
            collisionItem.setStress(this.computeStress(collisionItem, 0.0, 0.0, collisionItem.getOverallBounds(), Double.MAX_VALUE));
            if (collisionItem.getStress().getIntersectionStress() > 0.0) {
                if (!this.attemptMove(collisionItem, collisionItem.getStress())) continue;
                bl = false;
                continue;
            }
            collisionItem.setNeedsCheck(false);
        }
        return bl;
    }

    private boolean attemptMove(CollisionItem collisionItem, Stress stress) {
        Stress stress2;
        int n;
        int n2 = -1;
        Stress stress3 = stress;
        Rect rect = collisionItem.getOverallBounds();
        Rect rect2 = rect.copy();
        for (n = 0; n < 4; ++n) {
            rect2.setX(rect.getX() + (double)this.xdirs[n]);
            rect2.setY(rect.getY() + (double)this.ydirs[n]);
            stress2 = this.computeStress(collisionItem, this.xdirs[n], this.ydirs[n], rect2, stress3.getCombinedStress());
            if (stress2.betterThan(stress3)) {
                stress3 = stress2;
                n2 = n;
            }
            if (stress2.getCombinedStress() == 0.0) break;
        }
        if (n2 < 0) {
            for (n = 0; n < 8; ++n) {
                rect2.setX(rect.getX() + (double)this.xdirs[n] * 5.0);
                rect2.setY(rect.getY() + (double)this.ydirs[n] * 5.0);
                stress2 = this.computeStress(collisionItem, this.xdirs[n], this.ydirs[n], rect2, stress3.getCombinedStress());
                if (stress2.betterThan(stress3)) {
                    stress3 = stress2;
                    n2 = n;
                }
                if (stress2.getCombinedStress() == 0.0) break;
            }
            if (n2 < 0) {
                return false;
            }
        }
        double d = this.xdirs[n2];
        double d2 = this.ydirs[n2];
        if (stress3.getIntersectionStress() > 0.0) {
            for (int i = 0; i < 4; ++i) {
                rect2.setX(rect.getX() + (d *= 2.0));
                rect2.setY(rect.getY() + (d2 *= 2.0));
                Stress stress4 = this.computeStress(collisionItem, d, d2, rect2, stress3.getCombinedStress());
                if (!stress4.betterThan(stress3)) {
                    d /= 2.0;
                    d2 /= 2.0;
                    break;
                }
                stress3 = stress4;
            }
        }
        this.moveItem(collisionItem, d, d2, stress, stress3);
        collisionItem.setStress(stress3);
        collisionItem.setNeedsCheck(stress.getIntersectionStress() > 0.0);
        return true;
    }

    Stress computeStress(CollisionItem collisionItem, double d, double d2, Rect rect, double d3) {
        Stress stress = new Stress(0.0);
        double d4 = collisionItem.getDistanceMoved(rect);
        if (d4 > this.maxMoveDistance) {
            return Stress.MAXIMALLY_BAD;
        }
        if (!this.back.containsGeom(rect)) {
            stress.addToLabelStress(1000.0 * (1.0 + this.amountOutside(rect)));
            if (stress.getIntersectionStress() >= d3) {
                return Stress.MAXIMALLY_BAD;
            }
        }
        Shape shape = d == 0.0 && d2 == 0.0 ? this.itemsAndCallouts.get(collisionItem) : CollisionHandler.makeCallout(collisionItem, d, d2);
        if ((stress = this.textsCollisions(collisionItem, rect, d3, stress)).getIntersectionStress() >= d3) {
            return Stress.MAXIMALLY_BAD;
        }
        if (shape != null && (stress = this.calloutLabelsCollisions(collisionItem, shape, stress)).getIntersectionStress() >= d3) {
            return Stress.MAXIMALLY_BAD;
        }
        if ((stress = this.calloutsCollisions(collisionItem, rect, shape, stress)).getIntersectionStress() >= d3) {
            return Stress.MAXIMALLY_BAD;
        }
        if ((stress = this.fixedShapeCollisions(collisionItem, rect, shape, stress)).getIntersectionStress() >= d3) {
            return Stress.MAXIMALLY_BAD;
        }
        return stress;
    }

    private Stress textsCollisions(CollisionItem collisionItem, Rect rect, double d, Stress stress) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.itemsQT.addIntersecting(linkedHashSet, rect.getY(), rect.getX(), rect.getY2(), rect.getX2(), 4);
        for (QTItem qTItem : linkedHashSet) {
            double d2;
            CollisionItem collisionItem2 = (CollisionItem)qTItem.getItem();
            if (collisionItem2 == collisionItem || !((d2 = CollisionHandler.overlapFractionRect(rect, collisionItem2.getOverallBounds())) > 0.0)) continue;
            stress.addToLabelStress(3.0 + 2.0 * (this.penalty + d2));
            if (stress.getIntersectionStress() >= d) {
                return Stress.MAXIMALLY_BAD;
            }
            stress.addCollisionLabel(collisionItem2);
        }
        return stress;
    }

    private Stress calloutsCollisions(CollisionItem collisionItem, Rect rect, Shape shape, Stress stress) {
        for (CollisionItem collisionItem2 : this.itemsAndCallouts.keySet()) {
            if (collisionItem2.index() == collisionItem.index()) continue;
            Shape shape2 = this.itemsAndCallouts.get(collisionItem2);
            if (((Line)shape2.getRenderGeom(0.0)).intersects(rect)) {
                stress.addToLabelCalloutStress(2.0);
                stress.addCollisionLabel(collisionItem2);
            }
            if (shape == null || !Line.segmentsIntersect(shape.getXArray()[0], shape.getYArray()[0], shape.getXArray()[1], shape.getYArray()[1], shape2.getXArray()[0], shape2.getYArray()[0], shape2.getXArray()[1], shape2.getYArray()[1], false)) continue;
            stress.addToCalloutStress(1.0);
            stress.addCollisionLabel(collisionItem2);
        }
        return stress;
    }

    private static Shape makeCallout(CollisionItem collisionItem, double d, double d2) {
        collisionItem.moveBy(d, d2, false);
        Shape shape = collisionItem.makeCallout();
        collisionItem.moveBy(-d, -d2, false);
        return shape;
    }

    private Stress fixedShapeCollisions(CollisionItem collisionItem, Rect rect, Shape shape, Stress stress) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.fixedQT.addIntersecting(linkedHashSet, rect.getY(), rect.getX(), rect.getY2(), rect.getX2(), 4);
        for (QTItem qTItem : linkedHashSet) {
            int n;
            Geom geom = (Geom)qTItem.getItem();
            Integer n2 = this.whichElement.get(geom);
            int n3 = n = n2 == null ? 0 : n2;
            if (collisionItem.getElementIndex() != n || collisionItem.getShape().getGeom().containsGeom(geom) && geom.containsGeom(collisionItem.getShape().getGeom()) || collisionItem.getShape().getGeom().equals(geom)) continue;
            double d = CollisionHandler.overlapFraction(rect, geom);
            if (d > 0.0) {
                stress.addToFixedShapeStress(8.0 * (this.penalty + d));
            }
            if (shape == null || !((Line)shape.getRenderGeom(0.0)).intersects(geom.getBounds())) continue;
            stress.addToFixedShapeStress(1.0);
        }
        return stress;
    }

    private Stress calloutLabelsCollisions(CollisionItem collisionItem, Shape shape, Stress stress) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Rect rect = shape.getBounds();
        int n = 0;
        this.itemsQT.addIntersecting(linkedHashSet, rect.getY(), rect.getX(), rect.getY2(), rect.getX2(), 4);
        for (QTItem qTItem : linkedHashSet) {
            CollisionItem collisionItem2 = (CollisionItem)qTItem.getItem();
            if (collisionItem2 == collisionItem) continue;
            Rect rect2 = collisionItem2.getOverallBounds();
            if (!((Line)shape.getRenderGeom(0.0)).intersects(rect2)) continue;
            ++n;
            collisionItem.getStress().addCollisionLabel(collisionItem2);
        }
        stress.addToLabelCalloutStress((double)n * 2.0);
        return stress;
    }

    private double amountOutside(Rect rect) {
        if (this.back.type() == 1002) {
            Rect rect2 = rect.makeIntersection((Rect)this.back);
            if (rect2 == null) {
                return 0.0;
            }
            return 1.0 - rect2.area() / rect.area();
        }
        return 1.0 - CollisionHandler.overlapFraction(rect, this.back);
    }

    private static CollisionItem[] getMovableItems(ShapeList[] shapeListArray) {
        ArrayList<CollisionItem> arrayList = new ArrayList<CollisionItem>();
        for (ShapeList shapeList : shapeListArray) {
            for (Text text : shapeList.getElementLabels()) {
                if (text.isInside() || text.isCallout() || CollisionHandler.isRotated(text.style.angle)) continue;
                int n = CollisionHandler.getElementIndex(text);
                arrayList.add(new CollisionItem(shapeList, text, n));
            }
        }
        BasicFactory.sortList(arrayList, new CollisionComparator());
        return arrayList.toArray(new CollisionItem[arrayList.size()]);
    }

    private void addFixedGeoms(ShapeList[] shapeListArray) {
        this.whichElement = new HashMap<Geom, Integer>();
        for (ShapeList shapeList : shapeListArray) {
            for (Text text : shapeList.getElementLabels()) {
                if (!text.isInside() && !text.isCallout() && !CollisionHandler.isRotated(text.style.angle)) continue;
                this.addGeom(text.getBounds(), CollisionHandler.getElementIndex(text));
            }
            for (Shape shape : shapeList.getElementShapes()) {
                if (shape.getGeom() == null) continue;
                this.addGeom(shape.getGeom(), CollisionHandler.getElementIndex(shape));
            }
        }
    }

    private void addGeom(Geom geom, int n) {
        Rect rect = geom.getBounds();
        this.fixedQT.add(new QTItem<Geom>(geom, rect.getY(), rect.getX(), rect.getY2(), rect.getX2()));
        if (n > 0) {
            this.whichElement.put(geom, n);
        }
    }

    private void moveItem(CollisionItem collisionItem, double d, double d2, Stress stress, Stress stress2) {
        this.itemsQT.remove(collisionItem.asQTItem());
        boolean bl = false;
        if (stress2.getCombinedStress() > 0.0) {
            bl = true;
        }
        collisionItem.moveBy(d, d2, bl);
        for (CollisionItem collisionItem2 : stress.getCollisionLabels()) {
            collisionItem2.setNeedsCheck(true);
        }
        for (CollisionItem collisionItem2 : stress2.getCollisionLabels()) {
            collisionItem2.setNeedsCheck(true);
        }
        this.itemsQT.add(collisionItem.asQTItem());
        this.updateCallout(collisionItem);
    }

    private void updateCallout(CollisionItem collisionItem) {
        Shape shape = collisionItem.makeCallout();
        if (shape == null) {
            this.itemsAndCallouts.remove(collisionItem);
        } else {
            this.itemsAndCallouts.put(collisionItem, shape);
        }
    }

    private static boolean isRotated(Object object) {
        if (object == null) {
            return false;
        }
        if (BasicFactory.isNumber(object)) {
            return ((Number)object).doubleValue() != 0.0;
        }
        return true;
    }

    private static Dim getLabelMeanSize(CollisionItem[] collisionItemArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (CollisionItem collisionItem : collisionItemArray) {
            Rect rect = collisionItem.getOverallBounds();
            d += rect.getWidth();
            d2 += rect.getHeight();
        }
        return new Dim(d / (double)collisionItemArray.length, d2 / (double)collisionItemArray.length);
    }

    public static double overlapFraction(Rect rect, Geom geom) {
        if (geom.type() == 1002) {
            return CollisionHandler.overlapFractionRect(rect, (Rect)geom);
        }
        double d = rect.distanceToGeom(geom);
        if (d > 0.0) {
            return 0.0;
        }
        if (d < 0.0) {
            return 1.0;
        }
        return CollisionHandler.overlapFractionRect(rect, geom.getBounds());
    }

    private static double overlapFractionRect(Rect rect, Rect rect2) {
        double d = Math.min(rect.getMaxX(), rect2.getMaxX()) - Math.max(rect.getMinX(), rect2.getMinX());
        double d2 = Math.min(rect.getMaxY(), rect2.getMaxY()) - Math.max(rect.getMinY(), rect2.getMinY());
        if (d <= 0.0 || d2 <= 0.0) {
            return 0.0;
        }
        double d3 = d * d2 / Math.min(rect.area(), rect2.area());
        return d3 < 0.001 ? 0.0 : d3;
    }

    private static int getElementIndex(Shape shape) {
        String string = shape.getID();
        if (string == null) {
            return -1;
        }
        int n = string.indexOf("E") + 1;
        if (n == 0) {
            return -1;
        }
        double d = BasicFactory.parseDouble(string.substring(n, n + 1));
        return Double.isNaN(d) ? -1 : (int)d;
    }

    public boolean isNone() {
        return this.method.equals("none");
    }

    public String getMethod() {
        return this.method;
    }
}

