/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.geom.qt.QTItem;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.label.Stress;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class CollisionItem {
    private static final double INSET_DELTA = 0.1;
    private final int elementIndex;
    private final ShapeList shapeList;
    private final double ox;
    private final double oy;
    private Stress stress;
    private final Rect bounds;
    private final Rect plaque;
    private boolean needsCheck;
    private final int index;
    private static int counter = 0;
    final Text text;

    CollisionItem(ShapeList shapeList, Text text, int n) {
        this.shapeList = shapeList;
        this.elementIndex = n;
        this.text = text;
        this.stress = new Stress(0.0);
        this.bounds = shapeList.getBoundsForLabel(this.text).inset(0.1);
        Shape shape = shapeList.getPlaqueForLabel(this.text);
        this.plaque = shape != null ? shape.getBounds() : null;
        this.ox = this.bounds.getX();
        this.oy = this.bounds.getY();
        this.needsCheck = true;
        this.index = counter++;
    }

    final QTItem<CollisionItem> asQTItem() {
        return new QTItem<CollisionItem>(this, this.bounds.getY(), this.bounds.getX(), this.bounds.getY2(), this.bounds.getX2());
    }

    final Rect getOverallBounds() {
        if (this.plaque != null && !ShapeList.labelHasTransparentPlaque(this.text)) {
            return this.plaque;
        }
        return this.bounds;
    }

    void moveBy(double d, double d2, boolean bl) {
        if (bl) {
            this.needsCheck = true;
        }
        this.bounds.translate(d, d2);
        if (this.plaque != null) {
            this.plaque.translate(d, d2);
        }
    }

    void commitMove() {
        double d;
        double d2 = this.bounds.getX() - this.ox;
        if (d2 * d2 + (d = this.bounds.getY() - this.oy) * d > 1.0E-6) {
            this.shapeList.moveLabel(this.text, d2, d);
        }
    }

    final int getElementIndex() {
        return this.elementIndex;
    }

    final boolean needsCheck() {
        return this.needsCheck;
    }

    final void setNeedsCheck(boolean bl) {
        this.needsCheck = bl;
    }

    final double getDistanceMoved(Rect rect) {
        return Math.abs(rect.getX() - this.ox) + Math.abs(rect.getY() - this.oy);
    }

    public final int index() {
        return this.index;
    }

    public Shape makeCallout() {
        return this.shapeList.makeLabelLine(this.text, this.getOverallBounds());
    }

    public void setStress(Stress stress) {
        this.stress = stress;
    }

    public Stress getStress() {
        return this.stress;
    }

    public Shape getShape() {
        return this.shapeList.getShapeForLabel(this.text);
    }
}

