/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.label.ShapeLabelLinesHolder;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.MultiPartText;
import com.ibm.vis.engine.internal.struct.MultiPartTextLine;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.geom.Wedge;
import com.ibm.vis.spec.internal.PreferredSizeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LabelCallout {
    private final Grammar grammar;
    private final Dim extent;
    private final Dim graphSize;
    private final List<LabelProducer> labelProducers;
    private final boolean isWidthPercent;
    private static final double PERCENTAGE_RADIUS_RADIAL_CALLOUT = 0.1;
    private static final double INITIAL_PERCENTAGE_RADIUS_HORIZONTAL_CALLOUT = 0.2;

    public LabelCallout(Grammar grammar, Element element, Dim dim) {
        this.grammar = grammar;
        this.extent = dim;
        this.graphSize = grammar.graphSize;
        this.labelProducers = element.labelProducers;
        this.isWidthPercent = LabelCallout.isElementWidthPercentage(element);
    }

    private static boolean isElementWidthPercentage(Element element) {
        if (element.spec != null && element.spec.style != null) {
            StyleSpec styleSpec = element.spec.style;
            boolean bl = styleSpec.width != null ? LabelCallout.isPercent(styleSpec.width) : LabelCallout.isPercent(styleSpec.size);
            return bl;
        }
        return false;
    }

    private static boolean isPercent(Object object) {
        if (object == null) {
            return false;
        }
        if (!BasicFactory.isString(object)) {
            return false;
        }
        return ((String)object).endsWith("%") && !((String)object).endsWith("%%");
    }

    public void modifyShapes(List<ShapeLabelLinesHolder> list, LabelProducer labelProducer, StyleSpec styleSpec) {
        block22: {
            double d;
            if (styleSpec == null) {
                styleSpec = new StyleSpec();
            }
            if (list.isEmpty() || !this.grammar.coordinates.containsPolar()) {
                return;
            }
            double d2 = this.grammar.coordinates.getCoordinateCenter(this.graphSize).getX();
            boolean bl = true;
            PreferredSizeSpec preferredSizeSpec = this.getDiameterFromSpec();
            double d3 = d = Math.min(this.graphSize.getWidth(), this.graphSize.getHeight());
            double d4 = 0.0;
            double d5 = d / 2.0;
            if (preferredSizeSpec != null) {
                if (preferredSizeSpec.max != null) {
                    d3 = UnitConverter.convertLength(preferredSizeSpec.max, d, d);
                }
                if (preferredSizeSpec.min != null) {
                    d4 = UnitConverter.convertLength(preferredSizeSpec.min, d, d);
                }
                if (preferredSizeSpec.preferred != null) {
                    d5 = UnitConverter.convertLength(preferredSizeSpec.preferred, d, d);
                }
            }
            if (preferredSizeSpec != null && preferredSizeSpec.preferred != null) {
                if (d5 > d) {
                    d5 = d;
                } else if (d5 < 0.0) {
                    d5 = 0.0;
                }
                if (d5 < d4) {
                    d5 = d4;
                }
                if (d5 > d3) {
                    d5 = d3;
                }
                LabelCallout.setWedgeRadius(list, d5 / 2.0, this.isWidthPercent);
                this.createLabelCallouts(list, labelProducer, styleSpec, d2, LabelCallout.getWedgeRadius(list));
                LabelCallout.clip(list, this.extent);
                return;
            }
            double d6 = Math.min(this.graphSize.getWidth(), this.graphSize.getHeight()) / 4.0;
            if (d6 < d4 / 2.0) {
                d6 = d4 / 2.0;
            } else if (d6 > d3 / 2.0) {
                d6 = d3 / 2.0;
            }
            LabelCallout.setWedgeRadius(list, d6, this.isWidthPercent);
            this.createLabelCallouts(list, labelProducer, styleSpec, d2, LabelCallout.getWedgeRadius(list));
            bl = this.isLableTruncated(list);
            if (preferredSizeSpec != null && preferredSizeSpec.max != null && !bl) {
                double d7;
                do {
                    d7 = LabelCallout.getWedgeRadius(list) * 0.1;
                    LabelCallout.increaseWedgeSize(list, d7, this.isWidthPercent);
                    if (LabelCallout.getWedgeRadius(list) > d3 / 2.0) {
                        double d8 = LabelCallout.getWedgeRadius(list) - d3 / 2.0;
                        LabelCallout.reduceWedgeSize(list, d8, this.isWidthPercent);
                        this.createLabelCallouts(list, labelProducer, styleSpec, d2, LabelCallout.getWedgeRadius(list));
                        break block22;
                    }
                    this.createLabelCallouts(list, labelProducer, styleSpec, d2, LabelCallout.getWedgeRadius(list));
                } while (!(bl = this.isLableTruncated(list)));
                LabelCallout.reduceWedgeSize(list, d7, this.isWidthPercent);
                this.createLabelCallouts(list, labelProducer, styleSpec, d2, LabelCallout.getWedgeRadius(list));
            } else if (preferredSizeSpec != null && preferredSizeSpec.min != null && bl) {
                do {
                    double d9 = LabelCallout.getWedgeRadius(list) * 0.1;
                    LabelCallout.reduceWedgeSize(list, d9, this.isWidthPercent);
                    if (LabelCallout.getWedgeRadius(list) < d4 / 2.0) {
                        double d10 = d4 / 2.0 - LabelCallout.getWedgeRadius(list);
                        LabelCallout.increaseWedgeSize(list, d10, this.isWidthPercent);
                        this.createLabelCallouts(list, labelProducer, styleSpec, d2, LabelCallout.getWedgeRadius(list));
                        break;
                    }
                    this.createLabelCallouts(list, labelProducer, styleSpec, d2, LabelCallout.getWedgeRadius(list));
                } while (bl = this.isLableTruncated(list));
            }
        }
        LabelCallout.clip(list, this.extent);
    }

    private PreferredSizeSpec getDiameterFromSpec() {
        assert (this.grammar.coordinates != null);
        CoordinateTransform[] coordinateTransformArray = this.grammar.coordinates.getTransforms();
        if (coordinateTransformArray != null) {
            for (CoordinateTransform coordinateTransform : coordinateTransformArray) {
                if (coordinateTransform == null || !coordinateTransform.isPolar()) continue;
                return coordinateTransform.getDiameterSpec();
            }
        }
        return null;
    }

    private boolean getClockwise() {
        assert (this.grammar.coordinates != null);
        CoordinateTransform[] coordinateTransformArray = this.grammar.coordinates.getTransforms();
        if (coordinateTransformArray != null) {
            for (CoordinateTransform coordinateTransform : coordinateTransformArray) {
                if (coordinateTransform == null || !coordinateTransform.isPolar()) continue;
                return coordinateTransform.getClockwise();
            }
        }
        return false;
    }

    protected static boolean isWedgeShape(Shape shape) {
        return 1005 == shape.getType();
    }

    private static double getWedgeRadius(List<ShapeLabelLinesHolder> list) {
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            Shape shape = shapeLabelLinesHolder.getElementShape();
            if (!LabelCallout.isWedgeShape(shape)) continue;
            return ((Wedge)shape.getGeom()).getR2();
        }
        return 0.0;
    }

    private static void setWedgeRadius(List<ShapeLabelLinesHolder> list, double d, boolean bl) {
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            Shape shape = shapeLabelLinesHolder.getElementShape();
            if (!LabelCallout.isWedgeShape(shape)) continue;
            Wedge wedge = (Wedge)shape.getGeom();
            if (wedge.getR1() > 0.0) {
                if (bl) {
                    wedge.setR1(wedge.getR1() * d / wedge.getR2());
                } else {
                    wedge.setR1(d - (wedge.getR2() - wedge.getR1()));
                }
            }
            wedge.setR2(d);
        }
    }

    private static double getFarthestWedgeCenterXCoordinateOnRight(List<ShapeLabelLinesHolder> list) {
        double d = Double.NEGATIVE_INFINITY;
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            Wedge wedge;
            Shape shape = shapeLabelLinesHolder.getElementShape();
            if (!LabelCallout.isWedgeShape(shape) || !((wedge = (Wedge)shape.getGeom()).getOrigin().getX() > d)) continue;
            d = wedge.getOrigin().getX();
        }
        return d;
    }

    private static double getFarthestWedgeCenterXCoordinateOnLeft(List<ShapeLabelLinesHolder> list) {
        double d = Double.POSITIVE_INFINITY;
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            Wedge wedge;
            Shape shape = shapeLabelLinesHolder.getElementShape();
            if (!LabelCallout.isWedgeShape(shape) || !((wedge = (Wedge)shape.getGeom()).getOrigin().getX() < d)) continue;
            d = wedge.getOrigin().getX();
        }
        return d;
    }

    private static void reduceWedgeSize(List<ShapeLabelLinesHolder> list, double d, boolean bl) {
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            Shape shape = shapeLabelLinesHolder.getElementShape();
            if (!LabelCallout.isWedgeShape(shape)) continue;
            Wedge wedge = (Wedge)shape.getGeom();
            if (wedge.getR1() > 0.0) {
                if (bl) {
                    wedge.setR1(wedge.getR1() - wedge.getR1() * d / wedge.getR2());
                } else {
                    wedge.setR1(wedge.getR1() - d);
                }
            }
            wedge.setR2(wedge.getR2() - d);
        }
    }

    private static void increaseWedgeSize(List<ShapeLabelLinesHolder> list, double d, boolean bl) {
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            Shape shape = shapeLabelLinesHolder.getElementShape();
            if (!LabelCallout.isWedgeShape(shape)) continue;
            Wedge wedge = (Wedge)shape.getGeom();
            if (wedge.getR1() > 0.0) {
                if (bl) {
                    wedge.setR1(wedge.getR1() + wedge.getR1() * d / wedge.getR2());
                } else {
                    wedge.setR1(wedge.getR1() + d);
                }
            }
            wedge.setR2(wedge.getR2() + d);
        }
    }

    private void createLabelCallouts(List<ShapeLabelLinesHolder> list, LabelProducer labelProducer, StyleSpec styleSpec, double d, double d2) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        ArrayList<Shape> arrayList2 = new ArrayList<Shape>();
        boolean bl = true;
        double d3 = 0.1;
        double d4 = 0.6;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        while (bl) {
            arrayList.clear();
            arrayList2.clear();
            LabelCallout.clearLabelLines(list);
            d5 = (1.0 + (d3 += 0.1)) * d2;
            d6 = LabelCallout.getFarthestWedgeCenterXCoordinateOnRight(list) + d5;
            d7 = LabelCallout.getFarthestWedgeCenterXCoordinateOnLeft(list) - d5;
            LabelCallout.prepareLabels(list, arrayList, arrayList2, d, d6, d7);
            this.arrangeLabels(arrayList, labelProducer.backgroundStyle);
            this.arrangeLabels(arrayList2, labelProducer.backgroundStyle);
            if (this.isOutOfBounds(arrayList)) {
                this.adjustLabels(arrayList);
            }
            if (this.isOutOfBounds(arrayList2)) {
                this.adjustLabels(arrayList2);
            }
            bl = this.drawLabelLines(list, styleSpec, arrayList, arrayList2, d3, d4);
            if (list.size() != 1) continue;
            bl = false;
        }
        double d8 = this.graphSize.getWidth() - d6;
        this.arrangeLongLabels(list, arrayList, labelProducer, d8);
        d8 = d7;
        this.arrangeLongLabels(list, arrayList2, labelProducer, d8);
    }

    private static void clearLabelLines(List<ShapeLabelLinesHolder> list) {
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            shapeLabelLinesHolder.setLabelLine(null);
        }
    }

    private boolean drawLabelLines(List<ShapeLabelLinesHolder> list, StyleSpec styleSpec, List<Shape> list2, List<Shape> list3, double d, double d2) {
        boolean bl = true;
        double d3 = 0.2;
        double d4 = 0.0;
        boolean bl2 = this.isThreeSegmentsNeeded(list, list2, true);
        boolean bl3 = this.isThreeSegmentsNeeded(list, list3, false);
        if (bl2) {
            this.adjustLabels(list2);
        } else if (bl3) {
            this.adjustLabels(list3);
        }
        if (bl2) {
            bl2 = this.isThreeSegmentsNeeded(list, list2, true);
        } else if (bl3) {
            bl3 = this.isThreeSegmentsNeeded(list, list3, false);
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Shape shape;
            ShapeLabelLinesHolder shapeLabelLinesHolder = list.get(i);
            if (shapeLabelLinesHolder.getShapeLabel() == null || !LabelCallout.isWedgeShape(shape = shapeLabelLinesHolder.getElementShape())) continue;
            Wedge wedge = (Wedge)shape.getGeom();
            if (d4 == 0.0) {
                d4 = (this.graphSize.getHeight() - 2.0 * wedge.getR2()) / 3.0;
            }
            double d5 = wedge.getOrigin().getX() + wedge.getR2() * Math.cos((wedge.getA1() + wedge.getA2()) / 2.0);
            double d6 = wedge.getOrigin().getY() + wedge.getR2() * Math.sin((wedge.getA1() + wedge.getA2()) / 2.0);
            double d7 = wedge.getOrigin().getX() + (wedge.getR2() + wedge.getR2() * 0.1) * Math.cos((wedge.getA1() + wedge.getA2()) / 2.0);
            double d8 = (wedge.getA1() + wedge.getA2()) / 2.0;
            double d9 = d6 + wedge.getR2() * 0.1 * Math.sin(d8);
            Text text = shapeLabelLinesHolder.getShapeLabel();
            double d10 = ((Shape)text).getCenter().getX();
            double d11 = ((Shape)text).getCenter().getY();
            double d12 = 0.0;
            double d13 = d9 -= d4 * Math.sin(Math.PI * 2 - d8);
            double d14 = 0.0;
            double d15 = d11;
            if (list2.contains(text)) {
                d12 = wedge.getOrigin().getX() + (wedge.getR2() + wedge.getR2() * d3);
                while (d12 >= d10) {
                    d12 = wedge.getOrigin().getX() + (wedge.getR2() + wedge.getR2() * (d3 -= 0.1));
                }
                d14 = d10 - wedge.getR2() / 10.0;
            } else {
                d12 = wedge.getOrigin().getX() - (wedge.getR2() + wedge.getR2() * d3);
                while (d12 <= d10) {
                    d12 = wedge.getOrigin().getX() - (wedge.getR2() + wedge.getR2() * (d3 -= 0.1));
                }
                d14 = d10 + wedge.getR2() / 10.0;
            }
            if (i > 0 && list.get(i - 1).getLabelLine() != null) {
                object4 = LabelCallout.getLastLine(list.get(i - 1).getLabelLine());
                object3 = MathUtil.r3(d5);
                object2 = MathUtil.r3(d6);
                object = MathUtil.r3(((Line)object4).getX1());
                Number number = MathUtil.r3(((Line)object4).getY1());
                double d16 = ((Number)object3).doubleValue();
                double d17 = ((Number)object2).doubleValue();
                double d18 = ((Number)object).doubleValue();
                double d19 = number.doubleValue();
                if ((d16 != d18 || d17 != d19) && (bl = Line.segmentsIntersect(d5, d6, d14, d15, ((Line)object4).getX1(), ((Line)object4).getY1(), ((Line)object4).getX2(), ((Line)object4).getY2(), false))) {
                    if (d2 - d >= 0.0) break;
                    bl = false;
                }
            }
            if (Math.abs(d12 - d7) < 15.0) {
                d7 = d12;
                d9 = d13;
            }
            object4 = null;
            object3 = null;
            object2 = new Rect(0.0, 0.0, this.extent.getWidth(), this.extent.getHeight());
            if (list2.contains(text) && !bl2 || list3.contains(text) && !bl3 || !((Rect)object2).containsPt(d7, d9) || !((Rect)object2).containsPt(d12, d13)) {
                object4 = new double[]{d5, d14, d10};
                object3 = new double[]{d6, d15, d11};
            } else {
                object4 = new double[]{d5, d7, d12, d10};
                object3 = new double[]{d6, d9, d13, d11};
            }
            object = new ShapePoly((double[])object4, (double[])object3, false, null);
            ((Shape)object).setSnap(shapeLabelLinesHolder.getElementShape().getSnap());
            if (shape.getKey() != null) {
                ((Shape)object).setKey(shape.getKey() + "|" + "LN");
            }
            boolean bl4 = shapeLabelLinesHolder.getElementShape().isVisible() ? text.isVisible() : false;
            ((Shape)object).setVisible(bl4);
            StyleBuilder.setUnfilled((Shape)object, styleSpec, null);
            shapeLabelLinesHolder.setLabelLine((ShapePoly)object);
        }
        return bl;
    }

    private static Line getLastLine(ShapePoly shapePoly) {
        double[] dArray = shapePoly.getXArray();
        double[] dArray2 = shapePoly.getYArray();
        int n = dArray.length - 1;
        return new Line(dArray[n - 1], dArray2[n - 1], dArray[0], dArray2[0]);
    }

    private boolean isThreeSegmentsNeeded(List<ShapeLabelLinesHolder> list, List<Shape> list2, boolean bl) {
        boolean bl2 = this.getClockwise();
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            Shape shape = shapeLabelLinesHolder.getElementShape();
            if (!(shape.getGeom() instanceof Wedge)) continue;
            Wedge wedge = (Wedge)shape.getGeom();
            Text text = shapeLabelLinesHolder.getShapeLabel();
            if (!list2.contains(text)) continue;
            double d7 = ((Shape)text).getCenter().getY();
            double d8 = ((Shape)text).getCenter().getX();
            double d9 = d7;
            double d10 = 0.0;
            d10 = bl ? d8 - wedge.getR2() / 10.0 : d8 + wedge.getR2() / 10.0;
            double d11 = wedge.getA1() - wedge.getA2();
            double d12 = 0.0;
            d12 = wedge.getA2() + d11 / 2.0;
            if (!bl2) {
                d12 -= Math.PI * 2;
            }
            double d13 = wedge.getOrigin().getX();
            double d14 = wedge.getOrigin().getY();
            double d15 = wedge.getOrigin().getX() + wedge.getR2() * Math.cos((wedge.getA1() + wedge.getA2()) / 2.0);
            double d16 = wedge.getOrigin().getY() + wedge.getR2() * Math.sin((wedge.getA1() + wedge.getA2()) / 2.0);
            if (d15 > d13 && d16 < d14) {
                d12 = Math.PI * 2 - d12;
                d6 = 1.5707963267948966 - d12;
                d5 = wedge.getR2() / Math.sin(d6);
                d4 = d13 + d5;
                d3 = (d16 - d14) / (d15 - d4);
                d2 = d16 - d3 * d15;
                d = (d9 - d2) / d3;
                if (!(d9 > d16) || !(d > d10)) continue;
                return true;
            }
            if (d15 > d13 && d16 > d14) {
                d6 = 1.5707963267948966 - d12;
                d5 = wedge.getR2() / Math.sin(d6);
                d4 = d13 + d5;
                d3 = (d16 - d14) / (d15 - d4);
                d2 = d16 - d3 * d15;
                d = (d9 - d2) / d3;
                if (!(d9 < d16) || !(d > d10)) continue;
                return true;
            }
            if (d15 < d13 && d16 < d14) {
                d12 = Math.PI - d12;
                d6 = 1.5707963267948966 - d12;
                d5 = wedge.getR2() / Math.sin(d6);
                d4 = d13 - d5;
                d3 = (d16 - d14) / (d15 - d4);
                d2 = d16 - d3 * d15;
                d = (d9 - d2) / d3;
                if (!(d9 > d16) || !(d < d10)) continue;
                return true;
            }
            if (!(d15 < d13) || !(d16 > d14)) continue;
            d12 = Math.PI - d12;
            d6 = 1.5707963267948966 - d12;
            d5 = wedge.getR2() / Math.sin(d6);
            d4 = d13 - d5;
            d3 = (d16 - d14) / (d15 - d4);
            d2 = d16 - d3 * d15;
            d = (d9 - d2) / d3;
            if (!(d9 < d16) || !(d < d10)) continue;
            return true;
        }
        return false;
    }

    protected boolean isLableTruncated(List<ShapeLabelLinesHolder> list) {
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            Text text = shapeLabelLinesHolder.getShapeLabel();
            if (text == null) continue;
            Text text2 = text;
            if (1007 == text2.getType()) {
                MultiPartText multiPartText = (MultiPartText)text2;
                List<MultiPartTextLine> list2 = multiPartText.getLines();
                for (MultiPartTextLine multiPartTextLine : list2) {
                    if (!multiPartTextLine.wasClipped) continue;
                    return true;
                }
            } else if (text2.getText().indexOf("\u2026") != -1) {
                return true;
            }
            if (!(text2.getPoint().getX() > this.graphSize.getWidth() || text2.getPoint().getX() < 0.0 || text2.getPoint().getY() > this.graphSize.getHeight()) && !(text2.getPoint().getY() < 0.0)) continue;
            return true;
        }
        return false;
    }

    private static void prepareLabels(List<ShapeLabelLinesHolder> list, List<Shape> list2, List<Shape> list3, double d, double d2, double d3) {
        LabelCallout.divideLabels(list, list2, list3, d, d2, d3);
        LabelCallout.sortLabels(list2);
        LabelCallout.sortLabels(list3);
    }

    private static void divideLabels(List<ShapeLabelLinesHolder> list, List<Shape> list2, List<Shape> list3, double d, double d2, double d3) {
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            if (shapeLabelLinesHolder.getShapeLabel() == null) continue;
            Text text = shapeLabelLinesHolder.getShapeLabel();
            Text text2 = text;
            if (text2.getCenter().getX() > d) {
                text2.align = "start";
                text2.affine(0.0, d2, 1.0, 0.0, false);
                list2.add(text2);
                continue;
            }
            text2.align = "end";
            text2.affine(0.0, d3, 1.0, 0.0, false);
            list3.add(text2);
        }
    }

    private void adjustLabels(List<Shape> list) {
        Shape shape;
        Text text;
        double d = this.graphSize.getHeight() / (double)(list.size() + 1);
        double d2 = 0.0;
        Iterator<Shape> iterator = list.iterator();
        while (iterator.hasNext() && d2 + (text = (Text)(shape = iterator.next())).getBounds().getHeight() < this.graphSize.getHeight()) {
            double d3 = d2 + text.getBounds().getHeight() / 2.0 + d / 2.0;
            shape.affine(1.0, 0.0, 0.0, d3, false);
            if (d > text.getBounds().getHeight()) {
                d2 += d;
                continue;
            }
            d2 += text.getBounds().getHeight() + 2.0;
        }
    }

    private boolean isOutOfBounds(List<Shape> list) {
        for (int i = 0; i < list.size(); ++i) {
            Text text = (Text)list.get(i);
            double d = text.getCenter().getY() + text.getBounds().getHeight() / 2.0;
            double d2 = text.getBounds().getY();
            if (!(d > this.extent.getHeight()) && !(d2 < 0.0)) continue;
            return true;
        }
        return false;
    }

    private static void sortLabels(List<Shape> list) {
        int n = -1;
        boolean bl = false;
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (Shape shape : list) {
            for (Shape shape2 : arrayList) {
                if (!(shape2.getCenter().getY() > shape.getCenter().getY())) continue;
                n = arrayList.indexOf(shape2);
                bl = true;
                break;
            }
            if (!bl) {
                n = arrayList.size();
            }
            arrayList.add(n, shape);
            bl = false;
        }
        list.clear();
        list.addAll(arrayList);
    }

    private void arrangeLabels(List<Shape> list, StyleSpec styleSpec) {
        double d = 0.0;
        if (LabelCallout.isLabelCollision(list)) {
            Shape shape2;
            for (Shape shape2 : list) {
                d += shape2.getBounds().getHeight() / 2.0;
                if (shape2.getCenter().getY() < d) {
                    shape2.affine(1.0, 0.0, 0.0, d, false);
                }
                if (styleSpec == null) {
                    d = shape2.getCenter().getY() + shape2.getBounds().getHeight() / 2.0 + 0.01;
                    continue;
                }
                d = shape2.getCenter().getY() + shape2.getBounds().getHeight() / 2.0 + 2.0 + 0.01;
            }
            Shape shape3 = list.get(0);
            shape2 = list.get(list.size() - 1);
            double d2 = shape2.getCenter().getY() + shape2.getBounds().getHeight() - this.graphSize.getHeight();
            if (d2 > 0.0) {
                if (shape3.getCenter().getY() - shape3.getBounds().getHeight() - d2 < 0.0) {
                    d2 = shape3.getCenter().getY() - shape3.getBounds().getHeight();
                }
                for (Shape shape4 : list) {
                    double d3 = shape4.getCenter().getY() - d2;
                    shape4.affine(1.0, 0.0, 0.0, d3, false);
                }
            }
        }
    }

    private static boolean isLabelCollision(List<Shape> list) {
        boolean bl = false;
        if (list.size() != 0) {
            Shape shape;
            Rect rect;
            for (int i = 0; i < list.size() - 1 && !(bl = (rect = list.get(i).getBounds()).intersectsRect((shape = list.get(i + 1)).getBounds())); ++i) {
            }
        }
        return bl;
    }

    private void arrangeLongLabels(List<ShapeLabelLinesHolder> list, List<Shape> list2, LabelProducer labelProducer, double d) {
        for (int i = 0; i < list2.size(); ++i) {
            int n;
            Text text = (Text)list2.get(i);
            String string = text.getText();
            String string2 = string.trim();
            text.setText(string2);
            double d2 = 0.0;
            if (i > 0) {
                Text text2 = (Text)list2.get(i - 1);
                d2 = text2.getCenter().getY() + text2.getHeight() / 2.0;
            }
            double d3 = 0.0;
            if (i + 1 == list2.size()) {
                d3 = this.graphSize.getHeight();
            } else {
                Text text3 = (Text)list2.get(i + 1);
                d3 = text3.getCenter().getY() - text3.getHeight() / 2.0;
            }
            double d4 = text.getCenter().getY() - text.getHeight() / 2.0;
            double d5 = d4 - d2;
            double d6 = d3 - d4;
            double d7 = text.getHeight() / (double)text.getNumLines();
            double d8 = 0.0;
            d8 = Math.min(d5, d6) > d7 && Math.min(d5, d6) - d7 > 1.0 ? text.getHeight() + 2.0 * Math.min(d5, d6) : text.getHeight();
            Dim dim = new Dim(d, d8);
            Text text4 = ItemBuilder.makeText(TextContent.makeForString(string2, text.getFont().getMinimumSize()), text.getPoint().getX(), text.getPoint().getY(), text.align, text.valign, text.getFont(), labelProducer.style, null, dim, LabelCallout.allowClip(labelProducer.style), "\u2026", labelProducer.shapingInfo, labelProducer.getTooltipsForTruncatedText());
            if (text4 == null) continue;
            text4.setID(text.getID());
            text4.setKey(text.getKey());
            text4.copyInfoFrom(text);
            if (d8 < text.getFont().getHeight() || 1009 == text4.getType() && text4.getText().equals(string2)) {
                text.clipToFit(d);
                n = LabelCallout.findIndexOfShapeLabel(list, text);
                if (n <= -1) continue;
                list.get(n).setShapeLabel(text);
                continue;
            }
            if (text4.getNumLines() == 1 && 1007 == text4.getType() && ((MultiPartText)text4).getLines().get(0).getText().indexOf("\u2026") != -1) {
                text.clipToFit(d);
                n = LabelCallout.findIndexOfShapeLabel(list, text);
                if (n <= -1) continue;
                list.get(n).setShapeLabel(text);
                continue;
            }
            n = LabelCallout.findIndexOfShapeLabel(list, text);
            if (n <= -1) continue;
            list.get(n).setShapeLabel(text4);
        }
    }

    private static int findIndexOfShapeLabel(List<ShapeLabelLinesHolder> list, Text text) {
        if (text == null) {
            return -1;
        }
        int n = 0;
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            if (text.equals(shapeLabelLinesHolder.getShapeLabel())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static boolean allowClip(StyleSpec styleSpec) {
        return styleSpec == null || styleSpec.location == null || !"fit".equals(styleSpec.location) && !"stretch".equals(styleSpec.location);
    }

    private static void clip(List<ShapeLabelLinesHolder> list, Dim dim) {
        for (ShapeLabelLinesHolder shapeLabelLinesHolder : list) {
            Text text = shapeLabelLinesHolder.getShapeLabel();
            if (text == null) continue;
            Text text2 = text;
            Rect rect = new Rect(0.0, 0.0, dim.getWidth(), dim.getHeight());
            if (rect.containsRect(text2.getBounds())) continue;
            shapeLabelLinesHolder.setShapeLabel(null);
            shapeLabelLinesHolder.setLabelLine(null);
        }
    }
}

