/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.Alignment;
import com.ibm.vis.engine.internal.FormatInfo;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.globalization.NumericShapingInfo;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.label.AbstractLabelProducer;
import com.ibm.vis.engine.internal.grammar.label.LabelCallout;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.scale.Axis;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.SpecUtil;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapeNearShape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.ColorSpec;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.StrokeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.HashMap;
import java.util.Map;

public class LabelProducer
extends AbstractLabelProducer {
    protected static final double TEXT_WIDTH_PADDING = 1.1;
    private Map<String, Dim> labelSizeCache;
    public final StyleSpec style;
    public final StyleSpec backgroundStyle;
    public final NumericShapingInfo shapingInfo;
    private Insets padding;
    public final Font font;
    private Aesthetic[] aesthetics;
    public String align;
    public String valign;
    public Object angle;
    private String positioning;
    private String alignEdge;
    private boolean stretch;
    private boolean fit;
    private Rect clipBounds;
    private Rect coordinateBounds;
    public static final int V_BACKGROUND_PADDING = 1;
    public static final int H_BACKGROUND_PADDING = 2;
    public String clipSymbol;
    private Insets backgroundPadding;
    private final boolean labelCollisionActive;

    public static LabelProducer makeForData(Data data, Vis vis, boolean bl, ElementLabelSpec elementLabelSpec, String string, boolean bl2) {
        String string2 = string;
        if (elementLabelSpec.modifies != null) {
            string2 = elementLabelSpec.modifies.part;
        }
        return new LabelProducer(data, vis, string2, bl, null, null, elementLabelSpec.style, elementLabelSpec.backgroundStyle, bl2);
    }

    public static LabelProducer makeSimpleInside(Vis vis, StyleSpec styleSpec, String string, String string2, StyleSpec styleSpec2) {
        return new LabelProducer(null, vis, null, true, string, string2, styleSpec, styleSpec2, false);
    }

    private LabelProducer(Data data, Vis vis, String string, boolean bl, String string2, String string3, StyleSpec styleSpec, StyleSpec styleSpec2, boolean bl2) {
        super(data, vis, string);
        this.style = styleSpec == null ? new StyleSpec() : (StyleSpec)styleSpec.copy();
        this.backgroundStyle = styleSpec2;
        this.shapingInfo = vis.getVisContext().getNumericShapingInfo();
        this.positioning = null;
        this.alignEdge = null;
        this.stretch = false;
        this.fit = false;
        this.labelCollisionActive = bl2;
        if (this.style.location == null) {
            this.positioning = bl ? "inside" : "outside";
        } else if (BasicFactory.isString(this.style.location)) {
            if ("stretch".equals(this.style.location)) {
                this.positioning = "inside";
                this.stretch = true;
            } else if ("fit".equals(this.style.location)) {
                this.positioning = "inside";
                this.fit = true;
            } else if ("inside".equals(this.style.location)) {
                this.positioning = "inside";
            } else if ("outside".equals(this.style.location)) {
                this.positioning = "outside";
                this.alignEdge = this.style.alignEdge;
            } else if ("outward".equals(this.style.location)) {
                this.positioning = "outside";
            } else if ("callout".equals(this.style.location)) {
                this.positioning = "callout";
            } else {
                throw new SpecException("Invalid value -> location : " + this.style.location, ErrorCode.SPEC_INVALID_VALUE, null);
            }
        }
        FontSpec fontSpec = this.style.font;
        this.font = FontHelper.makeFromSpec(fontSpec, this.vis.getVisContext().getMinimumFontSize(), this.vis.getVisContext().usesFractionalMetrics());
        Dim dim = new Dim(this.font.getHeight(), this.font.getHeight());
        this.padding = Insets.makeForStylePadding(this.style.padding, dim, vis.getSize());
        if (this.backgroundStyle != null) {
            this.backgroundPadding = this.backgroundStyle.padding == null ? new Insets(1.0, 2.0, 1.0, 2.0) : Insets.makeForStylePadding(this.backgroundStyle.padding, dim, dim);
            this.padding = Insets.combine(this.padding, this.backgroundPadding);
        }
        this.angle = this.style.angle;
        if ("outward".equals(this.style.location)) {
            this.align = this.style.align == null ? "outward" : this.style.align;
            this.valign = this.style.valign == null ? "outward" : this.style.valign;
        } else {
            this.align = LabelProducer.getAlignString(this.style.align, string2);
            this.valign = LabelProducer.getAlignString(this.style.valign, string3);
        }
        this.clipSymbol = "\u2026";
    }

    public void addAesthetics(Aesthetic[] aestheticArray) {
        this.aesthetics = aestheticArray;
    }

    public Aesthetic[] getAesthetics() {
        return this.aesthetics;
    }

    public Text makeLabelForContent(TextContent textContent, Shape shape) {
        String string;
        String[] stringArray;
        Shape shape2;
        Rect rect;
        double d;
        String string2;
        if (textContent == null || textContent.isEmptyString()) {
            return null;
        }
        Shape[] shapeArray = shape.getParts();
        Shape shape3 = shape;
        if (shapeArray != null) {
            for (int i = 0; i < shapeArray.length; ++i) {
                string2 = shapeArray[i].getElementPart();
                if (string2 == null || !string2.equals(this.part)) continue;
                shape3 = shapeArray[i];
                break;
            }
        }
        d = (d = (rect = this.calculateBoundsForOutsideLabel(shape2 = ShapeNearShape.getLabelShape(shape3, string2 = (stringArray = this.getTextAlignments(shape3))[0], string = stringArray[1], this.positioning, this.style.location), textContent)).getWidth() - this.padding.getHorizontal()) >= 0.0 ? d : 0.0;
        double d2 = rect.getHeight() - this.padding.getVertical();
        Dim dim = new Dim(d, d2 = d2 >= 0.0 ? d2 : 0.0);
        Text text = this.assembleText(shape, shape2, dim, textContent, string2, string);
        if (text != null && this.positioning.equals("outside") && !this.labelCollisionActive) {
            text = this.makeOutsideLabel(text, textContent, shape);
        }
        return text;
    }

    private String[] getTextAlignments(Shape shape) {
        String string;
        Point point = shape.getCenter();
        Point point2 = this.coordinateBounds != null ? this.coordinateBounds.getCenter() : null;
        String string2 = this.align;
        if ("outward".equals(string2)) {
            double d;
            string2 = point2 != null ? ((d = point2.getX() - point.getX()) > 10.0 ? "start" : (d < -10.0 ? "end" : "middle")) : "middle";
        }
        if ("outward".equals(string = this.valign)) {
            double d;
            string = point2 != null ? ((d = point2.getY() - point.getY()) > 10.0 ? "start" : (d < -10.0 ? "end" : "middle")) : "middle";
        }
        return new String[]{string2, string};
    }

    public Text makeLabel(Object[] objectArray, Shape shape) {
        return this.makeLabelForContent(this.makeContentFor(objectArray, shape), shape);
    }

    public Rect calculateBoundsForOutsideLabel(Shape shape, TextContent textContent) {
        Rect rect = shape.getBounds();
        if (textContent == null || textContent.isEmptyString()) {
            return rect;
        }
        if ("outside".equals(this.positioning) || "callout".equals(this.positioning)) {
            rect = rect.copy();
            Dim dim = this.calculateLabelSize(textContent);
            rect.setWidth(dim.getWidth() + this.padding.getHorizontal());
            rect.setHeight(dim.getHeight() + this.padding.getVertical());
        }
        return rect;
    }

    private Text assembleText(Shape shape, Shape shape2, Dim dim, TextContent textContent, String string, String string2) {
        if (textContent == null || textContent.isEmptyString()) {
            return null;
        }
        Text text = "inside".equals(this.positioning) ? this.assembleTextInside(shape, shape2, dim, textContent, string, string2) : (LabelCallout.isWedgeShape(shape) && "callout".equals(this.positioning) ? this.assembleTextWedgeCallout(shape, shape2, dim, textContent, string, string2) : this.assembleTextOutside(shape, shape2, dim, textContent, string, string2));
        return text;
    }

    private Text assembleTextInside(Shape shape, Shape shape2, Dim dim, TextContent textContent, String string, String string2) {
        double d;
        String string3 = string;
        String string4 = string2;
        Rect rect = shape2.getBounds();
        Point point = shape2.getCenter();
        double d2 = "start".equals(string3) ? rect.getX() + this.padding.left : ("end".equals(string3) ? rect.getX2() - this.padding.right : point.getX());
        if ("start".equals(string4)) {
            d = rect.getY() + this.padding.top;
            string4 = "end";
        } else if ("end".equals(string4)) {
            d = rect.getY2() - this.padding.bottom;
            string4 = "start";
        } else {
            d = point.getY();
        }
        return this.assembleTextFinish(shape, dim, textContent, d2, d, string3, string4, false);
    }

    private Text assembleTextWedgeCallout(Shape shape, Shape shape2, Dim dim, TextContent textContent, String string, String string2) {
        double d;
        double d2;
        String string3 = string;
        String string4 = string2;
        Rect rect = shape2.getBounds();
        Point point = shape2.getCenter();
        if ("start".equals(string3)) {
            d2 = rect.getX();
            string3 = "middle";
        } else if ("end".equals(string3)) {
            d2 = rect.getX() + rect.getWidth();
            string3 = "middle";
        } else {
            d2 = point.getX();
        }
        if ("start".equals(string4)) {
            d = rect.getY();
            string4 = "middle";
        } else if ("end".equals(string4)) {
            d = rect.getY() + rect.getHeight();
            string4 = "middle";
        } else {
            d = point.getY();
        }
        return this.assembleTextFinish(shape, dim, textContent, d2, d, string3, string4, true);
    }

    private Text assembleTextOutside(Shape shape, Shape shape2, Dim dim, TextContent textContent, String string, String string2) {
        double d;
        String string3 = string;
        String string4 = string2;
        Rect rect = shape2.getBounds();
        Point point = shape2.getCenter();
        if ("start".equals(string3)) {
            d = "vertical".equals(this.alignEdge) && !"middle".equals(string4) ? rect.getX() + this.padding.left + dim.getWidth() : rect.getX() - this.padding.right;
            string3 = "end";
        } else if ("end".equals(string3)) {
            d = "vertical".equals(this.alignEdge) && !"middle".equals(string4) ? rect.getX() + rect.getWidth() - this.padding.right - dim.getWidth() : rect.getX() + rect.getWidth() + this.padding.left;
            string3 = "start";
        } else {
            d = point.getX();
        }
        double d2 = "start".equals(string4) ? ("horizontal".equals(this.alignEdge) && !"middle".equals(string3) ? rect.getY() + this.padding.top + dim.getHeight() : rect.getY() - this.padding.bottom) : ("end".equals(string4) ? ("horizontal".equals(this.alignEdge) && !"middle".equals(string3) ? rect.getY() + rect.getHeight() - this.padding.bottom - dim.getHeight() : rect.getY() + rect.getHeight() + this.padding.top) : point.getY());
        return this.assembleTextFinish(shape, dim, textContent, d, d2, string3, string4, false);
    }

    private Text assembleTextFinish(Shape shape, Dim dim, TextContent textContent, double d, double d2, String string, String string2, boolean bl) {
        Object object;
        Object object2;
        if ("middleOfFirstLine".equals(string2)) {
            string2 = "middle";
        }
        this.clipSymbol = this.determineClipSymbol(textContent);
        Affine affine = null;
        double d3 = 0.0;
        if (this.angle != null && !bl) {
            d3 = this.getAngle(shape, this.angle);
            affine = Affine.makeRotation(d3, d, d2);
        }
        if ("inside".equals(this.positioning)) {
            object2 = Shape.transformBounds(Rect.makeRectFromDim(dim), affine);
            if (!Axis.isTickLabelHeightReduced()) {
                dim.setHeight(((Rect)object2).getHeight());
            }
            dim.setWidth(((Rect)object2).getWidth());
        }
        if ((object2 = this.buildText(dim, textContent, string, string2, d, d2)) == null) {
            return null;
        }
        if (((Text)object2).wasClipped && this.isClippedNumeric(((Text)object2).getText())) {
            object = textContent.getText();
            TextContent textContent2 = ((Text)object2).reduceToFit(textContent, this.vis.getVisContext());
            if ((object2 = this.buildText(dim, textContent2, string, string2, d, d2)) == null) {
                return null;
            }
            if (!((Text)object2).getText().equals(object)) {
                ((Text)object2).setOriginalText((String)object);
                ((Text)object2).wasClipped = true;
            }
        }
        if (this.aesthetics != null && shape.getRows() != null) {
            for (Aesthetic aesthetic : this.aesthetics) {
                aesthetic.apply((Shape)object2, this.data.rows[shape.getRows()[0]]);
            }
        }
        if (affine != null) {
            if (d3 == 0.0) {
                ((Text)object2).updateTransform(affine);
            } else {
                object = this.getOffsetForLabelAngle((Text)object2, d3, this.positioning, this.align, this.valign, dim);
                ((Text)object2).updateTransform(affine);
                ((Text)object2).updateTransform(Affine.makeIntTransform(((Point)object).getX(), ((Point)object).getY()));
            }
        }
        if (shape.getRows() != null) {
            ((Shape)object2).setRow(shape.getRows()[0]);
        }
        return object2;
    }

    private boolean isClippedNumeric(String string) {
        return string.equals("#") || string.equals("###");
    }

    private Text buildText(Dim dim, TextContent textContent, String string, String string2, double d, double d2) {
        if (textContent == null || textContent.isEmptyString()) {
            return null;
        }
        Text text = ItemBuilder.makeText(textContent, d, d2, string, string2, this.font, this.style, this.backgroundStyle, dim, this.allowClip(), this.clipSymbol, this.shapingInfo, this.vis.getVisContext().getTooltipsForTruncatedText());
        if (text == null) {
            return null;
        }
        if (this.fit) {
            text = text.sizeToFit(dim, this.allowClip());
        } else if (this.stretch) {
            text = text.stretchToFit(dim);
        } else if ("inside".equals(this.positioning)) {
            text = text.fitInside(dim);
        }
        if (text == null) {
            return null;
        }
        return text;
    }

    public Point getOffsetForLabelAngle(Text text, double d, String string, String string2, String string3, Dim dim) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (d != 1.5707963267948966 && d != -1.5707963267948966) {
            return new Point(0.0, 0.0);
        }
        if (d < 0.0) {
            if ("end".equals(string3)) {
                string3 = "start";
            } else if ("start".equals(string3)) {
                string3 = "end";
            }
        }
        if ("outside".equals(string)) {
            if ("start".equals(string2)) {
                d2 = text.getHeight();
            } else if ("end".equals(string2)) {
                d3 -= text.calculateTextWidth();
            } else if ("middle".equals(string2)) {
                d3 -= text.calculateTextWidth() / 2.0;
            }
            if (!"start".equals(string3)) {
                if ("end".equals(string3)) {
                    d3 += text.calculateTextWidth();
                    d2 += text.getHeight();
                } else if ("middle".equals(string3)) {
                    d3 += text.calculateTextWidth() / 2.0;
                    if ("start".equals(string2)) {
                        d2 -= text.getHeight();
                    }
                }
            }
        } else {
            if ("start".equals(string2)) {
                d2 = text.getHeight();
            } else if ("end".equals(string2)) {
                d3 = text.calculateTextWidth();
            } else if ("middle".equals(string2)) {
                d3 = text.calculateTextWidth() / 2.0;
            }
            if (!"start".equals(string3)) {
                if ("end".equals(string3)) {
                    d3 -= text.calculateTextWidth();
                    d2 -= text.getHeight();
                } else if ("middle".equals(string3)) {
                    d2 -= text.getHeight() / 2.0;
                    d3 -= text.calculateTextWidth() / 2.0;
                }
            }
            if (d3 < -dim.getWidth()) {
                d3 = -dim.getWidth();
            }
        }
        if (d < 0.0 && (d3 = -d3) < -dim.getWidth()) {
            d3 = -dim.getWidth();
        }
        return new Point(d2, d3);
    }

    private boolean allowClip() {
        if ("outside".equals(this.positioning) && this.labelCollisionActive) {
            return false;
        }
        return !this.fit && !this.stretch;
    }

    private double getAngle(Shape shape, Object object) {
        if (object == null) {
            return 0.0;
        }
        if (BasicFactory.isNumber(object)) {
            return ((Number)object).doubleValue() * Math.PI / 180.0;
        }
        return shape.getTangentAngle(this.align, this.valign);
    }

    public Text makeRotatedLabel(TextContent textContent, Shape shape) {
        if (textContent == null || textContent.isEmptyString()) {
            return null;
        }
        Text text = this.makeLabelForContent(textContent, ShapeFactory2.CreateRect(shape.getY(), shape.getX(), shape.getHeight(), shape.getWidth()));
        if (text == null) {
            return null;
        }
        text.setSnap(shape.getSnap());
        Affine affine = Affine.makeRotation(-1.5707963267948966, 0.0, 0.0);
        affine = new Affine(affine.m00, affine.m01, affine.m02, affine.m10, affine.m11, MathUtil.r3(shape.getHeight()).doubleValue());
        text.setTransform(affine);
        return text;
    }

    public Text makeSimpleLabel(TextContent textContent, Shape shape) {
        return this.makeLabelForContent(textContent, shape);
    }

    public Text makeSimpleRotatedLabel(TextContent textContent, Shape shape) {
        return this.makeRotatedLabel(textContent, shape);
    }

    private static String getAlignString(String string, String string2) {
        if ("start".equals(string) || "end".equals(string) || "outward".equals(string)) {
            return string;
        }
        if (string2 != null) {
            return string2;
        }
        return "middle";
    }

    public Dim calculateConstrainedLabelSize(TextContent textContent, Dim dim) {
        if (textContent == null || textContent.isEmptyString()) {
            return new Dim(0.0, 0.0);
        }
        Dim dim2 = null;
        String string = this.isCategorical + textContent.getText() + dim.getWidth() + "|" + dim.getHeight();
        if (this.labelSizeCache != null) {
            dim2 = this.labelSizeCache.get(string);
        } else {
            this.labelSizeCache = new HashMap<String, Dim>();
        }
        if (dim2 == null) {
            Text text = ItemBuilder.makeText(textContent, 0.0, 0.0, null, null, this.font, this.style, null, dim, this.allowClip(), this.clipSymbol, this.shapingInfo, this.vis.getVisContext().getTooltipsForTruncatedText());
            if (text != null) {
                dim2 = new Dim(text.calculateTextWidth(), text.getHeight());
                this.labelSizeCache.put(string, dim2);
            } else {
                dim2 = new Dim(0.0, 0.0);
            }
        }
        return dim2;
    }

    public Dim calculateLabelSize(TextContent textContent) {
        return this.calculateConstrainedLabelSize(textContent, new Dim(Double.MAX_VALUE, Double.MAX_VALUE));
    }

    public Shape makeLabelBackground(Shape shape, Shape shape2) {
        if (this.backgroundStyle == null) {
            return null;
        }
        Rect rect = this.getLabelBounds(shape);
        Shape shape3 = ItemBuilder.makeRectangle(rect.getX() - this.backgroundPadding.left, rect.getY() - this.backgroundPadding.top, rect.getWidth() + this.backgroundPadding.left + this.backgroundPadding.right, rect.getHeight() + this.backgroundPadding.top + this.backgroundPadding.bottom, this.backgroundStyle);
        if (shape.getTransform() != null) {
            shape3.setTransform(shape.getTransform());
        }
        shape3 = StyleBuilder.modifyShapeStyle(shape3, this.backgroundStyle);
        if (this.backgroundStyle.fill == null) {
            JSONObject jSONObject = BasicFactory.createJSONObject();
            BasicFactory.put(jSONObject, "a", 0);
            ColorSpec colorSpec = (ColorSpec)SpecUtil.createSpecObject(jSONObject, "ColorSpec");
            this.backgroundStyle.fill = colorSpec;
            StyleBuilder.setFilled(shape3, this.backgroundStyle);
        }
        if (shape2.getRows() != null) {
            shape3.setRow(shape2.getRows()[0]);
        }
        return shape3;
    }

    private Rect getLabelBounds(Shape shape) {
        StyleSpec styleSpec = ((Text)shape).style;
        if (styleSpec != null && styleSpec.angle != null) {
            return ((Text)shape).getNonTransformedBounds();
        }
        Rect rect = shape.getBounds();
        if (shape.getTransform() != null) {
            rect = Shape.transformBounds(rect, shape.getTransform());
        }
        return rect;
    }

    public void adjustPlaqueBounds(Shape shape, Shape shape2) {
        Rect rect = shape.getBounds();
        if (1004 == shape2.getType()) {
            shape2.setX(rect.getX() - this.backgroundPadding.left);
            shape2.setY(rect.getY() - this.backgroundPadding.top);
            shape2.setWidth(rect.getWidth() + this.backgroundPadding.left + this.backgroundPadding.right);
            shape2.setHeight(rect.getHeight() + this.backgroundPadding.top + this.backgroundPadding.bottom);
        } else if (1002 == shape2.getType()) {
            Shape shape3 = ItemBuilder.makeRectangle(rect.getX() - this.backgroundPadding.left, rect.getY() - this.backgroundPadding.top, rect.getWidth() + this.backgroundPadding.left + this.backgroundPadding.right, rect.getHeight() + this.backgroundPadding.top + this.backgroundPadding.bottom, this.backgroundStyle);
            ((Path)shape2).setX(((Path)shape3).getX());
            ((Path)shape2).setY(((Path)shape3).getY());
        }
    }

    public void addPaddingForOutline(StyleSpec styleSpec) {
        Dim dim = new Dim(this.font.getHeight(), this.font.getHeight());
        StrokeSpec strokeSpec = styleSpec.stroke;
        Object object = styleSpec.outline;
        String string = styleSpec.outlineMethod;
        Insets insets = LabelProducer.getOutlinePadding(dim, strokeSpec, object, string);
        this.padding = Insets.combine(this.padding, insets);
    }

    private static Insets getOutlinePadding(Dim dim, StrokeSpec strokeSpec, Object object, String string) {
        Insets insets = Insets.NONE;
        if (strokeSpec != null && strokeSpec.width != null) {
            Double d = UnitConverter.convertLength(strokeSpec.width, dim.getHeight(), dim.getHeight());
            if (d == null) {
                d = 1.0;
            }
            insets = "inside".equals(string) ? new Insets(d, d, d, d) : new Insets(d / 2.0, d / 2.0, d / 2.0, d / 2.0);
        } else if (object != null) {
            insets = new Insets(0.5, 0.5, 0.5, 0.5);
        }
        return insets;
    }

    private Text makeOutsideLabel(Text text, TextContent textContent, Shape shape) {
        Rect rect = text.getBounds();
        if (this.clipBounds != null && !this.clipBounds.containsRect(rect)) {
            Rect rect2 = rect.makeIntersection(this.clipBounds);
            if (rect2 == null) {
                return null;
            }
            Rect rect3 = this.padding.expandRectBy(rect2);
            Shape shape2 = ShapeFactory2.CreateRect(rect3.getX(), rect3.getY(), rect3.getWidth(), rect3.getHeight());
            shape2.copyInfoFrom(shape);
            this.positioning = "inside";
            this.align = Alignment.getReverseAlignment(this.align);
            this.valign = Alignment.getReverseAlignment(this.valign);
            Text text2 = this.makeLabelForContent(textContent, shape2);
            this.positioning = "outside";
            this.align = Alignment.getReverseAlignment(this.align);
            this.valign = Alignment.getReverseAlignment(this.valign);
            return text2;
        }
        return text;
    }

    public final void setBounds(Rect rect, Rect rect2) {
        this.clipBounds = rect;
        this.coordinateBounds = rect2;
    }

    public final String getLocation() {
        return this.positioning;
    }

    public Dim getExtentAdjustedForAlignment(Dim dim) {
        if (dim == null || this.padding == null) {
            return dim;
        }
        double d = dim.getWidth() * 1.1 + this.padding.getHorizontal();
        double d2 = dim.getHeight() + this.padding.getVertical();
        return new Dim(d, d2);
    }

    public boolean getTooltipsForTruncatedText() {
        return this.vis.getVisContext().getTooltipsForTruncatedText();
    }

    public final Insets getPadding() {
        return this.padding;
    }

    public final void setPadding(Insets insets) {
        this.padding = insets;
    }

    protected String determineClipSymbol(TextContent textContent) {
        FormatInfo formatInfo = textContent.getContent().get(0).getFormatInfo();
        if (formatInfo != null && formatInfo.isNumeric() && this.vis.getVisContext().formatContext.hasCustomNumberFormatter()) {
            return "\u2026";
        }
        if (this.isCategorical && (formatInfo == null || !formatInfo.isNumeric()) || formatInfo != null && (formatInfo.getSpecifiedFormatter() != null && !formatInfo.getSpecifiedFormatter().isRAVEFormatterEmpty() || formatInfo.getUnit() != null && !formatInfo.getUnit().name.equals(Unit.RATIO.name))) {
            return "\u2026";
        }
        return "#";
    }
}

