/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.grammar.label.FontMetric;
import com.ibm.vis.engine.internal.grammar.label.FontStats;
import com.ibm.vis.engine.internal.grammar.label.NativeFontStatistics;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.NativeTextMeasure;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.util.MathUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NativeFontMetric
extends FontMetric {
    private final Font font;
    private final boolean cacheEnabled;
    private Map<String, Number> widthCache = null;
    private Map<String, HashMap<Double, Integer>> amountThatFitsCache = null;
    private double ascent = Double.NaN;
    private double height = Double.NaN;
    private static NativeFontStatistics fontStatistics = new NativeFontStatistics();
    private FontStats fontStats;
    private static Map<String, NativeFontMetric> metrics = new ConcurrentHashMap<String, NativeFontMetric>();
    private static boolean useMetricsCache = true;

    public static NativeFontMetric get(Font font) {
        NativeFontMetric nativeFontMetric = null;
        if (useMetricsCache) {
            String string = font.getMetricsId();
            nativeFontMetric = metrics.get(string);
            if (nativeFontMetric == null) {
                nativeFontMetric = new NativeFontMetric(font);
                metrics.put(string, nativeFontMetric);
            }
        } else {
            nativeFontMetric = new NativeFontMetric(font);
        }
        return nativeFontMetric;
    }

    public void setFontStats(FontStats fontStats) {
        this.fontStats = fontStats;
    }

    public FontStats getFontStats() {
        return this.fontStats;
    }

    public NativeFontMetric(Font font) {
        this.cacheEnabled = true;
        this.font = font;
        this.setFontStats(fontStatistics.resolveFontStats(font));
        if (this.cacheEnabled) {
            this.widthCache = new ConcurrentHashMap<String, Number>(16, 0.75f, 1);
            this.amountThatFitsCache = new ConcurrentHashMap<String, HashMap<Double, Integer>>(16, 0.75f, 1);
        }
    }

    int internalGetAmountThatFitsBin(Font font, String string, double d, int n, int n2) {
        double d2;
        double d3;
        block12: {
            block13: {
                int n3;
                block10: {
                    block11: {
                        d3 = this.fontStats.getAvg(font.getSize());
                        d2 = this.getWidth(string.substring(0, n2), font.getSize(), font.getBold());
                        n3 = n - n2;
                        if (!(d >= d2)) break block10;
                        if (n3 == 0) break block11;
                        StringBuilder stringBuilder = new StringBuilder();
                        if (!(d - d2 < this.getWidth(stringBuilder.append("").append(string.charAt(n2)).toString(), font.getSize(), font.getBold()))) break block10;
                    }
                    return n2;
                }
                if (n3 != 0) break block12;
                if (d2 < d) break block13;
                StringBuilder stringBuilder = new StringBuilder();
                if (!(d2 - d < this.getWidth(stringBuilder.append("").append(string.charAt(n2 - 1)).toString(), font.getSize(), font.getBold()))) break block12;
            }
            return d2 <= d ? n2 : n2 - 1;
        }
        if (d2 < d) {
            int n4 = (int)((d - d2) / d3);
            return this.internalGetAmountThatFitsBin(font, string, d, n, n2 + Math.min(Math.max(n4, 1), n - n2));
        }
        if (d2 > d) {
            if (n2 == 1) {
                return 0;
            }
            int n5 = (int)((d2 - d) / d3);
            return this.internalGetAmountThatFitsBin(font, string, d, n2 - 1, Math.max(1, n2 - Math.max(n5, 1)));
        }
        if (d2 == d) {
            return n2;
        }
        return 0;
    }

    public int getAmountThatFitsBin(Font font, String string, double d) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        double d2 = this.getFontStats().getAvg(font.getSize());
        int n = this.internalGetAmountThatFitsBin(font, string, d, string.length(), (int)Math.min((double)string.length(), Math.max(d / d2, 1.0)));
        return n;
    }

    public int getAmountThatFitsGuessLin(Font font, String string, double d) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        double d2 = this.getFontStats().getAvg(font.getSize());
        int n = (int)Math.floor(Math.min(Math.max(d / d2, 1.0), (double)string.length()));
        double d3 = this.getWidth(string.substring(0, n), font.getSize(), font.getBold());
        if (d3 == d) {
            return n;
        }
        if (d3 < d) {
            for (int i = n; i <= string.length(); ++i) {
                d3 = this.getWidth(string.substring(0, i), font.getSize(), font.getBold());
                if (!(d3 > d)) continue;
                return Math.max(i - 1, 0);
            }
            return string.length();
        }
        for (int i = n; i > 0; --i) {
            d3 = this.getWidth(string.substring(0, i), font.getSize(), font.getBold());
            if (!(d3 <= d)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int getAmountThatFits(String string, double d, boolean bl, double d2) {
        double d3 = d2;
        if (string == null || this.font == null || d3 <= 0.0 || string.length() == 0) {
            return 0;
        }
        d3 = MathUtil.r3(d3).doubleValue();
        Integer n = null;
        HashMap<Double, Integer> hashMap = null;
        if (this.cacheEnabled) {
            hashMap = this.amountThatFitsCache.get(string);
            if (hashMap != null) {
                n = hashMap.get(d3);
            } else {
                hashMap = new HashMap();
                this.amountThatFitsCache.put(string, hashMap);
            }
        }
        if (n == null) {
            n = this._getAmountThatFits(this.font, string, d3);
            if (this.cacheEnabled) {
                hashMap.put(d3, n);
            }
        }
        return n;
    }

    private Integer _getAmountThatFits(Font font, String string, double d) {
        int n = 0;
        int n2 = string.length();
        n = n2 < 16 ? this.getAmountThatFitsGuessLin(font, string, d) : this.getAmountThatFitsBin(font, string, d);
        return n;
    }

    @Override
    public double getAscent(double d) {
        if (Double.isNaN(this.ascent)) {
            this.ascent = NativeTextMeasure.getAscent(this.font);
        }
        return this.ascent;
    }

    @Override
    public double getHeight(double d) {
        if (Double.isNaN(this.height)) {
            this.height = NativeTextMeasure.getHeight(this.font);
        }
        return this.height;
    }

    @Override
    public double getWidth(String string, double d, boolean bl) {
        Number number;
        double d2 = 0.0;
        Number number2 = number = this.cacheEnabled ? (Number)this.widthCache.get(string) : (Number)null;
        if (number == null) {
            d2 = NativeTextMeasure.getWidth(this.font, string);
            number = MathUtil.r3(d2);
            if (this.cacheEnabled) {
                this.widthCache.put(string, number);
            }
        }
        d2 = number.doubleValue();
        return d2;
    }

    @Override
    public String getActualFamily() {
        return this.font.getFamily();
    }
}

