/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.grammar.label.FontStats;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NativeFontStatistics {
    private static final double DEFAULT_FONT_SIZE = 12.0;
    private static final String DEFAULT_FONT = "default";
    private static Map<String, FontStats> fontStats = new ConcurrentHashMap<String, FontStats>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeFontStatistics() {
        Map<String, FontStats> map = fontStats;
        synchronized (map) {
            if (fontStats.isEmpty()) {
                fontStats.put(DEFAULT_FONT, new FontStats(8.0, 1.12));
                fontStats.put("Courier", new FontStats(7.0, 1.12));
            }
        }
    }

    public String toString() {
        return "NativeFontStatistics [" + fontStats + "]";
    }

    private String genKey(Font font) {
        String string = font.getFamily().toLowerCase();
        if (string.indexOf(",") > 0) {
            string = string.substring(0, string.indexOf(",") - 1);
        }
        return string + "," + font.getBold();
    }

    public FontStats resolveFontStats(Font font) {
        String string = this.genKey(font);
        FontStats fontStats = NativeFontStatistics.fontStats.get(string);
        if (fontStats == null) {
            fontStats = new FontStats(NativeFontStatistics.fontStats.get(DEFAULT_FONT).getAvg(12.0), 1.0);
            NativeFontStatistics.fontStats.put(string, fontStats);
        }
        return fontStats;
    }
}

