/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.json.java.JSONArray;
import com.ibm.vis.engine.internal.grammar.label.FontMetric;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.ResourceUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import java.io.IOException;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PrecomputedFontMetric
extends FontMetric {
    private static HashMap<String, PrecomputedFontMetric> metrics;
    private static PrecomputedFontMetric arial;
    private double width;
    private final double height;
    private final double ascent;
    private final double boldFactor;
    private final JSONArray pages;
    private final String actualFamily;
    private boolean initialized = false;
    public static final int PAGE_NOT_AVAILABLE = 0;
    public static final int PAGE_DEFAULT_WIDTH = 1;
    public static final int NOT_AVAILABLE = 0;
    public static final int DEFAULT_WIDTH = 1;
    public static final int WIDTH_ZERO = 2;

    public static PrecomputedFontMetric get(String string) {
        if (metrics == null) {
            metrics = PrecomputedFontMetric.makeMetrics();
            arial = metrics.get("arial");
        }
        string = string == null ? "serif" : string.toLowerCase();
        String[] stringArray = string.split(",");
        PrecomputedFontMetric precomputedFontMetric = null;
        for (int i = 0; precomputedFontMetric == null && i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            string2 = string2.replace("'", "");
            string2 = string2.replace("\"", "");
            precomputedFontMetric = metrics.get(string2);
        }
        if (precomputedFontMetric != null) {
            super.initialize();
        }
        return precomputedFontMetric;
    }

    public void setClassWidth(double d) {
        this.width = d;
    }

    private void expandRuns(JSONArray jSONArray) {
        for (int i = 0; i < BasicFactory.size(jSONArray); ++i) {
            Object object = BasicFactory.getArrayItem(jSONArray, i);
            if (!BasicFactory.isArray(object)) continue;
            JSONArray jSONArray2 = (JSONArray)object;
            for (int j = BasicFactory.size(jSONArray2) - 1; j > 0; --j) {
                int n;
                Object object2 = BasicFactory.getArrayItem(jSONArray2, j);
                if (BasicFactory.isArray(object2)) {
                    n = (int)((Number)BasicFactory.getArrayItem((JSONArray)object2, 0)).doubleValue() + 3;
                    int n2 = 1;
                    if (BasicFactory.size((JSONArray)object2) == 2) {
                        n2 = (int)((Number)BasicFactory.getArrayItem((JSONArray)object2, 1)).doubleValue();
                    }
                    while (n-- > 1) {
                        BasicFactory.addAt(jSONArray2, n2, j + 1);
                    }
                    BasicFactory.setAt(jSONArray2, n2, j);
                    continue;
                }
                n = (int)((Number)object2).doubleValue();
                if (n >= 0) continue;
                while (n++ < 0) {
                    BasicFactory.addAt(jSONArray2, 0, j + 1);
                }
                BasicFactory.setAt(jSONArray2, 0, j);
            }
        }
    }

    private static HashMap<String, PrecomputedFontMetric> makeMetrics() {
        HashMap<String, PrecomputedFontMetric> hashMap = new HashMap<String, PrecomputedFontMetric>();
        JSONArray jSONArray = null;
        try {
            jSONArray = ResourceUtil.getFontMetricsArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (Object e : jSONArray) {
            int n = (int)Math.round(((Number)BasicFactory.getItem(e, "w")).doubleValue());
            int n2 = (int)Math.round(((Number)BasicFactory.getItem(e, "h")).doubleValue());
            int n3 = (int)Math.round(((Number)BasicFactory.getItem(e, "a")).doubleValue());
            int n4 = (int)Math.round(((Number)BasicFactory.getItem(e, "b")).doubleValue());
            JSONArray jSONArray2 = (JSONArray)BasicFactory.getItem(e, "c");
            String string = (String)BasicFactory.getItem(e, "n");
            for (String string2 : string.split(",")) {
                PrecomputedFontMetric precomputedFontMetric = new PrecomputedFontMetric(n, n2, n3, n4, jSONArray2, string2);
                hashMap.put(string2, precomputedFontMetric);
            }
        }
        return hashMap;
    }

    private PrecomputedFontMetric(int n, int n2, int n3, int n4, JSONArray jSONArray, String string) {
        this.pages = jSONArray;
        this.width = (double)n / 100.0;
        this.height = (double)n2 / 100.0;
        this.ascent = (double)n3 / 100.0;
        this.boldFactor = (double)n4 / 100.0;
        this.actualFamily = string;
    }

    private synchronized void initialize() {
        if (!this.initialized) {
            this.expandRuns(this.pages);
            this.initialized = true;
        }
    }

    @Override
    public String getActualFamily() {
        return this.actualFamily;
    }

    @Override
    public int getAmountThatFits(String string, double d, boolean bl, double d2) {
        d2 /= d;
        if (bl) {
            d2 /= this.boldFactor;
        }
        double d3 = 0.0;
        for (int i = 0; i < string.length(); ++i) {
            if (!((d3 += this.getCharWidth(BasicFactory.charCodeAt(string, i))) > d2)) continue;
            return i;
        }
        return string.length();
    }

    @Override
    public double getAscent(double d) {
        return this.ascent * d;
    }

    @Override
    public double getHeight(double d) {
        return this.height * d;
    }

    @Override
    public double getWidth(String string, double d, boolean bl) {
        double d2 = 0.0;
        for (int i = 0; i < string.length(); ++i) {
            d2 += this.getCharWidth(BasicFactory.charCodeAt(string, i));
        }
        return bl ? d2 * this.boldFactor * d : d2 * d;
    }

    private double charWidthFallback(int n) {
        if (this != arial) {
            arial.initialize();
            return arial.getCharWidth(n);
        }
        return this.width;
    }

    private int getUnicodePageFor(int n) {
        return n >> 8;
    }

    private int getUnicodeIndexInPageFor(int n) {
        return n % 256;
    }

    public boolean hasCode(int n) {
        int n2 = this.getUnicodePageFor(n);
        if (BasicFactory.size(this.pages) <= n2) {
            return false;
        }
        Object object = BasicFactory.getArrayItem(this.pages, n2);
        if (!BasicFactory.isArray(object)) {
            int n3 = (int)((Number)object).doubleValue();
            return n3 != 0;
        }
        int n4 = this.getUnicodeIndexInPageFor(n);
        JSONArray jSONArray = (JSONArray)object;
        int n5 = 0;
        if (n4 < BasicFactory.size(jSONArray) - 1) {
            n5 = (int)((Number)BasicFactory.getArrayItem(jSONArray, n4 + 1)).doubleValue();
        }
        if (n5 == 1 && (n5 = (int)((Number)BasicFactory.getArrayItem(jSONArray, 0)).doubleValue()) == 1) {
            return true;
        }
        return n5 != 0;
    }

    protected double getCharWidth(int n) {
        if (n > 32 && !this.hasCode(n) && this.width == 0.0) {
            String string = "font " + this.getActualFamily() + " does not support the char " + n;
            throw new EngineException(string, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        int n2 = this.getUnicodePageFor(n);
        if (BasicFactory.size(this.pages) <= n2) {
            return this.charWidthFallback(n);
        }
        Object object = BasicFactory.getArrayItem(this.pages, n2);
        if (!BasicFactory.isArray(object)) {
            int n3 = (int)((Number)object).doubleValue();
            if (n3 == 0) {
                return this.charWidthFallback(n);
            }
            if (n3 == 1) {
                return this.width;
            }
            return (double)(n3 - 2) / 100.0;
        }
        int n4 = this.getUnicodeIndexInPageFor(n);
        JSONArray jSONArray = (JSONArray)object;
        int n5 = 0;
        if (n4 < BasicFactory.size(jSONArray) - 1) {
            n5 = (int)((Number)BasicFactory.getArrayItem(jSONArray, n4 + 1)).doubleValue();
        }
        if (n5 == 1 && (n5 = (int)((Number)BasicFactory.getArrayItem(jSONArray, 0)).doubleValue()) == 1) {
            return this.width;
        }
        if (n5 == 0) {
            return this.charWidthFallback(n);
        }
        return (double)(n5 - 2) / 100.0;
    }
}

