/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.grammar.label.CollisionItem;
import java.util.ArrayList;
import java.util.List;

class Stress {
    private static final double EPSILON = 0.001;
    static final Stress MAXIMALLY_BAD = new Stress(Double.MAX_VALUE);
    private double labelStress;
    private double labelCalloutStress;
    private double calloutStress;
    private double fixedShapeStress;
    private double distanceStress;
    private List<CollisionItem> collisionLabels;

    Stress(double d) {
        this.labelStress = d;
        this.labelCalloutStress = 0.0;
        this.calloutStress = 0.0;
        this.distanceStress = 0.0;
        this.collisionLabels = new ArrayList<CollisionItem>();
    }

    final List<CollisionItem> getCollisionLabels() {
        return this.collisionLabels;
    }

    final void addCollisionLabel(CollisionItem collisionItem) {
        this.collisionLabels.add(collisionItem);
    }

    final double getIntersectionStress() {
        return this.labelStress + this.labelCalloutStress + this.calloutStress + this.fixedShapeStress;
    }

    final void addToLabelStress(double d) {
        this.labelStress += d;
    }

    final void addToLabelCalloutStress(double d) {
        this.labelCalloutStress += d;
    }

    final void addToFixedShapeStress(double d) {
        this.fixedShapeStress += d;
    }

    final void addToCalloutStress(double d) {
        this.calloutStress += d;
    }

    final double getCombinedStress() {
        return this.distanceStress + this.getIntersectionStress();
    }

    boolean betterThan(Stress stress) {
        if (this.getIntersectionStress() + 0.001 < stress.getIntersectionStress()) {
            return true;
        }
        return !(stress.getIntersectionStress() + 0.001 < this.getIntersectionStress()) && this.getCombinedStress() + 0.001 < stress.getCombinedStress();
    }
}

