/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.grammar.label.TextContentPart;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TextContent {
    private ArrayList<TextContentPart> content;
    private boolean containsImage = false;
    private boolean alphabetic = false;
    private final Double minimumFontSize;
    private boolean bIsMultiLine = false;

    public TextContent(Double d) {
        this.minimumFontSize = d;
    }

    public TextContent clone() {
        TextContent textContent = new TextContent(this.minimumFontSize);
        textContent.bIsMultiLine = this.bIsMultiLine;
        textContent.alphabetic = this.alphabetic;
        textContent.containsImage = this.containsImage;
        if (this.content != null) {
            textContent.content = new ArrayList();
            for (TextContentPart textContentPart : this.content) {
                textContent.content.add(textContentPart.clone());
            }
        }
        return textContent;
    }

    public ArrayList<TextContentPart> getContent() {
        return this.content;
    }

    public String getText() {
        if (this.content != null) {
            String string = "";
            for (TextContentPart textContentPart : this.content) {
                Object object = textContentPart.getValue();
                if (object == null || this.containsImage && !BasicFactory.isString(object)) continue;
                string = string + (String)object;
            }
            return string;
        }
        return null;
    }

    public List<Shape> getShapes() {
        if (this.content == null) {
            return null;
        }
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (TextContentPart textContentPart : this.content) {
            Object object = textContentPart.getValue();
            if (!(object instanceof Shape)) continue;
            arrayList.add((Shape)object);
        }
        return arrayList;
    }

    public void addPart(TextContentPart textContentPart) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        if (textContentPart.isString() && !this.bIsMultiLine) {
            this.bIsMultiLine = ((String)textContentPart.getValue()).indexOf("\n") != -1;
        }
        this.content.add(textContentPart);
    }

    public boolean isMultiLine() {
        return this.bIsMultiLine;
    }

    public int size() {
        if (this.content != null) {
            return this.content.size();
        }
        return 0;
    }

    public void addShape(Shape shape) {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        this.containsImage = true;
        TextContentPart textContentPart = new TextContentPart(shape, null, this.minimumFontSize);
        this.addPart(textContentPart);
    }

    public void addString(String string, StyleSpec styleSpec) {
        if (string != null) {
            if (this.content == null) {
                this.content = new ArrayList();
            }
            TextContentPart textContentPart = new TextContentPart(string, styleSpec, this.minimumFontSize);
            this.addPart(textContentPart);
        }
    }

    public void addTextContentPart(TextContentPart textContentPart) {
        if (textContentPart != null) {
            if (this.content == null) {
                this.content = new ArrayList();
            }
            this.addPart(textContentPart);
        }
    }

    public boolean hasMultipleContentParts() {
        return this.content.size() > 1;
    }

    public void addNumber(Number number, StyleSpec styleSpec) {
        if (number != null) {
            if (this.content == null) {
                this.content = new ArrayList();
            }
            TextContentPart textContentPart = null;
            textContentPart = BasicFactory.isInteger(number) ? new TextContentPart("" + number.intValue(), styleSpec, this.minimumFontSize) : new TextContentPart("" + number.doubleValue(), styleSpec, this.minimumFontSize);
            this.addPart(textContentPart);
        }
    }

    public void removeTransform() {
        if (this.content == null) {
            return;
        }
        for (TextContentPart textContentPart : this.content) {
            Object object = textContentPart.getValue();
            if (!(object instanceof Shape)) continue;
            ((Shape)object).setTransform(null);
        }
    }

    public void clearContent() {
        this.content.clear();
        this.bIsMultiLine = false;
    }

    public boolean hasImages() {
        return this.containsImage;
    }

    public boolean hasPartStyles() {
        if (this.content == null) {
            return false;
        }
        for (TextContentPart textContentPart : this.content) {
            if (textContentPart.getStyle() == null) continue;
            return true;
        }
        return false;
    }

    public static TextContent makeForString(String string, Double d) {
        TextContent textContent = new TextContent(d);
        textContent.addString(string, null);
        return textContent;
    }

    public boolean isEmptyString() {
        for (TextContentPart textContentPart : this.content) {
            if (textContentPart.getValue() instanceof String) {
                if (((String)textContentPart.getValue()).length() == 0) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isAlphabetic() {
        return this.alphabetic;
    }

    public void setAlphabetic(boolean bl) {
        this.alphabetic = bl;
    }
}

