/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.FormatInfo;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.LocaleUtil;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TextContentPart {
    private Object value;
    private Font font;
    private final StyleSpec style;
    private FormatInfo formatInfo;
    private Shape sourceShape;

    public TextContentPart(Object object, StyleSpec styleSpec, Double d) {
        this.value = object;
        this.style = styleSpec;
        if (styleSpec != null) {
            this.font = FontHelper.makeFromSpecDeprecated(styleSpec.font, d);
        }
    }

    public TextContentPart clone() {
        TextContentPart textContentPart = new TextContentPart(this.value, this.style != null ? (StyleSpec)this.style.copy() : null, this.font != null ? this.font.getMinimumSize() : null);
        if (this.formatInfo != null) {
            textContentPart.setFormatInfo(this.formatInfo.clone());
        }
        return textContentPart;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public StyleSpec getStyle() {
        return this.style;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public final FormatInfo getFormatInfo() {
        return this.formatInfo;
    }

    public final void setFormatInfo(FormatInfo formatInfo) {
        this.formatInfo = formatInfo;
    }

    public Shape getSourceShape() {
        return this.sourceShape;
    }

    public void setSourceShape(Shape shape) {
        this.sourceShape = shape;
    }

    public boolean reduceToFit(VisContext visContext) {
        if (this.formatInfo != null && Unit.isTime(this.formatInfo.getUnit())) {
            return false;
        }
        if (this.formatInfo != null && this.formatInfo.isNumeric() && visContext.formatContext.hasCustomNumberFormatter()) {
            return this.reduceStringToFit((String)this.value, false, visContext);
        }
        if (this.formatInfo != null) {
            RAVEFormatter rAVEFormatter = this.formatInfo.getSpecifiedFormatter();
            String string = rAVEFormatter.getFitMethod();
            if (string == null || "reducePrecision".equals(string)) {
                Object object = this.formatInfo.getDataValue();
                if (object instanceof String) {
                    if (this.formatInfo.isNumeric() && !visContext.formatContext.hasCustomNumberFormatter()) {
                        return this.reduceExponentialToFit((String)object, false, visContext);
                    }
                    return this.reduceStringToFit((String)object, true, visContext);
                }
                if (!this.formatInfo.isNumeric() && visContext.formatContext != null && !visContext.formatContext.hasCustomNumberFormatter()) {
                    return this.reduceStringToFit((String)this.value, false, visContext);
                }
                String string2 = visContext.formatContext.formatToExponential((Number)object, this.formatInfo.getRange().getMin(), this.formatInfo.getRange().getMax(), this.formatInfo.getSpecifiedFormatter());
                return this.reduceExponentialToFit(string2, true, visContext);
            }
            return false;
        }
        return this.reduceStringToFit((String)this.value, false, visContext);
    }

    private boolean reduceStringToFit(String string, boolean bl, VisContext visContext) {
        String string2 = "";
        if (!string.contains("\u2026")) {
            if (string.length() <= 3) {
                return false;
            }
            string2 = string.substring(0, string.length() - 3);
            string2 = string2 + "\u2026";
            if (bl) {
                this.value = visContext.formatContext.formatString(string2, this.formatInfo.getSpecifiedFormatter(), this.formatInfo.getRowIx(), this.formatInfo.getId());
                this.formatInfo.setDataValue(string2);
            } else {
                this.value = string2;
            }
            return true;
        }
        String[] stringArray = string.split("\u2026");
        String string3 = stringArray[0];
        if (string3.length() > 2) {
            string2 = string3.substring(0, string3.length() - 1) + "\u2026";
            if (bl) {
                this.value = visContext.formatContext.formatString(string2, this.formatInfo.getSpecifiedFormatter(), this.formatInfo.getRowIx(), this.formatInfo.getId());
                this.formatInfo.setDataValue(string2);
            } else {
                this.value = string2;
            }
            return true;
        }
        return false;
    }

    protected boolean reduceExponentialToFit(String string, boolean bl, VisContext visContext) {
        String string2 = LocaleUtil.getExponentSeparator(visContext.getLocale());
        String string3 = TextContentPart.getNumberPart(string, string2, true);
        String string4 = TextContentPart.getNumberPart(string, string2, false);
        if (TextContentPart.canReduce(string3)) {
            String string5 = string3.substring(0, string3.length() - 1);
            string5 = string5 + string2 + string4;
            this.formatInfo.setDataValue(string5);
            this.value = visContext.formatContext.formatString(string5, this.formatInfo.getSpecifiedFormatter(), this.formatInfo.getRowIx(), this.formatInfo.getId());
            return true;
        }
        if (bl) {
            this.formatInfo.setDataValue(string);
            this.value = visContext.formatContext.formatString(string, this.formatInfo.getSpecifiedFormatter(), this.formatInfo.getRowIx(), this.formatInfo.getId());
            return true;
        }
        return false;
    }

    private static String getNumberPart(String string, String string2, boolean bl) {
        String string3 = bl ? string : "";
        int n = string.indexOf(string2);
        if (n >= 0) {
            string3 = bl ? string.substring(0, n) : string.substring(n += string2.length(), string.length());
        }
        return string3;
    }

    private static boolean canReduce(String string) {
        return string.startsWith("-") ? string.length() > 2 : string.length() > 1;
    }

    public boolean isString() {
        return this.value instanceof String;
    }
}

