/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.FormatInfo;
import com.ibm.vis.engine.internal.ImageStyle;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.label.TextContentPart;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.MappedJSONObject;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.ArgumentSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.ImageSpec;
import com.ibm.vis.spec.internal.StringValueSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TextProducer {
    public static final String REF_METHOD_AUTO = "auto";
    public static final String REF_METHOD_DATA = "data";
    public static final String REF_METHOD_RAWDATA = "rawdata";
    public static final String REF_METHOD_LABEL = "label";
    public static final String REF_METHOD_ID = "id";
    public static final String REF_METHOD_ROW = "row";
    public static final String REF_METHOD_COUNT = "count";
    public static final String REF_METHOD_COL = "col";
    public static final String REF_METHOD_IMAGE = "image";

    public static Object[] updateEmptyFieldMethodToLabel(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (!BasicFactory.isString(object) && !BasicFactory.isNumber(object)) {
                if (object instanceof FieldValueRefSpec) {
                    FieldValueRefSpec fieldValueRefSpec = (FieldValueRefSpec)object;
                    if (fieldValueRefSpec.method == null) {
                        fieldValueRefSpec.method = REF_METHOD_LABEL;
                    }
                    arrayList.add(fieldValueRefSpec);
                    continue;
                }
                arrayList.add(object);
                continue;
            }
            arrayList.add(object);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public static TextContent makeTextContent(VisInterface visInterface, Data data, Object[] objectArray, int n) {
        return TextProducer.makeTextContentWithContext(visInterface, data, objectArray, n, null);
    }

    public static TextContent makeTextContentWithContext(VisInterface visInterface, Data data, Object[] objectArray, int n, HashMap<String, Object> hashMap) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        TextContent textContent = new TextContent(visInterface.getVisContext().getMinimumFontSize());
        for (Object object : objectArray) {
            String string;
            MappedJSONObject mappedJSONObject;
            if (object == null) continue;
            if (BasicFactory.isNumber(object)) {
                textContent.addNumber((Number)object, null);
                continue;
            }
            if (BasicFactory.isString(object)) {
                textContent.addString((String)object, null);
                continue;
            }
            if (object instanceof FieldValueRefSpec) {
                TextProducer.addFieldReference(visInterface, data, n, (FieldValueRefSpec)object, textContent);
                continue;
            }
            if (hashMap != null && object instanceof ArgumentSpec) {
                mappedJSONObject = (ArgumentSpec)object;
                string = (String)hashMap.get(mappedJSONObject.args);
                FormatInfo formatInfo = (FormatInfo)hashMap.get("format_info");
                if (string == null) continue;
                TextContentPart textContentPart = new TextContentPart(string, mappedJSONObject.style, visInterface.getVisContext().getMinimumFontSize());
                textContentPart.setFormatInfo(formatInfo);
                textContent.addTextContentPart(textContentPart);
                continue;
            }
            if (object instanceof ImageSpec) {
                mappedJSONObject = new ImageSpec();
                ((ImageSpec)mappedJSONObject).source = ((ImageSpec)object).source;
                if (TextProducer.addImage((ImageSpec)mappedJSONObject, textContent)) continue;
                return null;
            }
            if (!(object instanceof StringValueSpec)) continue;
            mappedJSONObject = (StringValueSpec)object;
            if (((StringValueSpec)mappedJSONObject).value == null) {
                string = "Value must be provided when defining string content with style.";
                throw new SpecException(string, ErrorCode.SPEC_INVALID_PARAMETERS, null);
            }
            textContent.addString(((StringValueSpec)mappedJSONObject).value, ((StringValueSpec)mappedJSONObject).style);
        }
        return textContent.size() > 0 ? textContent : null;
    }

    private static boolean addImage(ImageSpec imageSpec, TextContent textContent) {
        if (imageSpec != null) {
            ImageStyle imageStyle = new ImageStyle(imageSpec);
            imageStyle.setImageInText();
            Shape shape = ItemBuilder.makeRectangle(0.0, 0.0, imageStyle.getWidth(), imageStyle.getHeight(), null);
            shape.setOutline(null);
            shape.setImage(imageStyle);
            textContent.addShape(shape);
            return true;
        }
        return false;
    }

    private static boolean addFieldReference(VisInterface visInterface, Data data, int n, FieldValueRefSpec fieldValueRefSpec, TextContent textContent) {
        String string = null;
        FormatInfo formatInfo = null;
        Field field = (Field)visInterface.getByID(fieldValueRefSpec.$ref);
        if (field == null) {
            return false;
        }
        Data data2 = data != null ? data : field.data;
        String string2 = fieldValueRefSpec.method != null ? fieldValueRefSpec.method : REF_METHOD_AUTO;
        StyleSpec styleSpec = fieldValueRefSpec.style;
        if (REF_METHOD_AUTO.equals(string2)) {
            string2 = data2 == null || n != -1 ? REF_METHOD_DATA : REF_METHOD_LABEL;
        }
        if (REF_METHOD_DATA.equals(string2)) {
            if (data2 == null || data2.rows == null || data2.rows.length == 0 || n == -1) {
                return false;
            }
            string = field.getFormattedStringValue(data2.rows[n].data[field.getIndex()], data2.rows[n].index, fieldValueRefSpec.format);
            formatInfo = field.getFormatInfo(data2.rows[n].data[field.getIndex()], data2.rows[n].index, fieldValueRefSpec.format);
        } else if (REF_METHOD_RAWDATA.equals(string2)) {
            if (data2 == null || n == -1) {
                return false;
            }
            string = String.valueOf((int)data2.rows[n].data[field.getIndex()]);
        } else if (REF_METHOD_LABEL.equals(string2)) {
            string = field.label != null ? field.label : field.id;
            textContent.setAlphabetic(true);
        } else if (REF_METHOD_ID.equals(string2)) {
            string = field.id;
            textContent.setAlphabetic(true);
        } else if (REF_METHOD_ROW.equals(string2)) {
            if (n != -1) {
                string = "" + (n + 1);
            }
        } else if (REF_METHOD_COUNT.equals(string2)) {
            if (data2 != null) {
                string = "" + data2.rows.length;
            }
        } else if (REF_METHOD_COL.equals(string2)) {
            string = "" + field.getIndex();
        } else if (REF_METHOD_IMAGE.equals(string2)) {
            String string3;
            double d;
            if (field.categories == null) {
                String string4 = "'method:image' can only be used with categorical fields.";
                throw new SpecException(string4, ErrorCode.SPEC_INVALID_PARAMETERS, null);
            }
            if (styleSpec != null) {
                String string5 = "Style is not supported when 'method:image' is used in field reference.";
                throw new SpecException(string5, ErrorCode.SPEC_INVALID_PARAMETERS, null);
            }
            if (n != -1 && data2 != null && !Double.isNaN(d = data2.rows[n].data[field.getIndex()]) && (int)d >= 0 && (int)d < field.categories.length && (string3 = field.categories[(int)d]) != null) {
                ImageSpec imageSpec = new ImageSpec();
                imageSpec.source = visInterface.getResourceDefinition(string3);
                return TextProducer.addImage(imageSpec, textContent);
            }
        }
        if (string != null) {
            TextContentPart textContentPart = new TextContentPart(string, styleSpec, visInterface.getVisContext().getMinimumFontSize());
            textContentPart.setFormatInfo(formatInfo);
            textContent.addTextContentPart(textContentPart);
            return true;
        }
        return false;
    }

    public static boolean isContentCategorical(VisInterface visInterface, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            if (object instanceof FieldValueRefSpec) {
                FieldValueRefSpec fieldValueRefSpec = (FieldValueRefSpec)object;
                Field field = (Field)visInterface.getByID(fieldValueRefSpec.$ref);
                if (field == null || !field.isCategorical()) continue;
                return true;
            }
            if (!BasicFactory.isString(object)) continue;
            return true;
        }
        return false;
    }
}

