/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.globalization.NumericShaper;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.label.TextContentPart;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.util.MathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Tooltip {
    private String tooltip;
    private String formattedTooltip;
    private final TextContent content;
    private final Vis vis;
    private String[] tooltipString;
    private final String FONT_STYLE = "font-style";
    private final String FONT_SIZE = "font-size";
    private final String FONT_FAMILY = "font-family";
    private final String FONT_WEIGHT = "font-weight";
    private final String COLOR = "color";
    private final String OPACITY = "opacity";
    private final String ATTRIBUTE_TEXT_VALUE = "value";
    private final String EMPTY_STRING = "";

    public Tooltip(TextContent textContent, Vis vis) {
        this.content = textContent;
        this.vis = vis;
        this.createTooltipString();
        this.setRegularTooltip();
        this.setFormattedTooltip();
    }

    private void createTooltipString() {
        this.tooltipString = new String[]{"<a ", "style=\"", "font-style:", "", ";", "font-size :", "", ";", "font-family:", "", ";", "font-weight:", "", ";", "color:", "", ";", "opacity:", "", ";", "\"", ">", "", "</a>"};
        Map<String, String> map = this.getDefaultValues();
        this.populateTooltipString(map);
    }

    private Map<String, String> getDefaultValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("font-style", "");
        hashMap.put("font-size", "");
        hashMap.put("font-family", "");
        hashMap.put("font-weight", "");
        hashMap.put("color", "");
        hashMap.put("opacity", "");
        hashMap.put("value", "");
        return hashMap;
    }

    private void populateTooltipString(Map<String, String> map) {
        this.tooltipString[3] = map.get("font-style");
        this.tooltipString[6] = map.get("font-size");
        this.tooltipString[9] = map.get("font-family");
        this.tooltipString[12] = map.get("font-weight");
        this.tooltipString[15] = map.get("color");
        this.tooltipString[18] = map.get("opacity");
        this.tooltipString[22] = map.get("value");
    }

    public void setRegularTooltip() {
        if (this.content != null) {
            String string = this.content.getText();
            this.tooltip = NumericShaper.shape(string, this.vis.getVisContext().getNumericShapingInfo());
        }
    }

    public void setFormattedTooltip() {
        if (this.content != null && this.content.hasPartStyles()) {
            this.formattedTooltip = this.buildformattedTooltip(this.content);
        }
    }

    private String buildformattedTooltip(TextContent textContent) {
        ArrayList<TextContentPart> arrayList = textContent.getContent();
        StringBuffer stringBuffer = new StringBuffer();
        for (TextContentPart textContentPart : arrayList) {
            if (!textContentPart.isString()) continue;
            String string = NumericShaper.shape((String)textContentPart.getValue(), this.vis.getVisContext().getNumericShapingInfo());
            if (textContentPart.getStyle() != null) {
                stringBuffer.append(this.addFontformatting(string, textContentPart.getFont(), this.defaultFontUsed(textContentPart), textContentPart.getStyle().fill));
                continue;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private boolean defaultFontUsed(TextContentPart textContentPart) {
        return textContentPart.getStyle().font == null;
    }

    private String addFontformatting(String string, Font font, boolean bl, Object object) {
        Object object2;
        Object object3;
        Map<String, String> map = this.getDefaultValues();
        this.createTooltipString();
        if (!bl) {
            if (font.getBold()) {
                map.put("font-weight", "bold");
            }
            if ("italic".equals(font.getStyle())) {
                map.put("font-style", "italic");
            } else {
                map.put("font-style", "regular");
            }
            object3 = MathUtil.r3(font.getSize()).toString();
            object2 = font.getFamily();
            map.put("font-size", (String)object3 + "px");
            map.put("font-family", (String)object2);
        }
        map.put("value", string);
        object3 = ColorUtil.toCanonicalColor(object);
        if (object3 == null) {
            object3 = ColorUtil.createDefaultColor();
        }
        object2 = ((ColorNew)object3).getRGBA();
        String string2 = "rgb(" + MathUtil.r3(object2[0]) + "," + MathUtil.r3(object2[1]) + "," + MathUtil.r3(object2[2]) + ")";
        String string3 = String.valueOf(MathUtil.r3(object2[3]));
        map.put("color", string2);
        map.put("opacity", string3);
        this.populateTooltipString(map);
        if (bl) {
            this.removeFontFromTooltipString();
        }
        return this.getTooltipString();
    }

    private void removeFontFromTooltipString() {
        for (int i = 0; i < this.tooltipString.length; ++i) {
            String string = this.tooltipString[i];
            if (!string.startsWith("font")) continue;
            this.tooltipString[i] = "";
            int n = i;
            this.tooltipString[++n] = "";
            this.tooltipString[++n] = "";
        }
    }

    private String getTooltipString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.tooltipString) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getRegularTooltip() {
        return this.tooltip;
    }

    public String getFormattedTooltip() {
        return this.formattedTooltip;
    }
}

