/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.BidiProcess;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.spec.internal.LocalizationSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TooltipEvaluator {
    private static String getTooltipFromShapeOrGrammar(Vis vis, Shape shape) {
        String string = shape.getID();
        if (string == null) {
            return null;
        }
        String string2 = null;
        Integer n = TooltipEvaluator.grammarIndex(string);
        Integer n2 = TooltipEvaluator.elementIndex(string);
        if (n != null && n2 != null) {
            int n3 = n;
            int n4 = n2;
            if (vis.getGrammar() != null && n3 < vis.getGrammar().length) {
                Grammar grammar = vis.getGrammar()[n3];
                if (grammar.elements != null && n4 < grammar.elements.length) {
                    Element element = grammar.elements[n4];
                    string2 = element.getShapeTooltip(shape);
                }
            }
        }
        return string2;
    }

    public static String getBidiTooltip(Vis vis, Shape shape) {
        if (shape.hasTooltip()) {
            return shape.getDisplayTooltip();
        }
        String string = TooltipEvaluator.getTooltipFromShapeOrGrammar(vis, shape);
        String string2 = null;
        String string3 = null;
        if (string != null) {
            LocalizationSpec localizationSpec = vis.getVisContext().getLocalizationSpec();
            if (localizationSpec != null) {
                string3 = localizationSpec.baseTextDirection;
            }
            string2 = string3 != null ? (string3.equals("ltr") ? "\u202a" + string + "\u202c" : (string3.equals("rtl") ? "\u202b" + string + "\u202c" : BidiProcess.bidiProcess(string, 0))) : BidiProcess.bidiProcess(string, 0);
            shape.setTooltip(string2);
        }
        return string2;
    }

    public static String getTooltip(Vis vis, Shape shape) {
        if (shape.hasTooltip()) {
            return shape.getDisplayTooltip();
        }
        String string = TooltipEvaluator.getTooltipFromShapeOrGrammar(vis, shape);
        shape.setTooltip(string);
        return string;
    }

    private static Integer elementIndex(String string) {
        return TooltipEvaluator.getIndexFromID(string, 'E');
    }

    private static Integer grammarIndex(String string) {
        return TooltipEvaluator.getIndexFromID(string, 'G');
    }

    private static Integer getIndexFromID(String string, char c) {
        int n;
        if (string != null && (n = string.indexOf(c) + 1) > 0) {
            double d = BasicFactory.parseDouble(string.substring(n, n + 1));
            if (Double.isNaN(d)) {
                return null;
            }
            double d2 = BasicFactory.parseDouble(string.substring(n, n + 2));
            if (Double.isNaN(d2)) {
                return (int)Math.round(d);
            }
            double d3 = BasicFactory.parseDouble(string.substring(n, n + 3));
            return (int)Math.round(Double.isNaN(d3) ? d2 : d3);
        }
        return null;
    }
}

