/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.label;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.grammar.label.AbstractLabelProducer;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.label.Tooltip;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.TooltipSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TooltipProducer
extends AbstractLabelProducer {
    private final TooltipSpec tooltipSpec;

    public TooltipProducer(Data data, Vis vis, String string, TooltipSpec tooltipSpec) {
        super(data, vis, string);
        this.tooltipSpec = tooltipSpec;
    }

    private Object[] getContent() {
        if (this.tooltipSpec.content != null && this.tooltipSpec.content.length > 0) {
            return this.tooltipSpec.content;
        }
        return null;
    }

    public Tooltip makeTooltip(Shape shape) {
        TextContent textContent = this.makeTooltipTextContent(shape);
        Tooltip tooltip = new Tooltip(textContent, this.vis);
        return tooltip;
    }

    private TextContent makeTooltipTextContent(Shape shape) {
        Object[] objectArray = this.getContent();
        if (objectArray != null) {
            if (!(this.part == null || shape.getElementPart() != null && this.part.equals(shape.getElementPart()))) {
                return null;
            }
            for (Object object : objectArray) {
                if (!(object instanceof FieldValueRefSpec) || shape.getRows() != null) continue;
                return null;
            }
            TextContent textContent = this.makeContentFor(objectArray, shape);
            return textContent;
        }
        return null;
    }
}

