/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.BubbleEdgeData;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.BubbleParametersSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/layoutsLayer")
public class BubbleLayout
extends Layout {
    private Insets padding;
    private double[] radii;
    private Dim extent;
    private ArrayList<BubbleEdgeData> edges;
    private Point[] locations;
    private final boolean squarify;
    private int threshold = -1;

    public BubbleLayout(LayoutAdapter layoutAdapter, boolean bl) {
        super(layoutAdapter);
        this.squarify = bl;
        LayoutSpec layoutSpec = layoutAdapter.getSpec();
        if (layoutSpec != null && layoutSpec.bubbleParameters != null) {
            BubbleParametersSpec bubbleParametersSpec = layoutAdapter.getSpec().bubbleParameters;
            this.threshold = bubbleParametersSpec.threshold != null ? bubbleParametersSpec.threshold.intValue() : this.threshold;
        }
    }

    @Override
    public boolean needsAestheticsPreApplied() {
        return true;
    }

    private List<Shape> _subList(List<Shape> list, int n, int n2) {
        int n3 = Math.min(list.size(), n2);
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (int i = n; i < n3; ++i) {
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        Object object;
        int n2;
        this.extent = dim;
        StyleSpec styleSpec = this.adapter.getStyle();
        this.padding = styleSpec != null ? Insets.makeForStylePadding(styleSpec.padding, dim, dim) : Insets.NONE;
        List<Shape> list = new ArrayList<Shape>();
        DoublePrimitiveArrayList doublePrimitiveArrayList = new DoublePrimitiveArrayList(n);
        double d = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            object = this.adapter.makeItemAtSimpleCoordinates(new double[]{0.0, 0.0}, n2, true);
            if (object == null) continue;
            list.add((Shape)object);
        }
        if (this.threshold > 0 && this.threshold < n) {
            BasicFactory.sortList(list, new Comparator<Shape>(){

                @Override
                public int compare(Shape shape, Shape shape2) {
                    double d;
                    double d2 = shape.asBasic().getEnclosingCircle().getR();
                    return d2 < (d = shape2.asBasic().getEnclosingCircle().getR()) ? 1 : (d2 == d ? 0 : -1);
                }
            });
            list = this._subList(list, 0, this.threshold);
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            object = (Shape)list.get(n2);
            Circle circle = ((Shape)object).asBasic().getEnclosingCircle();
            double d2 = circle.getR() + Math.max(this.padding.getHorizontal(), this.padding.getVertical()) / 2.0;
            d += Math.PI * d2 * d2;
            doublePrimitiveArrayList.add(d2);
        }
        double[] dArray = doublePrimitiveArrayList.toArray();
        this.resizeShapes(list, dArray, d);
        this.place(dArray);
        object = new ArrayList();
        int n3 = 0;
        for (Shape shape : list) {
            Point point = shape.getCenter();
            Point point2 = this.locations[n3];
            if (point2 != null) {
                shape.affine(1.0, dim.getWidth() / 2.0 + point2.getX() - point.getX(), 1.0, dim.getWidth() / 2.0 + point2.getY() - point.getY(), false);
                object.add(shape);
            }
            ++n3;
        }
        this.scaleTo(list);
        return object;
    }

    public Point[] placeSimpleCircles(double[] dArray, Dim dim) {
        this.extent = dim;
        this.place(dArray);
        return this.locations;
    }

    private void place(double[] dArray) {
        int n;
        int n2;
        this.radii = new double[dArray.length];
        int n3 = dArray.length;
        int[] nArray = BasicFactory.makeSortOrder(dArray);
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n3 - n2 - 1];
            nArray2[n] = n2;
            this.radii[n2] = dArray[n];
        }
        this.locations = new Point[n3];
        this.edges = new ArrayList();
        if (n3 > 0) {
            this.locations[0] = new Point(0.0, 0.0);
        }
        if (n3 > 1) {
            double d = this.radii[0] + this.radii[1];
            this.locations[1] = new Point(d, 0.0);
        }
        if (n3 > 2) {
            Point point;
            double d = this.radii[0];
            double d2 = this.radii[1];
            double d3 = this.radii[2];
            this.locations[2] = point = BubbleLayout.getLocationForCanonicalCircles(d3, d, d2, null);
            double d4 = d * d + d2 * d2 + d3 * d3;
            double d5 = d2 * d2 * (d2 + d) + d3 * d3 * point.getX();
            double d6 = d3 * d3 * point.getY();
            for (int i = 0; i < 3; ++i) {
                this.locations[i].setX(this.locations[i].getX() - d5 / d4);
                this.locations[i].setY(this.locations[i].getY() - d6 / d4);
            }
            this.addEdge(new BubbleEdgeData(0, 1));
            this.addEdge(new BubbleEdgeData(1, 0));
            this.addEdge(new BubbleEdgeData(0, 2));
            this.addEdge(new BubbleEdgeData(2, 0));
            this.addEdge(new BubbleEdgeData(1, 2));
            this.addEdge(new BubbleEdgeData(2, 1));
        }
        for (n2 = 3; n2 < n3; ++n2) {
            this.placeOnEdge(n2);
        }
        Point[] pointArray = new Point[this.locations.length];
        for (n = 0; n < n3; ++n) {
            pointArray[n] = this.locations[nArray2[n]];
        }
        this.locations = pointArray;
    }

    private void placeOnEdge(int n) {
        double d = this.radii[n];
        Point point = new Point(0.0, 0.0);
        for (int i = 0; i < this.edges.size(); ++i) {
            boolean bl;
            BubbleEdgeData bubbleEdgeData = this.edges.get(i);
            double d2 = bubbleEdgeData.cr;
            boolean bl2 = bl = d2 != -1.0;
            if (bl && !(d <= d2)) continue;
            int n2 = bubbleEdgeData.e1;
            int n3 = bubbleEdgeData.e2;
            BubbleLayout.placeTouching(this.locations[n2], this.radii[n2], this.locations[n3], this.radii[n3], d, point);
            boolean bl3 = bl ? false : (bubbleEdgeData.nearShapes != null ? this.intersectsNearShapes(point, d, bubbleEdgeData) : this.intersectsExisting(point, d, n));
            if (bl3) continue;
            this.locations[n] = point;
            bubbleEdgeData.cr = BubbleLayout.getLargestInsideCircleRadius(d, this.radii[n2], this.radii[n3]);
            BubbleEdgeData bubbleEdgeData2 = new BubbleEdgeData(n, n3);
            BubbleEdgeData bubbleEdgeData3 = new BubbleEdgeData(n2, n);
            this.addEdge(bubbleEdgeData2);
            this.addEdge(bubbleEdgeData3);
            if (bubbleEdgeData.nearShapes != null) {
                bubbleEdgeData2.nearShapes = bubbleEdgeData.nearShapes;
                bubbleEdgeData3.nearShapes = bubbleEdgeData.nearShapes;
                bubbleEdgeData.nearShapes.add(n);
            } else if (bubbleEdgeData.nearShapes == null && bl) {
                bubbleEdgeData2.nearShapes = new IntPrimitiveArrayList();
                bubbleEdgeData2.nearShapes.add(n);
                bubbleEdgeData2.nearShapes.add(n2);
                bubbleEdgeData2.nearShapes.add(n3);
                bubbleEdgeData2.nearShapes.add(bubbleEdgeData.e3);
                bubbleEdgeData3.nearShapes = bubbleEdgeData2.nearShapes;
            }
            bubbleEdgeData.e3 = n;
            return;
        }
    }

    private static double getLargestInsideCircleRadius(double d, double d2, double d3) {
        double d4 = 1.0 / d;
        double d5 = 1.0 / d2;
        double d6 = 1.0 / d3;
        return 1.0 / (d4 + d5 + d6 + 2.0 * Math.sqrt(d4 * d5 + d5 * d6 + d6 * d4));
    }

    private void addEdge(BubbleEdgeData bubbleEdgeData) {
        double d;
        bubbleEdgeData.touchPointDistance = d = this.getTouchPointDistance(bubbleEdgeData);
        int n = this.edges.size();
        if (n == 0) {
            this.edges.add(bubbleEdgeData);
            return;
        }
        int n2 = 0;
        if (d < this.edges.get((int)n2).touchPointDistance) {
            this.edges.add(0, bubbleEdgeData);
            return;
        }
        int n3 = n - 1;
        if (d >= this.edges.get((int)n3).touchPointDistance) {
            this.edges.add(bubbleEdgeData);
            return;
        }
        while (n3 > n2 + 1) {
            int n4 = (int)Math.floor((n2 + n3) / 2);
            double d2 = this.edges.get((int)n4).touchPointDistance;
            if (d < d2) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        this.edges.add(n3, bubbleEdgeData);
    }

    private double getTouchPointDistance(BubbleEdgeData bubbleEdgeData) {
        Point point = this.locations[bubbleEdgeData.e1];
        Point point2 = this.locations[bubbleEdgeData.e2];
        double d = this.radii[bubbleEdgeData.e1];
        double d2 = this.radii[bubbleEdgeData.e2];
        double d3 = (point.getX() * d2 + point2.getX() * d) / (d + d2);
        double d4 = (point.getY() * d2 + point2.getY() * d) / (d + d2);
        if (this.squarify) {
            double d5 = Math.abs(d3) / this.extent.getWidth();
            double d6 = Math.abs(d4) / this.extent.getHeight();
            return Math.max(d5, d6);
        }
        return d3 * d3 + d4 * d4;
    }

    private boolean intersectsNearShapes(Point point, double d, BubbleEdgeData bubbleEdgeData) {
        IntPrimitiveArrayList intPrimitiveArrayList = bubbleEdgeData.nearShapes;
        int n = bubbleEdgeData.e1;
        int n2 = bubbleEdgeData.e2;
        int n3 = intPrimitiveArrayList.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = intPrimitiveArrayList.get(i);
            if (n4 == n || n4 == n2) continue;
            double d2 = d + this.radii[n4] - 0.01;
            Point point2 = this.locations[n4];
            if (!(Math.abs(point.getX() - point2.getX()) < d2) || !(Math.abs(point.getY() - point2.getY()) < d2) || !(point.distance(point2) < d2)) continue;
            return true;
        }
        return false;
    }

    private boolean intersectsExisting(Point point, double d, int n) {
        for (int i = 0; i < n; ++i) {
            double d2 = d + this.radii[i] - 0.01;
            Point point2 = this.locations[i];
            if (!(Math.abs(point.getX() - point2.getX()) < d2) || !(Math.abs(point.getY() - point2.getY()) < d2) || !(point.distance(point2) < d2)) continue;
            return true;
        }
        return false;
    }

    private static Point placeTouching(Point point, double d, Point point2, double d2, double d3, Point point3) {
        double d4 = point2.getX() - point.getX();
        double d5 = point2.getY() - point.getY();
        double d6 = d + d2;
        double d7 = d4 / d6;
        double d8 = d5 / d6;
        Point point4 = BubbleLayout.getLocationForCanonicalCircles(d3, d, d2, point3);
        double d9 = point4.getX() * d7 - point4.getY() * d8 + point.getX();
        double d10 = point4.getX() * d8 + point4.getY() * d7 + point.getY();
        point4.setX(d9);
        point4.setY(d10);
        return point4;
    }

    private static Point getLocationForCanonicalCircles(double d, double d2, double d3, Point point) {
        double d4 = d2 + d3;
        double d5 = d2 + d;
        double d6 = d3 + d;
        double d7 = (d4 * d4 + d5 * d5 - d6 * d6) / 2.0 / d4;
        double d8 = Math.sqrt(d5 * d5 - d7 * d7);
        if (point == null) {
            return new Point(d7, d8);
        }
        point.setX(d7);
        point.setY(d8);
        return point;
    }

    public void scaleTo(List<Shape> list) {
        Range[] rangeArray = BubbleLayout.getShapeRanges(list);
        double d = this.extent.getWidth() / (rangeArray[0].getRange() + this.padding.left + this.padding.right);
        double d2 = this.extent.getHeight() / (rangeArray[1].getRange() + this.padding.top + this.padding.bottom);
        double d3 = Math.min(d, d2);
        double d4 = -rangeArray[0].getMin();
        double d5 = -rangeArray[1].getMin();
        double d6 = (this.extent.getWidth() - d3 * rangeArray[0].getRange()) / 2.0;
        double d7 = (this.extent.getHeight() - d3 * rangeArray[1].getRange()) / 2.0;
        for (Shape shape : list) {
            shape.affine(d3, d4 * d3 + d6, d3, d5 * d3 + d7, true);
        }
    }

    private static Range[] getShapeRanges(List<Shape> list) {
        Range[] rangeArray = new Range[]{Range.EMPTY, Range.EMPTY};
        for (Shape shape : list) {
            Rect rect = shape.getBounds();
            rangeArray[0] = rangeArray[0].unionValue(rect.getX()).unionValue(rect.getX() + rect.getWidth());
            rangeArray[1] = rangeArray[1].unionValue(rect.getY()).unionValue(rect.getY() + rect.getHeight());
        }
        return rangeArray;
    }

    public void resizeShapes(List<Shape> list, double[] dArray, double d) {
        double d2;
        double d3 = 0.0;
        if (this.squarify) {
            d3 = this.extent.getWidth() * this.extent.getHeight();
        } else {
            d2 = 0.5 * Math.min(this.extent.getWidth(), this.extent.getHeight());
            d3 = Math.PI * d2 * d2;
        }
        d2 = d3 / d;
        if (Math.abs(d2 - 1.0) < 0.001) {
            return;
        }
        int n = 0;
        for (Shape shape : list) {
            shape.affine(d2, 0.0, d2, 0.0, true);
            dArray[n++] = shape.asBasic().getEnclosingCircle().getR() + Math.max(this.padding.getHorizontal(), this.padding.getVertical()) / 2.0;
        }
    }
}

