/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.grammar.layout.ConnectionSide;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.ArrowType;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class ConnectionPoint {
    ConnectionSide side;
    ArrowType arrowStyle;

    ConnectionPoint(ConnectionSide connectionSide, ArrowType arrowType) {
        this.side = connectionSide;
        this.arrowStyle = arrowType;
    }

    Point determinePoint(Rect rect, int n, int n2, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = d == 0.0 ? ((double)n2 + 1.0) / ((double)n + 1.0) : d;
        switch (this.side) {
            case LEFT: {
                d2 = rect.getX();
                d3 = rect.getY() + rect.getHeight() * d4;
                break;
            }
            case RIGHT: {
                d2 = rect.getX2();
                d3 = rect.getY2() - rect.getHeight() * d4;
                break;
            }
            case TOP: {
                d2 = rect.getX2() - rect.getWidth() * d4;
                d3 = rect.getY();
                break;
            }
            case BOTTOM: {
                d2 = rect.getX() + rect.getWidth() * d4;
                d3 = rect.getY2();
                break;
            }
        }
        return new Point(d2, d3);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.arrowStyle == null ? 0 : this.arrowStyle.hashCode());
        n = 31 * n + this.side.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ConnectionPoint)) {
            return false;
        }
        ConnectionPoint connectionPoint = (ConnectionPoint)object;
        if (this.arrowStyle != connectionPoint.arrowStyle) {
            return false;
        }
        return this.side == connectionPoint.side;
    }

    public String toString() {
        return "ConnectionPoint " + (Object)((Object)this.side) + ", " + this.arrowStyle;
    }
}

