/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.diagramService.Diagram;
import com.ibm.vis.engine.diagramService.DiagramConnector;
import com.ibm.vis.engine.diagramService.TextGeom;
import com.ibm.vis.engine.diagramService.internal.DiagramServiceDelegate;
import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.scene.SymbolBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.CompositeGeom;
import com.ibm.vis.geom.Curve;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.geom.Wedge;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.LayoutDataSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DiagramLayout
extends Layout
implements DiagramConnector {
    private Diagram diagram;
    private final String type;
    private boolean diagramInitialized;
    private boolean diagramBuilt;
    private final String idField;
    private Map<Double, Integer> idMap;
    private boolean[] dataTypes;
    private String[] dataIDs;
    private Number[] dataValues;
    private final Map<String, Object> parameters;
    private int rowCount;
    private final List<Shape> elementShapes;
    private final List<Shape> nonElementShapes;
    private final List<Shape> nonElementLabels;
    private Dim extent;

    public DiagramLayout(LayoutAdapter layoutAdapter, String string) {
        super(layoutAdapter);
        this.type = string;
        this.parameters = new HashMap<String, Object>();
        this.elementShapes = new ArrayList<Shape>();
        this.nonElementShapes = new ArrayList<Shape>();
        this.nonElementLabels = new ArrayList<Shape>();
        LayoutSpec layoutSpec = layoutAdapter.getSpec();
        this.idField = layoutSpec.id == null ? null : layoutSpec.id.$ref;
        this.makeData(layoutSpec.data);
        this.setParameters(layoutSpec.parameters);
    }

    @Override
    public void prepareForNewRows(int n) {
        this.diagramInitialized = false;
        this.diagramBuilt = false;
    }

    private void makeData(LayoutDataSpec[] layoutDataSpecArray) {
        int n;
        int n2 = layoutDataSpecArray == null ? 0 : layoutDataSpecArray.length;
        for (n = 0; n < n2; ++n) {
            if (layoutDataSpecArray[n] == null) {
                throw new SpecException("All entries in the layout.data array must be non-null", ErrorCode.SPEC_INVALID_PARAMETERS, null);
            }
            if (layoutDataSpecArray[n].field == null && layoutDataSpecArray[n].value == null) {
                throw new SpecException("All entries in the layout.data array must define a field or value", ErrorCode.SPEC_INVALID_PARAMETERS, null);
            }
            if (layoutDataSpecArray[n].field == null || layoutDataSpecArray[n].field.$ref != null) continue;
            throw new SpecException("All entries in the layout.data array that define a field must contain a $ref", ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        this.dataTypes = new boolean[n2];
        this.dataIDs = new String[n2];
        this.dataValues = new Number[n2];
        for (n = 0; n < n2; ++n) {
            if (layoutDataSpecArray[n].field != null) {
                this.dataTypes[n] = true;
                this.dataIDs[n] = layoutDataSpecArray[n].field.$ref;
                this.dataValues[n] = null;
                continue;
            }
            this.dataTypes[n] = false;
            this.dataIDs[n] = null;
            this.dataValues[n] = layoutDataSpecArray[n].value;
        }
    }

    private void setParameters(Object object) {
        if (object == null || !BasicFactory.isObject(object)) {
            return;
        }
        JSONObject jSONObject = (JSONObject)object;
        for (String string : BasicFactory.keySet(jSONObject)) {
            Object object2 = BasicFactory.getItem(jSONObject, string);
            this.parameters.put(string, object2);
        }
    }

    private Diagram makeDiagram() {
        return DiagramServiceDelegate.getInstance().getDiagram(this.type);
    }

    private void ensureBuilt(Dim dim) {
        this.extent = dim;
        if (!this.diagramBuilt) {
            this.elementShapes.clear();
            this.nonElementShapes.clear();
            this.nonElementLabels.clear();
            this.diagram.build(dim);
            this.diagramBuilt = true;
        }
    }

    private void ensureInitialized(int n) {
        this.rowCount = n;
        if (this.diagram == null) {
            this.diagram = this.makeDiagram();
        }
        if (!this.diagramInitialized) {
            this.diagram.initialize(this);
            this.diagramInitialized = true;
        }
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        this.ensureInitialized(n);
        this.ensureBuilt(dim);
        return this.elementShapes;
    }

    @Override
    public List<Shape> makeNonElementShapes(Dim dim) {
        this.ensureInitialized(this.rowCount);
        this.ensureBuilt(dim);
        return this.nonElementShapes;
    }

    @Override
    public List<Shape> makeNonElementLabels(Dim dim) {
        this.ensureInitialized(this.rowCount);
        this.ensureBuilt(dim);
        return this.nonElementLabels;
    }

    @Override
    public Dim getPreferredSize(int n) {
        if (this.diagram == null) {
            this.diagram = this.makeDiagram();
        }
        if (this.diagram.connectsExistingShapes()) {
            return new Dim(0.0, 0.0);
        }
        this.ensureInitialized(n);
        Dim dim = this.diagram.calculatePreferredSize();
        return dim == null ? new Dim(0.0, 0.0) : dim;
    }

    @Override
    public boolean respectsTransforms() {
        if (this.diagram == null) {
            this.diagram = this.makeDiagram();
        }
        return !this.diagram.connectsExistingShapes();
    }

    @Override
    public Geom[] getTargetShapes() {
        HashMap<Double, Shape> hashMap = this.adapter.getElementItems(this.idField);
        Geom[] geomArray = new Geom[this.max(hashMap.keySet()) + 1];
        for (Map.Entry<Double, Shape> entry : hashMap.entrySet()) {
            Geom geom = entry.getValue().getRenderGeom(0.0);
            if (geom == null) {
                geom = entry.getValue().getBounds();
            }
            geomArray[entry.getKey().intValue()] = geom;
        }
        return geomArray;
    }

    private int max(Set<? extends Number> set) {
        int n = 0;
        for (Number number : set) {
            if (number == null) continue;
            n = Math.max(n, number.intValue());
        }
        return n;
    }

    @Override
    public int columnCount() {
        return this.dataTypes.length;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Double[] row(int n) {
        if (n < 0 || n >= this.rowCount) {
            return null;
        }
        int n2 = this.dataTypes.length;
        Double[] doubleArray = new Double[n2];
        for (int i = 0; i < n2; ++i) {
            double d;
            if (this.dataTypes[i]) {
                try {
                    d = this.adapter.getFieldNumericValue(this.dataIDs[i], n);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    d = Double.NaN;
                }
            } else {
                d = this.dataValues[i].doubleValue();
            }
            doubleArray[i] = Double.isNaN(d) ? null : Double.valueOf(d);
        }
        return doubleArray;
    }

    @Override
    public Boolean booleanParameter(String string, Boolean bl) {
        Object object = this.parameters.get(string);
        if (object == null) {
            return bl;
        }
        if (BasicFactory.isBoolean(object)) {
            return (Boolean)object;
        }
        if (BasicFactory.isString(object)) {
            if (object.equals("true")) {
                return true;
            }
            if (object.equals("false")) {
                return false;
            }
        }
        return bl;
    }

    @Override
    public Number numericParameter(String string, Number number) {
        Object object = this.parameters.get(string);
        if (object == null) {
            return number;
        }
        if (BasicFactory.isNumber(object)) {
            return (Number)object;
        }
        return number;
    }

    @Override
    public String stringParameter(String string, String string2) {
        Object object = this.parameters.get(string);
        if (object == null) {
            return string2;
        }
        if (BasicFactory.isString(object)) {
            return (String)object;
        }
        if (BasicFactory.isBoolean(object)) {
            return (Boolean)object != false ? "true" : "false";
        }
        return string2;
    }

    @Override
    public Object objectParameter(String string, Object object) {
        Object object2 = this.parameters.get(string);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    private void rotateText(Text text, double d) {
        Point point = text.getCenter();
        Affine affine = Affine.makeRotation(d, point.getX(), point.getY());
        text.setTransform(affine);
    }

    @Override
    public ShapeInfo addElementShape(Geom geom, int n, String[] stringArray) {
        Shape shape;
        if (geom == null) {
            return null;
        }
        if (geom instanceof TextGeom) {
            boolean bl;
            TextGeom textGeom = (TextGeom)geom;
            Rect rect = textGeom.getBounds();
            boolean bl2 = bl = textGeom.getTextAngle() != 0.0;
            if (bl) {
                rect = new Rect(rect.getCenterX() - rect.getHeight() / 2.0, rect.getCenterY() - rect.getWidth() / 2.0, rect.getHeight(), rect.getWidth());
            }
            Text text = (Text)this.adapter.makeItemInRect(rect, n);
            shape = text;
            if (bl) {
                this.rotateText(text, textGeom.getTextAngle() * Math.PI / 180.0);
            }
            if (textGeom.getFontMagnification() != 1.0) {
                double d = text.getFont().getSize() * textGeom.getFontMagnification();
                text.setFont(text.getFont().modifySize(d));
            }
        } else {
            shape = geom.type() == 1002 ? this.adapter.makeItemInRect((Rect)geom, n) : this.toShape(geom, n);
        }
        if (shape == null) {
            return null;
        }
        shape = this.applyTargetStyle(shape, stringArray);
        this.elementShapes.add(shape);
        return shape;
    }

    @Override
    public ShapeInfo addNonElementShape(Geom geom, String[] stringArray) {
        if (geom == null) {
            return null;
        }
        Shape shape = this.toShape(geom, -1);
        shape = this.applyTargetStyle(shape, stringArray);
        this.nonElementShapes.add(shape);
        return shape;
    }

    private Shape toShape(Geom geom, int n) {
        Shape shape = null;
        int n2 = geom.type();
        if (n2 == 1007) {
            CompositeGeom compositeGeom = (CompositeGeom)geom;
            Rect rect = geom.getBounds();
            Shape[] shapeArray = new Shape[compositeGeom.getParts().length];
            String[] stringArray = compositeGeom.getPartNames();
            for (int i = 0; i < shapeArray.length; ++i) {
                shapeArray[i] = this.toShape(compositeGeom.getParts()[i], n);
                if (stringArray == null) continue;
                shapeArray[i].setMeta("part", stringArray[i]);
            }
            shape = new Schema(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), shapeArray, geom.filled());
        } else if (n2 == 1000) {
            Line line = (Line)geom;
            shape = ShapeLine.make(line.getX1(), line.getY1(), line.getX2(), line.getY2());
        } else if (n2 == 1001) {
            Circle circle = (Circle)geom;
            shape = ShapeFactory2.CreateCircle(circle.getX(), circle.getY(), circle.getR());
        } else if (n2 == 1006) {
            Wedge wedge = (Wedge)geom;
            Point point = wedge.getOrigin();
            shape = ShapeFactory2.createWedge(point.getX(), point.getY(), wedge.getR1(), wedge.getR2(), wedge.getA1(), wedge.getA2());
        } else if (n2 == 1002) {
            Rect rect = (Rect)geom;
            shape = ShapeFactory2.CreateRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        } else if (n2 == 1003) {
            Poly poly = (Poly)geom;
            int n3 = poly.getX().length;
            char[] cArray = new char[n3];
            cArray[0] = 77;
            for (int i = 1; i < n3; ++i) {
                cArray[i] = 76;
            }
            shape = this.adapter.makeItemFromPath(poly.getX(), poly.getY(), cArray, geom.filled(), 0);
            shape.setRow(n);
        } else if (n2 == 1004) {
            Curve curve = (Curve)geom;
            boolean[] blArray = curve.getControls();
            char[] cArray = new char[blArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                if (!blArray[i]) {
                    cArray[i] = i == 0 ? 77 : 76;
                    continue;
                }
                if (!blArray[i + 1]) {
                    cArray[i++] = 81;
                    cArray[i] = 44;
                    continue;
                }
                cArray[i++] = 67;
                cArray[i++] = 44;
                cArray[i] = 44;
            }
            shape = this.adapter.makeItemFromPath(curve.getX(), curve.getY(), cArray, geom.filled(), n);
        } else {
            return this.toShape(geom.asBasic(), n);
        }
        if (n >= 0) {
            shape.setRow(n);
        }
        return shape;
    }

    private Shape applyTargetStyle(Shape shape, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return shape;
        }
        for (String string : stringArray) {
            StyleSpec styleSpec = this.adapter.getTargetedStyle(string);
            if (styleSpec == null) continue;
            shape = this.modifyShapeForStyle(shape, styleSpec);
            break;
        }
        return shape;
    }

    private Shape modifyShapeForStyle(Shape shape, StyleSpec styleSpec) {
        if (shape == null || styleSpec == null) {
            return shape;
        }
        String string = (String)styleSpec.symbol;
        Geom geom = shape.getGeom();
        if (geom == null) {
            geom = shape.getRenderGeom(0.0);
        }
        if (geom.type() == 1002 && string != null) {
            Rect rect = (Rect)geom;
            Shape shape2 = SymbolBuilder.makeSymbol(string, rect.getCenterX(), rect.getCenterY(), rect.getWidth(), rect.getHeight(), styleSpec, this.adapter.getVisContext());
            shape2.copyInfoFrom(shape);
            shape = shape2;
        }
        shape = StyleBuilder.modifyShapeStyle(shape, styleSpec);
        return shape;
    }

    @Override
    public boolean targetStyleExists(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (String string : stringArray) {
            if (this.adapter.getTargetedStyle(string) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Geom[] makeUnplacedShapes() {
        Geom[] geomArray = new Geom[this.rowCount];
        double[] dArray = new double[]{0.0, 0.0};
        for (int i = 0; i < this.rowCount; ++i) {
            Shape shape = this.adapter.makeItemAtSimpleCoordinates(dArray, i, true);
            if (shape instanceof Text) {
                Text text = (Text)shape;
                Rect rect = text.getTextBounds();
                geomArray[i] = new TextGeom(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), text.getContent().getText(), 0.0);
                continue;
            }
            if (shape == null) continue;
            geomArray[i] = shape.getGeom();
            if (geomArray[i] != null) continue;
            geomArray[i] = shape.getRenderGeom(0.0);
        }
        return geomArray;
    }

    @Override
    public Object getStoredItem(String string) {
        return this.adapter.getVisContext().getStoredItem(string);
    }

    @Override
    public void putStoredItem(String string, Object object) {
        this.adapter.getVisContext().putStoredItem(string, object);
    }

    @Override
    public Rect applyInsets(Rect rect, boolean bl, String[] stringArray) {
        if (rect == null) {
            return null;
        }
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                StyleSpec styleSpec = this.adapter.getTargetedStyle(string);
                if (styleSpec == null) continue;
                Insets insets = Insets.makeForStylePadding(styleSpec.padding, rect.getExtent(), this.extent);
                rect = this.safeInset(rect, insets);
                break;
            }
        }
        if (bl && this.adapter.getStyle() != null) {
            Insets insets = Insets.makeForStylePadding(this.adapter.getStyle().padding, rect.getExtent(), this.extent);
            rect = this.safeInset(rect, insets);
        }
        return rect;
    }

    private Rect safeInset(Rect rect, Insets insets) {
        Rect rect2 = insets.insetRect(rect);
        if (rect2.getHeight() < 0.0) {
            rect2.setY(rect.getCenterY());
            rect2.setHeight(0.0);
        }
        if (rect2.getWidth() < 0.0) {
            rect2.setX(rect.getCenterX());
            rect2.setWidth(0.0);
        }
        return rect2;
    }

    @Override
    public String getDataLabel(double d, int n) {
        if (n < 0 || n >= this.dataTypes.length) {
            return null;
        }
        if (this.dataTypes[n]) {
            Field field = (Field)this.adapter.getVisContext().getParentVis().getByID(this.dataIDs[n]);
            return field.getFormattedStringValue(d, -1, null);
        }
        return "" + this.dataValues[n];
    }

    @Override
    public ShapeInfo addNonElementLabel(String string, Geom geom, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        for (String string2 : stringArray) {
            StyleSpec styleSpec = this.adapter.getTargetedStyle(string2);
            if (styleSpec == null) continue;
            ElementLabelSpec elementLabelSpec = new ElementLabelSpec();
            elementLabelSpec.content = new Object[]{string};
            elementLabelSpec.style = styleSpec;
            Shape shape = this.adapter.makeLabelShape(elementLabelSpec, this.toShape(geom, -1));
            if (shape != null) {
                this.nonElementLabels.add(shape);
            }
            return shape;
        }
        return null;
    }

    @Override
    public Point getLocation(double[] dArray, Dim dim) {
        return this.adapter.getLocation(dArray, dim);
    }

    @Override
    public Integer getReferencedRow(Double d) {
        if (this.idField == null) {
            throw new IllegalArgumentException("No ID defined");
        }
        if (this.idMap == null) {
            this.idMap = new HashMap<Double, Integer>();
            double[] dArray = this.adapter.getAllFieldValuesAsNumeric(this.idField);
            for (int i = 0; i < dArray.length; ++i) {
                this.idMap.put(dArray[i], i);
            }
        }
        return this.idMap.get(d);
    }

    @Override
    public Dim getElementSize() {
        return this.adapter.getElementSize();
    }
}

