/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.grammar.layout.graph.Direction;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.geom.Point;

class DirectedNode {
    private final Node node;
    private final Direction dir;
    private final Link incidentEdge;
    public final int index;
    private final double length;

    public DirectedNode(int n, Node node, Direction direction, Link link) {
        this.index = n;
        this.node = node;
        this.dir = direction;
        this.incidentEdge = link;
        if (link == null) {
            this.length = 0.0;
        } else {
            Node node2 = this.incidentEdge.getFrom();
            Node node3 = this.incidentEdge.getTo();
            this.length = Math.abs(node2.getX() - node3.getX()) + Math.abs(node2.getY() - node3.getY());
        }
    }

    public static DirectedNode makeDummy(Point point, Direction direction) {
        Node node = new Node(-1);
        node.setX(point.getX());
        node.setY(point.getY());
        node.setInLink(Link.NONE);
        node.setOutLink(Link.NONE);
        node.setInfo(0.0);
        return new DirectedNode(-1, node, direction, null);
    }

    final Node node() {
        return this.node;
    }

    final Direction dir() {
        return this.dir;
    }

    final Link incident() {
        return this.incidentEdge;
    }

    public String toString() {
        return this.dir.toString();
    }

    final double segmentLength() {
        return this.length;
    }
}

