/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.grammar.layout.DirectedNode;
import com.ibm.vis.engine.internal.grammar.layout.EdgeRouteInfo;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.PartialRoute;
import com.ibm.vis.engine.internal.grammar.layout.PriorityQueueHeap;
import com.ibm.vis.engine.internal.grammar.layout.VisibilityGraph;
import com.ibm.vis.engine.internal.grammar.layout.graph.Direction;
import com.ibm.vis.engine.internal.grammar.layout.graph.GraphBuilder;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.LiteGraph;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class EdgeRouting
extends Layout {
    private static final int[] minimalBendsArr = new int[]{0, 3, 3, 4, 1, 4, 2, 3, 1, 2, 4, 3, 4, 3, 3, 4, 4, 1, 3, 2, 3, 0, 4, 3, 3, 4, 4, 3, 2, 1, 3, 4, 4, 3, 1, 2, 3, 4, 4, 3, 3, 4, 0, 3, 2, 3, 1, 4, 4, 3, 3, 4, 3, 4, 2, 1, 3, 2, 4, 1, 4, 3, 3, 0, 2, 1, 3, 2, 1, 2, 2, 3, 3, 2, 4, 3, 2, 3, 3, 4, 4, 3, 3, 2, 3, 2, 2, 1, 3, 2, 4, 3, 2, 1, 3, 2, 2, 3, 1, 2, 3, 4, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 4, 3, 3, 2, 3, 4, 2, 3, 3, 2, 2, 1, 2, 3, 1, 2};
    private final double cost_bend;
    private final double cost_cross;
    private final double cost_coincide;
    private final double cost_inconsistent;
    private final double curveRadius;
    private final GraphBuilder graphBuilder;
    private final PriorityQueueHeap<PartialRoute> queue;
    private LiteGraph base;
    private EdgeRouteInfo[] edgeInfo;
    private VisibilityGraph visibility;
    private DirectedNode[][] neighbors;
    private double pad;
    private long timeVisGraph;
    private long timeRouting;
    private final boolean useCurves;
    int debug = 0;

    public EdgeRouting(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        String string = layoutAdapter.getSpec().family;
        this.cost_bend = this.getFamilyPart(string, 0, 40.0);
        this.cost_cross = this.getFamilyPart(string, 1, 50.0);
        this.cost_coincide = this.getFamilyPart(string, 2, 100.0);
        this.cost_inconsistent = this.getFamilyPart(string, 3, 1000.0);
        boolean bl = false;
        double d = 8.0;
        if (layoutAdapter.getStyle() != null) {
            if (layoutAdapter.getStyle().cornerRadius != null) {
                if (BasicFactory.isNumber(layoutAdapter.getStyle().cornerRadius)) {
                    d = ((Number)layoutAdapter.getStyle().cornerRadius).doubleValue();
                }
                bl = true;
            }
            if (BasicFactory.isString(layoutAdapter.getStyle().symbol)) {
                bl = ((String)layoutAdapter.getStyle().symbol).startsWith("curv");
            }
        }
        this.useCurves = bl;
        this.curveRadius = d;
        this.graphBuilder = new GraphBuilder(layoutAdapter);
        this.queue = new PriorityQueueHeap(80);
    }

    private double getFamilyPart(String string, int n, double d) {
        if (string == null) {
            return d;
        }
        String[] stringArray = string.split(";");
        if (n >= stringArray.length) {
            return d;
        }
        try {
            double d2 = Double.parseDouble(stringArray[n]);
            return d2 >= 0.0 ? d2 : d;
        }
        catch (Exception exception) {
            return d;
        }
    }

    @Override
    public void prepareForNewRows(int n) {
        this.base = null;
    }

    private void initializeStructures() {
        if (this.base == null) {
            this.timeVisGraph = BasicFactory.getSystemTimer();
            this.base = this.graphBuilder.build(true);
            this.makeEdgeInfo();
            Rect[] rectArray = new Rect[this.base.getNodesCount()];
            List<Node> list = this.base.getNodes();
            for (int i = 0; i < rectArray.length; ++i) {
                Node node = list.get(i);
                Rect rect = node.getShape().getBounds();
                rectArray[i] = new Rect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
                node.setInfo(new int[4]);
            }
            this.adapter.logInfo("Building Routing layout", "# obstacles", rectArray.length);
            double d = this.adapter.getSharedLayoutInfo().getMinimalNodeSeparation();
            if (d == 0.0) {
                d = EdgeRouting.findMinimalDistance(rectArray);
            }
            this.pad = d > 3.0 * this.curveRadius ? Math.floor(d / 3.0) : Math.floor(d * 0.45);
            for (int i = 0; i < rectArray.length; ++i) {
                rectArray[i] = (Rect)rectArray[i].expand(this.pad);
            }
            this.visibility = VisibilityGraph.makeOrthogonal(rectArray);
            this.neighbors = new DirectedNode[this.visibility.directedNodeCount][];
            for (EdgeRouteInfo edgeRouteInfo : this.edgeInfo) {
                edgeRouteInfo.setStartNodes(this.getTerminalNodes(edgeRouteInfo.startRect(), edgeRouteInfo.startDirs()));
                edgeRouteInfo.setEndNodes(this.getTerminalNodes(edgeRouteInfo.endRect(), edgeRouteInfo.endDirs()));
            }
            this.timeVisGraph = BasicFactory.getSystemTimer() - this.timeVisGraph;
            this.adapter.logInfo("Routing : Initialized Structures", "N,E", this.visibility.getNodesCount() + "," + this.visibility.getLinksCount());
        }
    }

    private Node[] getTerminalNodes(Rect rect, Direction[] directionArray) {
        Node[] nodeArray = new Node[directionArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            Point point = directionArray[i].boundaryPoint(rect);
            nodeArray[i] = this.visibility.findNode(directionArray[i].offset(point, this.pad));
        }
        return nodeArray;
    }

    private void makeEdgeInfo() {
        Rect rect;
        Object object;
        for (Node node : this.base.getNodes()) {
            object = node.getShape().getBounds();
            rect = new Rect(((Rect)object).getX(), ((Rect)object).getY(), ((Rect)object).getWidth(), ((Rect)object).getHeight());
            node.setInfo(rect);
        }
        List<Link> list = this.base.getLinks();
        this.edgeInfo = new EdgeRouteInfo[this.base.getLinksCount()];
        for (int i = 0; i < this.edgeInfo.length; ++i) {
            object = (Link)list.get(i);
            rect = (Rect)((Link)object).getFrom().getInfo();
            Rect rect2 = (Rect)((Link)object).getTo().getInfo();
            Direction[] directionArray = Direction.getOrderedDirections(rect, rect2, ((Link)object).getGroupType());
            Direction[] directionArray2 = Direction.getOrderedDirections(rect2, rect, null);
            this.edgeInfo[i] = new EdgeRouteInfo((Link)object, rect, directionArray, rect2, directionArray2);
        }
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        this.initializeStructures();
        int[] nArray = this.orderEdgesByMinimalCost();
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        this.timeRouting = BasicFactory.getSystemTimer();
        for (int n2 : nArray) {
            EdgeRouteInfo edgeRouteInfo = this.edgeInfo[n2];
            Shape shape = this.findRoute(edgeRouteInfo);
            if (shape == null) continue;
            shape.setRow(edgeRouteInfo.getEdge().getRow());
            arrayList.add(shape);
        }
        this.timeRouting = BasicFactory.getSystemTimer() - this.timeRouting;
        this.adapter.logDetail("Routing visibility graph", "time taken", this.timeVisGraph);
        this.adapter.logInfo("Routing completed", "time taken", this.timeRouting);
        if (this.debug > 0) {
            System.out.println("Timing = " + this.timeVisGraph + " / " + this.timeRouting);
        }
        return arrayList;
    }

    private Shape findRoute(EdgeRouteInfo edgeRouteInfo) {
        Object object;
        if (this.debug > 1) {
            System.out.println(edgeRouteInfo.getEdge().getFrom().getRow() + " -> " + edgeRouteInfo.getEdge().getTo().getRow());
        }
        PartialRoute partialRoute = null;
        double d = Double.MAX_VALUE;
        Object object2 = null;
        Direction direction = null;
        for (int i = 0; i < edgeRouteInfo.startDirs().length; ++i) {
            object = edgeRouteInfo.startDirs()[i];
            for (int j = 0; j < edgeRouteInfo.endDirs().length; ++j) {
                PartialRoute partialRoute2;
                Direction direction2 = edgeRouteInfo.endDirs()[j];
                Node node = edgeRouteInfo.startNodes()[i];
                Node node2 = edgeRouteInfo.endNodes()[j];
                if (node == null || node2 == null) continue;
                double d2 = this.calculateEndLocationCost(edgeRouteInfo.getEdge(), (Direction)object, direction2);
                DirectedNode directedNode = new DirectedNode(0, node, (Direction)object, null);
                DirectedNode directedNode2 = new DirectedNode(-1, node2, direction2.getReverse(), null);
                this.neighbors[0] = null;
                if (this.debug > 2) {
                    System.out.println("  START " + object + " -> " + direction2);
                }
                if ((partialRoute2 = this.route(directedNode, directedNode2, d2, d)) != null && this.debug > 2) {
                    System.out.println("  END " + object + " -> " + direction2 + ": " + partialRoute2.f());
                }
                if (partialRoute2 == null || !(partialRoute2.f() < d)) continue;
                Point point = ((Direction)object).boundaryPoint(edgeRouteInfo.startRect());
                Point point2 = direction2.boundaryPoint(edgeRouteInfo.endRect());
                partialRoute = partialRoute2.complete(point, point2, direction2.getReverse());
                d = partialRoute2.f();
                object2 = object;
                direction = direction2;
            }
        }
        if (partialRoute == null) {
            return null;
        }
        ((int[])edgeRouteInfo.getEdge().getFrom().getInfo())[((Direction)object2).getIndex()] = 1;
        ((int[])edgeRouteInfo.getEdge().getTo().getInfo())[direction.getIndex()] = -1;
        for (PartialRoute partialRoute3 = partialRoute; partialRoute3 != null; partialRoute3 = partialRoute3.getParent()) {
            partialRoute3.getNode().setInfo((Double)partialRoute3.getNode().getInfo() + 1.0);
            object = partialRoute3.getIncident();
            if (object == null) continue;
            ((Link)object).setWeight(((Link)object).getWeight() + 1.0);
        }
        object = partialRoute.asShape(edgeRouteInfo.getEdge().getRow(), this.useCurves ? this.curveRadius : 0.0, this.adapter);
        ((Shape)object).setKey(edgeRouteInfo.getEdge().getFrom().getShape().getKey() + "|" + edgeRouteInfo.getEdge().getTo().getShape().getKey());
        return object;
    }

    private double calculateEndLocationCost(Link link, Direction direction, Direction direction2) {
        double d = 0.0;
        int n = ((int[])link.getFrom().getInfo())[direction.getIndex()];
        int n2 = ((int[])link.getTo().getInfo())[direction2.getIndex()];
        if (n != 0) {
            d += n > 0 ? this.cost_coincide : this.cost_inconsistent;
        }
        if (n2 != 0) {
            d += n2 > 0 ? this.cost_inconsistent : this.cost_coincide;
        }
        return d;
    }

    private PartialRoute route(DirectedNode directedNode, DirectedNode directedNode2, double d, double d2) {
        boolean[] blArray = new boolean[this.visibility.directedNodeCount];
        boolean[] blArray2 = new boolean[this.visibility.directedNodeCount];
        double[] dArray = new double[this.visibility.directedNodeCount];
        this.queue.clear();
        PartialRoute partialRoute = PartialRoute.makeInitial(directedNode, d, this.heuristicCostEstimate(directedNode, directedNode2));
        this.queue.insert(partialRoute, partialRoute.f());
        blArray[partialRoute.getDirectedNode().index] = true;
        dArray[partialRoute.getDirectedNode().index] = d;
        while (!this.queue.isEmpty()) {
            DirectedNode[] directedNodeArray;
            PartialRoute partialRoute2 = this.queue.pop();
            DirectedNode directedNode3 = partialRoute2.getDirectedNode();
            if (partialRoute2.f() >= d2) {
                return null;
            }
            if (directedNode3.node() == directedNode2.node()) {
                return partialRoute2;
            }
            blArray[directedNode3.index] = false;
            blArray2[directedNode3.index] = true;
            if (this.debug > 3) {
                System.out.println("  .. " + partialRoute2.toString());
            }
            if ((directedNodeArray = this.neighbors[directedNode3.index]) == null) {
                directedNodeArray = this.calculateNeighbors(directedNode3);
            }
            for (DirectedNode directedNode4 : directedNodeArray) {
                double d3;
                double d4 = partialRoute2.getG() + directedNode4.segmentLength();
                if (directedNode4.dir() != partialRoute2.getDir()) {
                    d4 += this.cost_bend;
                }
                d4 += directedNode4.incident().getWeight() * this.cost_coincide;
                double d5 = (d4 += (Double)directedNode4.node().getInfo() * this.cost_cross) + (d3 = this.heuristicCostEstimate(directedNode4, directedNode2));
                if (d5 >= d2) continue;
                double d6 = dArray[directedNode4.index];
                if (blArray2[directedNode4.index] && d5 >= d6 || blArray[directedNode4.index] && !(d5 < d6)) continue;
                PartialRoute partialRoute3 = partialRoute2.extend(directedNode4, d4, d3);
                dArray[directedNode4.index] = d5;
                this.queue.insert(partialRoute3, d5);
                blArray[directedNode4.index] = true;
            }
        }
        return null;
    }

    private DirectedNode[] calculateNeighbors(DirectedNode directedNode) {
        DirectedNode[] directedNodeArray;
        Direction direction = directedNode.dir().getReverse();
        for (DirectedNode directedNode2 : directedNodeArray = this.visibility.getNeighbors(directedNode)) {
            if (directedNode2.dir() != direction) continue;
            DirectedNode[] directedNodeArray2 = new DirectedNode[directedNodeArray.length - 1];
            int n = 0;
            for (int i = 0; i < directedNodeArray.length; ++i) {
                if (directedNodeArray[i].dir() == direction) continue;
                directedNodeArray2[n++] = directedNodeArray[i];
            }
            directedNodeArray = directedNodeArray2;
            break;
        }
        this.neighbors[directedNode.index] = directedNodeArray;
        return directedNodeArray;
    }

    private final double heuristicCostEstimate(DirectedNode directedNode, DirectedNode directedNode2) {
        double d = directedNode.node().orthogonalDistance(directedNode2.node());
        if (d < 1.0) {
            return directedNode.dir() == directedNode2.dir() ? 0.0 : this.cost_bend;
        }
        return d + this.cost_bend * (double)EdgeRouting.minimalBends(directedNode, directedNode2);
    }

    static int minimalBends(DirectedNode directedNode, DirectedNode directedNode2) {
        double d = directedNode2.node().getX() - directedNode.node().getX();
        double d2 = directedNode2.node().getY() - directedNode.node().getY();
        Direction direction = Direction.getDirectionForVector(d, d2);
        return minimalBendsArr[Math.abs(direction.getIndex()) * 16 + Math.abs(directedNode.dir().getIndex()) * 4 + Math.abs(directedNode2.dir().getIndex())];
    }

    private int[] orderEdgesByMinimalCost() {
        double[] dArray = new double[this.edgeInfo.length];
        for (int i = 0; i < dArray.length; ++i) {
            Link link = this.edgeInfo[i].getEdge();
            dArray[i] = this.getMinimalDistance(this.edgeInfo[i]) + 1.0E-6 * (double)i;
            if (link.getFrom().getX() == link.getTo().getX() || link.getFrom().getX() == link.getTo().getX()) continue;
            int n = i;
            dArray[n] = dArray[n] + this.cost_bend;
        }
        return BasicFactory.makeSortOrder(dArray);
    }

    private double getMinimalDistance(EdgeRouteInfo edgeRouteInfo) {
        double d = 9.0E99;
        for (Direction direction : edgeRouteInfo.startDirs()) {
            Point point = direction.boundaryPoint(edgeRouteInfo.startRect());
            for (Direction direction2 : edgeRouteInfo.endDirs()) {
                Point point2 = direction2.boundaryPoint(edgeRouteInfo.endRect());
                d = Math.min(d, point.distance(point2));
            }
        }
        return d;
    }

    @Override
    public Shape getLabelShape(Shape shape) {
        if (shape instanceof PolyShape) {
            PolyShape polyShape = (PolyShape)shape;
            int n = -1;
            double d = 0.0;
            for (int i = 1; i < polyShape.getXArray().length; ++i) {
                double d2 = Math.abs(polyShape.getXArray()[i] - polyShape.getXArray()[i - 1]) + Math.abs(polyShape.getYArray()[i] - polyShape.getYArray()[i - 1]);
                if (!(d2 > d)) continue;
                d = d2;
                n = i;
            }
            ShapeLine shapeLine = ShapeLine.make(polyShape.getXArray()[n - 1], polyShape.getYArray()[n - 1], polyShape.getXArray()[n], polyShape.getYArray()[n]);
            shapeLine.setID(shape.getID());
            shapeLine.copyInfoFrom(shape);
            return shapeLine;
        }
        return shape;
    }

    @Override
    public boolean respectsTransforms() {
        return false;
    }

    @Override
    public Dim getPreferredSize(int n) {
        return new Dim(0.0, 0.0);
    }

    public static double findMinimalDistance(Rect[] rectArray) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < rectArray.length; ++i) {
            for (int j = 0; j < i; ++j) {
                double d2 = rectArray[i].distance(rectArray[j]);
                if (!(d2 > 0.0)) continue;
                d = Math.min(d, d2);
            }
        }
        return d;
    }
}

