/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class Layout {
    protected final LayoutAdapter adapter;

    protected Layout(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
    }

    public final ShapeList buildLayout(int n, Dim dim, Rect rect) {
        if (dim == null) {
            dim = this.getPreferredSize(n);
        }
        List<Shape> list = this.makeElementShapes(n, dim);
        list = this.orientShapes(dim, list);
        List<Shape> list2 = this.makeNonElementShapes(dim);
        list2 = this.orientShapes(dim, list2);
        List<Shape> list3 = this.makeNonElementLabels(dim);
        list3 = this.orientShapes(dim, list3);
        ShapeList shapeList = new ShapeList();
        for (Shape shape : list2) {
            shapeList.addNonElementShape(shape);
        }
        for (Shape shape : list) {
            shapeList.addElementShape(shape);
        }
        for (Shape shape : list3) {
            shapeList.addNonElementShape(shape);
        }
        this.translateShapes(shapeList, rect);
        return shapeList;
    }

    public void prepareForNewRows(int n) {
    }

    protected void translateShapes(ShapeList shapeList, Rect rect) {
        List<Shape> list = shapeList.getAllShapes();
        for (Shape shape : list) {
            shape.affine(1.0, rect.getX(), 1.0, rect.getY(), true);
        }
    }

    public Dim getPreferredSize(int n) {
        return new Dim(400.0, 400.0);
    }

    public abstract List<Shape> makeElementShapes(int var1, Dim var2);

    public List<Shape> makeNonElementShapes(Dim dim) {
        return new ArrayList<Shape>();
    }

    public List<Shape> makeNonElementLabels(Dim dim) {
        return new ArrayList<Shape>();
    }

    public final LayoutAdapter getAdapter() {
        return this.adapter;
    }

    public boolean respectsTransforms() {
        return true;
    }

    public final List<Shape> orientShapes(Dim dim, List<Shape> list) {
        if (this.adapter.isOriented() && this.respectsTransforms()) {
            Iterator<Shape> iterator = list.iterator();
            while (iterator.hasNext()) {
                Shape shape;
                Shape shape2 = shape = iterator.next();
                if (this.adapter.isReflectY()) {
                    shape2.reflect(dim, true);
                }
                if (!this.adapter.isSwapXY()) continue;
                shape2.transpose(dim);
            }
        }
        return list;
    }

    public String getDefaultOrientation() {
        return null;
    }

    public boolean applyStyles(Shape shape) {
        return false;
    }

    public boolean applyLabels(Shape shape, ShapeList shapeList, boolean bl) {
        return false;
    }

    public Dim getDefaultShapeSize(Dim dim, int n) {
        double d = dim.getWidth() * dim.getHeight() / (double)n;
        double d2 = Math.round(Math.sqrt(d / 5.0));
        if (d2 < 10.0) {
            d2 = 10.0;
        } else if (d2 > 60.0) {
            d2 = 60.0;
        }
        return new Dim(d2, d2);
    }

    public boolean needsAestheticsPreApplied() {
        return false;
    }

    public boolean isGraph() {
        return false;
    }

    protected Rect getPaddedBounds(Dim dim) {
        if (this.getAdapter().getSpec().padding == null) {
            return new Rect(0.0, 0.0, dim.getWidth(), dim.getHeight());
        }
        Insets insets = Insets.makeForStylePadding(this.getAdapter().getSpec().padding, dim, dim);
        return insets.insetRectFromDimension(dim);
    }

    public Shape getLabelShape(Shape shape) {
        return shape;
    }
}

