/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.diagramService.internal.DiagramServiceDelegate;
import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.diagram.DefaultDiagramFactory;
import com.ibm.vis.engine.internal.extension.RAVEExtensionManager;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.layout.DefaultDiagramLayouts;
import com.ibm.vis.engine.internal.grammar.layout.DefaultLinkLayouts;
import com.ibm.vis.engine.internal.grammar.layout.DiagramLayout;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.RAVELayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.DefaultGraphLayouts;
import com.ibm.vis.engine.internal.grammar.layout.spiral.SpiralDiagramFactory;
import com.ibm.vis.engine.internal.grammar.layout.treemap.DefaultTreeMapLayouts;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.TargetedStyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LayoutFactory {
    public static synchronized Layout makeLayout(LayoutSpec layoutSpec, Data data, Grammar grammar, Vis vis, StyleSpec styleSpec, TargetedStyleSpec[] targetedStyleSpecArray) {
        if (layoutSpec == null) {
            return null;
        }
        LayoutAdapter layoutAdapter = LayoutFactory.makeAdapter(layoutSpec, data, grammar, vis, styleSpec, targetedStyleSpecArray);
        String string = layoutSpec.method;
        if (vis.getVisContext().getLogger().hasListeners()) {
            vis.getVisContext().getLogger().log(LogLevel.Info, LogComponent.CommonGrammar, "Creating layout", "method", string);
        }
        DefaultLinkLayouts.registerExtensions();
        DefaultGraphLayouts.registerExtensions();
        DefaultTreeMapLayouts.registerExtensions();
        DefaultDiagramLayouts.registerExtensions();
        DiagramServiceDelegate diagramServiceDelegate = DiagramServiceDelegate.getInstance();
        diagramServiceDelegate.register(new DefaultDiagramFactory());
        diagramServiceDelegate.register(new SpiralDiagramFactory());
        Layout layout = null;
        layout = layoutAdapter.getSpec().data != null && diagramServiceDelegate.supports(string) ? new DiagramLayout(layoutAdapter, string) : (Layout)RAVEExtensionManager.INSTANCE.newInstance(string, layoutAdapter);
        if (layout == null) {
            if (vis.getVisContext().getLogger().hasListeners()) {
                vis.getVisContext().getLogger().log(LogLevel.GrammarError, LogComponent.CommonGrammar, "Could not locate, access or construct layout", "method", string);
            }
            throw new IllegalStateException("Could not locate, access or construct layout " + string);
        }
        if (!layoutAdapter.isOriented()) {
            layoutAdapter.setOrientation(layout.getDefaultOrientation());
        }
        return layout;
    }

    private static LayoutAdapter makeAdapter(LayoutSpec layoutSpec, Data data, Grammar grammar, Vis vis, StyleSpec styleSpec, TargetedStyleSpec[] targetedStyleSpecArray) {
        RAVELayoutAdapter rAVELayoutAdapter = new RAVELayoutAdapter(layoutSpec, data, grammar, vis, styleSpec, targetedStyleSpecArray);
        if (!rAVELayoutAdapter.isOriented()) {
            Element element;
            Element[] elementArray = grammar.elements;
            int n = elementArray.length;
            for (int i = 0; !(i >= n || (element = elementArray[i]) != null && element.layout != null && rAVELayoutAdapter.copyOrientationFrom(element.layout.getAdapter())); ++i) {
            }
        }
        return rAVELayoutAdapter;
    }
}

