/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.grammar.layout.ConnectionPoint;
import com.ibm.vis.engine.internal.grammar.layout.ConnectionSide;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.ArrowType;
import com.ibm.vis.engine.internal.struct.Shape;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
final class LinkConnectionPoint {
    static final ConnectionPoint[] ALL_CONNECTION_POINTS;
    private final Shape from;
    private final Shape to;
    private final ConnectionPoint fromConnectionPoint;
    private final ConnectionPoint toConnectionPoint;

    public LinkConnectionPoint(Shape shape, Shape shape2, ConnectionPoint connectionPoint, ConnectionPoint connectionPoint2) {
        this.from = shape;
        this.to = shape2;
        this.fromConnectionPoint = connectionPoint;
        this.toConnectionPoint = connectionPoint2;
        assert (connectionPoint != null);
        assert (connectionPoint2 != null);
        assert (shape != null);
        assert (shape2 != null);
    }

    public final Shape getFrom() {
        return this.from;
    }

    public final Shape getTo() {
        return this.to;
    }

    public final ConnectionPoint getFromSide() {
        return this.fromConnectionPoint;
    }

    public final ConnectionPoint getToSide() {
        return this.toConnectionPoint;
    }

    public static boolean isFarSide(ConnectionSide connectionSide) {
        return connectionSide == ConnectionSide.RIGHT || connectionSide == ConnectionSide.BOTTOM;
    }

    public String toString() {
        return "[ " + this.from.getRows()[0] + " -> " + this.to.getRows()[0] + " ]" + this.fromConnectionPoint + " -> " + this.toConnectionPoint;
    }

    boolean isOnlyLinkOnSide(boolean bl, Map<Shape, Map<ConnectionPoint, Integer>> map) {
        Shape shape = bl ? this.getFrom() : this.getTo();
        ConnectionSide connectionSide = bl ? this.getFromSide().side : this.getToSide().side;
        Map<ConnectionPoint, Integer> map2 = map.get(shape);
        return LinkConnectionPoint.countTotalLinksOnSide(map2, connectionSide) == 1;
    }

    public static Map<ConnectionPoint, Integer> initCountMap(Map<Shape, Map<ConnectionPoint, Integer>> map, Shape shape) {
        Map<ConnectionPoint, Integer> map2 = map.get(shape);
        if (map2 == null) {
            map2 = new HashMap<ConnectionPoint, Integer>();
            for (ConnectionPoint connectionPoint : ALL_CONNECTION_POINTS) {
                map2.put(connectionPoint, 0);
            }
            map.put(shape, map2);
        }
        return map2;
    }

    public void updateCounts(Map<Shape, Map<ConnectionPoint, Integer>> map) {
        Map<ConnectionPoint, Integer> map2 = LinkConnectionPoint.initCountMap(map, this.from);
        Map<ConnectionPoint, Integer> map3 = LinkConnectionPoint.initCountMap(map, this.to);
        Integer n = map2.get(this.fromConnectionPoint);
        map2.put(this.fromConnectionPoint, n + 1);
        Integer n2 = map3.get(this.toConnectionPoint);
        map3.put(this.toConnectionPoint, n2 + 1);
    }

    public static int countDifferentLinkTypesAt(Map<ConnectionPoint, Integer> map, ConnectionSide connectionSide) {
        int n = 0;
        for (ConnectionPoint connectionPoint : ALL_CONNECTION_POINTS) {
            if (connectionPoint.side != connectionSide || map.get(connectionPoint) <= 0) continue;
            ++n;
        }
        return n;
    }

    public static int countTotalLinksOnSide(Map<ConnectionPoint, Integer> map, ConnectionSide connectionSide) {
        int n = 0;
        for (ConnectionPoint connectionPoint : ALL_CONNECTION_POINTS) {
            if (connectionPoint.side != connectionSide) continue;
            n += map.get(connectionPoint).intValue();
        }
        return n;
    }

    public static int determineIndexOfUsedType(Map<ConnectionPoint, Integer> map, ConnectionPoint connectionPoint) {
        int n = 0;
        for (ConnectionPoint connectionPoint2 : ALL_CONNECTION_POINTS) {
            if (connectionPoint2.side != connectionPoint.side || map.get(connectionPoint2) <= 0) continue;
            if (connectionPoint2.arrowStyle == connectionPoint.arrowStyle) {
                return n;
            }
            ++n;
        }
        return n;
    }

    static {
        int n;
        ConnectionSide[] connectionSideArray = new ConnectionSide[]{ConnectionSide.LEFT, ConnectionSide.RIGHT, ConnectionSide.TOP, ConnectionSide.BOTTOM};
        ArrowType[] arrowTypeArray = new ArrowType[ArrowType.ArrowTypes.length + 1];
        arrowTypeArray[ArrowType.ArrowTypes.length] = null;
        for (n = 0; n < ArrowType.ArrowTypes.length; ++n) {
            arrowTypeArray[n] = ArrowType.ArrowTypes[n];
        }
        ALL_CONNECTION_POINTS = new ConnectionPoint[connectionSideArray.length * arrowTypeArray.length];
        n = 0;
        for (ConnectionSide connectionSide : connectionSideArray) {
            for (ArrowType arrowType : arrowTypeArray) {
                LinkConnectionPoint.ALL_CONNECTION_POINTS[n] = new ConnectionPoint(connectionSide, arrowType);
                ++n;
            }
        }
    }
}

