/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.layout.ConnectionPoint;
import com.ibm.vis.engine.internal.grammar.layout.ConnectionSide;
import com.ibm.vis.engine.internal.grammar.layout.DimUtil;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.LinkConnectionPoint;
import com.ibm.vis.engine.internal.grammar.layout.LinkLayoutEdgeBuilder;
import com.ibm.vis.engine.internal.grammar.layout.LinkLength;
import com.ibm.vis.engine.internal.grammar.layout.LinkLengthComparator;
import com.ibm.vis.engine.internal.grammar.layout.SharedLayoutInfo;
import com.ibm.vis.engine.internal.grammar.layout.graph.LinkGroup;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.ArrowGeom;
import com.ibm.vis.engine.internal.struct.ArrowType;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.AttachmentPointsSpec;
import com.ibm.vis.spec.internal.ConnectionPointSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/graphLayoutsLayer")
public class LinkLayout
extends Layout {
    private final String idField;
    private final String fromField;
    private final String toField;
    private Dim extent;
    private int rowCount;
    private Map<Double, Shape> nodeShapes;
    private Map<Shape, List<Shape>> nodeMap;
    private final Map<Shape, Map<ConnectionPoint, Integer>> connectionCountMap;
    private final Map<Shape, List<Shape>> inLayerDirectLinks;
    private LinkConnectionPoint[] linkDetails;
    private ArrowType[][] linkArrowHeadStylePerRow;
    private boolean needArrowHeadOffset;
    private final Shape dummyPathToBeStyled;
    private final String attachPointOnNodes;
    private final LayoutSpec layoutSpec;
    protected static final String ATTACH_CENTER = "center";
    protected static final String ATTACH_CLOSEST = "closestPoint";

    public LinkLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        this.layoutSpec = layoutAdapter.getSpec();
        this.idField = this.layoutSpec.id == null ? null : this.layoutSpec.id.$ref;
        this.fromField = this.layoutSpec.from == null ? null : this.layoutSpec.from.$ref;
        String string = this.toField = this.layoutSpec.to == null ? null : this.layoutSpec.to.$ref;
        this.attachPointOnNodes = this.layoutSpec.attachmentPoint != null ? (BasicFactory.isString(this.layoutSpec.attachmentPoint) ? (String)this.layoutSpec.attachmentPoint : null) : ATTACH_CLOSEST;
        this.nodeShapes = new HashMap<Double, Shape>();
        this.nodeMap = new HashMap<Shape, List<Shape>>();
        this.inLayerDirectLinks = new HashMap<Shape, List<Shape>>();
        this.connectionCountMap = new HashMap<Shape, Map<ConnectionPoint, Integer>>();
        this.dummyPathToBeStyled = new Path(null, null, false, null);
        this.needArrowHeadOffset = false;
    }

    @Override
    public boolean respectsTransforms() {
        return false;
    }

    @Override
    public void prepareForNewRows(int n) {
        this.connectionCountMap.clear();
        this.nodeMap.clear();
        this.nodeShapes.clear();
        this.inLayerDirectLinks.clear();
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        Shape shape;
        Shape shape2;
        this.extent = dim;
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        this.nodeShapes = this.adapter.getElementItems(this.idField);
        this.rowCount = n;
        this.populateNodeMap();
        boolean bl = this.adapter.getSharedLayoutInfo().getGraphLayerRanges() != null;
        ArrayList<LinkLength> arrayList2 = new ArrayList<LinkLength>();
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            double d = this.adapter.getFieldNumericValue(this.fromField, i);
            double d2 = this.adapter.getFieldNumericValue(this.toField, i);
            if (Double.isNaN(d) || Double.isNaN(d2) || this.adapter.isLinkPruned(d, d2)) continue;
            shape2 = this.nodeShapes.get(d);
            shape = this.nodeShapes.get(d2);
            if (bl && this.itemsOnSameLayer(shape2, shape)) {
                double d3 = shape2.getCenter().distance(shape.getCenter());
                arrayList2.add(new LinkLength(i, d3));
                continue;
            }
            Shape shape3 = this.makeLinkItem(shape2, shape, i);
            if (shape3 == null) continue;
            boolean bl3 = bl2 = shape3.getSymbol() != null && shape3.getSymbol().indexOf("lbow") >= 0;
            if (bl2) {
                Number number = this.adapter.getSharedLayoutInfo().getRoutingGroupType(shape2.getRows()[0], shape.getRows()[0]);
                Shape shape4 = this.makeElbowLink(shape3, d, d2, number);
                arrayList.add(shape4);
                continue;
            }
            arrayList.add(shape3);
        }
        BasicFactory.sortList(arrayList2, new LinkLengthComparator());
        if (bl && !arrayList2.isEmpty()) {
            for (LinkLength linkLength : arrayList2) {
                Double d = this.adapter.getFieldNumericValue(this.fromField, linkLength.getValue());
                Double d4 = this.adapter.getFieldNumericValue(this.toField, linkLength.getValue());
                Shape shape5 = this.nodeShapes.get((double)d);
                shape = this.makeHorizontalLinkPath(shape5, shape2 = this.nodeShapes.get((double)d4), linkLength.getValue());
                if (shape == null) continue;
                arrayList.add(shape);
            }
        }
        return arrayList;
    }

    private Shape makeElbowLink(Shape shape, Number number, Number number2, Number number3) {
        double d;
        ArrowGeom arrowGeom;
        if (shape.getType() != 1002) {
            return shape;
        }
        Path path = (Path)shape;
        int n = path.getXArray().length;
        boolean bl = shape.getSymbol().indexOf("urved") >= 0;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ArrayList<Character> arrayList2 = new ArrayList<Character>();
        arrayList.add(new Point(path.getXArray()[0], path.getYArray()[0]));
        arrayList2.add(Character.valueOf(path.getTypes()[0]));
        if (path.getStartArrowName() != null && path.getPreferHorizontal() != null) {
            double d2;
            arrowGeom = this.getArrowGeom(path.getStartArrow());
            if (path.getPreferHorizontal().booleanValue()) {
                d2 = Math.min(arrowGeom.getLength(), Math.abs(path.getXArray()[1] - path.getXArray()[0]));
                double[] dArray = path.getXArray();
                dArray[0] = dArray[0] + (path.getXArray()[1] > path.getXArray()[0] ? d2 : -d2);
            } else {
                d2 = Math.min(arrowGeom.getLength(), Math.abs(path.getYArray()[1] - path.getYArray()[0]));
                double[] dArray = path.getYArray();
                dArray[0] = dArray[0] + (path.getYArray()[1] > path.getYArray()[0] ? d2 : -d2);
            }
        }
        Point point = new Point(path.getXArray()[n - 1], path.getYArray()[n - 1]);
        if (path.getEndArrowName() != null && path.getPreferHorizontal() != null) {
            arrowGeom = this.getArrowGeom(path.getEndArrow());
            double d3 = Math.min(arrowGeom.getLength(), Math.abs(path.getXArray()[n - 1] - path.getXArray()[n - 2]));
            d = Math.min(arrowGeom.getLength(), Math.abs(path.getYArray()[n - 1] - path.getYArray()[n - 2]));
            if (path.getPreferHorizontal().booleanValue() || d == 0.0) {
                double[] dArray = path.getXArray();
                int n2 = n - 1;
                dArray[n2] = dArray[n2] - (path.getXArray()[n - 1] > path.getXArray()[n - 2] ? d3 : -d3);
            } else {
                double[] dArray = path.getYArray();
                int n3 = n - 1;
                dArray[n3] = dArray[n3] - (path.getYArray()[n - 1] > path.getYArray()[n - 2] ? d : -d);
            }
        }
        for (int i = 1; i < n; ++i) {
            boolean bl2;
            boolean bl3 = false;
            d = Math.abs(path.getXArray()[i] - path.getXArray()[i - 1]);
            double d4 = Math.abs(path.getYArray()[i] - path.getYArray()[i - 1]);
            boolean bl4 = bl2 = d < 1.0 || d4 < 1.0;
            boolean bl5 = path.getPreferHorizontal() == null ? d > d4 : path.getPreferHorizontal();
            Point point2 = this.getCenterPoint(path, i, number, number2, number3);
            double d5 = Double.NaN;
            if (number3 != null) {
                d5 = number3.doubleValue();
            }
            double d6 = point2.getX();
            double d7 = point2.getY();
            if (bl && !bl2) {
                if (bl5) {
                    if (d4 <= d) {
                        arrayList.add(new Point(d6, path.getYArray()[i - 1]));
                        arrayList.add(new Point(d6, d7));
                        arrayList.add(new Point(d6, path.getYArray()[i]));
                        arrayList2.add(Character.valueOf('Q'));
                        arrayList2.add(Character.valueOf(','));
                        arrayList2.add(Character.valueOf('Q'));
                        bl3 = true;
                    } else {
                        double d8 = path.getYArray()[i] > path.getYArray()[i - 1] ? d / 2.0 : -d / 2.0;
                        arrayList.add(new Point(d6, path.getYArray()[i - 1]));
                        arrayList.add(new Point(d6, path.getYArray()[i - 1] + d8));
                        arrayList.add(new Point(d6, path.getYArray()[i] - d8));
                        arrayList.add(new Point(d6, path.getYArray()[i]));
                        arrayList2.add(Character.valueOf('Q'));
                        arrayList2.add(Character.valueOf(','));
                        arrayList2.add(Character.valueOf('L'));
                        arrayList2.add(Character.valueOf('Q'));
                        bl3 = true;
                    }
                } else if (d <= d4) {
                    arrayList.add(new Point(path.getXArray()[i - 1], d7));
                    arrayList.add(new Point(d6, d7));
                    arrayList.add(new Point(path.getXArray()[i], d7));
                    arrayList2.add(Character.valueOf('Q'));
                    arrayList2.add(Character.valueOf(','));
                    arrayList2.add(Character.valueOf('Q'));
                    bl3 = true;
                } else {
                    double d9 = path.getXArray()[i] > path.getXArray()[i - 1] ? d4 / 2.0 : -d4 / 2.0;
                    arrayList.add(new Point(path.getXArray()[i - 1], d7));
                    arrayList.add(new Point(path.getXArray()[i - 1] + d9, d7));
                    arrayList.add(new Point(path.getXArray()[i] - d9, d7));
                    arrayList.add(new Point(path.getXArray()[i], d7));
                    arrayList2.add(Character.valueOf('Q'));
                    arrayList2.add(Character.valueOf(','));
                    arrayList2.add(Character.valueOf('L'));
                    arrayList2.add(Character.valueOf('Q'));
                    bl3 = true;
                }
            } else if (!bl2) {
                arrayList2.add(Character.valueOf('L'));
                arrayList2.add(Character.valueOf('L'));
                if (bl5) {
                    if (LinkGroup.OFFSET_LAYOUT == d5 && i == 1) {
                        arrayList.add(new Point(path.getXArray()[i - 1], path.getYArray()[i]));
                    } else {
                        arrayList.add(new Point(d6, path.getYArray()[i - 1]));
                        arrayList.add(new Point(d6, path.getYArray()[i]));
                    }
                } else if (LinkGroup.OFFSET_LAYOUT == d5 && i == 1) {
                    arrayList.add(new Point(path.getXArray()[i], path.getYArray()[i - 1]));
                } else {
                    arrayList.add(new Point(path.getXArray()[i - 1], d7));
                    arrayList.add(new Point(path.getXArray()[i], d7));
                }
            }
            if (i == n - 1) {
                arrayList.add(point);
            } else {
                arrayList.add(new Point(path.getXArray()[i], path.getYArray()[i]));
            }
            char c = bl3 ? (char)',' : 'L';
            arrayList2.add(Character.valueOf(c));
        }
        n = arrayList.size();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = ((Character)arrayList2.get(i)).charValue();
            Point point3 = (Point)arrayList.get(i);
            dArray[i] = point3.getX();
            dArray2[i] = point3.getY();
        }
        Shape shape2 = this.adapter.makeItemFromPath(dArray, dArray2, cArray, path.isFilled(), path.getRows()[0]);
        this.setEdgeProperties(shape2, path.getRows()[0]);
        return shape2;
    }

    private ArrowGeom getArrowGeom(ArrowType arrowType) {
        ArrowGeom arrowGeom = new ArrowGeom(arrowType);
        arrowGeom.configForStrokeWidth(null);
        return arrowGeom;
    }

    private Point getCenterPoint(Path path, int n, Number number, Number number2, Number number3) {
        Range[] rangeArray;
        SharedLayoutInfo sharedLayoutInfo;
        double d = (path.getXArray()[n] + path.getXArray()[n - 1]) / 2.0;
        double d2 = (path.getYArray()[n] + path.getYArray()[n - 1]) / 2.0;
        double d3 = Double.NaN;
        if (number3 != null) {
            d3 = number3.doubleValue();
        }
        if (LinkGroup.NORMAL_LAYOUT == d3) {
            if (n == 1 && path.getXArray().length == 3) {
                if (this.adapter.isSwapXY()) {
                    d = (path.getXArray()[2] + path.getXArray()[0]) / 2.0;
                } else {
                    d2 = (path.getYArray()[2] + path.getYArray()[0]) / 2.0;
                }
            } else if (n == 2 && path.getXArray().length == 4) {
                if (this.adapter.isSwapXY()) {
                    d = (path.getXArray()[3] + path.getXArray()[1]) / 2.0;
                } else {
                    d2 = (path.getYArray()[3] + path.getYArray()[1]) / 2.0;
                }
            }
        }
        if (path.getXArray().length == 2 && !(sharedLayoutInfo = this.adapter.getSharedLayoutInfo()).isManuallyPositioned(number.intValue()) && !sharedLayoutInfo.isManuallyPositioned(number2.intValue()) && (rangeArray = sharedLayoutInfo.getGraphLayerRanges()) != null) {
            HashMap<Number, Integer> hashMap = sharedLayoutInfo.getLayerIndexMap();
            Range range = rangeArray[hashMap.get(number)];
            double d4 = range.getMin();
            if (!this.adapter.isCenteredLayerPlacement()) {
                d4 += range.getRange() * 0.2;
            }
            if (this.adapter.isSwapXY()) {
                if (this.adapter.isReflectY()) {
                    d = path.getXArray()[n - 1] < path.getXArray()[n] ? (1.0 - d4) * this.extent.getWidth() : (1.0 - range.getMax()) * this.extent.getWidth();
                    d += this.adapter.getLayoutBoundsStartPoint().getX();
                } else {
                    d = path.getXArray()[n - 1] < path.getXArray()[n] ? range.getMax() * this.extent.getWidth() : d4 * this.extent.getWidth();
                    d += this.adapter.getLayoutBoundsStartPoint().getX();
                }
            } else if (this.adapter.isReflectY()) {
                d2 = path.getYArray()[n - 1] < path.getYArray()[n] ? range.getMax() * this.extent.getHeight() : d4 * this.extent.getHeight();
                d2 += this.adapter.getLayoutBoundsStartPoint().getY();
            } else {
                d2 = path.getYArray()[n - 1] < path.getYArray()[n] ? (1.0 - d4) * this.extent.getHeight() : (1.0 - range.getMax()) * this.extent.getHeight();
                d2 += this.adapter.getLayoutBoundsStartPoint().getY();
            }
        }
        return new Point(d, d2);
    }

    private Shape makeLinkItem(Shape shape, Shape shape2, int n) {
        Shape shape3;
        if (shape == null || shape2 == null) {
            return null;
        }
        if (shape == shape2) {
            shape3 = this.makeSelfLink(shape, n);
        } else {
            shape3 = this.adapter.isOriented() ? this.makeVerticalLinkPath(shape, shape2, n) : this.makeSimplePath(shape, shape2, n);
            this.setEdgeProperties(shape3, n);
        }
        return shape3;
    }

    public void setEdgeProperties(Shape shape, int n) {
        PolyShape polyShape = (PolyShape)shape;
        Boolean bl = this.adapter.isOriented() ? Boolean.valueOf(this.adapter.isSwapXY()) : null;
        StyleSpec styleSpec = this.adapter.getStyle();
        Object object = styleSpec == null ? null : styleSpec.symbol;
        String string = BasicFactory.isString(object) ? (String)object : null;
        String string2 = styleSpec == null ? null : styleSpec.startArrow;
        String string3 = styleSpec == null ? null : styleSpec.endArrow;
        polyShape.setEdgeProperties(bl, string, string2, string3);
        polyShape.setRow(n);
    }

    private Shape makeHorizontalLinkPath(Shape shape, Shape shape2, int n) {
        SharedLayoutInfo sharedLayoutInfo = this.adapter.getSharedLayoutInfo();
        boolean bl = sharedLayoutInfo.isManuallyPositioned(shape.getRows()[0]) || sharedLayoutInfo.isManuallyPositioned(shape2.getRows()[0]);
        Point[] pointArray = sharedLayoutInfo.getRoutingInfo(shape.getRows()[0], shape2.getRows()[0]);
        boolean bl2 = pointArray.length == 0;
        int n2 = bl2 ? 2 : 3;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        char[] cArray = new char[n2];
        LinkConnectionPoint linkConnectionPoint = this.linkDetails[n];
        Point point = this.connectionPointFrom(linkConnectionPoint, this.connectionCountMap);
        Point point2 = this.connectionPointTo(linkConnectionPoint, this.connectionCountMap);
        cArray[0] = 77;
        dArray[0] = point.getX();
        dArray2[0] = point.getY();
        cArray[n2 - 1] = 76;
        dArray[n2 - 1] = point2.getX();
        dArray2[n2 - 1] = point2.getY();
        if (!bl2) {
            double d = this.calculateOffset(pointArray, linkConnectionPoint);
            boolean bl3 = LinkConnectionPoint.isFarSide(linkConnectionPoint.getFromSide().side);
            Point point3 = this.adapter.isSwapXY() ? (bl3 ? new Point(shape.getBounds().getX2() + d, (shape.getCenter().getY() + shape2.getCenter().getY()) / 2.0) : new Point(shape.getBounds().getX() - d, (shape.getCenter().getY() + shape2.getCenter().getY()) / 2.0)) : (bl3 ? new Point((shape.getCenter().getX() + shape2.getCenter().getX()) / 2.0, shape.getBounds().getY2() + d) : new Point((shape.getCenter().getX() + shape2.getCenter().getX()) / 2.0, shape.getBounds().getY() - d));
            dArray[1] = point3.getX();
            dArray2[1] = point3.getY();
            cArray[1] = 76;
        }
        LinkLayoutEdgeBuilder linkLayoutEdgeBuilder = new LinkLayoutEdgeBuilder(this.adapter);
        return linkLayoutEdgeBuilder.makeInLayerLink(dArray, dArray2, cArray, n, bl);
    }

    private double calculateOffset(Point[] pointArray, LinkConnectionPoint linkConnectionPoint) {
        double d;
        assert (Double.isNaN(pointArray[0].getX()));
        Shape shape = linkConnectionPoint.getFrom();
        SharedLayoutInfo sharedLayoutInfo = this.adapter.getSharedLayoutInfo();
        Rect rect = sharedLayoutInfo.getPaddedBounds();
        double d2 = pointArray[0].getY();
        if (this.adapter.isSwapXY()) {
            d = (linkConnectionPoint.getFrom().getCenter().getX() - rect.getX()) / rect.getWidth();
            if (this.adapter.isReflectY()) {
                d = 1.0 - d;
            }
        } else {
            d = (linkConnectionPoint.getFrom().getCenter().getY() - rect.getY()) / rect.getHeight();
            if (!this.adapter.isReflectY()) {
                d = 1.0 - d;
            }
        }
        int n = this.findLayerIndexForPosition(sharedLayoutInfo.getGraphLayerRanges(), d);
        Range range = sharedLayoutInfo.getGraphLayerRanges()[n];
        double d3 = sharedLayoutInfo.getIntraLayerLinkLevelCount(n);
        double d4 = this.adapter.isSwapXY() ? range.getRange() * rect.getWidth() - shape.getBounds().getWidth() : range.getRange() * rect.getHeight() - shape.getBounds().getHeight();
        if (range.getMin() == 0.0) {
            d4 += this.adapter.isSwapXY() ? rect.getX() : rect.getY();
        } else if (range.getMax() == 1.0) {
            d4 += this.adapter.isSwapXY() ? this.extent.getWidth() - (rect.getX() + rect.getWidth()) : this.extent.getHeight() - (rect.getY() + rect.getHeight());
        }
        double d5 = this.arrowHeadSize();
        double d6 = 1.5 * d5;
        double d7 = (d4 -= 1.5 * this.getStrokeWidthFromStyle()) / 2.0 - d6;
        return d7 * d2 / d3 + d6;
    }

    public static double getGoodSpaceToFit(int n, double d, double d2) {
        double d3 = Math.max(8.0, d2 * 4.2);
        return ((double)n * d2 * 2.0 + d3) / d;
    }

    private int findLayerIndexForPosition(Range[] rangeArray, double d) {
        for (int i = 0; i < rangeArray.length; ++i) {
            if (!rangeArray[i].contains(d)) continue;
            return i;
        }
        return -1;
    }

    private double getStrokeWidthFromStyle() {
        StyleSpec styleSpec;
        double d = 1.0;
        StyleSpec styleSpec2 = styleSpec = this.adapter.getStyle() != null ? this.adapter.getStyle() : new StyleSpec();
        if (styleSpec.stroke != null) {
            if (BasicFactory.isNumber(styleSpec.stroke.width)) {
                d = ((Number)styleSpec.stroke.width).doubleValue();
            } else if (BasicFactory.isString(styleSpec.stroke.width)) {
                double d2 = 1.0;
                d = UnitConverter.convertLength(styleSpec.stroke.width, d2, this.extent.getHeight());
            }
        }
        return d;
    }

    private double arrowHeadSize() {
        if (this.needArrowHeadOffset) {
            return Math.max(8.0, this.getStrokeWidthFromStyle() * 4.2);
        }
        return 0.0;
    }

    private Shape makeVerticalLinkPath(Shape shape, Shape shape2, int n) {
        Point[] pointArray = this.adapter.getSharedLayoutInfo().getRoutingInfo(shape.getRows()[0], shape2.getRows()[0]);
        Number number = this.adapter.getSharedLayoutInfo().getRoutingGroupType(shape.getRows()[0], shape2.getRows()[0]);
        int n2 = 2 + pointArray.length;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        char[] cArray = new char[n2];
        LinkConnectionPoint linkConnectionPoint = this.linkDetails[n];
        Point point = this.connectionPointFrom(linkConnectionPoint, this.connectionCountMap);
        Point point2 = this.connectionPointTo(linkConnectionPoint, this.connectionCountMap);
        dArray[0] = point.getX();
        dArray2[0] = point.getY();
        cArray[0] = 77;
        dArray[n2 - 1] = point2.getX();
        dArray2[n2 - 1] = point2.getY();
        cArray[n2 - 1] = 76;
        Rect rect = this.getPaddedBounds(this.extent);
        for (int i = 0; i < pointArray.length; ++i) {
            Point point3;
            if (number != null && this.adapter.isSwapXY()) {
                point3 = new Point(DimUtil.fromBoundedXCoord(pointArray[i].getY(), rect), DimUtil.fromBoundedYCoord(pointArray[i].getX(), rect));
                dArray[i + 1] = rect.getWidth() - point3.getX();
                dArray2[i + 1] = rect.getHeight() - point3.getY();
            } else {
                point3 = new Point(DimUtil.fromBoundedXCoord(pointArray[i].getX(), rect), DimUtil.fromBoundedYCoord(pointArray[i].getY(), rect));
                dArray[i + 1] = point3.getX();
                dArray2[i + 1] = point3.getY();
            }
            int n3 = i + 1;
            dArray[n3] = dArray[n3] + this.adapter.getLayoutBoundsStartPoint().getX();
            int n4 = i + 1;
            dArray2[n4] = dArray2[n4] + this.adapter.getLayoutBoundsStartPoint().getY();
            cArray[i + 1] = 76;
        }
        return this.adapter.makeItemFromPath(dArray, dArray2, cArray, false, n);
    }

    private static Range computeRange(Point[] pointArray, boolean bl) {
        Range range = null;
        range = bl ? new Range(pointArray[0].getY(), pointArray[1].getY()) : new Range(pointArray[0].getX(), pointArray[1].getX());
        return range;
    }

    protected Point getClosestPointOnAttachExtent(Point[] pointArray, Point point) {
        if (this.adapter.isSwapXY()) {
            if (this.isAttachmentPointAtNodeCenter()) {
                return new Point(pointArray[0].getX(), (pointArray[0].getY() + pointArray[1].getY()) / 2.0);
            }
            if (pointArray[1].getY() < point.getY()) {
                return pointArray[1];
            }
            if (pointArray[0].getY() > point.getY()) {
                return pointArray[0];
            }
            return new Point(pointArray[0].getX(), point.getY());
        }
        if (this.isAttachmentPointAtNodeCenter()) {
            return new Point((pointArray[0].getX() + pointArray[1].getX()) / 2.0, pointArray[0].getY());
        }
        if (pointArray[1].getX() < point.getX()) {
            return pointArray[1];
        }
        if (pointArray[0].getX() > point.getX()) {
            return pointArray[0];
        }
        return new Point(point.getX(), pointArray[0].getY());
    }

    private boolean isAttachmentPointAtNodeCenter() {
        return ATTACH_CENTER.equals(this.attachPointOnNodes);
    }

    protected final boolean isCurvedSymbol() {
        StyleSpec styleSpec = this.adapter.getStyle();
        return styleSpec == null || styleSpec.symbol == null ? false : "curved".equals(styleSpec.symbol) || "curvedElbow".equals(styleSpec.symbol);
    }

    private boolean itemsOnSameLayer(Shape shape, Shape shape2) {
        double d;
        double d2;
        double d3;
        double d4;
        if (shape == null || shape2 == null || shape == shape2 || !this.adapter.isOriented()) {
            return false;
        }
        boolean bl = false;
        SharedLayoutInfo sharedLayoutInfo = this.adapter.getSharedLayoutInfo();
        if (sharedLayoutInfo != null) {
            int[] nArray = shape.getRows();
            if (nArray != null && nArray.length > 0) {
                bl = sharedLayoutInfo.isManuallyPositioned(nArray[0]);
            }
            if (!bl && (nArray = shape2.getRows()) != null && nArray.length > 0) {
                bl = sharedLayoutInfo.isManuallyPositioned(nArray[0]);
            }
        }
        if (bl) {
            if (this.isCurvedSymbol()) {
                d4 = 0.25;
                d3 = this.needArrowHeadOffset ? (d3 = 2.1 * this.arrowHeadSize() + this.getStrokeWidthFromStyle()) : 0.0;
            } else {
                d4 = 0.5;
                d3 = 2.1 * this.arrowHeadSize() + this.getStrokeWidthFromStyle();
            }
        } else {
            d4 = 0.25;
            d3 = 0.0;
        }
        boolean bl2 = this.adapter.isSwapXY() ? (d2 = Math.abs(shape.getCenter().getX() - shape2.getCenter().getX())) < d4 * (shape.getBounds().getWidth() + shape2.getBounds().getWidth()) + d3 : (d = Math.abs(shape.getCenter().getY() - shape2.getCenter().getY())) < d4 * (shape.getBounds().getHeight() + shape2.getBounds().getHeight()) + d3;
        return bl2;
    }

    private Shape makeSimplePath(Shape shape, Shape shape2, int n) {
        Point point = this.connectionPointFrom(this.linkDetails[n], this.connectionCountMap);
        Point point2 = this.connectionPointTo(this.linkDetails[n], this.connectionCountMap);
        Point[] pointArray = this.adapter.getSharedLayoutInfo().getRoutingInfo(shape.getRows()[0], shape2.getRows()[0]);
        int n2 = 2 + pointArray.length;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        char[] cArray = new char[n2];
        dArray[0] = point.getX();
        dArray2[0] = point.getY();
        cArray[0] = 77;
        Rect rect = this.getPaddedBounds(this.extent);
        for (int i = 0; i < pointArray.length; ++i) {
            dArray[i + 1] = DimUtil.fromBoundedXCoord(pointArray[i].getX(), rect);
            dArray2[i + 1] = DimUtil.fromBoundedYCoord(pointArray[i].getY(), rect);
            cArray[i + 1] = 76;
        }
        dArray[n2 - 1] = point2.getX();
        dArray2[n2 - 1] = point2.getY();
        cArray[n2 - 1] = 76;
        return this.adapter.makeItemFromPath(dArray, dArray2, cArray, false, n);
    }

    private Shape makeSelfLink(Shape shape, int n) {
        Number number;
        Rect rect = shape.getBounds();
        double d = this.arrowHeadSize();
        double d2 = Math.min(rect.getWidth(), rect.getHeight()) / 2.0;
        if (d2 < 10.0) {
            d2 = 10.0;
        }
        if ((number = this.adapter.getSharedLayoutInfo().getSelfLinkRadius()) != null) {
            d2 = Math.min(d2, number.doubleValue());
        }
        LinkConnectionPoint linkConnectionPoint = this.linkDetails[n];
        Point point = this.connectionPointFrom(linkConnectionPoint, this.connectionCountMap);
        Point point2 = this.connectionPointTo(linkConnectionPoint, this.connectionCountMap);
        LinkLayoutEdgeBuilder linkLayoutEdgeBuilder = new LinkLayoutEdgeBuilder(this.adapter);
        return linkLayoutEdgeBuilder.makeSelfLink(point, point2, d2, d, n);
    }

    private void populateNodeMap() {
        Object object;
        Object object2;
        int n;
        this.nodeMap = new HashMap<Shape, List<Shape>>();
        this.linkDetails = new LinkConnectionPoint[this.rowCount];
        this.linkArrowHeadStylePerRow = new ArrowType[this.rowCount][];
        ArrowType arrowType = this.defaultArrowHeadStyle(false);
        ArrowType arrowType2 = this.defaultArrowHeadStyle(true);
        this.needArrowHeadOffset = arrowType != null || arrowType2 != null;
        for (n = 0; n < this.rowCount; ++n) {
            double d = this.adapter.getFieldNumericValue(this.fromField, n);
            if (Double.isNaN(d)) continue;
            object2 = this.nodeShapes.get(d);
            double d2 = this.adapter.getFieldNumericValue(this.toField, n);
            if (Double.isNaN(d2)) continue;
            object = this.nodeShapes.get(d2);
            this.dummyPathToBeStyled.setEndArrowByName(arrowType == null ? ArrowType.NONE : arrowType.getName());
            this.dummyPathToBeStyled.setStartArrowByName(arrowType2 == null ? ArrowType.NONE : arrowType2.getName());
            Shape shape = this.adapter.getStyledShape(this.fromField, this.dummyPathToBeStyled, n);
            this.linkArrowHeadStylePerRow[n] = new ArrowType[2];
            this.linkArrowHeadStylePerRow[n][0] = ArrowType.byName(shape.getStartArrowName());
            this.linkArrowHeadStylePerRow[n][1] = ArrowType.byName(shape.getEndArrowName());
            if (this.linkArrowHeadStylePerRow[n][0] != null || this.linkArrowHeadStylePerRow[n][1] != null) {
                this.needArrowHeadOffset = true;
            }
            if (object2 == null || object == null) continue;
            List<Object> list = new ArrayList<Object>();
            if (this.nodeMap.containsKey(object2)) {
                list = this.nodeMap.get(object2);
            }
            list.add(object);
            this.nodeMap.put((Shape)object2, list);
            list = new ArrayList();
            if (this.nodeMap.containsKey(object)) {
                list = this.nodeMap.get(object);
            }
            list.add(object2);
            this.nodeMap.put((Shape)object, list);
            if (!this.itemsOnSameLayer((Shape)object2, (Shape)object) || this.adapter.getSharedLayoutInfo().getRoutingInfo(((Shape)object2).getRows()[0], ((Shape)object).getRows()[0]).length != 0) continue;
            List<Shape> list2 = this.inLayerDirectLinks.get(object2);
            if (list2 == null) {
                list2 = new ArrayList<Shape>();
            }
            list2.add((Shape)object);
            this.inLayerDirectLinks.put((Shape)object2, list2);
        }
        for (n = 0; n < this.rowCount; ++n) {
            Double d = this.adapter.getFieldNumericValue(this.fromField, n);
            Shape shape = this.getConnectionPointOnNode(d, n, true);
            object2 = this.adapter.getFieldNumericValue(this.toField, n);
            Shape shape2 = this.getConnectionPointOnNode((Number)object2, n, false);
            if (shape != null && shape2 != null) {
                ArrowType arrowType3 = this.linkArrowHeadStylePerRow[n][0];
                object = this.linkArrowHeadStylePerRow[n][1];
                this.linkDetails[n] = this.populateLinkSideMap(shape, shape2, arrowType3, (ArrowType)object, this.connectionCountMap, this.inLayerDirectLinks);
                continue;
            }
            this.linkDetails[n] = null;
        }
    }

    private ArrowType defaultArrowHeadStyle(boolean bl) {
        StyleSpec styleSpec = this.adapter.getStyle();
        if (styleSpec != null) {
            String string = bl ? styleSpec.startArrow : styleSpec.endArrow;
            return ArrowType.byName(string);
        }
        return null;
    }

    protected LinkConnectionPoint populateLinkSideMap(Shape shape, Shape shape2, ArrowType arrowType, ArrowType arrowType2, Map<Shape, Map<ConnectionPoint, Integer>> map, Map<Shape, List<Shape>> map2) {
        assert (shape != null);
        assert (shape2 != null);
        LinkConnectionPoint linkConnectionPoint = this.determineConnectionPointLocation(shape, shape2, arrowType, arrowType2, map, map2);
        linkConnectionPoint.updateCounts(map);
        return linkConnectionPoint;
    }

    private LinkConnectionPoint determineConnectionPointLocation(Shape shape, Shape shape2, ArrowType arrowType, ArrowType arrowType2, Map<Shape, Map<ConnectionPoint, Integer>> map, Map<Shape, List<Shape>> map2) {
        List<Shape> list = map2.get(shape);
        Map<ConnectionPoint, Integer> map3 = LinkConnectionPoint.initCountMap(map, shape);
        boolean bl = this.isOffsetTreeLayout(shape, shape2);
        ConnectionSide connectionSide = ConnectionSide.BOTTOM;
        ConnectionSide connectionSide2 = ConnectionSide.TOP;
        Number number = this.adapter.getSharedLayoutInfo().getRoutingGroupType(shape.getRows()[0], shape2.getRows()[0]);
        double d = Double.NaN;
        if (number != null) {
            d = number.doubleValue();
        }
        if (this.adapter.isSwapXY()) {
            if (!this.adapter.isReflectY()) {
                if (shape == shape2) {
                    connectionSide = ConnectionSide.RIGHT;
                    connectionSide2 = ConnectionSide.TOP;
                } else if (list != null && list.contains(shape2)) {
                    if (shape.getCenter().getY() > shape2.getCenter().getY()) {
                        connectionSide = ConnectionSide.TOP;
                        connectionSide2 = ConnectionSide.BOTTOM;
                    } else {
                        connectionSide = ConnectionSide.BOTTOM;
                        connectionSide2 = ConnectionSide.TOP;
                    }
                } else if (this.itemsOnSameLayer(shape, shape2)) {
                    int n;
                    int n2 = LinkConnectionPoint.countTotalLinksOnSide(map3, ConnectionSide.LEFT);
                    if (n2 > (n = LinkConnectionPoint.countTotalLinksOnSide(map3, ConnectionSide.RIGHT))) {
                        connectionSide = ConnectionSide.RIGHT;
                        connectionSide2 = ConnectionSide.RIGHT;
                    } else {
                        connectionSide = ConnectionSide.LEFT;
                        connectionSide2 = ConnectionSide.LEFT;
                    }
                } else {
                    Point point = shape.getCenter();
                    Point point2 = shape2.getCenter();
                    if (point.getX() < point2.getX()) {
                        connectionSide2 = ConnectionSide.LEFT;
                        connectionSide = bl ? (point.getY() < point2.getY() ? ConnectionSide.BOTTOM : ConnectionSide.TOP) : ConnectionSide.RIGHT;
                    } else {
                        connectionSide2 = ConnectionSide.RIGHT;
                        connectionSide = bl ? (point.getY() < point2.getY() ? ConnectionSide.BOTTOM : ConnectionSide.TOP) : ConnectionSide.LEFT;
                    }
                    if (LinkGroup.STACK_LAYOUT == d) {
                        connectionSide2 = ConnectionSide.TOP;
                    }
                }
            } else if (shape == shape2) {
                connectionSide = ConnectionSide.LEFT;
                connectionSide2 = ConnectionSide.TOP;
            } else if (list != null && list.contains(shape2)) {
                if (shape.getCenter().getY() > shape2.getCenter().getY()) {
                    connectionSide = ConnectionSide.TOP;
                    connectionSide2 = ConnectionSide.BOTTOM;
                } else {
                    connectionSide = ConnectionSide.BOTTOM;
                    connectionSide2 = ConnectionSide.TOP;
                }
            } else if (this.itemsOnSameLayer(shape, shape2)) {
                int n;
                int n3 = LinkConnectionPoint.countTotalLinksOnSide(map3, ConnectionSide.LEFT);
                if (n3 >= (n = LinkConnectionPoint.countTotalLinksOnSide(map3, ConnectionSide.RIGHT))) {
                    connectionSide = ConnectionSide.RIGHT;
                    connectionSide2 = ConnectionSide.RIGHT;
                } else {
                    connectionSide = ConnectionSide.LEFT;
                    connectionSide2 = ConnectionSide.LEFT;
                }
            } else {
                Point point = shape.getCenter();
                Point point3 = shape2.getCenter();
                if (point.getX() < point3.getX()) {
                    connectionSide2 = ConnectionSide.LEFT;
                    connectionSide = bl ? (point.getY() < point3.getY() ? ConnectionSide.BOTTOM : ConnectionSide.TOP) : ConnectionSide.RIGHT;
                } else {
                    connectionSide2 = ConnectionSide.RIGHT;
                    connectionSide = bl ? (point.getY() < point3.getY() ? ConnectionSide.BOTTOM : ConnectionSide.TOP) : ConnectionSide.LEFT;
                }
                if (LinkGroup.STACK_LAYOUT == d) {
                    connectionSide2 = ConnectionSide.TOP;
                }
            }
        } else if (this.adapter.isReflectY()) {
            if (shape == shape2) {
                connectionSide = ConnectionSide.TOP;
                connectionSide2 = ConnectionSide.RIGHT;
            } else if (list != null && list.contains(shape2)) {
                if (shape.getCenter().getX() < shape2.getCenter().getX()) {
                    connectionSide = ConnectionSide.RIGHT;
                    connectionSide2 = ConnectionSide.LEFT;
                } else {
                    connectionSide = ConnectionSide.LEFT;
                    connectionSide2 = ConnectionSide.RIGHT;
                }
            } else if (this.itemsOnSameLayer(shape, shape2)) {
                int n;
                int n4 = LinkConnectionPoint.countTotalLinksOnSide(map3, ConnectionSide.TOP);
                if (n4 >= (n = LinkConnectionPoint.countTotalLinksOnSide(map3, ConnectionSide.BOTTOM))) {
                    connectionSide = ConnectionSide.BOTTOM;
                    connectionSide2 = ConnectionSide.BOTTOM;
                } else {
                    connectionSide = ConnectionSide.TOP;
                    connectionSide2 = ConnectionSide.TOP;
                }
            } else {
                Point point = shape.getCenter();
                Point point4 = shape2.getCenter();
                if (point.getY() < point4.getY()) {
                    connectionSide2 = ConnectionSide.TOP;
                    connectionSide = bl ? (point.getX() > point4.getX() ? ConnectionSide.LEFT : ConnectionSide.RIGHT) : ConnectionSide.BOTTOM;
                } else {
                    connectionSide2 = ConnectionSide.BOTTOM;
                    connectionSide = bl ? (point.getX() > point4.getX() ? ConnectionSide.LEFT : ConnectionSide.RIGHT) : ConnectionSide.TOP;
                }
                if (LinkGroup.STACK_LAYOUT == d) {
                    connectionSide2 = ConnectionSide.LEFT;
                }
            }
        } else if (shape == shape2) {
            connectionSide = ConnectionSide.BOTTOM;
            connectionSide2 = ConnectionSide.RIGHT;
        } else if (list != null && list.contains(shape2)) {
            if (shape.getCenter().getX() < shape2.getCenter().getX()) {
                connectionSide = ConnectionSide.RIGHT;
                connectionSide2 = ConnectionSide.LEFT;
            } else {
                connectionSide = ConnectionSide.LEFT;
                connectionSide2 = ConnectionSide.RIGHT;
            }
        } else if (this.itemsOnSameLayer(shape, shape2)) {
            int n;
            int n5 = LinkConnectionPoint.countTotalLinksOnSide(map3, ConnectionSide.TOP);
            if (n5 > (n = LinkConnectionPoint.countTotalLinksOnSide(map3, ConnectionSide.BOTTOM))) {
                connectionSide = ConnectionSide.BOTTOM;
                connectionSide2 = ConnectionSide.BOTTOM;
            } else {
                connectionSide = ConnectionSide.TOP;
                connectionSide2 = ConnectionSide.TOP;
            }
        } else {
            Point point = shape.getCenter();
            Point point5 = shape2.getCenter();
            if (point.getY() < point5.getY()) {
                connectionSide2 = ConnectionSide.TOP;
                connectionSide = bl ? (point.getX() > point5.getX() ? ConnectionSide.LEFT : ConnectionSide.RIGHT) : ConnectionSide.BOTTOM;
            } else {
                connectionSide2 = ConnectionSide.BOTTOM;
                connectionSide = bl ? (point.getX() > point5.getX() ? ConnectionSide.LEFT : ConnectionSide.RIGHT) : ConnectionSide.TOP;
            }
            if (LinkGroup.STACK_LAYOUT == d) {
                connectionSide2 = ConnectionSide.LEFT;
            }
        }
        ConnectionPoint connectionPoint = new ConnectionPoint(connectionSide, arrowType);
        ConnectionPoint connectionPoint2 = new ConnectionPoint(connectionSide2, arrowType2);
        return new LinkConnectionPoint(shape, shape2, connectionPoint, connectionPoint2);
    }

    boolean isOffsetTreeLayout(Shape shape, Shape shape2) {
        Number number = this.adapter.getSharedLayoutInfo().getRoutingGroupType(shape.getRows()[0], shape2.getRows()[0]);
        boolean bl = false;
        if (number != null) {
            bl = LinkGroup.OFFSET_LAYOUT == number.doubleValue();
        }
        return bl;
    }

    protected boolean useCenterPointForConnection(boolean bl) {
        if (this.attachPointOnNodes == null) {
            if (this.layoutSpec.attachmentPoint != null && !BasicFactory.isString(this.layoutSpec.attachmentPoint)) {
                ConnectionPointSpec connectionPointSpec;
                AttachmentPointsSpec attachmentPointsSpec = (AttachmentPointsSpec)this.layoutSpec.attachmentPoint;
                ConnectionPointSpec connectionPointSpec2 = connectionPointSpec = bl ? attachmentPointsSpec.outPoint : attachmentPointsSpec.inPoint;
                if (connectionPointSpec != null) {
                    return true;
                }
            }
        } else {
            return this.isAttachmentPointAtNodeCenter();
        }
        return false;
    }

    protected Point connectionPoint(boolean bl, LinkConnectionPoint linkConnectionPoint, Map<Shape, Map<ConnectionPoint, Integer>> map) {
        ConnectionPoint connectionPoint;
        Point point = null;
        Shape shape = linkConnectionPoint.getFrom();
        Shape shape2 = linkConnectionPoint.getTo();
        Shape shape3 = bl ? linkConnectionPoint.getFrom() : linkConnectionPoint.getTo();
        Shape shape4 = !bl ? linkConnectionPoint.getFrom() : linkConnectionPoint.getTo();
        ConnectionPoint connectionPoint2 = connectionPoint = bl ? linkConnectionPoint.getFromSide() : linkConnectionPoint.getToSide();
        if (this.adapter.isOriented()) {
            boolean bl2;
            Map<ConnectionPoint, Integer> map2 = map.get(shape3);
            boolean bl3 = !this.useCenterPointForConnection(bl);
            int n = LinkConnectionPoint.countDifferentLinkTypesAt(map2, connectionPoint.side);
            int n2 = LinkConnectionPoint.determineIndexOfUsedType(map2, connectionPoint);
            Number number = this.adapter.getSharedLayoutInfo().getRoutingGroupType(shape.getRows()[0], shape2.getRows()[0]);
            double d = Double.NaN;
            if (number != null) {
                d = number.doubleValue();
            }
            double d2 = 0.0;
            if (bl && LinkGroup.STACK_LAYOUT == d && this.adapter.getSharedLayoutInfo().getSpecialStackGroupInfo(shape.getRows()[0], shape2.getRows()[0]).booleanValue()) {
                double d3 = 10.0;
                d3 = this.adapter.isSwapXY() ? (d3 /= shape.getBounds().getHeight()) : (d3 /= shape.getBounds().getWidth());
                d2 = this.adapter.isReflectY() ? 1.0 - d3 : d3;
            }
            point = connectionPoint.determinePoint(shape3.getBounds(), n, n2, d2);
            boolean bl4 = bl2 = n == 1;
            if (bl3 && bl2 && !this.itemsOnSameLayer(shape, shape2)) {
                Point[] pointArray = this.adapter.getSharedLayoutInfo().getRoutingInfo(shape.getRows()[0], shape2.getRows()[0]);
                ConnectionPoint connectionPoint3 = bl ? linkConnectionPoint.getToSide() : linkConnectionPoint.getFromSide();
                Point[] pointArray2 = this.adapter.getAttachExtent(shape3, LinkConnectionPoint.isFarSide(connectionPoint.side), this.extent);
                if (shape == shape2) {
                    if (bl) {
                        Rect rect = shape.getBounds();
                        Point point2 = rect.getCenter();
                        switch (connectionPoint3.side) {
                            case RIGHT: {
                                point2 = new Point(rect.getX2(), rect.getY());
                                break;
                            }
                            case LEFT: {
                                point2 = new Point(rect.getX(), rect.getY2());
                                break;
                            }
                            case TOP: {
                                point2 = new Point(rect.getX2(), rect.getY());
                                break;
                            }
                            case BOTTOM: {
                                point2 = new Point(rect.getX(), rect.getY2());
                                break;
                            }
                        }
                        point = this.getClosestPointOnAttachExtent(pointArray2, point2);
                    }
                } else {
                    boolean bl5;
                    Point[] pointArray3 = this.adapter.getAttachExtent(shape4, LinkConnectionPoint.isFarSide(connectionPoint3.side), this.extent);
                    int n3 = LinkConnectionPoint.countTotalLinksOnSide(map2, connectionPoint.side);
                    boolean bl6 = n3 == 1;
                    boolean bl7 = bl5 = pointArray.length == 0;
                    if (bl5) {
                        Range range = LinkLayout.computeRange(pointArray2, this.adapter.isSwapXY());
                        Range range2 = LinkLayout.computeRange(pointArray3, this.adapter.isSwapXY());
                        if (this.adapter.isSwapXY()) {
                            if (range.containsRange(range2)) {
                                point = new Point(pointArray2[0].getX(), (range2.getMin() + range2.getMax()) / 2.0);
                            } else if (range2.containsRange(range)) {
                                point = new Point(pointArray2[0].getX(), (range.getMin() + range.getMax()) / 2.0);
                            } else if (pointArray2[1].getY() <= pointArray3[0].getY()) {
                                if (pointArray2[0].getY() >= pointArray3[0].getY() && pointArray2[0].getY() <= pointArray3[1].getY()) {
                                    point = new Point(pointArray2[0].getX(), (pointArray3[0].getY() + pointArray2[0].getY()) / 2.0);
                                } else if (!bl6) {
                                    point = this.getClosestPointOnAttachExtent(pointArray2, shape4.getCenter());
                                }
                            } else if (pointArray2[1].getY() >= pointArray3[0].getY()) {
                                if (pointArray2[1].getY() > pointArray3[0].getY() && pointArray2[1].getY() < pointArray3[1].getY()) {
                                    point = new Point(pointArray2[0].getX(), (pointArray3[0].getY() + pointArray2[1].getY()) / 2.0);
                                } else if (pointArray3[1].getY() > pointArray2[0].getY() && pointArray3[1].getY() < pointArray2[1].getY()) {
                                    point = new Point(pointArray2[0].getX(), (pointArray3[0].getY() + pointArray2[1].getY()) / 2.0);
                                } else if (!bl6) {
                                    point = this.getClosestPointOnAttachExtent(pointArray2, shape4.getCenter());
                                }
                            }
                        } else if (range.containsRange(range2)) {
                            point = new Point((range2.getMin() + range2.getMax()) / 2.0, pointArray2[0].getY());
                        } else if (range2.containsRange(range)) {
                            point = new Point((range.getMin() + range.getMax()) / 2.0, pointArray2[0].getY());
                        } else if (pointArray2[0].getX() > pointArray3[0].getX()) {
                            if (pointArray2[0].getX() >= pointArray3[0].getX() && pointArray2[0].getX() <= pointArray3[1].getX()) {
                                point = new Point((pointArray2[0].getX() + pointArray3[1].getX()) / 2.0, pointArray2[0].getY());
                            } else if (!bl6) {
                                point = this.getClosestPointOnAttachExtent(pointArray2, shape4.getCenter());
                            }
                        } else if (pointArray2[0].getX() < pointArray3[0].getX()) {
                            if (pointArray2[1].getX() >= pointArray3[0].getX() && pointArray2[1].getX() <= pointArray3[1].getX()) {
                                point = new Point((pointArray2[1].getX() + pointArray3[0].getX()) / 2.0, pointArray2[1].getY());
                            } else if (!bl6) {
                                point = this.getClosestPointOnAttachExtent(pointArray2, shape4.getCenter());
                            }
                        }
                    } else {
                        Rect rect = this.getPaddedBounds(this.extent);
                        int n4 = bl ? 0 : pointArray.length - 1;
                        Point point3 = new Point(DimUtil.fromBoundedXCoord(pointArray[n4].getX(), rect), DimUtil.fromBoundedYCoord(pointArray[n4].getY(), rect));
                        point = this.getClosestPointOnAttachExtent(pointArray2, point3);
                    }
                }
            }
        } else if (shape2 == shape) {
            Rect rect = shape.getBounds();
            point = bl ? this.adapter.getAttachPoint(shape, new Point(rect.getCenter().getX(), rect.getY2()), this.extent) : this.adapter.getAttachPoint(shape, new Point(rect.getX2(), rect.getCenter().getY()), this.extent);
        } else {
            point = this.adapter.getAttachPoint(shape3, shape4.getCenter(), this.extent);
        }
        return point;
    }

    @Override
    public Dim getPreferredSize(int n) {
        return new Dim(0.0, 0.0);
    }

    private Point connectionPointFrom(LinkConnectionPoint linkConnectionPoint, Map<Shape, Map<ConnectionPoint, Integer>> map) {
        return this.connectionPoint(true, linkConnectionPoint, map);
    }

    private Point connectionPointTo(LinkConnectionPoint linkConnectionPoint, Map<Shape, Map<ConnectionPoint, Integer>> map) {
        return this.connectionPoint(false, linkConnectionPoint, map);
    }

    protected String getConnectionPointName(boolean bl, int n) {
        if (this.layoutSpec.attachmentPoint != null && this.layoutSpec.attachmentPoint instanceof AttachmentPointsSpec) {
            AttachmentPointsSpec attachmentPointsSpec = (AttachmentPointsSpec)this.layoutSpec.attachmentPoint;
            ConnectionPointSpec connectionPointSpec = null;
            connectionPointSpec = bl ? attachmentPointsSpec.outPoint : attachmentPointsSpec.inPoint;
            if (connectionPointSpec != null) {
                if (connectionPointSpec.field == null && connectionPointSpec.value == null) {
                    throw new SpecException("A link attachmentPoint has to be specified either as a field or as a value.", ErrorCode.SPEC_INVALID_VALUE, null);
                }
                if (connectionPointSpec.field != null && connectionPointSpec.value != null) {
                    throw new SpecException("A link attachmentPoint can specified either as a field or as a value, never as both ", ErrorCode.SPEC_INVALID_VALUE, null);
                }
                if (connectionPointSpec.field != null) {
                    String string = this.adapter.getFieldStringValue(connectionPointSpec.field.$ref, n);
                    if (string == null) {
                        throw new SpecException("Cannot find the link attachmentPoint refered by field '" + connectionPointSpec.field.$ref + "'", ErrorCode.SPEC_INVALID_VALUE, null);
                    }
                    return string;
                }
                return connectionPointSpec.value;
            }
        }
        return null;
    }

    protected static Shape fetchConnectionPointFromNodeShape(Shape shape, String string) {
        Schema schema;
        Shape shape2;
        assert (string != null);
        if (shape instanceof Schema && (shape2 = (schema = (Schema)shape).fetchPartByName(string)) != null) {
            return shape2;
        }
        throw new SpecException("Cannot find a connection point shape with the part name = '" + string + "'", ErrorCode.SPEC_INVALID_VALUE, null);
    }

    protected Shape getConnectionPointOnNode(Number number, int n, boolean bl) {
        if (number == null) {
            return null;
        }
        Shape shape = this.nodeShapes.get(number.doubleValue());
        String string = this.getConnectionPointName(bl, n);
        if (shape != null && string != null) {
            return LinkLayout.fetchConnectionPointFromNodeShape(shape, string);
        }
        return shape;
    }

    @Override
    protected void translateShapes(ShapeList shapeList, Rect rect) {
    }
}

