/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Point;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
final class LinkLayoutEdgeBuilder {
    private static final String SYMBOL_CURVED = "curved";
    private static final String SYMBOL_ELBOW = "elbow";
    private final LayoutAdapter adapter;

    public LinkLayoutEdgeBuilder(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
    }

    private Shape makeElbowInLayerLink(double[] dArray, double[] dArray2, int n) {
        double[] dArray3;
        double[] dArray4;
        int n2 = dArray.length - 1;
        char[] cArray = new char[]{'M', 'L', 'L', 'L'};
        if (this.adapter.isSwapXY()) {
            double[] dArray5 = new double[]{dArray[0], dArray[1], dArray[n2 - 1], dArray[n2]};
            double[] dArray6 = new double[]{dArray2[0], dArray2[0], dArray2[n2], dArray2[n2]};
            dArray4 = dArray5;
            dArray3 = dArray6;
        } else {
            double[] dArray7 = new double[]{dArray[0], dArray[0], dArray[n2], dArray[n2]};
            double[] dArray8 = new double[]{dArray2[0], dArray2[1], dArray2[n2 - 1], dArray2[n2]};
            dArray4 = dArray7;
            dArray3 = dArray8;
        }
        return this.adapter.makeItemFromPath(dArray4, dArray3, cArray, false, n);
    }

    public Shape makeInLayerLink(double[] dArray, double[] dArray2, char[] cArray, int n, boolean bl) {
        Shape shape;
        boolean bl2;
        StyleSpec styleSpec = this.adapter.getStyle();
        String string = styleSpec == null || bl ? null : (BasicFactory.isString(styleSpec.symbol) ? (String)styleSpec.symbol : null);
        boolean bl3 = !this.adapter.isSwapXY();
        boolean bl4 = bl2 = dArray.length == 2;
        if (bl2) {
            shape = this.adapter.makeItemFromPath(dArray, dArray2, cArray, false, n);
        } else if (string != null && string.indexOf(SYMBOL_ELBOW) > -1) {
            shape = this.makeElbowInLayerLink(dArray, dArray2, n);
            bl3 = !bl3;
        } else if (string != null && string.indexOf(SYMBOL_CURVED) > -1) {
            shape = this.makeCurvedInLayerLink(dArray, dArray2, n);
            bl3 = !bl3;
        } else {
            shape = this.adapter.makeItemFromPath(dArray, dArray2, cArray, false, n);
        }
        PolyShape polyShape = (PolyShape)shape;
        String string2 = styleSpec == null ? null : styleSpec.startArrow;
        String string3 = styleSpec == null ? null : styleSpec.endArrow;
        polyShape.setEdgeProperties(bl3, string, string2, string3);
        return shape;
    }

    private Shape makeCurvedInLayerLink(double[] dArray, double[] dArray2, int n) {
        double[] dArray3;
        double[] dArray4;
        int n2 = dArray.length - 1;
        char[] cArray = new char[]{'M', 'L', 'Q', ',', 'L', 'Q', ',', 'L'};
        if (this.adapter.isSwapXY()) {
            int n3;
            double d = (dArray[1] - dArray[0]) / 2.0;
            double d2 = dArray[1];
            double d3 = dArray2[0];
            double d4 = dArray2[n2];
            int n4 = n3 = d3 < d4 ? -1 : 1;
            if (dArray[0] < dArray[1]) {
                n3 *= -1;
            }
            double[] dArray5 = new double[]{dArray[0], d2 - d, d2, d2, d2, d2, d2 - d, dArray[n2]};
            double[] dArray6 = new double[]{d3, d3, d3, d3 + d * (double)n3, d4 - d * (double)n3, d4, d4, d4};
            dArray4 = dArray5;
            dArray3 = dArray6;
        } else {
            int n5;
            double d = (dArray2[1] - dArray2[0]) / 2.0;
            double d5 = dArray2[1];
            double d6 = dArray[0];
            double d7 = dArray[n2];
            int n6 = n5 = d6 < d7 ? -1 : 1;
            if (dArray2[0] < dArray2[1]) {
                n5 *= -1;
            }
            double[] dArray7 = new double[]{d6, d6, d6, d6 + d * (double)n5, d7 - d * (double)n5, d7, d7, d7};
            double[] dArray8 = new double[]{dArray2[0], d5 - d, d5, d5, d5, d5, d5 - d, dArray2[n2]};
            dArray4 = dArray7;
            dArray3 = dArray8;
        }
        return this.adapter.makeItemFromPath(dArray4, dArray3, cArray, false, n);
    }

    public Shape makeSelfLink(Point point, Point point2, double d, double d2, int n) {
        StyleSpec styleSpec = this.adapter.getStyle();
        if (styleSpec == null || styleSpec.symbol == null || !BasicFactory.isString(styleSpec.symbol) || ((String)styleSpec.symbol).indexOf(SYMBOL_CURVED) < 0) {
            return this.makeStraightSelfLink(point, point2, d, d2, n);
        }
        return this.makeCurvedSelfLink(point, point2, d, d2, n);
    }

    private Shape makeStraightSelfLink(Point point, Point point2, double d, double d2, int n) {
        Point[] pointArray = this.makeSelfLinkCorners(point, point2, d, d2 > d ? d2 : 0.0);
        double[] dArray = new double[]{point.getX(), pointArray[0].getX(), pointArray[1].getX(), pointArray[2].getX(), point2.getX()};
        double[] dArray2 = new double[]{point.getY(), pointArray[0].getY(), pointArray[1].getY(), pointArray[2].getY(), point2.getY()};
        return this.adapter.makeItemFromPath(dArray, dArray2, new char[]{'M', 'L', 'L', 'L', 'L'}, false, n);
    }

    private Shape makeCurvedSelfLink(Point point, Point point2, double d, double d2, int n) {
        Point[] pointArray = this.makeSelfLinkCorners(point, point2, d / 2.0, d2);
        double d3 = Math.min(pointArray[0].distance(pointArray[1]), pointArray[1].distance(pointArray[2])) / 2.0;
        d3 = Math.min(d3, point.distance(pointArray[0]) - d2);
        if ((d3 = Math.min(d3, point2.distance(pointArray[2]) - d2)) <= 0.0) {
            double[] dArray = new double[]{point.getX(), pointArray[0].getX(), pointArray[1].getX(), pointArray[2].getX(), point2.getX()};
            double[] dArray2 = new double[]{point.getY(), pointArray[0].getY(), pointArray[1].getY(), pointArray[2].getY(), point2.getY()};
            return this.adapter.makeItemFromPath(dArray, dArray2, new char[]{'M', 'L', 'L', 'L', 'L'}, false, n);
        }
        double[] dArray = new double[11];
        double[] dArray3 = new double[11];
        double[] dArray4 = new double[2];
        dArray[0] = point.getX();
        dArray3[0] = point.getY();
        LinkLayoutEdgeBuilder.getIntermediate(pointArray[0], point, d3, dArray4);
        dArray[1] = dArray4[0];
        dArray3[1] = dArray4[1];
        dArray[2] = pointArray[0].getX();
        dArray3[2] = pointArray[0].getY();
        LinkLayoutEdgeBuilder.getIntermediate(pointArray[0], pointArray[1], d3, dArray4);
        dArray[3] = dArray4[0];
        dArray3[3] = dArray4[1];
        LinkLayoutEdgeBuilder.getIntermediate(pointArray[1], pointArray[0], d3, dArray4);
        dArray[4] = dArray4[0];
        dArray3[4] = dArray4[1];
        dArray[5] = pointArray[1].getX();
        dArray3[5] = pointArray[1].getY();
        LinkLayoutEdgeBuilder.getIntermediate(pointArray[1], pointArray[2], d3, dArray4);
        dArray[6] = dArray4[0];
        dArray3[6] = dArray4[1];
        LinkLayoutEdgeBuilder.getIntermediate(pointArray[2], pointArray[1], d3, dArray4);
        dArray[7] = dArray4[0];
        dArray3[7] = dArray4[1];
        dArray[8] = pointArray[2].getX();
        dArray3[8] = pointArray[2].getY();
        LinkLayoutEdgeBuilder.getIntermediate(pointArray[2], point2, d3, dArray4);
        dArray[9] = dArray4[0];
        dArray3[9] = dArray4[1];
        dArray[10] = point2.getX();
        dArray3[10] = point2.getY();
        return this.adapter.makeItemFromPath(dArray, dArray3, new char[]{'M', 'L', 'Q', ',', 'L', 'Q', ',', 'L', 'Q', ',', 'L'}, false, n);
    }

    private static void getIntermediate(Point point, Point point2, double d, double[] dArray) {
        double d2;
        double d3;
        if (point.getX() == point2.getX()) {
            d3 = point.getX();
            d2 = point.getY() > point2.getY() ? point.getY() - d : point.getY() + d;
        } else {
            d2 = point.getY();
            d3 = point.getX() > point2.getX() ? point.getX() - d : point.getX() + d;
        }
        dArray[0] = d3;
        dArray[1] = d2;
    }

    private Point[] makeSelfLinkCorners(Point point, Point point2, double d, double d2) {
        double d3 = point.getX();
        double d4 = point.getY();
        double d5 = point2.getX();
        double d6 = point2.getY();
        Point[] pointArray = new Point[3];
        if (this.adapter.isSwapXY()) {
            if (this.adapter.isReflectY()) {
                pointArray[0] = new Point(d3 - d2 - d, d4);
                pointArray[1] = new Point(d3 - d2 - d, d6 - d2 - d);
                pointArray[2] = new Point(d5, d6 - d2 - d);
            } else {
                pointArray[0] = new Point(d3 + d2 + d, d4);
                pointArray[1] = new Point(d3 + d2 + d, d6 - d2 - d);
                pointArray[2] = new Point(d5, d6 - d2 - d);
            }
        } else if (this.adapter.isReflectY()) {
            pointArray[0] = new Point(d3, d4 - d2 - d);
            pointArray[1] = new Point(d5 + d2 + d, d4 - d2 - d);
            pointArray[2] = new Point(d5 + d2 + d, d6);
        } else {
            pointArray[0] = new Point(d3, d4 + d2 + d);
            pointArray[1] = new Point(d5 + d2 + d, d4 + d2 + d);
            pointArray[2] = new Point(d5 + d2 + d, d6);
        }
        return pointArray;
    }
}

