/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.grammar.layout.DirectedNode;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.Direction;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Point;
import java.util.ArrayList;

final class PartialRoute {
    private double g;
    private double h;
    private PartialRoute parent;
    private final DirectedNode directed;

    static PartialRoute makeInitial(DirectedNode directedNode, double d, double d2) {
        return new PartialRoute(directedNode, null, d, d2);
    }

    PartialRoute extend(DirectedNode directedNode, double d, double d2) {
        return new PartialRoute(directedNode, this, d, d2);
    }

    private PartialRoute(DirectedNode directedNode, PartialRoute partialRoute, double d, double d2) {
        assert (directedNode != null);
        this.directed = directedNode;
        this.parent = partialRoute;
        this.g = d;
        this.h = d2;
    }

    double f() {
        return this.g + this.h;
    }

    PartialRoute complete(Point point, Point point2, Direction direction) {
        PartialRoute partialRoute = this;
        while (partialRoute.parent != null) {
            partialRoute = partialRoute.parent;
        }
        partialRoute.parent = new PartialRoute(DirectedNode.makeDummy(point, Direction.UNKNOWN), null, 0.0, 0.0);
        return new PartialRoute(DirectedNode.makeDummy(point2, direction), this, this.g, this.h);
    }

    Shape asShape(int n, double d, LayoutAdapter layoutAdapter) {
        Object object;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ArrayList<Character> arrayList2 = new ArrayList<Character>();
        PartialRoute partialRoute = this;
        while (partialRoute != null) {
            arrayList2.add(0, Character.valueOf('L'));
            arrayList.add(0, partialRoute.getLocation());
            object = partialRoute.getDir();
            partialRoute = partialRoute.parent;
            while (partialRoute != null && partialRoute.getDir() == object) {
                partialRoute = partialRoute.parent;
            }
        }
        arrayList2.set(0, Character.valueOf('M'));
        this.addBends(arrayList, arrayList2, 2.0 * d);
        this.addBends(arrayList, arrayList2, d);
        object = new double[arrayList.size()];
        double[] dArray = new double[arrayList.size()];
        char[] cArray = new char[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            cArray[i] = arrayList2.get(i).charValue();
            Point point = arrayList.get(i);
            object[i] = point.getX();
            dArray[i] = point.getY();
        }
        return layoutAdapter.makeItemFromPath((double[])object, dArray, cArray, false, n);
    }

    private void addBends(ArrayList<Point> arrayList, ArrayList<Character> arrayList2, double d) {
        int n;
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        for (n = arrayList.size() - 2; n > 0; --n) {
            Point point = arrayList.get(n);
            if (arrayList2.get(n).charValue() == 'L' && arrayList2.get(n + 1).charValue() != 'L' || !(arrayList.get(n - 1).distance(point) > d) || !(arrayList.get(n + 1).distance(point) > d)) continue;
            intPrimitiveArrayList.add(n);
        }
        for (n = 0; n < intPrimitiveArrayList.size(); ++n) {
            int n2 = intPrimitiveArrayList.get(n);
            Point point = arrayList.get(n2 - 1);
            Point point2 = arrayList.get(n2);
            Point point3 = arrayList.get(n2 + 1);
            Direction direction = Direction.getDirectionForVector(point.getX() - point2.getX(), point.getY() - point2.getY());
            Direction direction2 = Direction.getDirectionForVector(point3.getX() - point2.getX(), point3.getY() - point2.getY());
            Point point4 = direction.offset(point2, d / 2.0);
            Point point5 = direction2.offset(point2, d / 2.0);
            arrayList.add(n2 + 1, point5);
            arrayList.add(n2, point4);
            arrayList2.add(n2 + 1, Character.valueOf(','));
            arrayList2.add(n2 + 1, Character.valueOf('Q'));
        }
    }

    final double getG() {
        return this.g;
    }

    final PartialRoute getParent() {
        return this.parent;
    }

    final DirectedNode getDirectedNode() {
        return this.directed;
    }

    final Node getNode() {
        return this.directed.node();
    }

    final Direction getDir() {
        return this.directed.dir();
    }

    final Point getLocation() {
        return new Point(this.directed.node().getX(), this.directed.node().getY());
    }

    final Link getIncident() {
        return this.directed.incident();
    }

    public String toString() {
        String string = this.g + "/" + this.h;
        PartialRoute partialRoute = this;
        while (partialRoute != null) {
            string = partialRoute.directed.toString() + ":" + string;
            partialRoute = partialRoute.parent;
        }
        return string;
    }
}

