/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.grammar.layout.PQHItem;

public class PriorityQueueHeap<T> {
    private PQHItem<T>[] items;
    private int last;

    public PriorityQueueHeap(int n) {
        this.items = new PQHItem[n];
        this.last = -1;
    }

    public void insert(T t, double d) {
        if (++this.last == this.items.length) {
            PQHItem[] pQHItemArray = new PQHItem[2 * this.last];
            for (int i = 0; i < this.last; ++i) {
                pQHItemArray[i] = this.items[i];
            }
            this.items = pQHItemArray;
        }
        this.items[this.last] = new PQHItem<T>(t, d);
        this.bubbleUp(this.last);
    }

    public T pop() {
        if (this.last < 0) {
            return null;
        }
        Object t = this.items[0].item;
        this.items[0] = this.items[this.last--];
        if (this.last >= 0) {
            this.bubbleDown(0);
        }
        return t;
    }

    private void bubbleUp(int n) {
        int n2;
        while ((n2 = (int)Math.floor((n - 1) / 2)) >= 0) {
            PQHItem<T> pQHItem = this.items[n];
            PQHItem<T> pQHItem2 = this.items[n2];
            if (pQHItem.priority >= pQHItem2.priority) {
                return;
            }
            this.items[n] = pQHItem2;
            this.items[n2] = pQHItem;
            n = n2;
        }
        return;
    }

    private void bubbleDown(int n) {
        while (true) {
            int n2;
            if ((n2 = 2 * n + 1) > this.last) {
                return;
            }
            if (n2 < this.last && this.items[n2 + 1].priority < this.items[n2].priority) {
                ++n2;
            }
            PQHItem<T> pQHItem = this.items[n];
            PQHItem<T> pQHItem2 = this.items[n2];
            if (!(pQHItem2.priority < pQHItem.priority)) break;
            this.items[n2] = pQHItem;
            this.items[n] = pQHItem2;
            n = n2;
        }
    }

    public boolean isEmpty() {
        return this.last < 0;
    }

    public void clear() {
        this.last = -1;
    }
}

