/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.ShapeMaker;
import com.ibm.vis.engine.internal.grammar.layout.SharedLayoutInfo;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.TargetedStyleSpec;
import com.ibm.vis.spec.internal.TransformSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class RAVELayoutAdapter
implements LayoutAdapter {
    private final LayoutSpec spec;
    private final StyleSpec style;
    private final TargetedStyleSpec[] styles;
    private final Data data;
    private final Grammar grammar;
    private final Vis vis;
    private Row[] rows;
    private ShapeMaker builder;
    private final Object pad;
    private Dim elementSize;
    private Point layoutStartPoint;
    private int elementIndex;
    private final ArrayList<LabelProducer> labelProducers;
    private boolean oriented;
    private boolean swapXY;
    private boolean reflectY;
    private boolean centeredLayerPlacement;
    private Set<Double> prunedNodesSet;
    private Set<String> prunedEdgesSet;

    public RAVELayoutAdapter(LayoutSpec layoutSpec, Data data, Grammar grammar, Vis vis, StyleSpec styleSpec, TargetedStyleSpec[] targetedStyleSpecArray) {
        this.spec = layoutSpec;
        this.data = data;
        this.grammar = grammar;
        this.vis = vis;
        this.style = styleSpec;
        this.styles = targetedStyleSpecArray;
        this.layoutStartPoint = new Point(0.0, 0.0);
        this.pad = styleSpec == null ? null : styleSpec.padding;
        this.labelProducers = new ArrayList();
        this.setOrientation(layoutSpec.orientation);
        this.setPrunedNodesAndEdges();
    }

    @Override
    public SharedLayoutInfo getSharedLayoutInfo() {
        return this.grammar.getSharedLayoutInfo();
    }

    private void setPrunedNodesAndEdges() {
        Number[] numberArray = this.spec.prunedNodes;
        Number[][] numberArray2 = this.spec.prunedEdges;
        if (numberArray != null && numberArray.length > 0) {
            this.prunedNodesSet = new HashSet<Double>();
            for (Number number : numberArray) {
                if (number == null) continue;
                this.prunedNodesSet.add(number.doubleValue());
            }
        }
        if (numberArray2 != null && numberArray2.length > 0) {
            this.prunedEdgesSet = new HashSet<String>();
            for (int i = 0; i < numberArray2.length; ++i) {
                String string;
                if (numberArray2[i] == null || (string = this.makeEdge(numberArray2[i][0], numberArray2[i][1])) == null) continue;
                this.prunedEdgesSet.add(string);
            }
        }
    }

    @Override
    public void setOrientation(String string) {
        if (string == null) {
            this.oriented = false;
            this.reflectY = false;
            this.swapXY = false;
            return;
        }
        this.oriented = true;
        this.swapXY = false;
        this.reflectY = false;
        if (string.equals("right-to-left")) {
            this.swapXY = true;
            this.reflectY = false;
        } else if (string.equals("bottom-to-top")) {
            this.reflectY = true;
            this.swapXY = false;
        } else if (string.equals("left-to-right")) {
            this.reflectY = true;
            this.swapXY = true;
        }
    }

    @Override
    public Shape makeItemInRect(Rect rect, int n) {
        Shape shape = this.builder.makeInside(rect, n, true);
        if (shape != null) {
            shape.setKey(this.data.getKey(this.rows[n]));
        }
        return shape;
    }

    @Override
    public Shape makeDummyItemInRect(Rect rect) {
        Shape shape = this.builder.makeInside(rect, -1, false);
        return shape;
    }

    @Override
    public Shape makeItemAtSimpleCoordinates(double[] dArray, int n, boolean bl) {
        Shape shape = this.makeItemAtPosition(Position.makeSimple(dArray), n);
        if (bl) {
            Element element = this.grammar.elements[this.elementIndex];
            element.styleShape(shape);
            return element.applyAesthetic(shape);
        }
        return shape;
    }

    private Shape makeItemAtPosition(Position position, int n) {
        Shape shape = this.builder.make(position, n, true);
        if (shape != null) {
            if (shape.getParts() != null) {
                for (Shape shape2 : shape.getParts()) {
                    shape2.setKey(this.data.getKey(this.rows[n]));
                }
            }
            shape.setKey(this.data.getKey(this.rows[n]));
        }
        return shape;
    }

    @Override
    public Shape makeItemFromPath(double[] dArray, double[] dArray2, char[] cArray, boolean bl, int n) {
        Path path = new Path(dArray, dArray2, bl, cArray);
        path.setSnap(StyleBuilder.getSnap(this.style));
        if (this.style != null) {
            path.setStartArrowByName(this.style.startArrow);
            path.setEndArrowByName(this.style.endArrow);
        }
        if (n >= 0) {
            path.setKey(this.data.getKey(this.rows[n]));
            path.setRow(n);
        }
        return path;
    }

    @Override
    public void connect(Row[] rowArray, ShapeMaker shapeMaker, int n) {
        this.rows = rowArray;
        this.builder = shapeMaker;
        this.elementIndex = n;
    }

    @Override
    public boolean isField(String string) {
        IdentifiableItem identifiableItem = this.vis.getByID(string);
        return identifiableItem instanceof Field;
    }

    @Override
    public double getFieldNumericValue(String string, int n) {
        Field field = (Field)this.vis.getByID(string);
        Row[] rowArray = field.data.rows;
        return rowArray[n].data[field.getIndex()];
    }

    @Override
    public String getFieldStringValue(String string, int n) {
        assert (this.isField(string));
        Field field = (Field)this.vis.getByID(string);
        Row[] rowArray = field.data.rows;
        assert (0 <= n && n < rowArray.length);
        return field.getUnformattedStringValue(rowArray[n], true);
    }

    @Override
    public double[] getAllFieldValuesAsNumeric(String string) {
        if (string == null) {
            return null;
        }
        assert (this.isField(string));
        Field field = (Field)this.vis.getByID(string);
        Row[] rowArray = field.data.rows;
        double[] dArray = new double[rowArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = rowArray[i].data[field.getIndex()];
        }
        return dArray;
    }

    @Override
    public Shape getStyledShape(String string, Shape shape, int n) {
        Field field = (Field)this.vis.getByID(string);
        Data data = field.data;
        Element element = this.getElementForData(data);
        Shape shape2 = shape;
        for (Aesthetic aesthetic : element.aesthetics) {
            if (!"styleBy".equals(aesthetic.type)) continue;
            shape2 = aesthetic.apply(shape2, field.data.rows[n]);
        }
        return shape2;
    }

    @Override
    public HashMap<Double, Shape> getElementItems(String string) {
        Field field = (Field)this.vis.getByID(string);
        Data data = field.data;
        Element element = this.getElementForData(data);
        List<Shape> list = element.cachedShapes;
        HashMap<Double, Shape> hashMap = new HashMap<Double, Shape>();
        Row[] rowArray = data.rows;
        for (Shape shape : list) {
            if (shape.getRows() == null) continue;
            int n = shape.getRows()[0];
            Double d = rowArray[n].data[field.getIndex()];
            if (d == null) continue;
            hashMap.put((double)d, shape);
        }
        return hashMap;
    }

    @Override
    public StyleSpec getLinkStyle() {
        Element element = this.findLinkElement();
        if (element == null) {
            return null;
        }
        return element.spec.style;
    }

    private Element findLinkElement() {
        Element[] elementArray;
        for (Element element : elementArray = this.grammar.elements) {
            if (!element.type.equals("edge") || element.layout == null) continue;
            return element;
        }
        return null;
    }

    private Element getElementForData(Data data) {
        Element[] elementArray;
        Element element = null;
        for (Element element2 : elementArray = this.grammar.elements) {
            if (element2 == null || element2.data != data) continue;
            element = element2;
            break;
        }
        if (element == null) {
            throw new EngineException("No built element matches this data", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        return element;
    }

    @Override
    public Point[] getAttachExtent(Shape shape, boolean bl, Dim dim) {
        double d = 0.0;
        double d2 = 0.0;
        this.getPadding(shape, dim);
        Shape shape2 = shape;
        Rect rect = this.getPaddedBounds(shape2).getBounds();
        if (rect == null) {
            return null;
        }
        if (!this.swapXY) {
            d = 0.1 * rect.getWidth();
        } else {
            d2 = 0.1 * rect.getHeight();
        }
        if (bl) {
            if (!this.swapXY) {
                d2 = rect.getHeight();
            } else {
                d = rect.getWidth();
            }
        }
        Point point = new Point(rect.getX() + d, rect.getY() + d2);
        Point point2 = !this.swapXY ? new Point(rect.getX() + (rect.getWidth() - d), rect.getY() + d2) : new Point(rect.getX() + d, rect.getY() + (rect.getHeight() - d2));
        return new Point[]{point, point2};
    }

    @Override
    public Point getAttachPoint(Shape shape, Point point, Dim dim) {
        this.getPadding(shape, dim);
        Shape shape2 = shape;
        if (shape2.getContainingShape() != null && shape2.getContainingShape().getParts().length > 1) {
            return shape2.getOuterPoint();
        }
        Rect rect = this.getPaddedBounds(shape2);
        Point point2 = shape2.getCenter();
        if (rect == null) {
            return point2;
        }
        if (!this.oriented) {
            double d = Math.atan2(point.getY() - point2.getY(), point.getX() - point2.getX());
            return new Point(point2.getX() + Math.cos(d) * rect.getWidth() / 2.0, point2.getY() + Math.sin(d) * rect.getHeight() / 2.0);
        }
        if (this.swapXY) {
            return new Point(point2.getX() < point.getX() ? rect.getX() + rect.getWidth() : rect.getX(), point2.getY());
        }
        return new Point(point2.getX(), point2.getY() < point.getY() ? rect.getY() + rect.getHeight() : rect.getY());
    }

    @Override
    public Insets getPadding(Shape shape, Dim dim) {
        if (this.pad == null) {
            return Insets.NONE;
        }
        return Insets.makeForStylePadding(this.pad, shape.getBounds().getExtent(), dim);
    }

    @Override
    public boolean hasListeners() {
        return this.vis != null && this.vis.getVisContext().getLogger().hasListeners();
    }

    @Override
    public void logInfo(String string, String string2, Object object) {
        if (this.hasListeners()) {
            this.vis.getVisContext().getLogger().log(LogLevel.Info, LogComponent.CommonGrammar, string, string2, object);
        }
    }

    @Override
    public void logDetail(String string, String string2, Object object) {
        if (this.hasListeners()) {
            this.vis.getVisContext().getLogger().log(LogLevel.Detail, LogComponent.CommonGrammar, string, string2, object);
        }
    }

    @Override
    public void logWarn(String string, String string2, Object object) {
        if (this.hasListeners()) {
            this.vis.getVisContext().getLogger().log(LogLevel.Warning, LogComponent.CommonGrammar, string, string2, object);
        }
    }

    @Override
    public Rect getPaddedBounds(Shape shape) {
        return this.getPadding(shape, shape.getBounds().getExtent()).expandRectBy(shape.getBounds());
    }

    @Override
    public Dim getElementSize() {
        if (this.elementSize == null) {
            Position position;
            Shape shape;
            this.elementSize = this.builder != null ? ((shape = this.builder.make(position = Position.NO_COORDS, 0, true)) == null ? new Dim(10.0, 10.0) : shape.getBounds().getExtent()) : new Dim(10.0, 10.0);
        }
        return this.elementSize;
    }

    @Override
    public boolean copyOrientationFrom(LayoutAdapter layoutAdapter) {
        if (layoutAdapter != null && (layoutAdapter.isOriented() || layoutAdapter.isCenteredLayerPlacement())) {
            if (layoutAdapter.isOriented()) {
                this.oriented = true;
                this.swapXY = layoutAdapter.isSwapXY();
                this.reflectY = layoutAdapter.isReflectY();
            }
            if (layoutAdapter.isCenteredLayerPlacement()) {
                this.centeredLayerPlacement = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public Shape makeLabelShape(ElementLabelSpec elementLabelSpec, Shape shape) {
        LabelProducer labelProducer = this.getLabelProducer(elementLabelSpec);
        if (labelProducer.font.getSize() <= 0.0) {
            return null;
        }
        return labelProducer.makeLabel(elementLabelSpec.content, shape);
    }

    @Override
    public Shape makeLabelBackgroundShape(ElementLabelSpec elementLabelSpec, Shape shape, Shape shape2) {
        LabelProducer labelProducer = this.getLabelProducer(elementLabelSpec);
        return labelProducer.makeLabelBackground(shape, shape2);
    }

    private LabelProducer getLabelProducer(ElementLabelSpec elementLabelSpec) {
        for (LabelProducer labelProducer : this.labelProducers) {
            if (elementLabelSpec.style != labelProducer.style) continue;
            return labelProducer;
        }
        LabelProducer labelProducer = LabelProducer.makeForData(this.data, this.vis, true, elementLabelSpec, null, !this.grammar.isLabelCollisionMethodNone());
        this.labelProducers.add(labelProducer);
        return labelProducer;
    }

    @Override
    public LayoutSpec getSpec() {
        return this.spec;
    }

    @Override
    public boolean isOriented() {
        return this.oriented;
    }

    @Override
    public boolean isSwapXY() {
        return this.swapXY;
    }

    @Override
    public boolean isReflectY() {
        return this.reflectY;
    }

    @Override
    public boolean isCenteredLayerPlacement() {
        return this.centeredLayerPlacement;
    }

    @Override
    public void setCenteredLayerPlacement(boolean bl) {
        this.centeredLayerPlacement = bl;
    }

    @Override
    public StyleSpec getStyle() {
        return this.style;
    }

    @Override
    public StyleSpec getTargetedStyle(String string) {
        if (this.styles != null) {
            for (TargetedStyleSpec targetedStyleSpec : this.styles) {
                if (targetedStyleSpec.target == null || !targetedStyleSpec.target.equals(string)) continue;
                return targetedStyleSpec.style;
            }
        }
        return null;
    }

    @Override
    public Range getFieldRange(String string) {
        Field field = (Field)this.vis.getByID(string);
        if (field.isCategorical()) {
            return new Range(0.0, field.categories.length - 1);
        }
        return field.range;
    }

    @Override
    public Unit getFieldUnit(String string) {
        Field field = (Field)this.vis.getByID(string);
        if (field == null) {
            return null;
        }
        return field.unit;
    }

    @Override
    public String getFieldTimeZone(String string) {
        Field field = (Field)this.vis.getByID(string);
        return field.timeZone;
    }

    @Override
    public boolean isNodePruned(Number number) {
        return this.prunedNodesSet != null && this.prunedNodesSet.contains(number);
    }

    @Override
    public boolean isLinkPruned(Number number, Number number2) {
        if (this.prunedEdgesSet != null) {
            String string = this.makeEdge(number, number2);
            return this.prunedEdgesSet.contains(string);
        }
        return false;
    }

    private String makeEdge(Number number, Number number2) {
        String string = null;
        if (number != null && number2 != null) {
            string = (int)Math.floor(number.doubleValue()) + ";" + (int)Math.floor(number2.doubleValue());
        }
        return string;
    }

    @Override
    public VisContext getVisContext() {
        return this.vis.getVisContext();
    }

    @Override
    public Point getLayoutBoundsStartPoint() {
        return this.layoutStartPoint;
    }

    @Override
    public void setLayoutBoundsStartPoint(Point point) {
        this.layoutStartPoint = point;
    }

    @Override
    public String getLabelCollisionHandling() {
        if (this.grammar == null || this.grammar.isLabelCollisionMethodNone()) {
            return "none";
        }
        return this.grammar.getCollisionHandlerMethod();
    }

    @Override
    public TransformSpec[] getTransform() {
        return this.grammar.coordinates.spec.transforms;
    }

    @Override
    public Point getLocation(double[] dArray, Dim dim) {
        Double d = this.grammar.coordinates.getCoordinatePositions(dArray[0], 0);
        Double d2 = this.grammar.coordinates.getCoordinatePositions(dArray[1], 1);
        if (d2 != null && d != null) {
            return new Point(d2 * dim.getWidth(), (1.0 - d) * dim.getHeight());
        }
        return null;
    }
}

