/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.SankeyOrder;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Sankey
extends Layout {
    private final char[] CURVE_PATH = new char[]{'M', 'C', ',', ',', 'L', 'C', ',', ',', 'Z'};
    private final char[] QUAD = new char[]{'M', 'L', 'L', 'L', 'Z'};
    private final String idField;
    private final String fromField;
    private final String toField;
    private final String sizeField;
    private final boolean curve;
    private final boolean vertical;
    private final boolean reflectY;
    private HashMap<Double, Shape> nodeShapes;
    private HashMap<Double, double[]> valencyData;

    public Sankey(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        LayoutSpec layoutSpec = layoutAdapter.getSpec();
        this.idField = layoutSpec.id == null ? null : layoutSpec.id.$ref;
        this.fromField = layoutSpec.from == null ? null : layoutSpec.from.$ref;
        String string = this.toField = layoutSpec.to == null ? null : layoutSpec.to.$ref;
        if (this.idField == null || this.fromField == null || this.toField == null) {
            throw new SpecException("FlowPath layout requires id, from and to fields to be specified.", ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        if (!layoutAdapter.isOriented()) {
            throw new SpecException("FlowPath is supported only for layouts with an orientation such as dag and tree", ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        this.sizeField = layoutSpec.size == null ? null : ((FieldRefSpec)layoutSpec.size).$ref;
        this.curve = layoutAdapter.getStyle() != null && "curved".equals(layoutAdapter.getStyle().symbol);
        this.vertical = !layoutAdapter.isSwapXY();
        this.reflectY = layoutAdapter.isReflectY();
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        this.nodeShapes = this.adapter.getElementItems(this.idField);
        this.makeValencies(n);
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (int n2 : this.makeLinkOrder(n)) {
            double d;
            Shape shape;
            double d2 = this.adapter.getFieldNumericValue(this.fromField, n2);
            double d3 = this.adapter.getFieldNumericValue(this.toField, n2);
            if (this.adapter.isLinkPruned(d2, d3) || (shape = this.makeFlowItem(d2, d3, n2, d = this.sizeField == null ? 1.0 : this.adapter.getFieldNumericValue(this.sizeField, n2))) == null) continue;
            shape.setEdgeProperties(false, null, null, null);
            arrayList.add(shape);
        }
        BasicFactory.sortList(arrayList, new SankeyOrder(this.vertical));
        return arrayList;
    }

    private int[] makeLinkOrder(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = this.adapter.getFieldNumericValue(this.fromField, i);
            double d3 = this.adapter.getFieldNumericValue(this.toField, i);
            Shape shape = this.nodeShapes.get(d2);
            Shape shape2 = this.nodeShapes.get(d3);
            double d4 = d = this.vertical ? 1.5707963267948966 : 0.0;
            if (shape != null && shape2 != null) {
                double d5 = shape2.getCenter().getY() - shape.getCenter().getY();
                double d6 = shape2.getCenter().getX() - shape.getCenter().getX();
                if (this.vertical == this.reflectY) {
                    d6 = -d6;
                    d5 = -d5;
                }
                d = Math.atan2(d5, d6);
            }
            dArray[i] = this.vertical ? -d : d;
        }
        return BasicFactory.makeSortOrder(dArray);
    }

    private void makeValencies(int n) {
        this.valencyData = new HashMap();
        for (Double d : this.nodeShapes.keySet()) {
            this.valencyData.put(d, new double[]{0.0, 0.0, 0.0, 0.0});
        }
        for (int i = 0; i < n; ++i) {
            double d = this.adapter.getFieldNumericValue(this.fromField, i);
            double d2 = this.adapter.getFieldNumericValue(this.toField, i);
            double d3 = this.sizeField == null ? 1.0 : this.adapter.getFieldNumericValue(this.sizeField, i);
            this.addValency(d3, d, 2);
            this.addValency(d3, d2, 0);
        }
    }

    private void addValency(double d, double d2, int n) {
        double[] dArray = this.valencyData.get(d2);
        if (dArray != null) {
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
        }
    }

    private Shape makeFlowItem(double d, double d2, int n, double d3) {
        Rect rect = this.getShapeBounds(d);
        Rect rect2 = this.getShapeBounds(d2);
        double[] dArray = this.valencyData.get(d);
        double[] dArray2 = this.valencyData.get(d2);
        double[] dArray3 = this.makeVerticalPoints(rect, dArray, d3, 2);
        double[] dArray4 = this.makeVerticalPoints(rect2, dArray2, d3, 0);
        Shape shape = null;
        if (dArray3 != null && dArray4 != null) {
            char[] cArray;
            double[] dArray5;
            double[] dArray6;
            double d4 = this.vertical ? this.getCloserY(rect, rect2.getCenter()) : this.getCloserX(rect, rect2.getCenter());
            double d5 = this.vertical ? this.getCloserY(rect2, rect.getCenter()) : this.getCloserX(rect2, rect.getCenter());
            double d6 = (d4 + d5) / 2.0;
            if (this.curve) {
                dArray6 = new double[]{d4, d6, d6, d5, d5, d6, d6, d4, 0.0};
                dArray5 = new double[]{dArray3[0], dArray3[0], dArray4[0], dArray4[0], dArray4[1], dArray4[1], dArray3[1], dArray3[1], 0.0};
                cArray = this.CURVE_PATH;
            } else {
                dArray6 = new double[]{d4, d5, d5, d4, 0.0};
                dArray5 = new double[]{dArray3[0], dArray4[0], dArray4[1], dArray3[1], 0.0};
                cArray = this.QUAD;
            }
            shape = this.vertical ? this.adapter.makeItemFromPath(dArray5, dArray6, cArray, true, n) : this.adapter.makeItemFromPath(dArray6, dArray5, cArray, true, n);
        }
        return shape;
    }

    private double getCloserX(Rect rect, Point point) {
        return Math.abs(rect.getX() - point.getX()) < Math.abs(rect.getX2() - point.getX()) ? rect.getX() : rect.getX2();
    }

    private double getCloserY(Rect rect, Point point) {
        return Math.abs(rect.getY() - point.getY()) < Math.abs(rect.getY2() - point.getY()) ? rect.getY() : rect.getY2();
    }

    private double[] makeVerticalPoints(Rect rect, double[] dArray, double d, int n) {
        double d2;
        double d3;
        boolean bl;
        if (rect == null) {
            return null;
        }
        double d4 = this.getY(rect);
        double d5 = this.getHeight(rect);
        double d6 = dArray[n];
        double d7 = dArray[n + 1];
        boolean bl2 = bl = this.vertical == this.reflectY && n == 2 || this.vertical != this.reflectY && n == 0;
        if (bl) {
            d3 = d4 + d5 * (1.0 - d7 / d6);
            d2 = d4 + d5 * (1.0 - (d7 += d) / d6);
        } else {
            d2 = d4 + d5 * d7 / d6;
            d3 = d4 + d5 * (d7 += d) / d6;
        }
        dArray[n + 1] = d7;
        return new double[]{d2, d3};
    }

    private Rect getShapeBounds(double d) {
        Shape shape = this.nodeShapes.get(d);
        return shape == null ? null : shape.getBounds();
    }

    private double getHeight(Rect rect) {
        return this.vertical ? rect.getWidth() : rect.getHeight();
    }

    private double getY(Rect rect) {
        return this.vertical ? rect.getX() : rect.getY();
    }

    @Override
    public boolean respectsTransforms() {
        return false;
    }

    @Override
    public Dim getPreferredSize(int n) {
        return new Dim(0.0, 0.0);
    }
}

