/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class SharedLayoutInfo {
    private static final Point[] NO_ROUTE = new Point[0];
    private final HashMap<String, Point[]> routeInfo = new HashMap();
    private final HashMap<String, Number> routeGroupType = new HashMap();
    private final HashMap<String, Boolean> specialStackGroupInfo = new HashMap();
    private Range[] layerRanges;
    private Number selfLinkRadius;
    private int[] levelCount;
    private HashMap<Number, Integer> layerIndexMap;
    private final Set<Integer> manualNodes = new HashSet<Integer>();
    private Rect paddedBounds;
    private double minimalNodeSeparation;

    public void addRoutingInfo(int n, int n2, List<Point> list, Number number) {
        Point[] pointArray = list.toArray(new Point[list.size()]);
        String string = SharedLayoutInfo.makeLinkKey(n, n2);
        this.routeInfo.put(string, pointArray);
        if (number != null || number == null && this.routeGroupType.get(string) == null) {
            this.routeGroupType.put(string, number);
        }
    }

    public void addSpecialStackGroupInfo(int n, int n2, Boolean bl) {
        String string = SharedLayoutInfo.makeLinkKey(n, n2);
        this.specialStackGroupInfo.put(string, bl);
    }

    public Point[] getRoutingInfo(int n, int n2) {
        if (this.isManuallyPositioned(n) || this.isManuallyPositioned(n2)) {
            return NO_ROUTE;
        }
        String string = SharedLayoutInfo.makeLinkKey(n, n2);
        Point[] pointArray = this.routeInfo.get(string);
        if (pointArray == null) {
            pointArray = NO_ROUTE;
        }
        return pointArray;
    }

    public Number getRoutingGroupType(int n, int n2) {
        String string = SharedLayoutInfo.makeLinkKey(n, n2);
        Number number = this.routeGroupType.get(string);
        return number;
    }

    public Boolean getSpecialStackGroupInfo(int n, int n2) {
        String string = SharedLayoutInfo.makeLinkKey(n, n2);
        Boolean bl = this.specialStackGroupInfo.get(string);
        return bl;
    }

    private static String makeLinkKey(int n, int n2) {
        return "key" + n + "_" + n2;
    }

    public void setSelfLinkRadius(Number number) {
        this.selfLinkRadius = number;
    }

    public Number getSelfLinkRadius() {
        return this.selfLinkRadius;
    }

    public Range[] getGraphLayerRanges() {
        return this.layerRanges;
    }

    public HashMap<Number, Integer> getLayerIndexMap() {
        return this.layerIndexMap;
    }

    public void setGraphLayerRanges() {
        assert (this.levelCount == null || this.layerRanges == null || this.levelCount.length == this.layerRanges.length);
    }

    public void setLayerInfo(Range[] rangeArray, int[] nArray, HashMap<Number, Integer> hashMap) {
        this.levelCount = nArray;
        this.layerRanges = rangeArray;
        assert (this.levelCount.length == this.layerRanges.length);
        this.layerIndexMap = hashMap;
    }

    public int getIntraLayerLinkLevelCount(int n) {
        return this.levelCount[n];
    }

    public void setManuallyPositioned(int n) {
        this.manualNodes.add(n);
    }

    public boolean isManuallyPositioned(int n) {
        return this.manualNodes.contains(n);
    }

    public Rect getPaddedBounds() {
        return this.paddedBounds;
    }

    public void setPaddedBounds(Rect rect) {
        this.paddedBounds = rect;
    }

    public double getMinimalNodeSeparation() {
        return this.minimalNodeSeparation;
    }

    public void setMinimalNodeSeparation(double d) {
        this.minimalNodeSeparation = d;
    }
}

