/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/layoutsLayer")
public class SwimlaneLayout
extends Layout {
    private final String layerField;
    private final String sizeField;

    public SwimlaneLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        LayoutSpec layoutSpec = layoutAdapter.getSpec();
        this.layerField = layoutSpec.layer.$ref;
        this.sizeField = layoutSpec.size == null ? null : ((FieldRefSpec)layoutSpec.size).$ref;
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        int[] nArray = this.getItemsOrder(n);
        Range[] rangeArray = this.adapter.getSharedLayoutInfo().getGraphLayerRanges();
        if (rangeArray == null) {
            return new ArrayList<Shape>();
        }
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        int n2 = 0;
        for (int n3 : nArray) {
            double d;
            double d2 = this.adapter.getFieldNumericValue(this.layerField, n3);
            if (Double.isNaN(d2)) continue;
            int n4 = 1;
            if (this.sizeField != null && !Double.isNaN(d = this.adapter.getFieldNumericValue(this.sizeField, n3))) {
                n4 = (int)Math.round(d);
            }
            if (n4 < 1 || n2 + n4 > rangeArray.length) {
                throw new EngineException("Swim lane count and sizes must not exceed layers defined in the graph layout", ErrorCode.SWIM_LANE_DATA, "SwimlaneLayout");
            }
            Rect rect = this.makeSwimlaneBounds(dim, rangeArray, n2, n4);
            arrayList.add(this.adapter.makeItemInRect(rect, n3));
            n2 += n4;
        }
        return arrayList;
    }

    public Rect makeSwimlaneBounds(Dim dim, Range[] rangeArray, int n, int n2) {
        Range range = rangeArray[n];
        for (int i = 1; i < n2; ++i) {
            Range range2 = rangeArray[n + i];
            range = range.unionValue(range2.getMin()).unionValue(range2.getMax());
        }
        Rect rect = this.adapter.isSwapXY() ? new Rect(range.getMin() * dim.getWidth(), 0.0, range.getRange() * dim.getWidth(), dim.getHeight()) : new Rect(0.0, dim.getHeight() * (1.0 - range.getMax()), dim.getWidth(), range.getRange() * dim.getHeight());
        return rect;
    }

    private int[] getItemsOrder(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = this.adapter.getFieldNumericValue(this.layerField, i);
            dArray[i] = Double.isNaN(d) ? Double.MIN_VALUE : d;
        }
        return BasicFactory.makeSortOrder(dArray);
    }
}

