/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout;

import com.ibm.vis.engine.internal.grammar.layout.DirectedNode;
import com.ibm.vis.engine.internal.grammar.layout.graph.Direction;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.LiteGraph;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class VisibilityGraph
extends LiteGraph {
    private static final double EPSILON = 0.01;
    private static final double EPSILON_INV = 100.0;
    private final Rect[] obstacles;
    private final Map<Node, DirectedNode[]> neighbors;
    public int directedNodeCount;

    public static VisibilityGraph makeOrthogonal(Rect[] rectArray) {
        VisibilityGraph visibilityGraph = new VisibilityGraph(null, null, rectArray);
        visibilityGraph.buildOrthogonal();
        visibilityGraph.buildNeighbors();
        return visibilityGraph;
    }

    private VisibilityGraph(Node[] nodeArray, Link[] linkArray, Rect[] rectArray) {
        super(nodeArray, linkArray);
        this.obstacles = rectArray;
        this.neighbors = new HashMap<Node, DirectedNode[]>();
    }

    private void buildOrthogonal() {
        double[] dArray = this.makeInterestingCoordinates(true);
        double[] dArray2 = this.makeInterestingCoordinates(false);
        Node[] nodeArray = new Node[dArray2.length];
        Node node = null;
        for (int i = 0; i < dArray.length; ++i) {
            node = null;
            for (int j = 0; j < dArray2.length; ++j) {
                Node node2 = null;
                if (this.legal(dArray[i], dArray2[j])) {
                    node2 = new Node(-1);
                    node2.setInfo(0.0);
                    node2.setX(dArray[i]);
                    node2.setY(dArray2[j]);
                    this.addNode(node2);
                    if (node != null) {
                        this.addLink(new Link(node, node2));
                    }
                    if (nodeArray[j] != null) {
                        this.addLink(new Link(nodeArray[j], node2));
                    }
                }
                node = node2;
                nodeArray[j] = node2;
            }
        }
        this.attachLinksToNodes();
    }

    private boolean legal(double d, double d2) {
        for (Rect rect : this.obstacles) {
            if (!rect.containsPt(d, d2)) continue;
            return false;
        }
        return true;
    }

    private double[] makeInterestingCoordinates(boolean bl) {
        HashSet<Double> hashSet = new HashSet<Double>();
        for (Rect rect : this.obstacles) {
            double d;
            double d2;
            if (bl) {
                d2 = rect.getMinX();
                d = rect.getMaxX();
            } else {
                d2 = rect.getMinY();
                d = rect.getMaxY();
            }
            hashSet.add(this.r(d2) - 0.01);
            hashSet.add(this.r(d) + 0.01);
            hashSet.add(this.r((d2 + d) / 2.0));
        }
        double[] dArray = new double[hashSet.size()];
        int n = 0;
        for (Double d : hashSet) {
            dArray[n++] = 1.0 * d;
        }
        BasicFactory.sortArray(dArray);
        return dArray;
    }

    private double r(double d) {
        return (double)Math.round(d * 100.0) * 0.01;
    }

    public Node findNode(Point point) {
        int n;
        List<Node> list = this.getNodes();
        int n2 = 0;
        int n3 = list.size();
        while (n2 + 1 < n3) {
            n = (int)Math.floor((n2 + n3) / 2);
            if (list.get(n).getX() > point.getX() - 1.0) {
                n3 = n;
                continue;
            }
            n2 = n;
        }
        for (n = n2; n < list.size(); ++n) {
            Node node = list.get(n);
            if (node.getX() > point.getX() + 1.0) {
                return null;
            }
            if (!(Math.abs(point.getY() - node.getY()) < 1.0)) continue;
            return node;
        }
        return null;
    }

    public DirectedNode[] getNeighbors(DirectedNode directedNode) {
        return this.neighbors.get(directedNode.node());
    }

    private void buildNeighbors() {
        int n = 1;
        for (Node node : this.getNodes()) {
            Link[] linkArray = node.getLinks();
            DirectedNode[] directedNodeArray = new DirectedNode[linkArray.length];
            for (int i = 0; i < linkArray.length; ++i) {
                Link link = linkArray[i];
                Node node2 = link.getOpposite(node);
                if (node2.getY() > node.getY()) {
                    directedNodeArray[i] = new DirectedNode(n++, node2, Direction.SOUTH, link);
                    continue;
                }
                if (node2.getY() < node.getY()) {
                    directedNodeArray[i] = new DirectedNode(n++, node2, Direction.NORTH, link);
                    continue;
                }
                if (node2.getX() > node.getX()) {
                    directedNodeArray[i] = new DirectedNode(n++, node2, Direction.EAST, link);
                    continue;
                }
                if (node2.getX() < node.getX()) {
                    directedNodeArray[i] = new DirectedNode(n++, node2, Direction.WEST, link);
                    continue;
                }
                throw new IllegalStateException("Bad direction for neighbor");
            }
            this.neighbors.put(node, directedNodeArray);
        }
        this.directedNodeCount = n;
    }
}

