/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.calendar;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitMatchingCodes;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.DateUtil;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.PaddingSpec;
import com.ibm.vis.spec.internal.StrokeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/layoutsLayer")
public class CalendarLayout
extends Layout {
    public static final String DAY_OF_WEEK_STYLE = "dayOfWeek";
    public static final String MONTH_STYLE = "month";
    public static final String SEPARATOR_STYLE = "separator";
    private static final double SIZE_DAY = 1.0;
    private static final Dim DEFAULT_SIZE = new Dim(800.0, 400.0);
    private final String dateField;
    private final ElementLabelSpec monthLabelSpec;
    private final ElementLabelSpec dayLabelSpec;
    private final StyleSpec separatorStyle;
    private double shiftDistance;
    private boolean dayLabelWider;
    private final String locale;
    private List<Shape> nonElementShapes;
    Set<Shape> nonElementShapeSet;

    public CalendarLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        this.dateField = layoutAdapter.getSpec().date.$ref;
        Unit unit = layoutAdapter.getFieldUnit(this.dateField);
        if (unit == null || unit.getMatchingLevel(Unit.DATE) != UnitMatchingCodes.UNIT_MATCH) {
            throw new SpecException("Calendar layout requires a field with unit=date for the positioning.date attribute", ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        this.monthLabelSpec = new ElementLabelSpec();
        this.monthLabelSpec.style = new StyleSpec();
        StyleSpec styleSpec = layoutAdapter.getTargetedStyle(MONTH_STYLE);
        this.populateLabelSpec(this.monthLabelSpec.style, styleSpec, true);
        this.dayLabelSpec = new ElementLabelSpec();
        this.dayLabelSpec.style = new StyleSpec();
        StyleSpec styleSpec2 = layoutAdapter.getTargetedStyle(DAY_OF_WEEK_STYLE);
        this.populateLabelSpec(this.dayLabelSpec.style, styleSpec2, false);
        this.separatorStyle = new StyleSpec();
        StyleSpec styleSpec3 = layoutAdapter.getTargetedStyle(SEPARATOR_STYLE);
        this.populateSeparatorSpec(this.separatorStyle, styleSpec3);
        this.nonElementShapes = null;
        this.nonElementShapeSet = new HashSet<Shape>();
        this.locale = layoutAdapter.getVisContext().getLocale();
        this.shiftDistance = 0.0;
        this.dayLabelWider = false;
    }

    protected void populateLabelSpec(StyleSpec styleSpec, StyleSpec styleSpec2, boolean bl) {
        styleSpec.location = "outside";
        styleSpec.align = bl ? "middle" : "end";
        styleSpec.valign = "middle";
        styleSpec.font = new FontSpec();
        styleSpec.padding = new PaddingSpec();
        if (bl) {
            double d = this.adapter.getElementSize().getHeight();
            ((PaddingSpec)styleSpec.padding).top = d;
            ((PaddingSpec)styleSpec.padding).bottom = d;
        } else {
            double d = this.adapter.getElementSize().getWidth();
            ((PaddingSpec)styleSpec.padding).left = d;
            ((PaddingSpec)styleSpec.padding).right = d;
        }
        if (styleSpec2 != null) {
            if (styleSpec2.fill != null) {
                styleSpec.fill = styleSpec2.fill;
            }
            if (styleSpec2.font != null) {
                styleSpec.font = styleSpec2.font;
            }
            if (styleSpec2.padding != null) {
                styleSpec.padding = styleSpec2.padding;
            }
            if (styleSpec2.effect != null) {
                styleSpec.effect = styleSpec2.effect;
            }
            if (styleSpec2.accessibility != null) {
                styleSpec.accessibility = styleSpec2.accessibility;
            }
        }
    }

    protected void populateSeparatorSpec(StyleSpec styleSpec, StyleSpec styleSpec2) {
        styleSpec.stroke = new StrokeSpec();
        styleSpec.stroke.width = 1;
        double d = this.adapter.getElementSize().getWidth();
        styleSpec.padding = new PaddingSpec();
        ((PaddingSpec)styleSpec.padding).left = d;
        ((PaddingSpec)styleSpec.padding).right = d;
        styleSpec.symbol = "line";
        if (styleSpec2 != null) {
            if (styleSpec2.fill != null) {
                styleSpec.fill = styleSpec2.fill;
            }
            if (styleSpec2.stroke != null) {
                styleSpec.stroke = styleSpec2.stroke;
            }
            if (styleSpec2.padding != null) {
                styleSpec.padding = styleSpec2.padding;
            }
            if (styleSpec2.outline != null) {
                styleSpec.outline = styleSpec2.outline;
            }
            if (styleSpec2.size != null) {
                styleSpec.size = styleSpec2.size;
            }
            if (styleSpec2.width != null) {
                styleSpec.width = styleSpec2.width;
            }
            if (styleSpec2.accessibility != null) {
                styleSpec.accessibility = styleSpec2.accessibility;
            }
            if (styleSpec2.symbol != null && BasicFactory.isString(styleSpec2.symbol) && "elbow".equals(styleSpec2.symbol)) {
                styleSpec.symbol = styleSpec2.symbol;
            }
        }
    }

    @Override
    public boolean needsAestheticsPreApplied() {
        return false;
    }

    @Override
    public boolean respectsTransforms() {
        return false;
    }

    @Override
    public boolean applyStyles(Shape shape) {
        return shape.getRows() == null && !this.nonElementShapeSet.contains(shape);
    }

    @Override
    public Dim getPreferredSize(int n) {
        Dim dim = this.adapter.getElementSize();
        double d = this.computeSeparatorGap(DEFAULT_SIZE);
        double d2 = this.computeYearGap(DEFAULT_SIZE);
        double d3 = this.computeDayOfWeekGap(DEFAULT_SIZE);
        int n2 = (int)Math.round(this.adapter.getElementSize().getHeight() * 1.0);
        if (BasicFactory.isNumber(this.dayLabelSpec.style.font.size)) {
            this.dayLabelSpec.style.font.size = Math.min((double)n2, ((Number)this.dayLabelSpec.style.font.size).doubleValue());
            this.dayLabelSpec.style.font.setCachedObject(null);
        }
        Range range = this.adapter.getFieldRange(this.dateField);
        String string = this.adapter.getFieldTimeZone(this.dateField);
        Range range2 = CalendarLayout.expandRangeToMonthBoundaries(range, string);
        Object object = DateUtil.INSTANCE.toDate(range2.getMin(), Unit.DATE, string);
        Object object2 = DateUtil.INSTANCE.toDate(range2.getMax(), Unit.DATE, string);
        int n3 = DateUtil.INSTANCE.getYear(object2) - DateUtil.INSTANCE.getYear(object);
        double d4 = (double)(n3 + 1) * (7.0 + d2) - d2 / 2.0;
        double d5 = range2.getRange() > 365.25 || n3 > 0 ? 365.25 : range2.getRange();
        double d6 = d5 / 7.0 * 1.0 + d5 * 11.0 / 365.25 * d;
        Insets insets = this.adapter.getPadding(ShapeFactory2.CreateRect(0.0, 0.0, dim.getWidth(), dim.getHeight()), DEFAULT_SIZE);
        dim = new Dim(dim.getWidth() + insets.getHorizontal(), dim.getHeight() + insets.getVertical());
        return new Dim((d6 += d3) * dim.getMin(), d4 * dim.getMin());
    }

    protected static Range expandRangeToMonthBoundaries(Range range, String string) {
        Object object = DateUtil.INSTANCE.toDate(range.getMin(), Unit.DATE, string);
        Object object2 = DateUtil.INSTANCE.toDate(range.getMax(), Unit.DATE, string);
        DateUtil.INSTANCE.floorToUnitMultiple(object, Unit.MONTH, 1);
        DateUtil.INSTANCE.floorToUnitMultiple(object2, Unit.MONTH, 1);
        DateUtil.INSTANCE.increment(object2, Unit.MONTH, 1);
        DateUtil.INSTANCE.increment(object2, Unit.DAY, -1);
        return new Range(DateUtil.INSTANCE.fromDateObject(object, Unit.DATE), DateUtil.INSTANCE.fromDateObject(object2, Unit.DATE));
    }

    protected double computeSeparatorGap(Dim dim) {
        Dim dim2 = this.adapter.getElementSize();
        Insets insets = Insets.makeForStylePadding(this.separatorStyle.padding, new Dim(dim2.getWidth(), dim2.getHeight()), dim);
        return insets.getHorizontal() / dim2.getWidth();
    }

    protected double computeYearGap(Dim dim) {
        Dim dim2 = this.adapter.getElementSize();
        Insets insets = Insets.makeForStylePadding(this.monthLabelSpec.style.padding, new Dim(dim2.getWidth(), dim2.getHeight()), dim);
        Font font = FontHelper.makeFromSpec(this.monthLabelSpec.style.font, this.adapter.getVisContext().getMinimumFontSize(), this.getAdapter().getVisContext().usesFractionalMetrics());
        double d = font.getHeight();
        return (insets.getVertical() + d) / dim2.getHeight();
    }

    protected double computeDayOfWeekGap(Dim dim) {
        Dim dim2 = this.adapter.getElementSize();
        Insets insets = Insets.makeForStylePadding(this.dayLabelSpec.style.padding, new Dim(dim2.getWidth(), dim2.getHeight()), dim);
        Font font = FontHelper.makeFromSpec(this.dayLabelSpec.style.font, this.adapter.getVisContext().getMinimumFontSize(), this.adapter.getVisContext().usesFractionalMetrics());
        double d = font.getWidth(Text.createTextWithShapedValue("W", 0.0, 0.0, "end", "middle", font, this.dayLabelSpec.style, null, "...", dim2, false));
        return (insets.getHorizontal() + d) / dim2.getWidth();
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        String string;
        int n3;
        double d = this.computeSeparatorGap(dim);
        double d2 = this.computeYearGap(dim);
        double d3 = this.computeDayOfWeekGap(dim);
        Range range = this.adapter.getFieldRange(this.dateField);
        String string2 = this.adapter.getFieldTimeZone(this.dateField);
        Range range2 = CalendarLayout.expandRangeToMonthBoundaries(range, string2);
        Object object5 = DateUtil.INSTANCE.toDate(range2.getMin(), Unit.DATE, string2);
        Object object6 = DateUtil.INSTANCE.toDate(range2.getMax(), Unit.DATE, string2);
        int n4 = DateUtil.INSTANCE.getYear(object6) - DateUtil.INSTANCE.getYear(object5);
        if (n4 > 0) {
            DateUtil.INSTANCE.floorToUnitMultiple(object5, Unit.YEAR, 1);
        }
        int n5 = DateUtil.INSTANCE.getMonth(object5);
        int n6 = n3 = DateUtil.INSTANCE.getYear(object5);
        double d4 = d2 / 2.0;
        double d5 = d3;
        int n7 = (int)Math.floor(DateUtil.INSTANCE.fromDateObject(object5, Unit.DATE) + 0.1);
        int n8 = (int)Math.ceil(range2.getMax() - 0.1);
        Point[] pointArray = new Point[n8 - n7 + 1];
        int[] nArray = new int[n8 - n7 + 1];
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int[] nArray2 = new int[12];
        double[] dArray = new double[12];
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        arrayList2.add(d4);
        Range range3 = new Range(0.0, 0.0);
        double d6 = 0.0;
        boolean bl = false;
        String string3 = string = this.locale != null ? this.locale.substring(0, 2) : null;
        if (!(this.locale == null || string.equals("en") || string.equals("fr") || string.equals("it") || string.equals("de") || string.equals("es"))) {
            this.dayLabelWider = true;
            this.shiftDistance = this.calculateDayLabelWidth();
        }
        for (int i = 0; i <= n8 - n7; ++i) {
            boolean bl2;
            pointArray[i] = new Point(d5 + this.shiftDistance, d4 + (double)CalendarLayout.dayFromMonday(object5) * 1.0);
            boolean bl3 = bl2 = DateUtil.INSTANCE.fromDateObject(object5, Unit.DATE) >= range2.getMin();
            if (bl2) {
                int n9 = n5 - 1;
                nArray2[n9] = nArray2[n9] + 1;
                int n10 = n5 - 1;
                dArray[n10] = dArray[n10] + (pointArray[i].getX() + 0.5);
                range3 = range3.unionValue(pointArray[i].getX());
                range3 = range3.unionValue(pointArray[i].getX() + 1.0);
                d6 = Math.max(d6, pointArray[i].getY() + 1.0);
                nArray[i] = 2;
            } else {
                nArray[i] = 0;
            }
            DateUtil.INSTANCE.increment(object5, Unit.DAY, 1);
            int n11 = DateUtil.INSTANCE.getYear(object5);
            int n12 = DateUtil.INSTANCE.getMonth(object5);
            if (CalendarLayout.dayFromMonday(object5) == 0) {
                d5 += 1.0;
            }
            if (n11 != n3) {
                d5 = d3;
                arrayList2.add(d4 += 7.0 + d2);
                n3 = n11;
                n5 = n12;
                bl = true;
                continue;
            }
            if (n12 == n5) continue;
            if (bl2) {
                bl = false;
                arrayList.add(new double[]{pointArray[i].getX() + 1.0 + d / 2.0, d4, pointArray[i].getY() + 1.0});
            }
            d5 += d;
            n5 = n12;
        }
        if (!bl) {
            arrayList.remove(arrayList.size() - 1);
        } else {
            arrayList2.remove(arrayList2.size() - 1);
        }
        double d7 = Math.min(dim.getWidth() / range3.getRange(), dim.getHeight() / d6);
        double d8 = -(dim.getWidth() * range3.getMin()) / range3.getRange();
        ArrayList<Shape> arrayList3 = new ArrayList<Shape>();
        for (n2 = 0; n2 < n; ++n2) {
            object4 = this.adapter.getFieldNumericValue(this.dateField, n2);
            if (object4 == null || ((Number)object4).doubleValue() < range2.getMin() || ((Number)object4).doubleValue() > range2.getMax()) continue;
            int n13 = (int)Math.floor(((Number)object4).doubleValue() - (double)n7);
            nArray[n13] = 1;
            object3 = pointArray[n13];
            object2 = ShapeFactory2.CreateRect(d8 + ((Point)object3).getX() * d7, ((Point)object3).getY() * d7, 1.0 * d7, 1.0 * d7);
            object = (Rect)((Shape)object2).getGeom();
            Insets insets = this.adapter.getPadding((Shape)object2, dim);
            object = insets.insetRect((Rect)object);
            Shape shape = this.adapter.makeItemInRect((Rect)object, n2);
            arrayList3.add(shape);
        }
        this.nonElementShapes = new ArrayList<Shape>();
        this.nonElementShapeSet = new HashSet<Shape>();
        for (n2 = 0; n2 <= n8 - n7; ++n2) {
            if (nArray[n2] != 2) continue;
            object4 = pointArray[n2];
            Shape shape = ShapeFactory2.CreateRect(d8 + ((Point)object4).getX() * d7, ((Point)object4).getY() * d7, 1.0 * d7, 1.0 * d7);
            object3 = (Rect)shape.getGeom();
            object2 = this.adapter.getPadding(shape, dim);
            object3 = ((Insets)object2).insetRect((Rect)object3);
            object = this.adapter.makeDummyItemInRect((Rect)object3);
            StyleBuilder.setFilled((Shape)object, this.adapter.getStyle());
            this.nonElementShapes.add((Shape)object);
            this.nonElementShapeSet.add((Shape)object);
        }
        if (this.separatorStyle.fill != null) {
            double d9;
            double d10;
            double d11;
            if ("line".equals(this.separatorStyle.symbol)) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    object4 = (double[])arrayList.get(n2);
                    double d12 = d8 + d7 * object4[0];
                    double d13 = d8 + d7 * (object4[0] - 1.0);
                    double d14 = d7 * object4[1];
                    d11 = d7 * (object4[2] - 0.5);
                    d10 = d7 * (object4[2] + 0.5);
                    d9 = d7 * (object4[1] + 7.0);
                    if (d10 > d9) {
                        d13 = d12;
                        d10 = d9;
                    }
                    ShapePoly shapePoly = new ShapePoly(new double[]{d12, d12, d13, d13}, new double[]{d14, d11, d10, d9}, false, null);
                    if (this.separatorStyle != null) {
                        StyleBuilder.setFilled(shapePoly, this.separatorStyle);
                    }
                    this.nonElementShapes.add(shapePoly);
                }
            } else if ("elbow".equals(this.separatorStyle.symbol)) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    object4 = (double[])arrayList.get(n2);
                    double d15 = d8 + d7 * object4[0];
                    double d16 = d8 + d7 * (object4[0] - 1.0);
                    double d17 = d8 + d7 * (object4[0] - 0.5);
                    d11 = d7 * object4[1];
                    d10 = d7 * (object4[2] - 0.5);
                    d9 = d7 * (object4[2] + 0.5);
                    double d18 = d7 * (object4[1] + 7.0);
                    if (d9 > d18) {
                        d16 = d15;
                        d17 = d15;
                        d9 = d18;
                    }
                    ShapePoly shapePoly = new ShapePoly(new double[]{d15, d15, d17, d17, d16, d16}, new double[]{d11, d10, d10, d9, d9, d18}, false, null);
                    if (this.separatorStyle != null) {
                        StyleBuilder.setFilled(shapePoly, this.separatorStyle);
                    }
                    this.nonElementShapes.add(shapePoly);
                }
            }
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            int n14;
            double d19 = d7 * ((Double)arrayList2.get(n2) - 1.0);
            object3 = DateUtil.INSTANCE.makeDateTime(1970, 1, 5, 12, 0, 0);
            for (n14 = 0; n14 < 7; ++n14) {
                object = DateUtil.INSTANCE.getFormattedDate(object3, "EEEE", this.locale);
                if (!this.dayLabelWider) {
                    object = ((String)object).substring(0, 1);
                }
                this.dayLabelSpec.content = new Object[]{object};
                Shape shape = this.adapter.makeLabelShape(this.dayLabelSpec, ShapeFactory2.CreateCircle(0.0, d7 * ((Double)arrayList2.get(n2) + ((double)n14 + 0.5) * 1.0), 1.0));
                if (shape != null) {
                    this.nonElementShapes.add(shape);
                }
                DateUtil.INSTANCE.increment(object3, Unit.DAY, 1);
            }
            for (n14 = 0; n14 < 12; ++n14) {
                double d20;
                if (nArray2[n14] <= 0 || (d20 = DateUtil.INSTANCE.fromDateObject(object = DateUtil.INSTANCE.makeDateTime(n6 + n2, n14 + 1, 15, 12, 0, 0), Unit.DATE)) > range2.getMax() || d20 < range2.getMin()) continue;
                String string4 = DateUtil.INSTANCE.formatDate(object, Unit.MONTH, null, this.adapter.getVisContext().getLocale(), string2);
                double d21 = d8 + d7 * dArray[n14] / (double)nArray2[n14];
                this.monthLabelSpec.content = new Object[]{string4};
                Shape shape = this.adapter.makeLabelShape(this.monthLabelSpec, ShapeFactory2.CreateCircle(d21, d19, 1.0));
                if (shape == null) continue;
                this.nonElementShapes.add(shape);
            }
        }
        return arrayList3;
    }

    @Override
    public List<Shape> makeNonElementShapes(Dim dim) {
        if (this.nonElementShapes == null) {
            throw new EngineException("In CalendarLayout, makeElementShapes was not called before makeNonElementShapes", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
        }
        return this.nonElementShapes;
    }

    private static int dayFromMonday(Object object) {
        return (DateUtil.INSTANCE.getDayOfWeek(object) + 6) % 7;
    }

    private double calculateDayLabelWidth() {
        Object object = DateUtil.INSTANCE.makeDateTime(1970, 1, 5, 12, 0, 0);
        double d = 0.0;
        for (int i = 0; i < 7; ++i) {
            String string = DateUtil.INSTANCE.getFormattedDate(object, "EEEE", this.locale);
            Font font = FontHelper.makeFromSpec(this.dayLabelSpec.style.font, this.adapter.getVisContext().getMinimumFontSize(), this.adapter.getVisContext().usesFractionalMetrics());
            double d2 = font.getWidth(Text.createTextWithShapedValue(string, 0.0, 0.0, "end", "middle", font, this.dayLabelSpec.style, null, "...", this.adapter.getElementSize(), false));
            d = d2 > d ? d2 : d;
            DateUtil.INSTANCE.increment(object, Unit.DAY, 1);
        }
        return d /= this.adapter.getElementSize().getWidth();
    }
}

