/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.chord;

import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.struct.Path;
import java.util.ArrayList;
import java.util.List;

class ChordBuilder {
    private final double a1;
    private final double a2;
    private final double a3;
    private final double a4;
    private final double r;
    private final DoublePrimitiveArrayList xx;
    private final DoublePrimitiveArrayList yy;
    private final List<Character> type;

    ChordBuilder(double d, double d2, double d3, double d4, double d5) {
        this.a1 = d;
        this.a2 = d2;
        this.a3 = d3;
        this.a4 = d4;
        this.r = d5;
        this.xx = new DoublePrimitiveArrayList();
        this.yy = new DoublePrimitiveArrayList();
        this.type = new ArrayList<Character>();
    }

    private void addArc(double d, double d2, double d3) {
        double d4 = Math.abs(d2 - d3);
        if (d < 0.001 || d4 < 0.001) {
            return;
        }
        int n = (int)Math.ceil((d4 - 0.01) / 1.5707963267948966);
        if (n < 1) {
            n = 1;
        }
        if (n > 4) {
            n = 4;
        }
        double d5 = (d2 - d3) / (2.0 * (double)n);
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5);
        double[][] dArrayArray = new double[][]{{(4.0 - d6) / 3.0, (1.0 - d6) * (3.0 - d6) / (3.0 * d7)}, {(4.0 - d6) / 3.0, -(1.0 - d6) * (3.0 - d6) / (3.0 * d7)}, {d6, -d7}};
        double d8 = d2;
        for (int i = 0; i < n; ++i) {
            double d9 = Math.cos(d5 - d8);
            double d10 = Math.sin(d5 - d8);
            for (int j = 0; j < 3; ++j) {
                double d11;
                double d12;
                if (i == n - 1 && j == 2) {
                    d12 = d * Math.cos(d3);
                    d11 = d * Math.sin(d3);
                } else {
                    d12 = d * (d9 * dArrayArray[j][0] + d10 * dArrayArray[j][1]);
                    d11 = d * (-d10 * dArrayArray[j][0] + d9 * dArrayArray[j][1]);
                }
                this.addCoord(j == 0 ? (char)'C' : ',', d12, d11);
            }
            d8 -= 2.0 * d5;
        }
    }

    private void addCoord(char c, double d, double d2) {
        this.type.add(Character.valueOf(c));
        this.xx.add(d);
        this.yy.add(d2);
    }

    Path build() {
        this.addCoord('M', this.r * Math.cos(this.a1), this.r * Math.sin(this.a1));
        this.addArc(this.r, this.a1, this.a2);
        this.addCoord('Q', 0.0, 0.0);
        this.addCoord(',', this.r * Math.cos(this.a3), this.r * Math.sin(this.a3));
        this.addArc(this.r, this.a3, this.a4);
        this.addCoord('Q', 0.0, 0.0);
        this.addCoord(',', this.r * Math.cos(this.a1), this.r * Math.sin(this.a1));
        this.addCoord('Z', 0.0, 0.0);
        char[] cArray = new char[this.type.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = this.type.get(i).charValue();
        }
        return new Path(this.xx.toArray(), this.yy.toArray(), true, cArray);
    }
}

