/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.chord;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.chord.ChordBuilder;
import com.ibm.vis.engine.internal.grammar.layout.chord.ChordSpan;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.struct.WedgeShape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/layoutsLayer")
public class ChordLayout
extends Layout {
    private static final double GAP_FRACTION = 0.05;
    private final String fromField;
    private final String toField;
    private final String sizeField;
    private final boolean combineCategories;
    private final Map<Shape, ChordSpan> spanMap;
    private double cx;
    private double cy;
    private double radius;
    private double wedgeInner;
    private double wedgeOuter;
    private static final String ARC_STYLE = "arc";
    private static final String ARCTEXT_STYLE = "arctext";
    public static final String FROM = "from";
    public static final String TO = "to";

    public ChordLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        this.fromField = layoutAdapter.getSpec().from.$ref;
        this.toField = layoutAdapter.getSpec().to.$ref;
        this.sizeField = layoutAdapter.getSpec().size == null ? null : ((FieldRefSpec)layoutAdapter.getSpec().size).$ref;
        this.spanMap = new HashMap<Shape, ChordSpan>();
        this.combineCategories = layoutAdapter.getSpec().combineCategories;
    }

    @Override
    public boolean respectsTransforms() {
        return false;
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        ChordSpan[] chordSpanArray;
        ChordSpan[] chordSpanArray2;
        Object object2;
        this.setGeometryValues(dim);
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        if (this.combineCategories) {
            object2 = this.buildCombinedSpans(-Math.PI, Math.PI, n);
            this.addOuterArcs((ChordSpan[])object2, arrayList);
            chordSpanArray2 = this.getSpans((ChordSpan[])object2, FROM);
            chordSpanArray = this.getSpans((ChordSpan[])object2, TO);
        } else {
            chordSpanArray2 = this.buildSpans(this.fromField, -1.5707963267948966, -4.71238898038469, n, FROM);
            chordSpanArray = this.buildSpans(this.toField, -1.5707963267948966, 1.5707963267948966, n, TO);
            this.addOuterArcs(chordSpanArray2, arrayList);
            this.addOuterArcs(chordSpanArray, arrayList);
        }
        object2 = new HashMap();
        for (ChordSpan object3 : chordSpanArray) {
            object2.put(object3.toValue, object3);
        }
        int n2 = 0;
        double[] dArray = this.adapter.getAllFieldValuesAsNumeric(this.toField);
        Shape[] shapeArray = new Shape[n];
        double[] dArray2 = new double[n];
        ChordSpan[] chordSpanArray3 = chordSpanArray2;
        int n3 = chordSpanArray3.length;
        for (int i = 0; i < n3; ++i) {
            int[] nArray;
            ChordSpan chordSpan = chordSpanArray3[i];
            for (int n4 : nArray = chordSpan.getSortedRows(dArray)) {
                Shape shape;
                ChordSpan chordSpan2 = (ChordSpan)object2.get(dArray[n4]);
                double d = this.getWeight(n4);
                Range range = chordSpan.getChordRange(d);
                Range range2 = chordSpan2.getChordRange(d);
                shapeArray[n2] = shape = this.makeChordShape(range, range2, n4);
                dArray2[n2] = -d;
                ++n2;
            }
        }
        int[] nArray = BasicFactory.makeSortOrder(dArray2);
        for (n3 = 0; n3 < nArray.length; ++n3) {
            Shape shape = shapeArray[nArray[n3]];
            if (shape == null) continue;
            arrayList.add(shape);
        }
        return arrayList;
    }

    private ChordSpan[] getSpans(ChordSpan[] chordSpanArray, String string) {
        ArrayList<ChordSpan> arrayList = new ArrayList<ChordSpan>();
        for (ChordSpan chordSpan : chordSpanArray) {
            if ((!string.equals(FROM) || chordSpan.fromRows == null) && (!string.equals(TO) || chordSpan.toRows == null)) continue;
            arrayList.add(chordSpan);
        }
        return arrayList.toArray(new ChordSpan[arrayList.size()]);
    }

    private void setGeometryValues(Dim dim) {
        Double d;
        double d2 = dim.getMin() / 2.0;
        this.cx = dim.getWidth() / 2.0;
        this.cy = dim.getHeight() / 2.0;
        double d3 = Math.min(20.0, d2 / 2.0);
        StyleSpec styleSpec = this.adapter.getTargetedStyle(ARC_STYLE);
        if (styleSpec != null && (d = UnitConverter.convertLength(styleSpec.size, d3, d2)) != null) {
            d3 = Math.min(d, d2 - 1.0);
        }
        this.wedgeOuter = d2;
        this.wedgeInner = this.wedgeOuter - d3;
        this.radius = this.wedgeInner - 3.0;
    }

    private void addOuterArcs(ChordSpan[] chordSpanArray, List<Shape> list) {
        for (ChordSpan chordSpan : chordSpanArray) {
            WedgeShape wedgeShape = ShapeFactory2.createWedge(this.cx, this.cy, this.wedgeInner, this.wedgeOuter, chordSpan.a, chordSpan.b);
            if (chordSpan.isFrom()) {
                wedgeShape.getA11yInfo().setProperty("chordFrom", chordSpan.getValue());
            } else {
                wedgeShape.getA11yInfo().setProperty("chordTo", chordSpan.getValue());
            }
            this.spanMap.put(wedgeShape, chordSpan);
            list.add(wedgeShape);
        }
    }

    private Shape makeChordShape(Range range, Range range2, int n) {
        ChordBuilder chordBuilder = new ChordBuilder(range.getMin(), range.getMax(), range2.getMin(), range2.getMax(), this.radius);
        Path path = chordBuilder.build();
        ((Shape)path).affine(1.0, this.cx, 1.0, this.cy, false);
        path.setRow(n);
        return path;
    }

    @Override
    public final boolean applyLabels(Shape shape, ShapeList shapeList, boolean bl) {
        ChordSpan chordSpan = this.spanMap.get(shape);
        if (chordSpan == null) {
            return false;
        }
        ElementLabelSpec elementLabelSpec = new ElementLabelSpec();
        elementLabelSpec.style = this.adapter.getTargetedStyle(ARCTEXT_STYLE);
        if (elementLabelSpec.style == null) {
            elementLabelSpec.style = new StyleSpec();
        }
        if (elementLabelSpec.style.font == null) {
            elementLabelSpec.style.font = new FontSpec();
            elementLabelSpec.style.font.size = Math.min(this.wedgeOuter - this.wedgeInner - 2.0, 12.0);
        }
        elementLabelSpec.style.location = "outside";
        elementLabelSpec.style.angle = "perpendicular";
        elementLabelSpec.content = new Object[]{chordSpan.name};
        Shape shape2 = this.adapter.makeLabelShape(elementLabelSpec, shape);
        double d = this.wedgeOuter * Math.min(0.2617993877991494, Math.abs(chordSpan.b - chordSpan.a));
        if (shape2 != null) {
            if (shape2.getBounds().getWidth() > d) {
                int n = (int)Math.floor((double)chordSpan.name.length() * d / shape2.getBounds().getWidth());
                if (n <= 2) {
                    return true;
                }
                String string = chordSpan.name.substring(0, n -= 2) + "...";
                elementLabelSpec.content = new Object[]{string};
                shape2 = this.adapter.makeLabelShape(elementLabelSpec, shape);
            }
            shapeList.addPlaqueAndLabelForShape(shape, (Text)shape2, null, false, null);
        }
        return true;
    }

    ChordSpan[] buildCombinedSpans(double d, double d2, int n) {
        HashMap<Number, ChordSpan> hashMap = new HashMap<Number, ChordSpan>();
        double d3 = this.buildSpanMap(this.fromField, n, hashMap, FROM);
        HashMap<Number, ChordSpan> hashMap2 = new HashMap<Number, ChordSpan>();
        Map<String, ChordSpan> map = this.combine(hashMap, hashMap2);
        Object[] objectArray = map.keySet().toArray(new String[map.keySet().size()]);
        BasicFactory.sortArray(objectArray);
        int n2 = objectArray.length;
        double d4 = (d3 += this.buildSpanMap(this.toField, n, hashMap2, TO)) * 1.05;
        double d5 = (d2 - d) * 0.05 / (double)n2;
        ChordSpan[] chordSpanArray = new ChordSpan[n2];
        double d6 = d + d5 / 2.0;
        for (int i = 0; i < n2; ++i) {
            ChordSpan chordSpan = map.get(objectArray[i]);
            double d7 = chordSpan.spanWeight * (d2 - d) / d4;
            chordSpan.setExtent(d6, d6 + d7);
            d6 += d7 + d5;
            chordSpanArray[i] = chordSpan;
        }
        return chordSpanArray;
    }

    private Map<String, ChordSpan> combine(Map<Number, ChordSpan> map, Map<Number, ChordSpan> map2) {
        HashMap<String, ChordSpan> hashMap = new HashMap<String, ChordSpan>();
        for (ChordSpan chordSpan : map.values()) {
            hashMap.put(chordSpan.name, chordSpan);
        }
        for (ChordSpan chordSpan : map2.values()) {
            if (!hashMap.keySet().contains(chordSpan.name)) {
                hashMap.put(chordSpan.name, chordSpan);
                continue;
            }
            ChordSpan chordSpan2 = this.findSpan(hashMap, chordSpan.name);
            chordSpan2.toRows = chordSpan.toRows;
            chordSpan2.toValue = chordSpan.toValue;
            chordSpan2.spanWeight += chordSpan.spanWeight;
        }
        return hashMap;
    }

    private ChordSpan findSpan(Map<String, ChordSpan> map, String string) {
        for (ChordSpan chordSpan : map.values()) {
            if (!string.equals(chordSpan.name)) continue;
            return chordSpan;
        }
        return null;
    }

    private ChordSpan[] buildSpans(String string, double d, double d2, int n, String string2) {
        HashMap<Number, ChordSpan> hashMap = new HashMap<Number, ChordSpan>();
        double d3 = this.buildSpanMap(string, n, hashMap, string2);
        Number[] numberArray = ChordLayout.getSorted(hashMap.keySet());
        int n2 = numberArray.length;
        double d4 = d3 * 1.05;
        double d5 = (d2 - d) * 0.05 / (double)n2;
        ChordSpan[] chordSpanArray = new ChordSpan[n2];
        double d6 = d + d5 / 2.0;
        for (int i = 0; i < n2; ++i) {
            ChordSpan chordSpan = (ChordSpan)hashMap.get(numberArray[i]);
            double d7 = chordSpan.spanWeight * (d2 - d) / d4;
            chordSpan.setExtent(d6, d6 + d7);
            d6 += d7 + d5;
            chordSpanArray[i] = chordSpan;
        }
        return chordSpanArray;
    }

    private double buildSpanMap(String string, int n, Map<Number, ChordSpan> map, String string2) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = this.adapter.getFieldNumericValue(string, i);
            double d3 = this.getWeight(i);
            if (Double.isNaN(d2) || !(d3 > 0.0)) continue;
            ChordSpan chordSpan = map.get(d2);
            if (chordSpan == null) {
                String string3 = this.adapter.getFieldStringValue(string, i);
                chordSpan = new ChordSpan(string3, d2, string2);
                map.put(d2, chordSpan);
            }
            chordSpan.addChord(i, d3, string2);
            d += d3;
        }
        return d;
    }

    private double getWeight(int n) {
        if (this.sizeField == null) {
            return 1.0;
        }
        double d = this.adapter.getFieldNumericValue(this.sizeField, n);
        return Double.isNaN(d) ? 0.0 : d;
    }

    private static final Number[] getSorted(Set<Number> set) {
        Object[] objectArray = set.toArray(new Number[set.size()]);
        BasicFactory.sortArray(objectArray);
        return objectArray;
    }
}

