/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.chord;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;

@OnDemandLoad(value="com/ibm/vis/layers/layoutsLayer")
class ChordSpan {
    double a;
    double b;
    double spanWeight;
    final String name;
    double fromValue;
    double toValue;
    boolean isFromValue;
    IntPrimitiveArrayList fromRows;
    IntPrimitiveArrayList toRows;
    private double allocatedWt;

    ChordSpan(String string, double d, String string2) {
        this.name = string;
        if (string2.equals("from")) {
            this.fromValue = d;
            this.fromRows = new IntPrimitiveArrayList();
            this.isFromValue = true;
        } else {
            this.toValue = d;
            this.toRows = new IntPrimitiveArrayList();
            this.isFromValue = false;
        }
    }

    Range getChordRange(double d) {
        Range range = new Range(this.a + (this.b - this.a) * this.allocatedWt / this.spanWeight, this.a + (this.b - this.a) * (this.allocatedWt + d) / this.spanWeight);
        this.allocatedWt += d;
        return range;
    }

    void setExtent(double d, double d2) {
        this.a = d;
        this.b = d2;
    }

    int[] getSortedRows(double[] dArray) {
        int n = this.fromRows.size();
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[this.fromRows.get(i)];
        }
        int[] nArray = BasicFactory.makeSortOrder(dArray2);
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.fromRows.get(nArray[i]);
        }
        return nArray;
    }

    void addChord(int n, double d, String string) {
        if (string.equals("from")) {
            this.fromRows.add(n);
        } else {
            this.toRows.add(n);
        }
        this.spanWeight += d;
    }

    double getValue() {
        return this.isFromValue ? this.fromValue : this.toValue;
    }

    final boolean isFrom() {
        return this.isFromValue;
    }
}

