/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.cloud;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.extension.RAVEExtensionManager;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.cloud.Alignable;
import com.ibm.vis.engine.internal.grammar.layout.cloud.CloudAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.cloud.DefaultCloudAlgorithms;
import com.ibm.vis.engine.internal.grammar.layout.cloud.spiral.SpiralLayoutAlgorithm;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.SpiralParametersSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/layoutsLayer")
public class CloudLayout
extends Layout {
    public CloudLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        DefaultCloudAlgorithms.registerExtensions();
    }

    @Override
    public boolean needsAestheticsPreApplied() {
        return true;
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        Object object;
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        ArrayList<Shape> arrayList2 = new ArrayList<Shape>();
        for (int i = 0; i < n; ++i) {
            object = this.adapter.makeItemAtSimpleCoordinates(new double[]{1.0, 1.0}, i, true);
            if (object == null) continue;
            arrayList2.add((Shape)object);
        }
        Insets insets = Insets.NONE;
        object = this.adapter.getStyle();
        if (object != null) {
            insets = Insets.makeForStylePadding(((StyleSpec)object).padding, dim, dim);
        }
        this.layoutShapes(arrayList2, new Rect(0.0, 0.0, dim.getWidth(), dim.getHeight()), insets);
        for (Shape shape : arrayList2) {
            arrayList.add(shape);
        }
        return arrayList;
    }

    private void layoutShapes(List<Shape> list, Rect rect, Insets insets) {
        StyleSpec styleSpec;
        CloudAlgorithm cloudAlgorithm = (CloudAlgorithm)RAVEExtensionManager.INSTANCE.newInstance(this.adapter.getSpec().layout, null);
        if (cloudAlgorithm == null) {
            throw new SpecException("The 'cloud' method cannot handle a layout '" + this.adapter.getSpec().layout + "'", ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        if (cloudAlgorithm.isAlignable() && (styleSpec = this.adapter.getStyle()) != null) {
            Alignable alignable = (Alignable)((Object)cloudAlgorithm);
            alignable.setHorizontalAlignment(styleSpec.align);
            alignable.setVerticalAlignment(styleSpec.valign);
            alignable.alignBaseLine(styleSpec.valign == null ? false : "end".equals(styleSpec.valign));
        }
        if (cloudAlgorithm instanceof SpiralLayoutAlgorithm) {
            this.parameterizeSpiralAlgorithm(cloudAlgorithm);
        }
        cloudAlgorithm.layoutShapes(list, rect, insets);
    }

    private void parameterizeSpiralAlgorithm(CloudAlgorithm cloudAlgorithm) {
        SpiralLayoutAlgorithm spiralLayoutAlgorithm = (SpiralLayoutAlgorithm)cloudAlgorithm;
        LayoutSpec layoutSpec = this.adapter.getSpec();
        SpiralParametersSpec spiralParametersSpec = layoutSpec.spiralParameters;
        if (spiralParametersSpec != null) {
            spiralLayoutAlgorithm.setOrientations(spiralParametersSpec.orientations);
            if (spiralParametersSpec.orientationScheme != null) {
                spiralLayoutAlgorithm.setOrientationScheme(spiralParametersSpec.orientationScheme);
            }
            if (spiralParametersSpec.spiralType != null) {
                spiralLayoutAlgorithm.setSpiralType(spiralParametersSpec.spiralType);
            }
            if (spiralParametersSpec.fitAll != null) {
                spiralLayoutAlgorithm.setFitAll(spiralParametersSpec.fitAll);
            }
        }
    }

    @Override
    public Dim getDefaultShapeSize(Dim dim, int n) {
        return dim;
    }
}

